/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core.cartridge;

import com.bliss.core.Memory;
import com.bliss.core.Peripheral;
import com.bliss.core.Processor;
import com.bliss.core.RAM;
import com.bliss.core.ROM;
import com.bliss.core.cartridge.CartridgeFile;
import com.bliss.core.cartridge.CartridgeType;
import com.bliss.core.cartridge.CartridgeTypeFactory;
import com.bliss.core.devices.PlugIn;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Cartridge
implements Peripheral {
    private CartridgeType cartType;
    private Memory[] memories;
    private static /* synthetic */ Class class$Lcom$bliss$core$cartridge$Cartridge;

    public void changePlugIn(PlugIn plugIn) {
    }

    public int getProcessorCount() {
        return 0;
    }

    public Processor getProcessor(int n) {
        return null;
    }

    public int getMemoryCount() {
        return this.memories.length;
    }

    public Memory getMemory(int n) {
        return this.memories[n];
    }

    public CartridgeType getType() {
        return this.cartType;
    }

    public boolean requiresECS() {
        return this.cartType.requiresECS();
    }

    public boolean usesIntellivoice() {
        return this.cartType.usesIntellivoice();
    }

    private static long getCrc(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return cRC32.getValue();
    }

    private static long getCrc(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 2];
        int n = 0;
        while (n < nArray.length) {
            byArray[n << 1] = (byte)((nArray[n] & 0xFF00) >> 8);
            byArray[(n << 1) + 1] = (byte)(nArray[n] & 0xFF);
            ++n;
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return cRC32.getValue();
    }

    public static Cartridge loadCartridge(String string) throws IOException {
        ClassLoader classLoader = (class$Lcom$bliss$core$cartridge$Cartridge != null ? class$Lcom$bliss$core$cartridge$Cartridge : (class$Lcom$bliss$core$cartridge$Cartridge = Cartridge.class$("com.bliss.core.cartridge.Cartridge"))).getClassLoader();
        InputStream inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        Cartridge cartridge = Cartridge.loadCartridge(bufferedInputStream);
        bufferedInputStream.close();
        return cartridge;
    }

    public static Cartridge loadCartridge(InputStream inputStream) throws IOException {
        int[] nArray = ROM.loadROMImage(inputStream, true);
        long l = Cartridge.getCrc(nArray);
        CartridgeType cartridgeType = CartridgeTypeFactory.getCartridgeType(l);
        if (cartridgeType == null) {
            throw new IOException("Unknown cartridge type");
        }
        CartridgeType.MemoryMap memoryMap = cartridgeType.getMemoryMap();
        int n = memoryMap.getSegmentCount();
        Memory[] memoryArray = new Memory[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = memoryMap.getSegmentLocation(n3);
            if (n4 == -8) {
                memoryArray[n3] = new RAM(memoryMap.getSegmentSize(n3), memoryMap.getSegmentStart(n3), 8);
            } else if (n4 == -16) {
                memoryArray[n3] = new RAM(memoryMap.getSegmentSize(n3), memoryMap.getSegmentStart(n3), 16);
            } else {
                int[] nArray2 = new int[memoryMap.getSegmentSize(n3)];
                System.arraycopy(nArray, n2, nArray2, 0, memoryMap.getSegmentSize(n3));
                n2 += memoryMap.getSegmentSize(n3);
                memoryArray[n3] = new ROM(nArray2, memoryMap.getSegmentLocation(n3), memoryMap.getSegmentBank(n3));
            }
            ++n3;
        }
        return new Cartridge(cartridgeType, memoryArray);
    }

    public static Cartridge loadCartridge(CartridgeFile cartridgeFile) throws IOException {
        BufferedInputStream bufferedInputStream;
        Object object;
        File file = cartridgeFile.getFile();
        if (file.getName().toLowerCase().endsWith(".zip")) {
            object = new ZipFile(file);
            ZipEntry zipEntry = ((ZipFile)object).getEntry(cartridgeFile.getZipEntryName());
            bufferedInputStream = new BufferedInputStream(((ZipFile)object).getInputStream(zipEntry), 4096);
        } else {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
        }
        object = cartridgeFile.getType().getMemoryMap();
        int n = ((CartridgeType.MemoryMap)object).getSegmentCount();
        Memory[] memoryArray = new Memory[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((CartridgeType.MemoryMap)object).getSegmentLocation(n2);
            if (n3 == -8) {
                memoryArray[n2] = new RAM(((CartridgeType.MemoryMap)object).getSegmentSize(n2), ((CartridgeType.MemoryMap)object).getSegmentStart(n2), 8);
            } else if (n3 == -16) {
                memoryArray[n2] = new RAM(((CartridgeType.MemoryMap)object).getSegmentSize(n2), ((CartridgeType.MemoryMap)object).getSegmentStart(n2), 16);
            } else {
                int[] nArray = new int[((CartridgeType.MemoryMap)object).getSegmentSize(n2)];
                int n4 = 0;
                while (n4 < nArray.length) {
                    int n5 = bufferedInputStream.read();
                    int n6 = bufferedInputStream.read();
                    nArray[n4] = n5 << 8 | n6;
                    ++n4;
                }
                memoryArray[n2] = new ROM(nArray, ((CartridgeType.MemoryMap)object).getSegmentLocation(n2), ((CartridgeType.MemoryMap)object).getSegmentBank(n2));
            }
            ++n2;
        }
        bufferedInputStream.close();
        return new Cartridge(cartridgeFile.getType(), memoryArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Cartridge(CartridgeType cartridgeType, Memory[] memoryArray) {
        this.cartType = cartridgeType;
        this.memories = memoryArray;
    }
}

