/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app;

import com.bliss.core.BooleanOption;
import com.bliss.core.ChoiceOption;
import com.bliss.core.ECSKeyboard;
import com.bliss.core.HandController;
import com.bliss.core.Intellivision;
import com.bliss.core.Option;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.InputSignal;
import com.bliss.core.devices.PlugIn;
import com.blissj.app.Bliss;
import com.blissj.app.BlissConfig;
import com.blissj.app.BlissConfigureInputDialog;
import com.blissj.app.BlissMainFrame;
import com.blissj.app.BlissUtilities;
import com.blissj.app.BooleanOptionCheckBox;
import com.blissj.app.ChoiceOptionComboBoxModel;
import com.blissj.app.OptionEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlissOptionsDialog
extends JDialog {
    private Intellivision inty;
    private HandController player1;
    private HandController player2;
    private ECSKeyboard keyboard;
    private OptionEditor[] videoEditors;
    private OptionEditor[] audioEditors;
    private JFileChooser browseDialog;
    private BlissConfigureInputDialog configInputDialog;
    private GridBagConstraints gbc = new GridBagConstraints();
    private JTabbedPane tabbedPane;
    private JPanel generalPanel;
    private JLabel cartDirLabel;
    private JTextField cartDirField;
    private JButton cartDirBrowseButton;
    private JPanel videoPanel;
    private boolean videoPanelCreated;
    private JPanel audioPanel;
    private boolean audioPanelCreated;
    private JPanel inputPanel;
    private boolean inputPanelCreated;
    private JLabel player1Label;
    private JSeparator player1Separator;
    private JLabel player1Icon;
    private JTextArea player1Description;
    private JButton player1ConfigButton;
    private JLabel player2Label;
    private JSeparator player2Separator;
    private JLabel player2Icon;
    private JTextArea player2Description;
    private JButton player2ConfigButton;
    private JLabel ECSLabel;
    private JSeparator ECSSeparator;
    private JLabel ECSIcon;
    private JTextArea ECSDescription;
    private JButton ECSConfigButton;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;

    private void initUI() {
        this.setTitle(Bliss.RESOURCES.getString("OptionsDialogTitle"));
        this.setResizable(false);
        this.setModal(true);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.tabbedPane = new JTabbedPane();
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.ipadx = 50;
        this.gbc.ipady = 60;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(8, 8, 8, 8);
        container.add((Component)this.tabbedPane, this.gbc);
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new GridBagLayout());
        this.tabbedPane.addTab(Bliss.RESOURCES.getString("GeneralTab"), this.generalPanel);
        this.cartDirLabel = new JLabel(Bliss.RESOURCES.getString("CartridgeDirectoryLabel") + ":");
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(12, 12, 8, 8);
        this.generalPanel.add((Component)this.cartDirLabel, this.gbc);
        this.cartDirField = new JTextField();
        this.cartDirField.setColumns(20);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(12, 0, 8, 12);
        this.generalPanel.add((Component)this.cartDirField, this.gbc);
        this.cartDirBrowseButton = new JButton(Bliss.RESOURCES.getString("BrowseButton") + "...");
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(0, 12, 12, 12);
        this.generalPanel.add((Component)this.cartDirBrowseButton, this.gbc);
        JPanel jPanel = new JPanel();
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 2;
        this.gbc.weighty = 1.0;
        this.generalPanel.add((Component)jPanel, this.gbc);
        this.videoPanel = new JPanel();
        this.videoPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.videoPanel.setLayout(new GridBagLayout());
        this.tabbedPane.addTab(Bliss.RESOURCES.getString("VideoTab"), this.videoPanel);
        this.audioPanel = new JPanel();
        this.audioPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.audioPanel.setLayout(new GridBagLayout());
        this.tabbedPane.addTab(Bliss.RESOURCES.getString("SoundTab"), this.audioPanel);
        this.inputPanel = new JPanel();
        this.inputPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.inputPanel.setLayout(new GridBagLayout());
        this.initInputPanel();
        this.tabbedPane.addTab(Bliss.RESOURCES.getString("InputTab"), this.inputPanel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridy = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(0, 8, 8, 8);
        container.add((Component)this.buttonPanel, this.gbc);
        this.okButton = new JButton(Bliss.RESOURCES.getString("OKButton"));
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(0, 0, 0, 8);
        this.buttonPanel.add((Component)this.okButton, this.gbc);
        this.cancelButton = new JButton(Bliss.RESOURCES.getString("CancelButton"));
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.buttonPanel.add((Component)this.cancelButton, this.gbc);
        Dimension dimension = this.okButton.getPreferredSize();
        Dimension dimension2 = this.cancelButton.getPreferredSize();
        int n = Math.max(dimension.width, dimension2.width);
        this.okButton.setPreferredSize(new Dimension(n, dimension.height));
        this.cancelButton.setPreferredSize(new Dimension(n, dimension2.height));
        this.pack();
        this.browseDialog = new JFileChooser();
        this.browseDialog.setFileSelectionMode(1);
        this.configInputDialog = new BlissConfigureInputDialog((Frame)this.getOwner());
    }

    private void initListeners() {
        BlissOptionsDialog blissOptionsDialog = this;
        if (blissOptionsDialog == null) {
            throw null;
        }
        this.tabbedPane.addChangeListener(new ChangeListener(blissOptionsDialog){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = BlissOptionsDialog.access$0(this.this$0).getSelectedComponent();
                if (component == BlissOptionsDialog.access$1(this.this$0) && !BlissOptionsDialog.access$2(this.this$0)) {
                    BlissOptionsDialog.access$3(this.this$0);
                    if (BlissOptionsDialog.access$4(this.this$0) && BlissOptionsDialog.access$5(this.this$0)) {
                        BlissOptionsDialog.access$0(this.this$0).removeChangeListener(this);
                    }
                } else if (component == BlissOptionsDialog.access$6(this.this$0) && !BlissOptionsDialog.access$4(this.this$0)) {
                    BlissOptionsDialog.access$7(this.this$0);
                    if (BlissOptionsDialog.access$2(this.this$0) && BlissOptionsDialog.access$5(this.this$0)) {
                        BlissOptionsDialog.access$0(this.this$0).removeChangeListener(this);
                    }
                } else if (component == BlissOptionsDialog.access$8(this.this$0) && !BlissOptionsDialog.access$5(this.this$0)) {
                    BlissOptionsDialog.access$9(this.this$0);
                    if (BlissOptionsDialog.access$2(this.this$0) && BlissOptionsDialog.access$4(this.this$0)) {
                        BlissOptionsDialog.access$0(this.this$0).removeChangeListener(this);
                    }
                }
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        BlissOptionsDialog blissOptionsDialog2 = this;
        if (blissOptionsDialog2 == null) {
            throw null;
        }
        this.cartDirBrowseButton.addActionListener(new ActionListener(blissOptionsDialog2){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(BlissOptionsDialog.access$10(this.this$0).getText().trim()).getAbsoluteFile();
                if (file.exists() && file.isDirectory()) {
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        BlissOptionsDialog.access$11(this.this$0).setSelectedFile(file);
                    } else {
                        BlissOptionsDialog.access$11(this.this$0).setCurrentDirectory(file);
                    }
                }
                if ((n = BlissOptionsDialog.access$11(this.this$0).showDialog(this.this$0, Bliss.RESOURCES.getString("SelectDirectoryButton"))) != 0) {
                    return;
                }
                File file3 = BlissOptionsDialog.access$11(this.this$0).getSelectedFile();
                BlissOptionsDialog.access$10(this.this$0).setText(file3.getAbsolutePath());
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        BlissOptionsDialog blissOptionsDialog3 = this;
        if (blissOptionsDialog3 == null) {
            throw null;
        }
        this.okButton.addActionListener(new ActionListener(blissOptionsDialog3){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!BlissOptionsDialog.access$12(this.this$0)) {
                    return;
                }
                BlissOptionsDialog.access$13(this.this$0);
                this.this$0.dispose();
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        BlissOptionsDialog blissOptionsDialog4 = this;
        if (blissOptionsDialog4 == null) {
            throw null;
        }
        this.cancelButton.addActionListener(new ActionListener(blissOptionsDialog4){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.dispose();
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        BlissOptionsDialog blissOptionsDialog5 = this;
        if (blissOptionsDialog5 == null) {
            throw null;
        }
        this.addComponentListener(new ComponentAdapter(blissOptionsDialog5){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void componentShown(ComponentEvent componentEvent) {
                BlissOptionsDialog.access$0(this.this$0).setSelectedIndex(0);
                BlissOptionsDialog.access$14(this.this$0);
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
    }

    private void initVideoPanel() {
        Option[] optionArray = this.inty.getVideoOptions();
        this.videoEditors = new OptionEditor[optionArray.length];
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.anchor = 17;
        int n = 0;
        while (n < this.videoEditors.length) {
            JComponent jComponent;
            JLabel jLabel;
            if (optionArray[n] instanceof BooleanOption) {
                jLabel = new JLabel();
                this.videoEditors[n] = new BooleanOptionCheckBox((BooleanOption)optionArray[n]);
                jComponent = (JCheckBox)((Object)this.videoEditors[n]);
            } else {
                jLabel = new JLabel(optionArray[n].getDescription() + ":");
                this.videoEditors[n] = new ChoiceOptionComboBoxModel((ChoiceOption)optionArray[n]);
                jComponent = new JComboBox((ComboBoxModel)((Object)this.videoEditors[n]));
            }
            this.gbc.gridy = n + 2;
            this.gbc.weightx = 0.0;
            this.gbc.insets = new Insets(4, 0, 4, 8);
            this.videoPanel.add((Component)jLabel, this.gbc);
            this.gbc.weightx = 1.0;
            this.gbc.insets = new Insets(4, 0, 4, 0);
            this.videoPanel.add((Component)jComponent, this.gbc);
            ++n;
        }
        JPanel jPanel = new JPanel();
        this.gbc.gridy = this.videoEditors.length + 2;
        this.gbc.gridwidth = 2;
        this.gbc.weighty = 1.0;
        this.videoPanel.add((Component)jPanel, this.gbc);
        int n2 = 0;
        while (n2 < this.videoEditors.length) {
            this.videoEditors[n2].reloadOption();
            ++n2;
        }
        this.videoPanelCreated = true;
    }

    private void initAudioPanel() {
        Option[] optionArray = this.inty.getAudioOptions();
        this.audioEditors = new OptionEditor[optionArray.length];
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.anchor = 17;
        int n = 0;
        while (n < optionArray.length) {
            JComponent jComponent;
            JLabel jLabel;
            if (optionArray[n] instanceof BooleanOption) {
                jLabel = new JLabel();
                this.audioEditors[n] = new BooleanOptionCheckBox((BooleanOption)optionArray[n]);
                jComponent = (JCheckBox)((Object)this.audioEditors[n]);
            } else {
                jLabel = new JLabel(optionArray[n].getDescription() + ":");
                this.audioEditors[n] = new ChoiceOptionComboBoxModel((ChoiceOption)optionArray[n]);
                jComponent = new JComboBox((ComboBoxModel)((Object)this.audioEditors[n]));
            }
            this.gbc.gridy = n + 2;
            this.gbc.weightx = 0.0;
            this.gbc.insets = new Insets(4, 0, 4, 8);
            this.audioPanel.add((Component)jLabel, this.gbc);
            this.gbc.weightx = 1.0;
            this.gbc.insets = new Insets(4, 0, 4, 0);
            this.audioPanel.add((Component)jComponent, this.gbc);
            ++n;
        }
        JPanel jPanel = new JPanel();
        this.gbc.gridy = this.audioEditors.length + 2;
        this.gbc.gridwidth = 2;
        this.gbc.weighty = 1.0;
        this.audioPanel.add((Component)jPanel, this.gbc);
        int n2 = 0;
        while (n2 < this.audioEditors.length) {
            this.audioEditors[n2].reloadOption();
            ++n2;
        }
        this.audioPanelCreated = true;
    }

    private void initInputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.player1Label = new JLabel(Bliss.RESOURCES.getString("LeftControllerLabel"));
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)this.player1Label, this.gbc);
        this.player1Separator = new JSeparator();
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        jPanel.add((Component)this.player1Separator, this.gbc);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)jPanel, this.gbc);
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon imageIcon = new ImageIcon(classLoader.getResource("com/blissj/app/images/leftcontroller.gif"));
        this.player1Icon = new JLabel(imageIcon);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridheight = 2;
        this.gbc.anchor = 11;
        this.gbc.insets = new Insets(0, 0, 8, 8);
        this.inputPanel.add((Component)this.player1Icon, this.gbc);
        this.player1Description = new JTextArea(Bliss.RESOURCES.getString("LeftControllerDescription"));
        this.player1Description.setEditable(false);
        this.player1Description.setLineWrap(true);
        this.player1Description.setWrapStyleWord(true);
        this.player1Description.setBorder(null);
        this.player1Description.setBackground(null);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)this.player1Description, this.gbc);
        this.player1ConfigButton = new JButton(Bliss.RESOURCES.getString("ConfigureButton") + "...");
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)this.player1ConfigButton, this.gbc);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.player2Label = new JLabel(Bliss.RESOURCES.getString("RightControllerLabel"));
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)this.player2Label, this.gbc);
        this.player2Separator = new JSeparator();
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        jPanel.add((Component)this.player2Separator, this.gbc);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)jPanel, this.gbc);
        classLoader = this.getClass().getClassLoader();
        imageIcon = new ImageIcon(classLoader.getResource("com/blissj/app/images/rightcontroller.gif"));
        this.player2Icon = new JLabel(imageIcon);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridheight = 2;
        this.gbc.anchor = 11;
        this.gbc.insets = new Insets(0, 0, 8, 8);
        this.inputPanel.add((Component)this.player2Icon, this.gbc);
        this.player2Description = new JTextArea(Bliss.RESOURCES.getString("RightControllerDescription"));
        this.player2Description.setEditable(false);
        this.player2Description.setLineWrap(true);
        this.player2Description.setWrapStyleWord(true);
        this.player2Description.setBorder(null);
        this.player2Description.setBackground(null);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)this.player2Description, this.gbc);
        this.player2ConfigButton = new JButton(Bliss.RESOURCES.getString("ConfigureButton") + "...");
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)this.player2ConfigButton, this.gbc);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.ECSLabel = new JLabel(Bliss.RESOURCES.getString("ECSKeyboardLabel"));
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)this.ECSLabel, this.gbc);
        this.ECSSeparator = new JSeparator();
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        jPanel.add((Component)this.ECSSeparator, this.gbc);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)jPanel, this.gbc);
        classLoader = this.getClass().getClassLoader();
        imageIcon = new ImageIcon(classLoader.getResource("com/blissj/app/images/ecskeyboard.gif"));
        this.ECSIcon = new JLabel(imageIcon);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridheight = 2;
        this.gbc.anchor = 11;
        this.gbc.insets = new Insets(0, 8, 8, 8);
        this.inputPanel.add((Component)this.ECSIcon, this.gbc);
        this.ECSDescription = new JTextArea(Bliss.RESOURCES.getString("ECSKeyboardDescription"));
        this.ECSDescription.setEditable(false);
        this.ECSDescription.setLineWrap(true);
        this.ECSDescription.setWrapStyleWord(true);
        this.ECSDescription.setBorder(null);
        this.ECSDescription.setBackground(null);
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)this.ECSDescription, this.gbc);
        this.ECSConfigButton = new JButton(Bliss.RESOURCES.getString("ConfigureButton") + "...");
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(0, 0, 8, 0);
        this.inputPanel.add((Component)this.ECSConfigButton, this.gbc);
        JPanel jPanel2 = new JPanel();
        BlissOptionsDialog.reinitConstraints(this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 2;
        this.gbc.weighty = 1.0;
        this.inputPanel.add((Component)jPanel2, this.gbc);
        BlissOptionsDialog blissOptionsDialog = this;
        if (blissOptionsDialog == null) {
            throw null;
        }
        this.player1ConfigButton.addActionListener(new ActionListener(blissOptionsDialog){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                BlissUtilities.centerWindowOverParent(BlissOptionsDialog.access$15(this.this$0), 25, 10);
                BlissOptionsDialog.access$15(this.this$0).configureInput(Bliss.RESOURCES.getString("LeftControllerConfigureInputDialogTitle"), BlissConfig.KEY_INPUT_LEFT_CONTROLLER, BlissOptionsDialog.access$16(this.this$0).getPlugIn().getInputDevice(), BlissOptionsDialog.access$17(this.this$0));
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        BlissOptionsDialog blissOptionsDialog2 = this;
        if (blissOptionsDialog2 == null) {
            throw null;
        }
        this.player2ConfigButton.addActionListener(new ActionListener(blissOptionsDialog2){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                BlissUtilities.centerWindowOverParent(BlissOptionsDialog.access$15(this.this$0), 20, 10);
                BlissOptionsDialog.access$15(this.this$0).configureInput(Bliss.RESOURCES.getString("RightControllerConfigureInputDialogTitle"), BlissConfig.KEY_INPUT_RIGHT_CONTROLLER, BlissOptionsDialog.access$16(this.this$0).getPlugIn().getInputDevice(), BlissOptionsDialog.access$18(this.this$0));
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        BlissOptionsDialog blissOptionsDialog3 = this;
        if (blissOptionsDialog3 == null) {
            throw null;
        }
        this.ECSConfigButton.addActionListener(new ActionListener(blissOptionsDialog3){
            private final /* synthetic */ BlissOptionsDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                BlissUtilities.centerWindowOverParent(BlissOptionsDialog.access$15(this.this$0), 20, 10);
                BlissOptionsDialog.access$15(this.this$0).configureInput(Bliss.RESOURCES.getString("ECSKeyboardConfigureInputDialogTitle"), BlissConfig.KEY_INPUT_ECS_KEYBOARD, BlissOptionsDialog.access$16(this.this$0).getPlugIn().getInputDevice(), BlissOptionsDialog.access$19(this.this$0));
            }
            {
                this.this$0 = blissOptionsDialog;
                this.constructor$0(blissOptionsDialog);
            }

            private final void constructor$0(BlissOptionsDialog blissOptionsDialog) {
            }
        });
        this.inputPanelCreated = true;
    }

    private static void reinitConstraints(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
    }

    private void refresh() {
        int n;
        this.cartDirField.setText(Bliss.REGISTRY.getDataAsString(BlissConfig.KEY_GENERAL, "cartdir", "roms"));
        if (this.videoPanelCreated) {
            n = 0;
            while (n < this.videoEditors.length) {
                this.videoEditors[n].reloadOption();
                ++n;
            }
        }
        if (this.audioPanelCreated) {
            n = 0;
            while (n < this.audioEditors.length) {
                this.audioEditors[n].reloadOption();
                ++n;
            }
        }
    }

    private boolean assertValidConfig() {
        File file = new File(this.cartDirField.getText().trim());
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorCartridgeDirectoryDoesNotExist"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
            this.tabbedPane.setSelectedIndex(0);
            return false;
        }
        if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorCartridgeDirectoryDoesNotExist"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
            this.tabbedPane.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    private void commitConfig() {
        InputSignal inputSignal;
        int n;
        Bliss.REGISTRY.setData(BlissConfig.KEY_GENERAL, "cartdir", this.cartDirField.getText().trim());
        if (this.videoPanelCreated) {
            n = 0;
            while (n < this.videoEditors.length) {
                this.videoEditors[n].commitSelection();
                ++n;
            }
        }
        if (this.audioPanelCreated) {
            n = 0;
            while (n < this.audioEditors.length) {
                this.audioEditors[n].commitSelection();
                ++n;
            }
        }
        PlugIn plugIn = this.inty.getPlugIn();
        InputDevice inputDevice = plugIn.getInputDevice();
        String[] stringArray = new String[BlissConfig.KEY_INPUT_LEFT_CONTROLLER.length + 1];
        System.arraycopy(BlissConfig.KEY_INPUT_LEFT_CONTROLLER, 0, stringArray, 0, stringArray.length - 1);
        stringArray[stringArray.length - 1] = plugIn.getPlugInName();
        int n2 = this.player1.getControlCount();
        int n3 = 0;
        while (n3 < n2) {
            inputSignal = inputDevice.getInputSignal(this.player1.getControlID(n3));
            Bliss.REGISTRY.setData(stringArray, Integer.toString(n3), inputSignal == null ? "" : inputSignal.getConfigString());
            ++n3;
        }
        System.arraycopy(BlissConfig.KEY_INPUT_RIGHT_CONTROLLER, 0, stringArray, 0, stringArray.length - 1);
        n2 = this.player2.getControlCount();
        n3 = 0;
        while (n3 < n2) {
            inputSignal = inputDevice.getInputSignal(this.player2.getControlID(n3));
            Bliss.REGISTRY.setData(stringArray, Integer.toString(n3), inputSignal == null ? "" : inputSignal.getConfigString());
            ++n3;
        }
        System.arraycopy(BlissConfig.KEY_INPUT_ECS_KEYBOARD, 0, stringArray, 0, stringArray.length - 1);
        n2 = this.keyboard.getControlCount();
        n3 = 0;
        while (n3 < n2) {
            inputSignal = inputDevice.getInputSignal(this.keyboard.getControlID(n3));
            Bliss.REGISTRY.setData(stringArray, Integer.toString(n3), inputSignal == null ? "" : inputSignal.getConfigString());
            ++n3;
        }
    }

    static /* synthetic */ JTabbedPane access$0(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.tabbedPane;
    }

    static /* synthetic */ JPanel access$1(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.videoPanel;
    }

    static /* synthetic */ boolean access$2(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.videoPanelCreated;
    }

    static /* synthetic */ void access$3(BlissOptionsDialog blissOptionsDialog) {
        blissOptionsDialog.initVideoPanel();
    }

    static /* synthetic */ boolean access$4(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.audioPanelCreated;
    }

    static /* synthetic */ boolean access$5(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.inputPanelCreated;
    }

    static /* synthetic */ JPanel access$6(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.audioPanel;
    }

    static /* synthetic */ void access$7(BlissOptionsDialog blissOptionsDialog) {
        blissOptionsDialog.initAudioPanel();
    }

    static /* synthetic */ JPanel access$8(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.inputPanel;
    }

    static /* synthetic */ void access$9(BlissOptionsDialog blissOptionsDialog) {
        blissOptionsDialog.initInputPanel();
    }

    static /* synthetic */ JTextField access$10(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.cartDirField;
    }

    static /* synthetic */ JFileChooser access$11(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.browseDialog;
    }

    static /* synthetic */ boolean access$12(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.assertValidConfig();
    }

    static /* synthetic */ void access$13(BlissOptionsDialog blissOptionsDialog) {
        blissOptionsDialog.commitConfig();
    }

    static /* synthetic */ void access$14(BlissOptionsDialog blissOptionsDialog) {
        blissOptionsDialog.refresh();
    }

    static /* synthetic */ BlissConfigureInputDialog access$15(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.configInputDialog;
    }

    static /* synthetic */ Intellivision access$16(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.inty;
    }

    static /* synthetic */ HandController access$17(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.player1;
    }

    static /* synthetic */ HandController access$18(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.player2;
    }

    static /* synthetic */ ECSKeyboard access$19(BlissOptionsDialog blissOptionsDialog) {
        return blissOptionsDialog.keyboard;
    }

    public BlissOptionsDialog(BlissMainFrame blissMainFrame, Intellivision intellivision) {
        super(blissMainFrame);
        this.inty = intellivision;
        this.player1 = intellivision.getHandControllerOne();
        this.player2 = intellivision.getHandControllerTwo();
        this.keyboard = intellivision.getECSKeyboard();
        this.initUI();
        this.initListeners();
    }
}

