/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app;

import com.bliss.core.cartridge.CartridgeFile;
import com.bliss.core.cartridge.CartridgeType;
import com.bliss.core.cartridge.CartridgeTypeFactory;
import com.blissj.app.Bliss;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class CartridgeTableModel
extends AbstractTableModel {
    public static final int VIEW_ALL = 0;
    public static final int VIEW_AVAILABLE = 1;
    private CartridgeType[] cartTypes;
    private int[] cartTypeFileMap;
    private CartridgeFile[] cartFiles = new CartridgeFile[0];
    private ImageIcon redStop;
    private ImageIcon greenCheck;
    private int view;
    private int sortingColumn;

    private void init() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.redStop = new ImageIcon(classLoader.getResource("com/blissj/app/images/redstop.gif"));
        this.greenCheck = new ImageIcon(classLoader.getResource("com/blissj/app/images/greencheck.gif"));
        this.cartTypes = CartridgeTypeFactory.getCartridgeTypeList();
        this.cartTypeFileMap = new int[this.cartTypes.length];
        this.resort();
        this.remapTypesToFiles();
    }

    public void setView(int n) {
        if (n == this.view) {
            return;
        }
        this.view = n;
        this.fireTableDataChanged();
    }

    public int getView() {
        return this.view;
    }

    public void setSorting(int n) {
        if (n == this.sortingColumn) {
            return;
        }
        this.sortingColumn = n;
        this.resort();
        this.remapTypesToFiles();
        this.fireTableDataChanged();
    }

    public int getSorting() {
        return this.sortingColumn;
    }

    public void setCartridgeFileList(CartridgeFile[] cartridgeFileArray) {
        this.cartFiles = cartridgeFileArray;
        this.remapTypesToFiles();
        this.fireTableDataChanged();
    }

    public boolean isCartridgeFileAvailable(int n) {
        if (this.view == 0) {
            return this.cartTypeFileMap[n] != -1;
        }
        return true;
    }

    public CartridgeFile getCartridgeFile(int n) {
        if (this.view == 0) {
            return this.cartTypeFileMap[n] == -1 ? null : this.cartFiles[this.cartTypeFileMap[n]];
        }
        return this.cartFiles[n];
    }

    public CartridgeType getCartridgeType(int n) {
        if (this.view == 0) {
            return this.cartTypes[n];
        }
        return this.cartFiles[n].getType();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return Bliss.RESOURCES.getString("CartridgeColumnHeader");
            }
            case 2: {
                return Bliss.RESOURCES.getString("ProducerColumnHeader");
            }
            case 3: {
                return Bliss.RESOURCES.getString("YearColumnHeader");
            }
        }
        return Bliss.RESOURCES.getString("FileColumnHeader");
    }

    public int getRowCount() {
        return this.view == 0 ? this.cartTypes.length : this.cartFiles.length;
    }

    public Object getValueAt(int n, int n2) {
        CartridgeType cartridgeType = this.view == 0 ? this.cartTypes[n] : this.cartFiles[n].getType();
        switch (n2) {
            case 0: {
                return this.view == 0 && this.cartTypeFileMap[n] == -1 ? this.redStop : this.greenCheck;
            }
            case 1: {
                return cartridgeType.getName();
            }
            case 2: {
                return cartridgeType.getProducer();
            }
            case 3: {
                return cartridgeType.getYear();
            }
        }
        if (this.view == 0) {
            CartridgeFile cartridgeFile = this.cartTypeFileMap[n] == -1 ? null : this.cartFiles[this.cartTypeFileMap[n]];
            String string = cartridgeFile != null ? cartridgeFile.getFile().getName() : "";
            return string;
        }
        return this.cartFiles[n].getFile().getName();
    }

    private void resort() {
        CartridgeTableModel cartridgeTableModel = this;
        if (cartridgeTableModel == null) {
            throw null;
        }
        Arrays.sort(this.cartTypes, new Comparator(cartridgeTableModel){
            private final /* synthetic */ CartridgeTableModel this$0;

            public int compare(Object object, Object object2) {
                return ((CartridgeType)object).getName().compareTo(((CartridgeType)object2).getName());
            }
            {
                this.this$0 = cartridgeTableModel;
                this.constructor$0(cartridgeTableModel);
            }

            private final void constructor$0(CartridgeTableModel cartridgeTableModel) {
            }
        });
    }

    private void remapTypesToFiles() {
        int n = 0;
        while (n < this.cartTypes.length) {
            this.cartTypeFileMap[n] = -1;
            int n2 = 0;
            while (n2 < this.cartFiles.length) {
                if (this.cartFiles[n2].getType() == this.cartTypes[n]) {
                    this.cartTypeFileMap[n] = n2;
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    public CartridgeTableModel() {
        this.init();
    }
}

