/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.plugin;

import com.bliss.core.Intellivision;
import com.bliss.core.cartridge.Cartridge;
import com.bliss.core.devices.AudioOutputDevice;
import com.bliss.core.devices.ClockDevice;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.PlugIn;
import com.bliss.core.devices.VideoOutputDevice;
import com.blissj.plugin.AppAudioOutputDevice;
import com.blissj.plugin.AppClockDevice;
import com.blissj.plugin.AppInputDevice;
import com.blissj.plugin.AppVideoOutputDevice;
import java.util.ResourceBundle;

public class AppPlugIn
implements PlugIn {
    static ResourceBundle RESOURCES = ResourceBundle.getBundle("i18n/AppPlugInResources");
    private AppClockDevice cd = new AppClockDevice();
    private AppVideoOutputDevice vod = new AppVideoOutputDevice();
    private AppAudioOutputDevice aod = new AppAudioOutputDevice();
    private AppInputDevice id = new AppInputDevice();

    public void init(Intellivision intellivision) {
        Cartridge cartridge;
        String string = "";
        if (intellivision != null && (cartridge = intellivision.getCartridge()) != null) {
            string = cartridge.getType().getName();
        }
        this.vod.init(string, intellivision.getImageBank());
        this.aod.init();
        this.id.init();
    }

    public void release(Intellivision intellivision) {
        this.id.release();
        this.aod.release();
        this.vod.release();
    }

    public boolean stopRequested() {
        return this.vod.stop || this.id.stop;
    }

    public String getPlugInName() {
        return RESOURCES.getString("AppPlugInName");
    }

    public String getPlugInDescription() {
        return RESOURCES.getString("AppPlugInDescription");
    }

    public ClockDevice getClockDevice() {
        return this.cd;
    }

    public VideoOutputDevice getVideoOutputDevice() {
        return this.vod;
    }

    public AudioOutputDevice getAudioOutputDevice() {
        return this.aod;
    }

    public InputDevice getInputDevice() {
        return this.id;
    }
}

