/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.AudioMixer;
import com.bliss.core.IODevice;
import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.MemoryAlias;
import com.bliss.core.Peripheral;
import com.bliss.core.Processor;
import com.bliss.core.RAM;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.devices.PlugIn;
import java.io.IOException;

public class AY38914
extends Processor
implements Peripheral {
    private static final int TICK_LENGTH_POLLING = 14934;
    private static final int DEFAULT_CLOCK_DIVISOR = 1;
    private static final int[] amplitudes16Bit = new int[]{60, 85, 121, 171, 241, 341, 483, 682, 965, 1365, 1931, 2731, 3862, 5461, 7723, 10922};
    private int clockDivisor = 1;
    private PlugIn plugIn;
    private AudioMixer.AudioOutputLine aol;
    private Registers registers;
    private MemoryAlias registerAlias;
    private Channel channel0;
    private Channel channel1;
    private Channel channel2;
    private boolean cachedTotalOutputIsDirty;
    private int cachedTotalOutput;
    private boolean envelopeIdle;
    private int envelopePeriod;
    private int envelopePeriodValue;
    private int envelopeCounter;
    private int envelopeVolume;
    private boolean envelopeHold;
    private boolean envelopeAltr;
    private boolean envelopeAtak;
    private boolean envelopeCont;
    private IODevice ioDevice0;
    private IODevice ioDevice1;
    private boolean outputEnabled0;
    private boolean outputEnabled1;
    private boolean noiseIdle;
    private int noisePeriod;
    private int noisePeriodValue;
    private int noiseCounter;
    private int random;
    private boolean noise;

    public int getMemoryCount() {
        return 1;
    }

    public Memory getMemory(int n) {
        return this.registerAlias;
    }

    public int getProcessorCount() {
        return 1;
    }

    public Processor getProcessor(int n) {
        return this;
    }

    public int getClockSpeed() {
        return 3579545;
    }

    public void reset() {
        this.registers.reset();
        this.registerAlias.reset();
        this.noisePeriod = 0;
        this.noiseCounter = this.noisePeriodValue = 32;
        this.random = 1;
        this.noise = true;
        this.noiseIdle = true;
        this.channel0.reset();
        this.channel1.reset();
        this.channel2.reset();
        this.envelopeIdle = true;
        this.envelopePeriod = 0;
        this.envelopeCounter = this.envelopePeriodValue = 65536;
        this.envelopeVolume = 0;
        this.envelopeHold = false;
        this.envelopeAltr = false;
        this.envelopeAtak = false;
        this.envelopeCont = false;
        this.ioDevice0.reset();
        this.ioDevice1.reset();
        this.outputEnabled0 = false;
        this.outputEnabled1 = false;
    }

    public int tick() {
        this.envelopeCounter -= this.clockDivisor;
        if (this.envelopeCounter <= 0) {
            do {
                this.envelopeCounter += this.envelopePeriodValue;
                if (this.envelopeIdle) continue;
                this.envelopeVolume += this.envelopeAtak ? 1 : -1;
                if (this.envelopeVolume > 15 || this.envelopeVolume < 0) {
                    if (!this.envelopeCont) {
                        this.envelopeVolume = 0;
                        this.envelopeIdle = true;
                    } else if (this.envelopeHold) {
                        this.envelopeVolume = this.envelopeAtak == this.envelopeAltr ? 0 : 15;
                        this.envelopeIdle = true;
                    } else {
                        this.envelopeAtak = this.envelopeAtak != this.envelopeAltr;
                        this.envelopeVolume = this.envelopeAtak ? 0 : 15;
                    }
                }
                this.channel0.isDirty = this.channel0.envelope;
                this.channel1.isDirty = this.channel1.envelope;
                this.channel2.isDirty = this.channel2.envelope;
            } while (this.envelopeCounter <= 0);
        }
        this.noiseCounter -= this.clockDivisor;
        if (this.noiseCounter <= 0) {
            boolean bl = this.noise;
            do {
                this.noiseCounter += this.noisePeriodValue;
                if (this.noiseIdle) continue;
                this.random = this.random >> 1 ^ (this.noise ? 81920 : 0);
                boolean bl2 = this.noise = (this.random & 1) != 0;
            } while (this.noiseCounter <= 0);
            if (bl != this.noise) {
                this.channel0.isDirty = this.channel0.isDirty || !this.channel0.noiseDisabled;
                this.channel1.isDirty = this.channel1.isDirty || !this.channel1.noiseDisabled;
                this.channel2.isDirty = this.channel2.isDirty || !this.channel2.noiseDisabled;
            }
        }
        this.channel0.toneCounter -= this.clockDivisor;
        if (this.channel0.toneCounter <= 0) {
            do {
                this.channel0.toneCounter += this.channel0.periodValue;
                boolean bl = this.channel0.tone = !this.channel0.tone;
            } while (this.channel0.toneCounter <= 0);
            if (!this.channel0.toneDisabled) {
                this.channel0.isDirty = true;
            }
        }
        this.channel1.toneCounter -= this.clockDivisor;
        if (this.channel1.toneCounter <= 0) {
            do {
                this.channel1.toneCounter += this.channel1.periodValue;
                boolean bl = this.channel1.tone = !this.channel1.tone;
            } while (this.channel1.toneCounter <= 0);
            if (!this.channel1.toneDisabled) {
                this.channel1.isDirty = true;
            }
        }
        this.channel2.toneCounter -= this.clockDivisor;
        if (this.channel2.toneCounter <= 0) {
            do {
                this.channel2.toneCounter += this.channel2.periodValue;
                boolean bl = this.channel2.tone = !this.channel2.tone;
            } while (this.channel2.toneCounter <= 0);
            if (!this.channel2.toneDisabled) {
                this.channel2.isDirty = true;
            }
        }
        if (this.channel0.isDirty) {
            this.channel0.cachedSample = amplitudes16Bit[(this.channel0.toneDisabled | this.channel0.tone) & (this.channel0.noiseDisabled | this.noise) ? (this.channel0.envelope ? this.envelopeVolume : this.channel0.volume) : 0];
            this.channel0.isDirty = false;
            this.cachedTotalOutputIsDirty = true;
        }
        if (this.channel1.isDirty) {
            this.channel1.cachedSample = amplitudes16Bit[(this.channel1.toneDisabled | this.channel1.tone) & (this.channel1.noiseDisabled | this.noise) ? (this.channel1.envelope ? this.envelopeVolume : this.channel1.volume) : 0];
            this.channel1.isDirty = false;
            this.cachedTotalOutputIsDirty = true;
        }
        if (this.channel2.isDirty) {
            this.channel2.cachedSample = amplitudes16Bit[(this.channel2.toneDisabled | this.channel2.tone) & (this.channel2.noiseDisabled | this.noise) ? (this.channel2.envelope ? this.envelopeVolume : this.channel2.volume) : 0];
            this.channel2.isDirty = false;
            this.cachedTotalOutputIsDirty = true;
        }
        if (this.cachedTotalOutputIsDirty) {
            this.cachedTotalOutput = this.channel0.cachedSample + this.channel1.cachedSample + this.channel2.cachedSample;
        }
        this.aol.writeSample(this.cachedTotalOutput);
        return this.clockDivisor << 4;
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        this.registers.save(saveOutputStream);
        saveOutputStream.writeBoolean(this.envelopeIdle);
        saveOutputStream.writeInt(this.envelopeCounter);
        saveOutputStream.writeInt(this.envelopePeriod);
        saveOutputStream.writeInt(this.envelopePeriodValue);
        saveOutputStream.writeInt(this.envelopeVolume);
        saveOutputStream.writeBoolean(this.envelopeHold);
        saveOutputStream.writeBoolean(this.envelopeAltr);
        saveOutputStream.writeBoolean(this.envelopeAtak);
        saveOutputStream.writeBoolean(this.envelopeCont);
        saveOutputStream.writeBoolean(this.noiseIdle);
        saveOutputStream.writeInt(this.noiseCounter);
        saveOutputStream.writeInt(this.noisePeriod);
        saveOutputStream.writeInt(this.noisePeriodValue);
        this.channel0.save(saveOutputStream);
        this.channel1.save(saveOutputStream);
        this.channel2.save(saveOutputStream);
        saveOutputStream.writeBoolean(this.outputEnabled0);
        saveOutputStream.writeBoolean(this.outputEnabled1);
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.registers.load(loadInputStream);
        this.envelopeIdle = loadInputStream.readBoolean();
        this.envelopeCounter = loadInputStream.readInt(1, 65536);
        this.envelopePeriod = loadInputStream.readInt(0, 65535);
        this.envelopePeriodValue = loadInputStream.readInt(1, 65536);
        this.envelopeVolume = loadInputStream.readInt(0, 15);
        this.envelopeHold = loadInputStream.readBoolean();
        this.envelopeAltr = loadInputStream.readBoolean();
        this.envelopeAtak = loadInputStream.readBoolean();
        this.envelopeCont = loadInputStream.readBoolean();
        this.noiseIdle = loadInputStream.readBoolean();
        this.noiseCounter = loadInputStream.readInt(1, 32);
        this.noisePeriod = loadInputStream.readInt(0, 63);
        this.noisePeriodValue = loadInputStream.readInt(1, 32);
        this.channel0.load(loadInputStream);
        this.channel1.load(loadInputStream);
        this.channel2.load(loadInputStream);
        this.outputEnabled0 = loadInputStream.readBoolean();
        this.outputEnabled1 = loadInputStream.readBoolean();
        this.cachedTotalOutputIsDirty = true;
    }

    public void setClockDivisor(int n) {
        this.clockDivisor = n;
    }

    public int getClockDivisor() {
        return this.clockDivisor;
    }

    static /* synthetic */ boolean access$11(AY38914 aY38914) {
        return aY38914.noiseIdle;
    }

    static /* synthetic */ int access$15(AY38914 aY38914) {
        return aY38914.noisePeriodValue;
    }

    static /* synthetic */ boolean access$17(AY38914 aY38914) {
        return aY38914.envelopeHold;
    }

    static /* synthetic */ boolean access$19(AY38914 aY38914) {
        return aY38914.envelopeAltr;
    }

    static /* synthetic */ boolean access$23(AY38914 aY38914) {
        return aY38914.envelopeCont;
    }

    static /* synthetic */ int access$25(AY38914 aY38914) {
        return aY38914.envelopeVolume;
    }

    static /* synthetic */ int access$27(AY38914 aY38914) {
        return aY38914.envelopeCounter;
    }

    static /* synthetic */ boolean access$29(AY38914 aY38914) {
        return aY38914.envelopeIdle;
    }

    public AY38914(AudioMixer.AudioOutputLine audioOutputLine, int n, IODevice iODevice, IODevice iODevice2) {
        AY38914 aY38914 = this;
        if (aY38914 == null) {
            throw null;
        }
        this.channel0 = aY38914.new Channel();
        AY38914 aY389142 = this;
        if (aY389142 == null) {
            throw null;
        }
        this.channel1 = aY389142.new Channel();
        AY38914 aY389143 = this;
        if (aY389143 == null) {
            throw null;
        }
        this.channel2 = aY389143.new Channel();
        this.cachedTotalOutputIsDirty = true;
        this.envelopeIdle = true;
        this.envelopeCounter = this.envelopePeriodValue = 65536;
        this.noiseIdle = false;
        this.noiseCounter = this.noisePeriodValue = 32;
        this.random = 1;
        this.noise = true;
        this.aol = audioOutputLine;
        AY38914 aY389144 = this;
        if (aY389144 == null) {
            throw null;
        }
        this.registers = aY389144.new Registers();
        this.registerAlias = new MemoryAlias(this.registers, n);
        this.ioDevice0 = iODevice;
        this.ioDevice1 = iODevice2;
    }

    private class Registers
    extends RAM {
        public void poke(int n, int n2) {
            switch (n) {
                case 0: {
                    ((AY38914)AY38914.this).channel0.period = ((AY38914)AY38914.this).channel0.period & 0xF00 | (n2 &= 0xFF);
                    ((AY38914)AY38914.this).channel0.periodValue = ((AY38914)AY38914.this).channel0.period == 0 ? 4096 : ((AY38914)AY38914.this).channel0.period;
                    break;
                }
                case 1: {
                    ((AY38914)AY38914.this).channel1.period = ((AY38914)AY38914.this).channel1.period & 0xF00 | (n2 &= 0xFF);
                    ((AY38914)AY38914.this).channel1.periodValue = ((AY38914)AY38914.this).channel1.period == 0 ? 4096 : ((AY38914)AY38914.this).channel1.period;
                    break;
                }
                case 2: {
                    ((AY38914)AY38914.this).channel2.period = ((AY38914)AY38914.this).channel2.period & 0xF00 | (n2 &= 0xFF);
                    ((AY38914)AY38914.this).channel2.periodValue = ((AY38914)AY38914.this).channel2.period == 0 ? 4096 : ((AY38914)AY38914.this).channel2.period;
                    break;
                }
                case 3: {
                    AY38914.this.envelopePeriod = AY38914.this.envelopePeriod & 0xFF00 | (n2 &= 0xFF);
                    AY38914.this.envelopePeriodValue = AY38914.this.envelopePeriod == 0 ? 65536 : AY38914.this.envelopePeriod << 1;
                    break;
                }
                case 4: {
                    ((AY38914)AY38914.this).channel0.period = ((AY38914)AY38914.this).channel0.period & 0xFF | (n2 &= 0xF) << 8;
                    ((AY38914)AY38914.this).channel0.periodValue = ((AY38914)AY38914.this).channel0.period == 0 ? 4096 : ((AY38914)AY38914.this).channel0.period;
                    break;
                }
                case 5: {
                    ((AY38914)AY38914.this).channel1.period = ((AY38914)AY38914.this).channel1.period & 0xFF | (n2 &= 0xF) << 8;
                    ((AY38914)AY38914.this).channel1.periodValue = ((AY38914)AY38914.this).channel1.period == 0 ? 4096 : ((AY38914)AY38914.this).channel1.period;
                    break;
                }
                case 6: {
                    ((AY38914)AY38914.this).channel2.period = ((AY38914)AY38914.this).channel2.period & 0xFF | (n2 &= 0xF) << 8;
                    ((AY38914)AY38914.this).channel2.periodValue = ((AY38914)AY38914.this).channel2.period == 0 ? 4096 : ((AY38914)AY38914.this).channel2.period;
                    break;
                }
                case 7: {
                    AY38914.this.envelopePeriod = AY38914.this.envelopePeriod & 0xFF | (n2 &= 0xFF) << 8;
                    AY38914.this.envelopePeriodValue = AY38914.this.envelopePeriod == 0 ? 65536 : AY38914.this.envelopePeriod << 1;
                    break;
                }
                case 8: {
                    AY38914.this.outputEnabled0 = ((n2 &= 0xFF) & 0x40) != 0;
                    AY38914.this.outputEnabled1 = (n2 & 0x80) != 0;
                    ((AY38914)AY38914.this).channel0.toneDisabled = (n2 & 1) != 0;
                    ((AY38914)AY38914.this).channel1.toneDisabled = (n2 & 2) != 0;
                    ((AY38914)AY38914.this).channel2.toneDisabled = (n2 & 4) != 0;
                    ((AY38914)AY38914.this).channel0.noiseDisabled = (n2 & 8) != 0;
                    ((AY38914)AY38914.this).channel1.noiseDisabled = (n2 & 0x10) != 0;
                    ((AY38914)AY38914.this).channel2.noiseDisabled = (n2 & 0x20) != 0;
                    ((AY38914)AY38914.this).channel0.isDirty = true;
                    ((AY38914)AY38914.this).channel1.isDirty = true;
                    ((AY38914)AY38914.this).channel2.isDirty = true;
                    AY38914.this.noiseIdle = ((AY38914)AY38914.this).channel0.noiseDisabled & ((AY38914)AY38914.this).channel1.noiseDisabled & ((AY38914)AY38914.this).channel2.noiseDisabled;
                    break;
                }
                case 9: {
                    AY38914.this.noisePeriod = (n2 &= 0x1F);
                    AY38914.this.noisePeriodValue = AY38914.this.noisePeriod == 0 ? 32 : AY38914.this.noisePeriod << 1;
                    break;
                }
                case 10: {
                    AY38914.this.envelopeHold = ((n2 &= 0xF) & 1) != 0;
                    AY38914.this.envelopeAltr = (n2 & 2) != 0;
                    AY38914.this.envelopeAtak = (n2 & 4) != 0;
                    AY38914.this.envelopeCont = (n2 & 8) != 0;
                    AY38914.this.envelopeVolume = AY38914.this.envelopeAtak ? 0 : 15;
                    AY38914.this.envelopeCounter = AY38914.this.envelopePeriodValue;
                    AY38914.this.envelopeIdle = false;
                    break;
                }
                case 11: {
                    ((AY38914)AY38914.this).channel0.envelope = ((n2 &= 0x3F) & 0x10) != 0;
                    ((AY38914)AY38914.this).channel0.volume = n2 & 0xF;
                    ((AY38914)AY38914.this).channel0.isDirty = true;
                    break;
                }
                case 12: {
                    ((AY38914)AY38914.this).channel1.envelope = ((n2 &= 0x3F) & 0x10) != 0;
                    ((AY38914)AY38914.this).channel1.volume = n2 & 0xF;
                    ((AY38914)AY38914.this).channel1.isDirty = true;
                    break;
                }
                case 13: {
                    ((AY38914)AY38914.this).channel2.envelope = ((n2 &= 0x3F) & 0x10) != 0;
                    ((AY38914)AY38914.this).channel2.volume = n2 & 0xF;
                    ((AY38914)AY38914.this).channel2.isDirty = true;
                    break;
                }
                case 14: {
                    if (!AY38914.this.outputEnabled1) break;
                    AY38914.this.ioDevice1.setOutputValue(n2);
                    break;
                }
                case 15: {
                    if (!AY38914.this.outputEnabled0) break;
                    AY38914.this.ioDevice0.setOutputValue(n2);
                    break;
                }
            }
            super.poke(n, n2);
        }

        public int peek(int n) {
            switch (n) {
                case 14: {
                    return !AY38914.this.outputEnabled1 ? AY38914.this.ioDevice1.getInputValue() : 0;
                }
                case 15: {
                    return !AY38914.this.outputEnabled0 ? AY38914.this.ioDevice0.getInputValue() : 0;
                }
            }
            return super.peek(n);
        }

        private Registers() {
            super(16, 0, 8);
        }
    }

    private class Channel {
        int period;
        int periodValue;
        int volume;
        int toneCounter;
        boolean tone;
        boolean envelope = false;
        boolean toneDisabled;
        boolean noiseDisabled;
        boolean isDirty;
        int cachedSample;

        private void reset() {
            this.volume = 0;
            this.period = 0;
            this.toneCounter = this.periodValue = 4096;
            this.tone = false;
            this.envelope = false;
            this.toneDisabled = false;
            this.noiseDisabled = false;
            this.isDirty = true;
        }

        private void save(SaveOutputStream saveOutputStream) throws IOException {
            saveOutputStream.writeInt(this.period);
            saveOutputStream.writeInt(this.periodValue);
            saveOutputStream.writeInt(this.volume);
            saveOutputStream.writeInt(this.toneCounter);
            saveOutputStream.writeBoolean(this.tone);
            saveOutputStream.writeBoolean(this.envelope);
            saveOutputStream.writeBoolean(this.toneDisabled);
            saveOutputStream.writeBoolean(this.noiseDisabled);
        }

        private void load(LoadInputStream loadInputStream) throws IOException {
            this.period = loadInputStream.readInt(0, 4095);
            this.periodValue = loadInputStream.readInt(1, 4096);
            this.volume = loadInputStream.readInt(0, 15);
            this.toneCounter = loadInputStream.readInt(1, 4096);
            this.tone = loadInputStream.readBoolean();
            this.envelope = loadInputStream.readBoolean();
            this.toneDisabled = loadInputStream.readBoolean();
            this.noiseDisabled = loadInputStream.readBoolean();
            this.isDirty = true;
        }

        Channel() {
        }
    }
}

