/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.IODevice;
import com.bliss.core.Intellivision;
import com.bliss.core.devices.InputDevice;

public class ECSKeyboard
implements IODevice {
    private static final int[] CONTROL_IDS = new int[]{5038, 5040, 5013, 5021, 5023, 5042, 5041, 5012, 5001, 5002, 5025, 5037, 5043, 5010, 5007, 5005, 5018, 5036, 5015, 5008, 5024, 5017, 5022, 5016, 5045, 5035, 5033, 5031, 5029, 5027, 5026, 5034, 5032, 5030, 5028, 5039, 5046, 5014, 5020, 5019, 5004, 5047, 5011, 5009, 5006, 5003, 5000, 5048};
    private static final int[] orderedMapping = new int[]{46, 8, 9, 45, 40, 15, 44, 14, 19, 43, 13, 42, 7, 2, 37, 18, 23, 21, 16, 39, 38, 3, 22, 4, 20, 10, 30, 29, 34, 28, 33, 27, 32, 26, 31, 25, 17, 11, 0, 35, 1, 6, 12, 5, 36, 41, 47, 24};
    private static final String[] descriptionKeys = new String[]{"InputECSLeft", "InputECSComma", "InputECSN", "InputECSV", "InputECSX", "InputECSSpace", "InputECSPeriod", "InputECSM", "InputECSB", "InputECSC", "InputECSZ", "InputECSDown", "InputECSSemiColon", "InputECSK", "InputECSH", "InputECSF", "InputECSS", "InputECSUp", "InputECSP", "InputECSI", "InputECSY", "InputECSR", "InputECSW", "InputECSQ", "InputECSEscape", "InputECS9", "InputECS7", "InputECS5", "InputECS3", "InputECS1", "InputECS0", "InputECS8", "InputECS6", "InputECS4", "InputECS2", "InputECSRight", "InputECSEnter", "InputECSO", "InputECSU", "InputECST", "InputECSE", "InputECSControl", "InputECSL", "InputECSJ", "InputECSG", "InputECSD", "InputECSA", "InputECSShift"};
    private int rowsToScan;
    private InputDevice inputDevice;
    private int[] rowInputValues = new int[8];

    public void setInputDevice(InputDevice inputDevice) {
        this.inputDevice = inputDevice;
    }

    public void reset() {
        int n = 0;
        while (n < 8) {
            this.rowInputValues[n] = 0;
            ++n;
        }
    }

    public void poll() {
        int n = 0;
        while (n < 6) {
            this.rowInputValues[n] = 0;
            if (this.inputDevice.getControlValue(CONTROL_IDS[n]) == 1.0f) {
                int n2 = n;
                this.rowInputValues[n2] = this.rowInputValues[n2] | 1;
            }
            if (this.inputDevice.getControlValue(CONTROL_IDS[n + 6]) == 1.0f) {
                int n3 = n;
                this.rowInputValues[n3] = this.rowInputValues[n3] | 2;
            }
            if (this.inputDevice.getControlValue(CONTROL_IDS[n + 12]) == 1.0f) {
                int n4 = n;
                this.rowInputValues[n4] = this.rowInputValues[n4] | 4;
            }
            if (this.inputDevice.getControlValue(CONTROL_IDS[n + 18]) == 1.0f) {
                int n5 = n;
                this.rowInputValues[n5] = this.rowInputValues[n5] | 8;
            }
            if (this.inputDevice.getControlValue(CONTROL_IDS[n + 24]) == 1.0f) {
                int n6 = n;
                this.rowInputValues[n6] = this.rowInputValues[n6] | 0x10;
            }
            if (this.inputDevice.getControlValue(CONTROL_IDS[n + 30]) == 1.0f) {
                int n7 = n;
                this.rowInputValues[n7] = this.rowInputValues[n7] | 0x20;
            }
            if (this.inputDevice.getControlValue(CONTROL_IDS[n + 36]) == 1.0f) {
                int n8 = n;
                this.rowInputValues[n8] = this.rowInputValues[n8] | 0x40;
            }
            if (n > 0 && this.inputDevice.getControlValue(CONTROL_IDS[n + 41]) == 1.0f) {
                int n9 = n;
                this.rowInputValues[n9] = this.rowInputValues[n9] | 0x80;
            }
            ++n;
        }
        this.rowInputValues[6] = this.inputDevice.getControlValue(CONTROL_IDS[47]) == 1.0f ? 128 : 0;
    }

    public int getInputValue() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 8) {
            if ((this.rowsToScan & n2) != 0) {
                n2 <<= 1;
            } else {
                n |= this.rowInputValues[n3];
                n2 <<= 1;
            }
            ++n3;
        }
        return 0xFF ^ n;
    }

    public void setOutputValue(int n) {
        this.rowsToScan = n;
    }

    public int getControlCount() {
        return CONTROL_IDS.length;
    }

    public int getControlID(int n) {
        return CONTROL_IDS[orderedMapping[n]];
    }

    public String getControlDescription(int n) {
        return Intellivision.RESOURCES.getString(descriptionKeys[orderedMapping[n]]);
    }
}

