/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.BackTabRAM;
import com.bliss.core.CP1610;
import com.bliss.core.EmulationDirector;
import com.bliss.core.GRAM;
import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.MemoryAlias;
import com.bliss.core.Peripheral;
import com.bliss.core.Processor;
import com.bliss.core.ROM;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.SignalLine;
import com.bliss.core.Sprite;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class AY38900
extends Processor
implements Peripheral {
    private static final int MODE_INIT = -1;
    private static final int MODE_VBLANK = 0;
    private static final int MODE_START_ACTIVE_DISPLAY = 1;
    private static final int MODE_IDLE_ACTIVE_DISPLAY = 2;
    private static final int MODE_FETCH_ROW_0 = 3;
    private static final int MODE_RENDER_ROW_0 = 4;
    private static final int MODE_FETCH_ROW_1 = 5;
    private static final int MODE_RENDER_ROW_1 = 6;
    private static final int MODE_FETCH_ROW_2 = 7;
    private static final int MODE_RENDER_ROW_2 = 8;
    private static final int MODE_FETCH_ROW_3 = 9;
    private static final int MODE_RENDER_ROW_3 = 10;
    private static final int MODE_FETCH_ROW_4 = 11;
    private static final int MODE_RENDER_ROW_4 = 12;
    private static final int MODE_FETCH_ROW_5 = 13;
    private static final int MODE_RENDER_ROW_5 = 14;
    private static final int MODE_FETCH_ROW_6 = 15;
    private static final int MODE_RENDER_ROW_6 = 16;
    private static final int MODE_FETCH_ROW_7 = 17;
    private static final int MODE_RENDER_ROW_7 = 18;
    private static final int MODE_FETCH_ROW_8 = 19;
    private static final int MODE_RENDER_ROW_8 = 20;
    private static final int MODE_FETCH_ROW_9 = 21;
    private static final int MODE_RENDER_ROW_9 = 22;
    private static final int MODE_FETCH_ROW_10 = 23;
    private static final int MODE_RENDER_ROW_10 = 24;
    private static final int MODE_FETCH_ROW_11 = 25;
    private static final int MODE_RENDER_ROW_11 = 26;
    private static final int MODE_FETCH_ROW_12 = 27;
    static final int TICK_LENGTH_SCANLINE = 228;
    static final int TICK_LENGTH_FRAME = 59736;
    static final int TICK_LENGTH_VBLANK = 15162;
    static final int TICK_LENGTH_START_ACTIVE_DISPLAY = 114;
    static final int TICK_LENGTH_IDLE_ACTIVE_DISPLAY = 456;
    static final int TICK_LENGTH_FETCH_ROW = 456;
    static final int TICK_LENGTH_RENDER_ROW = 3192;
    protected static final int BACKTAB = 512;
    protected static final int GROM = 12288;
    protected static final int GRAM = 14336;
    protected static final int COLORSTACK = 40;
    protected static final int FOREGROUND_BIT = 16;
    protected static final byte[][] palette = new byte[][]{{0, 0, -1, -55, 56, 0, -6, -1, -67, 36, -1, 84, -1, -92, 117, -75}, {0, 45, 61, -49, 107, -89, -22, -4, -84, -72, -76, 110, 78, -106, -52, 26}, {0, -1, 16, -85, 63, 86, 80, -1, -56, -1, 31, 0, 87, -1, -128, 88}};
    public static final IndexColorModel COLOR_MODEL;
    protected MemoryAlias[] memorySegments;
    protected int mode = -1;
    protected EmulationDirector director;
    protected CP1610 cpu;
    protected SignalLine SR1;
    protected SignalLine SR2;
    protected SignalLine SST;
    protected BackTabRAM backtab;
    protected GRAM gram;
    protected int[] gromImage;
    protected ROM grom;
    protected Registers registers;
    protected boolean previousDisplayEnabled;
    protected boolean displayEnabled;
    protected boolean colorStackMode;
    protected boolean colorModeChanged;
    protected boolean bordersChanged;
    protected boolean colorStackChanged;
    protected boolean offsetsChanged;
    protected boolean hasGROMImage;
    protected String message;
    protected boolean messageChanged;
    protected int messageCounter;
    protected boolean imageBufferChanged;
    private byte borderColor;
    private boolean blockLeft;
    private boolean blockTop;
    private int horizontalOffset;
    private int verticalOffset;
    protected byte[] stagingBankData;
    protected Sprite[] sprites;
    protected byte[][] backgroundDataBuffer = new byte[192][320];
    protected boolean[][][] spriteBuffers = new boolean[8][16][128];

    public int getProcessorCount() {
        return 1;
    }

    public Processor getProcessor(int n) {
        return this;
    }

    public int getMemoryCount() {
        return this.memorySegments.length;
    }

    public Memory getMemory(int n) {
        return this.memorySegments[n];
    }

    public int getClockSpeed() {
        return 3579545;
    }

    public void setMessage(String string) {
        this.setMessage(string, 0);
    }

    public void setMessage(String string, int n) {
        this.message = string;
        if (string != null) {
            this.messageCounter = 60 * n;
            this.renderMessage();
            this.director.displayImage(this.imageBufferChanged);
        }
        this.messageChanged = true;
    }

    public void reset() {
        this.registers.reset();
        this.setGraphicsBusVisible(true);
        int n = 1;
        while (n < this.memorySegments.length) {
            this.memorySegments[n].reset();
            ++n;
        }
        n = 0;
        while (n < this.sprites.length) {
            this.sprites[n].reset();
            ++n;
        }
        this.mode = -1;
        this.SR1.isHigh = true;
        this.SR2.isHigh = true;
        this.cpu.isIdle = false;
        this.backtab.reset();
        this.gram.reset();
        this.grom.reset();
        this.previousDisplayEnabled = true;
        this.displayEnabled = false;
        this.colorStackMode = false;
        this.colorModeChanged = true;
        this.bordersChanged = true;
        this.colorStackChanged = true;
        this.offsetsChanged = true;
        this.messageChanged = true;
        this.imageBufferChanged = true;
        this.borderColor = 0;
        this.blockTop = false;
        this.blockLeft = false;
        this.verticalOffset = 0;
        this.horizontalOffset = 0;
        n = 0;
        while (n < this.stagingBankData.length) {
            this.stagingBankData[n] = 0;
            ++n;
        }
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeInt(this.mode);
        saveOutputStream.writeBoolean(this.SR1.isHigh);
        saveOutputStream.writeBoolean(this.SR2.isHigh);
        saveOutputStream.writeBoolean(this.previousDisplayEnabled);
        saveOutputStream.writeBoolean(this.displayEnabled);
        saveOutputStream.writeBoolean(this.colorStackMode);
        saveOutputStream.write(this.borderColor);
        saveOutputStream.writeBoolean(this.blockLeft);
        saveOutputStream.writeBoolean(this.blockTop);
        saveOutputStream.writeInt(this.horizontalOffset);
        saveOutputStream.writeInt(this.verticalOffset);
        this.backtab.save(saveOutputStream);
        this.gram.save(saveOutputStream);
        this.registers.save(saveOutputStream);
        int n = 0;
        while (n < 8) {
            this.sprites[n].save(saveOutputStream);
            ++n;
        }
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.mode = loadInputStream.readInt(-1, 27);
        this.SR1.isHigh = loadInputStream.readBoolean();
        this.SR2.isHigh = loadInputStream.readBoolean();
        this.previousDisplayEnabled = loadInputStream.readBoolean();
        this.displayEnabled = loadInputStream.readBoolean();
        this.colorStackMode = loadInputStream.readBoolean();
        this.borderColor = (byte)loadInputStream.read(0, 15);
        this.blockLeft = loadInputStream.readBoolean();
        this.blockTop = loadInputStream.readBoolean();
        this.horizontalOffset = loadInputStream.readInt(0, 7);
        this.verticalOffset = loadInputStream.readInt(0, 7);
        this.backtab.load(loadInputStream);
        this.gram.load(loadInputStream);
        this.registers.load(loadInputStream);
        int n = 0;
        while (n < 8) {
            this.sprites[n].load(loadInputStream);
            ++n;
        }
        this.offsetsChanged = true;
        this.bordersChanged = true;
        this.colorStackChanged = true;
        this.colorModeChanged = true;
    }

    public int tick() {
        ++this.mode;
        switch (this.mode) {
            case 0: {
                this.renderFrame();
                this.displayEnabled = false;
                this.director.pollInput();
                this.director.displayImage(this.imageBufferChanged);
                this.imageBufferChanged = false;
                if (this.messageCounter > 0) {
                    --this.messageCounter;
                    if (this.messageCounter == 0) {
                        this.message = null;
                        this.messageChanged = true;
                    }
                }
                this.setGraphicsBusVisible(true);
                this.SR2.isHigh = true;
                this.cpu.isIdle = false;
                this.SR1.isHigh = false;
                return 15162;
            }
            case 1: {
                this.SR1.isHigh = true;
                if (!this.displayEnabled) {
                    if (this.previousDisplayEnabled) {
                        int n = 0;
                        while (n < this.stagingBankData.length) {
                            this.stagingBankData[n] = this.borderColor;
                            ++n;
                        }
                    }
                    this.mode = -1;
                    return 44574;
                }
                this.previousDisplayEnabled = true;
                this.SR2.isHigh = false;
                return 114;
            }
            case 2: {
                if (!this.SST.isHigh) {
                    this.setGraphicsBusVisible(false);
                }
                this.SR2.isHigh = true;
                this.cpu.isIdle = false;
                return 456 + this.verticalOffset * 228 * 2;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                this.SR2.isHigh = false;
                return 456;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                this.SR2.isHigh = true;
                this.cpu.isIdle = false;
                return 3192;
            }
            case 26: {
                this.SR2.isHigh = true;
                this.cpu.isIdle = false;
                switch (this.verticalOffset) {
                    case 0: {
                        return 3192;
                    }
                    case 1: {
                        this.mode = -1;
                        return 2964;
                    }
                }
                this.mode = -1;
                return 2964 - 2 * (this.verticalOffset - 1) * 228;
            }
        }
        this.mode = -1;
        this.SR2.isHigh = false;
        return 228;
    }

    void writeSnapshot(OutputStream outputStream) throws IOException {
        CRCOutputStream cRCOutputStream = new CRCOutputStream(outputStream);
        cRCOutputStream.write(137);
        cRCOutputStream.write(80);
        cRCOutputStream.write(78);
        cRCOutputStream.write(71);
        cRCOutputStream.write(13);
        cRCOutputStream.write(10);
        cRCOutputStream.write(26);
        cRCOutputStream.write(10);
        int n = 13;
        cRCOutputStream.write((n & 0xFF000000) >> 24);
        cRCOutputStream.write((n & 0xFF0000) >> 16);
        cRCOutputStream.write((n & 0xFF00) >> 8);
        cRCOutputStream.write(n & 0xFF);
        cRCOutputStream.startCRC();
        cRCOutputStream.write(73);
        cRCOutputStream.write(72);
        cRCOutputStream.write(68);
        cRCOutputStream.write(82);
        int n2 = 320;
        cRCOutputStream.write((n2 & 0xFF000000) >> 24);
        cRCOutputStream.write((n2 & 0xFF0000) >> 16);
        cRCOutputStream.write((n2 & 0xFF00) >> 8);
        cRCOutputStream.write(n2 & 0xFF);
        int n3 = 192;
        cRCOutputStream.write((n3 & 0xFF000000) >> 24);
        cRCOutputStream.write((n3 & 0xFF0000) >> 16);
        cRCOutputStream.write((n3 & 0xFF00) >> 8);
        cRCOutputStream.write(n3 & 0xFF);
        cRCOutputStream.write(8);
        cRCOutputStream.write(3);
        cRCOutputStream.write(0);
        cRCOutputStream.write(0);
        cRCOutputStream.write(0);
        cRCOutputStream.writeCRC();
        n = 48;
        cRCOutputStream.write((n & 0xFF000000) >> 24);
        cRCOutputStream.write((n & 0xFF0000) >> 16);
        cRCOutputStream.write((n & 0xFF00) >> 8);
        cRCOutputStream.write(n & 0xFF);
        cRCOutputStream.startCRC();
        cRCOutputStream.write(80);
        cRCOutputStream.write(76);
        cRCOutputStream.write(84);
        cRCOutputStream.write(69);
        int n4 = 0;
        while (n4 < 16) {
            cRCOutputStream.write(palette[0][n4]);
            cRCOutputStream.write(palette[1][n4]);
            cRCOutputStream.write(palette[2][n4]);
            ++n4;
        }
        cRCOutputStream.writeCRC();
        byte[] byArray = new byte[61632];
        int n5 = 0;
        while (n5 < 192) {
            int n6 = n5 * 320;
            int n7 = n5 * 321;
            byArray[n7] = 0;
            int n8 = 0;
            while (n8 < 320) {
                byArray[n7 + n8 + 1] = (byte)(this.stagingBankData[n6 + n8] & 0xF);
                ++n8;
            }
            ++n5;
        }
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        byte[] byArray2 = new byte[byArray.length];
        n = deflater.deflate(byArray2);
        deflater.end();
        cRCOutputStream.write((n & 0xFF000000) >> 24);
        cRCOutputStream.write((n & 0xFF0000) >> 16);
        cRCOutputStream.write((n & 0xFF00) >> 8);
        cRCOutputStream.write(n & 0xFF);
        cRCOutputStream.startCRC();
        cRCOutputStream.write(73);
        cRCOutputStream.write(68);
        cRCOutputStream.write(65);
        cRCOutputStream.write(84);
        cRCOutputStream.write(byArray2, 0, n);
        cRCOutputStream.writeCRC();
        cRCOutputStream.write(0);
        cRCOutputStream.write(0);
        cRCOutputStream.write(0);
        cRCOutputStream.write(0);
        cRCOutputStream.startCRC();
        cRCOutputStream.write(73);
        cRCOutputStream.write(69);
        cRCOutputStream.write(78);
        cRCOutputStream.write(68);
        cRCOutputStream.writeCRC();
    }

    public void setGraphicsBusVisible(boolean bl) {
        int n = 1;
        while (n < this.memorySegments.length) {
            this.memorySegments[n].setVisible(bl);
            ++n;
        }
    }

    private void renderFrame() {
        int n;
        if (this.somethingChanged()) {
            this.renderBorders();
            this.renderBackground();
            this.renderSprites();
            n = 0;
            while (n < 8) {
                this.sprites[n].collisionRegister = 0;
                ++n;
            }
            this.copySpritesToStagingArea();
            this.renderMessage();
            this.determineSpriteCollisions();
            this.markClean();
            this.imageBufferChanged = true;
        }
        n = 0;
        while (n < 8) {
            int n2 = 24 + n;
            this.registers.memory[n2] = this.registers.memory[n2] | this.sprites[n].collisionRegister;
            ++n;
        }
    }

    private void renderMessage() {
        if (this.message != null) {
            int n = this.message.length();
            int n2 = (320 - n * 16) / 2;
            int n3 = 88;
            int n4 = n * 8 + 4;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < 11) {
                    int n7 = (n3 - 3 + n6 * 2) * 320 + n2 - 4 + n5 * 2;
                    int n8 = n7 + 320;
                    this.stagingBankData[n7] = 0;
                    this.stagingBankData[n8] = 0;
                    this.stagingBankData[n7 + 1] = 0;
                    this.stagingBankData[n8 + 1] = 0;
                    ++n6;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n) {
                this.renderCharacter(this.message.charAt(n5), n2, n3);
                n2 += 16;
                ++n5;
            }
        }
        this.messageChanged = false;
    }

    private void renderCharacter(char c, int n, int n2) {
        int n3 = 264 + (c - 65) * 8;
        int n4 = 0;
        while (n4 < 8) {
            int n5 = this.grom.peek(n3 + n4);
            int n6 = (n2 + n4 * 2) * 320 + n;
            int n7 = n6 + 320;
            int n8 = 7;
            if ((n5 & 0x80) != 0) {
                this.stagingBankData[n6] = n8;
                this.stagingBankData[n7] = n8;
                this.stagingBankData[n6 + 1] = n8;
                this.stagingBankData[n7 + 1] = n8;
            }
            if ((n5 & 0x40) != 0) {
                this.stagingBankData[n6 + 2] = n8;
                this.stagingBankData[n7 + 2] = n8;
                this.stagingBankData[n6 + 3] = n8;
                this.stagingBankData[n7 + 3] = n8;
            }
            if ((n5 & 0x20) != 0) {
                this.stagingBankData[n6 + 4] = n8;
                this.stagingBankData[n7 + 4] = n8;
                this.stagingBankData[n6 + 5] = n8;
                this.stagingBankData[n7 + 5] = n8;
            }
            if ((n5 & 0x10) != 0) {
                this.stagingBankData[n6 + 6] = n8;
                this.stagingBankData[n7 + 6] = n8;
                this.stagingBankData[n6 + 7] = n8;
                this.stagingBankData[n7 + 7] = n8;
            }
            if ((n5 & 8) != 0) {
                this.stagingBankData[n6 + 8] = n8;
                this.stagingBankData[n7 + 8] = n8;
                this.stagingBankData[n6 + 9] = n8;
                this.stagingBankData[n7 + 9] = n8;
            }
            if ((n5 & 4) != 0) {
                this.stagingBankData[n6 + 10] = n8;
                this.stagingBankData[n7 + 10] = n8;
                this.stagingBankData[n6 + 11] = n8;
                this.stagingBankData[n7 + 11] = n8;
            }
            if ((n5 & 2) != 0) {
                this.stagingBankData[n6 + 12] = n8;
                this.stagingBankData[n7 + 12] = n8;
                this.stagingBankData[n6 + 13] = n8;
                this.stagingBankData[n7 + 13] = n8;
            }
            if ((n5 & 1) != 0) {
                this.stagingBankData[n6 + 14] = n8;
                this.stagingBankData[n7 + 14] = n8;
                this.stagingBankData[n6 + 15] = n8;
                this.stagingBankData[n7 + 15] = n8;
            }
            ++n4;
        }
    }

    public boolean somethingChanged() {
        return this.offsetsChanged || this.bordersChanged || this.colorStackChanged || this.colorModeChanged || this.backtab.isDirty() || this.gram.isDirty() || this.sprites[0].changed || this.sprites[1].changed || this.sprites[2].changed || this.sprites[3].changed || this.sprites[4].changed || this.sprites[5].changed || this.sprites[6].changed || this.sprites[7].changed;
    }

    private final void markClean() {
        this.messageChanged = false;
        this.offsetsChanged = false;
        this.bordersChanged = false;
        this.colorStackChanged = false;
        this.colorModeChanged = false;
        this.backtab.markClean();
        this.gram.markClean();
        int n = 0;
        while (n < 8) {
            this.sprites[n].markClean();
            ++n;
        }
    }

    public void setGROMImage(int[] nArray) {
        System.arraycopy(nArray, 0, this.gromImage, 0, this.gromImage.length);
        this.hasGROMImage = true;
    }

    public boolean hasGROMImage() {
        return this.hasGROMImage;
    }

    private final void init() {
        this.memorySegments = new MemoryAlias[9];
        this.backtab = new BackTabRAM(240, 0, 16);
        this.memorySegments[0] = new MemoryAlias(this.backtab, 512);
        this.gromImage = new int[2048];
        this.grom = new ROM(this.gromImage, 0);
        this.memorySegments[1] = new MemoryAlias(this.grom, 12288);
        this.gram = new GRAM(512, 0, 8);
        this.memorySegments[2] = new MemoryAlias(this.gram, 14336);
        this.memorySegments[3] = new MemoryAlias(this.gram, 14848);
        this.memorySegments[4] = new MemoryAlias(this.gram, 15360);
        this.memorySegments[5] = new MemoryAlias(this.gram, 15872);
        AY38900 aY38900 = this;
        if (aY38900 == null) {
            throw null;
        }
        this.registers = aY38900.new Registers();
        this.memorySegments[6] = new MemoryAlias(this.registers, 0);
        this.memorySegments[7] = new MemoryAlias(this.registers, 32768, true);
        this.memorySegments[8] = new MemoryAlias(this.registers, 49152, true);
        this.stagingBankData = new byte[61440];
        this.sprites = new Sprite[8];
        int n = 0;
        while (n < 8) {
            this.sprites[n] = new Sprite();
            ++n;
        }
        this.director.setImageBank(this.stagingBankData);
    }

    private final void renderBorders() {
        block11: {
            int n;
            int n2;
            int n3;
            block10: {
                if (!this.bordersChanged && (!this.offsetsChanged || this.blockLeft && this.blockTop)) {
                    return;
                }
                if (this.blockTop) {
                    n3 = 0;
                    while (n3 < 320) {
                        this.stagingBankData[n3] = this.borderColor;
                        this.stagingBankData[n3 + 320] = this.borderColor;
                        this.stagingBankData[n3 + 640] = this.borderColor;
                        this.stagingBankData[n3 + 960] = this.borderColor;
                        this.stagingBankData[n3 + 1280] = this.borderColor;
                        this.stagingBankData[n3 + 1600] = this.borderColor;
                        this.stagingBankData[n3 + 1920] = this.borderColor;
                        this.stagingBankData[n3 + 2240] = this.borderColor;
                        this.stagingBankData[n3 + 58880] = this.borderColor;
                        this.stagingBankData[n3 + 59200] = this.borderColor;
                        this.stagingBankData[n3 + 59520] = this.borderColor;
                        this.stagingBankData[n3 + 59840] = this.borderColor;
                        this.stagingBankData[n3 + 60160] = this.borderColor;
                        this.stagingBankData[n3 + 60480] = this.borderColor;
                        this.stagingBankData[n3 + 60800] = this.borderColor;
                        this.stagingBankData[n3 + 61120] = this.borderColor;
                        ++n3;
                    }
                } else if (this.verticalOffset > 0) {
                    n3 = 0;
                    while (n3 < this.verticalOffset) {
                        n2 = n3 * 640;
                        n = 0;
                        while (n < 320) {
                            this.stagingBankData[n + n2] = this.borderColor;
                            this.stagingBankData[n + n2 + 320] = this.borderColor;
                            ++n;
                        }
                        ++n3;
                    }
                }
                if (!this.blockLeft) break block10;
                n3 = 0;
                while (n3 < 192) {
                    n2 = n3 * 320;
                    this.stagingBankData[n2] = this.borderColor;
                    this.stagingBankData[n2 + 1] = this.borderColor;
                    this.stagingBankData[n2 + 2] = this.borderColor;
                    this.stagingBankData[n2 + 3] = this.borderColor;
                    this.stagingBankData[n2 + 4] = this.borderColor;
                    this.stagingBankData[n2 + 5] = this.borderColor;
                    this.stagingBankData[n2 + 6] = this.borderColor;
                    this.stagingBankData[n2 + 7] = this.borderColor;
                    this.stagingBankData[n2 + 312] = this.borderColor;
                    this.stagingBankData[n2 + 313] = this.borderColor;
                    this.stagingBankData[n2 + 314] = this.borderColor;
                    this.stagingBankData[n2 + 315] = this.borderColor;
                    this.stagingBankData[n2 + 316] = this.borderColor;
                    this.stagingBankData[n2 + 317] = this.borderColor;
                    this.stagingBankData[n2 + 318] = this.borderColor;
                    this.stagingBankData[n2 + 319] = this.borderColor;
                    ++n3;
                }
                break block11;
            }
            if (this.horizontalOffset <= 0) break block11;
            n3 = 0;
            while (n3 < 192) {
                n2 = n3 * 320;
                n = 0;
                while (n < this.horizontalOffset) {
                    this.stagingBankData[n + n2] = this.borderColor;
                    ++n;
                }
                ++n3;
            }
        }
    }

    private final void renderBackground() {
        if (this.backtab.isDirty() || this.gram.isDirty() || this.colorStackChanged || this.colorModeChanged) {
            if (this.colorStackMode) {
                this.renderColorStackMode();
            } else {
                this.renderForegroundBackgroundMode();
            }
        }
        this.copyBackgroundBufferToStagingArea();
    }

    private final void copyBackgroundBufferToStagingArea() {
        int n = 2 * (this.blockLeft ? 8 - this.horizontalOffset : 0);
        int n2 = 2 * (this.blockLeft ? 152 : 160 - this.horizontalOffset);
        int n3 = 2 * (this.blockTop ? 8 - this.verticalOffset : 0);
        int n4 = n3 + 2 * (this.blockTop ? 88 : 96 - this.verticalOffset);
        int n5 = n3;
        while (n5 < n4) {
            int n6 = n + (this.horizontalOffset - (this.blockLeft ? 4 : 0) << 1) + (n5 + (this.verticalOffset - (this.blockTop ? 4 : 0) << 1)) * 320;
            System.arraycopy(this.backgroundDataBuffer[n5], n, this.stagingBankData, n6, n2);
            System.arraycopy(this.backgroundDataBuffer[n5 + 1], n, this.stagingBankData, n6 + 320, n2);
            n5 += 2;
        }
    }

    private final void renderForegroundBackgroundMode() {
        int n = 0;
        while (n < 240) {
            boolean bl;
            int n2 = this.backtab.peek(n);
            boolean bl2 = (n2 & 0x800) == 0;
            boolean bl3 = bl = this.backtab.isDirty(n) || this.colorModeChanged;
            if (bl || !bl2) {
                int n3 = n2 & 0x1F8;
                int n4 = n % 20 * 16;
                int n5 = n / 20 * 16;
                byte by = (byte)(n2 & 7 | 0x10);
                byte by2 = (byte)((n2 & 0x2000) >> 11 | (n2 & 0x1600) >> 9);
                Memory memory = bl2 ? this.grom : this.gram;
                int n6 = 0;
                while (n6 < 8) {
                    if (bl || !bl2 && this.gram.isDirty(n3 + n6)) {
                        this.renderLine(memory.peek(n3 + n6), n4, n5, by, by2);
                    }
                    n5 += 2;
                    ++n6;
                }
            }
            ++n;
        }
    }

    private final void renderColorStackMode() {
        int n = 0;
        boolean bl = this.backtab.areColorAdvanceBitsDirty() || this.colorStackChanged || this.colorModeChanged;
        int n2 = 0;
        while (n2 < 240) {
            byte by;
            byte by2;
            byte by3;
            int n3;
            byte by4;
            int n4 = this.backtab.peek(n2);
            int n5 = n2 % 20 * 16;
            int n6 = n2 / 20 * 16;
            if ((n4 & 0x1800) == 4096) {
                by4 = (byte)(this.registers.memory[40 + n] & 0xF);
                n3 = (byte)(n4 & 7);
                by3 = (byte)((n4 & 0x38) >> 3);
                by2 = (byte)((n4 & 0x1C0) >> 6);
                by = (byte)((n4 & 0x2000) >> 11 | (n4 & 0x600) >> 9);
                this.renderColoredSquares(n5, n6, n3 == 7 ? by4 : (byte)(n3 | 0x10), by3 == 7 ? by4 : (byte)(by3 | 0x10), by2 == 7 ? by4 : (byte)(by2 | 0x10), by == 7 ? by4 : (byte)(by | 0x10));
            } else {
                by4 = (n4 & 0x800) != 0 ? (byte)0 : 1;
                n3 = by4 != 0 ? n4 & 0x7F8 : n4 & 0x1F8;
                by3 = (byte)((n4 & 0x1000) >> 9 | n4 & 7 | 0x10);
                if ((n4 & 0x2000) != 0) {
                    n = n + 1 & 3;
                }
                by2 = (byte)(this.registers.memory[40 + n] & 0xF);
                by = (byte)(this.backtab.isDirty(n2) ? 1 : 0);
                Memory memory = by4 != 0 ? this.grom : this.gram;
                int n7 = 0;
                while (n7 < 8) {
                    if (bl || by != 0 || by4 == 0 && this.gram.isDirty(n3 + n7)) {
                        this.renderLine(memory.peek(n3 + n7), n5, n6, by3, by2);
                    }
                    n6 += 2;
                    ++n7;
                }
            }
            ++n2;
        }
    }

    private final void renderSprites() {
        int n = 0;
        while (n < 8) {
            if (this.sprites[n].changed || !this.sprites[n].isGrom) {
                int n2 = this.sprites[n].cardNumber;
                if (!this.sprites[n].isGrom) {
                    n2 &= 0x3F;
                }
                int n3 = n2 << 3;
                Rectangle rectangle = this.sprites[n].getBounds();
                int n4 = (this.sprites[n].quadHeight ? 4 : 1) * (this.sprites[n].doubleHeight ? 2 : 1);
                int n5 = rectangle.height * 2;
                boolean bl = this.sprites[n].doubleWidth;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = n3 + n6 / n4;
                    if (this.sprites[n].changed || n7 < this.gram.getSize() && this.gram.isDirty(n7)) {
                        int n8;
                        int n9 = this.sprites[n].isGrom ? (n7 >= this.grom.getSize() ? 65535 : this.grom.peek(n7)) : (n8 = n7 >= this.gram.getSize() ? 65535 : this.gram.peek(n7));
                        int n10 = this.sprites[n].horizontalMirror ? (bl ? 15 : 7) : 0;
                        int n11 = this.sprites[n].verticalMirror ? n5 - n6 - 1 : n6;
                        int n12 = this.sprites[n].horizontalMirror ? -1 : 1;
                        this.spriteBuffers[n][n10][n11] = (n8 & 0x80) != 0;
                        boolean bl2 = bl ? (n8 & 0x80) != 0 : (this.spriteBuffers[n][n10 + n12][n11] = (n8 & 0x40) != 0);
                        boolean bl3 = bl ? (n8 & 0x40) != 0 : (this.spriteBuffers[n][n10 + 2 * n12][n11] = (n8 & 0x20) != 0);
                        boolean bl4 = bl ? (n8 & 0x40) != 0 : (this.spriteBuffers[n][n10 + 3 * n12][n11] = (n8 & 0x10) != 0);
                        boolean bl5 = bl ? (n8 & 0x20) != 0 : (this.spriteBuffers[n][n10 + 4 * n12][n11] = (n8 & 8) != 0);
                        boolean bl6 = bl ? (n8 & 0x20) != 0 : (this.spriteBuffers[n][n10 + 5 * n12][n11] = (n8 & 4) != 0);
                        boolean bl7 = bl ? (n8 & 0x10) != 0 : (this.spriteBuffers[n][n10 + 6 * n12][n11] = (n8 & 2) != 0);
                        boolean bl8 = bl ? (n8 & 0x10) != 0 : (this.spriteBuffers[n][n10 + 7 * n12][n11] = (n8 & 1) != 0);
                        if (bl) {
                            this.spriteBuffers[n][n10 + 8 * n12][n11] = (n8 & 8) != 0;
                            this.spriteBuffers[n][n10 + 9 * n12][n11] = (n8 & 8) != 0;
                            this.spriteBuffers[n][n10 + 10 * n12][n11] = (n8 & 4) != 0;
                            this.spriteBuffers[n][n10 + 11 * n12][n11] = (n8 & 4) != 0;
                            this.spriteBuffers[n][n10 + 12 * n12][n11] = (n8 & 2) != 0;
                            this.spriteBuffers[n][n10 + 13 * n12][n11] = (n8 & 2) != 0;
                            this.spriteBuffers[n][n10 + 14 * n12][n11] = (n8 & 1) != 0;
                            this.spriteBuffers[n][n10 + 15 * n12][n11] = (n8 & 1) != 0;
                        }
                    }
                    ++n6;
                }
            }
            ++n;
        }
    }

    private final void copySpritesToStagingArea() {
        int n = 7;
        while (n >= 0) {
            block10: {
                boolean bl = this.sprites[n].isVisible;
                if (this.sprites[n].xLocation == 0 || !this.sprites[n].flagCollisions && !bl) break block10;
                boolean bl2 = false;
                boolean bl3 = false;
                Rectangle rectangle = this.sprites[n].getBounds();
                int n2 = rectangle.height * 2;
                byte by = (byte)this.sprites[n].foregroundColor;
                int n3 = (rectangle.x + this.horizontalOffset) * 2;
                int n4 = (rectangle.y + this.verticalOffset) * 2;
                int n5 = n3 + (this.blockLeft ? -8 : 0) + 320 * (n4 + (this.blockTop ? -8 : 0));
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = n4 + n6;
                    int n8 = 0;
                    while (n8 < rectangle.width) {
                        block11: {
                            byte by2;
                            int n9;
                            block13: {
                                block12: {
                                    if (!this.spriteBuffers[n][n8][n6]) break block11;
                                    int n10 = n3 + n8 * 2;
                                    n9 = n5 + 320 * n6 + n8 * 2;
                                    if (n10 >= (this.blockLeft ? 16 : 0) && n10 <= 317 && n7 >= (this.blockTop ? 16 : 0) && n7 <= 191) break block12;
                                    bl2 = true;
                                    break block11;
                                }
                                by2 = this.stagingBankData[n9];
                                if ((by2 & 0x10) == 0) break block13;
                                bl3 = true;
                                if (this.sprites[n].behindForeground) break block11;
                            }
                            if (bl) {
                                this.stagingBankData[n9] = (byte)(by | by2 & 0x10);
                                this.stagingBankData[n9 + 1] = this.stagingBankData[n9];
                            }
                        }
                        ++n8;
                    }
                    ++n7;
                    ++n6;
                }
                if (this.sprites[n].flagCollisions) {
                    if (bl3) {
                        this.sprites[n].collisionRegister |= 0x100;
                    }
                    if (bl2) {
                        this.sprites[n].collisionRegister |= 0x200;
                    }
                }
            }
            --n;
        }
    }

    private final void renderColoredSquares(int n, int n2, byte by, byte by2, byte by3, byte by4) {
        int n3 = n2;
        int n4 = n2 + 1;
        int n5 = 0;
        while (n5 < 8) {
            this.backgroundDataBuffer[n3][n] = by;
            this.backgroundDataBuffer[n3][n + 1] = by;
            this.backgroundDataBuffer[n3][n + 2] = by;
            this.backgroundDataBuffer[n3][n + 3] = by;
            this.backgroundDataBuffer[n3][n + 4] = by;
            this.backgroundDataBuffer[n3][n + 5] = by;
            this.backgroundDataBuffer[n3][n + 6] = by;
            this.backgroundDataBuffer[n3][n + 7] = by;
            this.backgroundDataBuffer[n4][n] = by;
            this.backgroundDataBuffer[n4][n + 1] = by;
            this.backgroundDataBuffer[n4][n + 2] = by;
            this.backgroundDataBuffer[n4][n + 3] = by;
            this.backgroundDataBuffer[n4][n + 4] = by;
            this.backgroundDataBuffer[n4][n + 5] = by;
            this.backgroundDataBuffer[n4][n + 6] = by;
            this.backgroundDataBuffer[n4][n + 7] = by;
            this.backgroundDataBuffer[n3][n + 8] = by2;
            this.backgroundDataBuffer[n3][n + 9] = by2;
            this.backgroundDataBuffer[n3][n + 10] = by2;
            this.backgroundDataBuffer[n3][n + 11] = by2;
            this.backgroundDataBuffer[n3][n + 12] = by2;
            this.backgroundDataBuffer[n3][n + 13] = by2;
            this.backgroundDataBuffer[n3][n + 14] = by2;
            this.backgroundDataBuffer[n3][n + 15] = by2;
            this.backgroundDataBuffer[n4][n + 8] = by2;
            this.backgroundDataBuffer[n4][n + 9] = by2;
            this.backgroundDataBuffer[n4][n + 10] = by2;
            this.backgroundDataBuffer[n4][n + 11] = by2;
            this.backgroundDataBuffer[n4][n + 12] = by2;
            this.backgroundDataBuffer[n4][n + 13] = by2;
            this.backgroundDataBuffer[n4][n + 14] = by2;
            this.backgroundDataBuffer[n4][n + 15] = by2;
            this.backgroundDataBuffer[n3 + 8][n] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 1] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 2] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 3] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 4] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 5] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 6] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 7] = by3;
            this.backgroundDataBuffer[n4 + 8][n] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 1] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 2] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 3] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 4] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 5] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 6] = by3;
            this.backgroundDataBuffer[n4 + 8][n + 7] = by3;
            this.backgroundDataBuffer[n3 + 8][n + 8] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 9] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 10] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 11] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 12] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 13] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 14] = by4;
            this.backgroundDataBuffer[n3 + 8][n + 15] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 8] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 9] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 10] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 11] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 12] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 13] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 14] = by4;
            this.backgroundDataBuffer[n4 + 8][n + 15] = by4;
            n3 += 2;
            n4 += 2;
            n5 += 2;
        }
    }

    private final void renderLine(int n, int n2, int n3, byte by, byte by2) {
        byte by3;
        int n4 = n3;
        int n5 = n3 + 1;
        this.backgroundDataBuffer[n4][n2] = by3 = (n & 0x80) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2] = by3;
        this.backgroundDataBuffer[n4][n2 + 1] = by3;
        this.backgroundDataBuffer[n5][n2 + 1] = by3;
        this.backgroundDataBuffer[n4][n2 + 2] = by3 = (n & 0x40) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 2] = by3;
        this.backgroundDataBuffer[n4][n2 + 3] = by3;
        this.backgroundDataBuffer[n5][n2 + 3] = by3;
        this.backgroundDataBuffer[n4][n2 + 4] = by3 = (n & 0x20) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 4] = by3;
        this.backgroundDataBuffer[n4][n2 + 5] = by3;
        this.backgroundDataBuffer[n5][n2 + 5] = by3;
        this.backgroundDataBuffer[n4][n2 + 6] = by3 = (n & 0x10) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 6] = by3;
        this.backgroundDataBuffer[n4][n2 + 7] = by3;
        this.backgroundDataBuffer[n5][n2 + 7] = by3;
        this.backgroundDataBuffer[n4][n2 + 8] = by3 = (n & 8) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 8] = by3;
        this.backgroundDataBuffer[n4][n2 + 9] = by3;
        this.backgroundDataBuffer[n5][n2 + 9] = by3;
        this.backgroundDataBuffer[n4][n2 + 10] = by3 = (n & 4) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 10] = by3;
        this.backgroundDataBuffer[n4][n2 + 11] = by3;
        this.backgroundDataBuffer[n5][n2 + 11] = by3;
        this.backgroundDataBuffer[n4][n2 + 12] = by3 = (n & 2) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 12] = by3;
        this.backgroundDataBuffer[n4][n2 + 13] = by3;
        this.backgroundDataBuffer[n5][n2 + 13] = by3;
        this.backgroundDataBuffer[n4][n2 + 14] = by3 = (n & 1) == 0 ? by2 : by;
        this.backgroundDataBuffer[n5][n2 + 14] = by3;
        this.backgroundDataBuffer[n4][n2 + 15] = by3;
        this.backgroundDataBuffer[n5][n2 + 15] = by3;
    }

    private final void determineSpriteCollisions() {
        int n = 0;
        while (n < 7) {
            int n2 = n + 1;
            while (n2 < 8) {
                if ((this.sprites[n].flagCollisions || this.sprites[n2].flagCollisions) && this.spritesCollide(n, n2)) {
                    if (this.sprites[n].flagCollisions) {
                        this.sprites[n].collisionRegister |= 1 << n2;
                    }
                    if (this.sprites[n2].flagCollisions) {
                        this.sprites[n2].collisionRegister |= 1 << n;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    protected boolean spritesCollide(int n, int n2) {
        Rectangle rectangle;
        Rectangle rectangle2 = this.sprites[n].getBounds();
        if (!rectangle2.intersects(rectangle = this.sprites[n2].getBounds())) {
            return false;
        }
        int n3 = Math.max(rectangle2.x, rectangle.x);
        int n4 = Math.max(rectangle2.y, rectangle.y);
        int n5 = (n4 - rectangle2.y) * 2;
        int n6 = (n4 - rectangle.y) * 2;
        int n7 = Math.min(rectangle2.x + rectangle2.width, rectangle.x + rectangle.width) - n3;
        int n8 = (Math.min(rectangle2.y + rectangle2.height, rectangle.y + rectangle.height) - n4) * 2;
        int n9 = 0;
        while (n9 < n7) {
            int n10 = 0;
            while (n10 < n8) {
                if (this.spriteBuffers[n][n3 - rectangle2.x + n9][n5 + n10] && this.spriteBuffers[n2][n3 - rectangle.x + n9][n6 + n10]) {
                    return true;
                }
                ++n10;
            }
            ++n9;
        }
        return false;
    }

    static /* synthetic */ byte access$0(AY38900 aY38900) {
        return aY38900.borderColor;
    }

    static /* synthetic */ int access$2(AY38900 aY38900) {
        return aY38900.horizontalOffset;
    }

    static /* synthetic */ int access$4(AY38900 aY38900) {
        return aY38900.verticalOffset;
    }

    static /* synthetic */ boolean access$6(AY38900 aY38900) {
        return aY38900.blockLeft;
    }

    static /* synthetic */ boolean access$8(AY38900 aY38900) {
        return aY38900.blockTop;
    }

    public AY38900(EmulationDirector emulationDirector, CP1610 cP1610, SignalLine signalLine, SignalLine signalLine2, SignalLine signalLine3) {
        this.director = emulationDirector;
        this.cpu = cP1610;
        this.SR1 = signalLine;
        this.SR2 = signalLine2;
        this.SST = signalLine3;
        this.init();
    }

    static {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        System.arraycopy(palette[0], 0, byArray, 0, 16);
        System.arraycopy(palette[0], 0, byArray, 16, 16);
        System.arraycopy(palette[1], 0, byArray2, 0, 16);
        System.arraycopy(palette[1], 0, byArray2, 16, 16);
        System.arraycopy(palette[2], 0, byArray3, 0, 16);
        System.arraycopy(palette[2], 0, byArray3, 16, 16);
        COLOR_MODEL = new IndexColorModel(5, 32, byArray, byArray2, byArray3);
    }

    protected class Registers
    extends Memory {
        int[] memory = new int[64];

        public int getSize() {
            return this.memory.length;
        }

        public int getLocation() {
            return 0;
        }

        public void save(SaveOutputStream saveOutputStream) throws IOException {
            int n = 0;
            while (n < this.memory.length) {
                saveOutputStream.writeInt(this.memory[n]);
                ++n;
            }
        }

        public void load(LoadInputStream loadInputStream) throws IOException {
            int n = 0;
            while (n < this.memory.length) {
                this.memory[n] = loadInputStream.readInt(0, 65535);
                ++n;
            }
        }

        public void reset() {
            int n = 0;
            while (n < this.memory.length) {
                this.memory[n] = 0;
                ++n;
            }
        }

        public void poke(int n, int n2) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Sprite sprite = AY38900.this.sprites[n];
                    sprite.setDoubleWidth(((n2 &= 0x7FF) & 0x400) != 0);
                    sprite.setVisible((n2 & 0x200) != 0);
                    sprite.setFlagCollisions((n2 & 0x100) != 0);
                    sprite.setXLocation(n2 & 0xFF);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Sprite sprite = AY38900.this.sprites[n - 8];
                    sprite.setVerticalMirror(((n2 &= 0xFFF) & 0x800) != 0);
                    sprite.setHorizontalMirror((n2 & 0x400) != 0);
                    sprite.setQuadHeight((n2 & 0x200) != 0);
                    sprite.setDoubleHeight((n2 & 0x100) != 0);
                    sprite.setDoubleYResolution((n2 & 0x80) != 0);
                    sprite.setYLocation(n2 & 0x7F);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    Sprite sprite = AY38900.this.sprites[n - 16];
                    sprite.setBehindForeground(((n2 &= 0x3FFF) & 0x2000) != 0);
                    sprite.setGROM((n2 & 0x800) == 0);
                    sprite.setCardNumber((n2 & 0x7F8) >> 3);
                    sprite.setForegroundColor((n2 & 0x1000) >> 9 | n2 & 7);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    n2 &= ~(1 << n - 24) & 0x3FF;
                    break;
                }
                case 32: {
                    AY38900.this.displayEnabled = true;
                    break;
                }
                case 33: {
                    n2 = 0;
                    if (!AY38900.this.colorStackMode) break;
                    AY38900.this.colorStackMode = false;
                    AY38900.this.colorModeChanged = true;
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    n2 &= 0xF;
                    AY38900.this.colorStackChanged = true;
                    break;
                }
                case 44: {
                    AY38900.this.borderColor = (byte)(n2 &= 0xF);
                    AY38900.this.bordersChanged = true;
                    break;
                }
                case 48: {
                    AY38900.this.horizontalOffset = (n2 &= 7);
                    AY38900.this.offsetsChanged = true;
                    break;
                }
                case 49: {
                    AY38900.this.verticalOffset = (n2 &= 7);
                    AY38900.this.offsetsChanged = true;
                    break;
                }
                case 50: {
                    AY38900.this.blockLeft = ((n2 &= 3) & 1) != 0;
                    AY38900.this.blockTop = (n2 & 2) != 0;
                    AY38900.this.bordersChanged = true;
                    break;
                }
                default: {
                    n2 = 0;
                    break;
                }
            }
            this.memory[n] = n2;
        }

        public int peek(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return 0x3800 | this.memory[n];
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return 0x3000 | this.memory[n];
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return 0x3C00 | this.memory[n];
                }
                case 32: {
                    return 0;
                }
                case 33: {
                    if (n == 33 && !AY38900.this.colorStackMode) {
                        AY38900.this.colorStackMode = true;
                        AY38900.this.colorModeChanged = true;
                    }
                    return this.memory[n];
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    return 0x3FF0 | this.memory[n];
                }
                case 48: 
                case 49: {
                    return 0x3FF8 | this.memory[n];
                }
                case 50: {
                    return 0x3FFC | this.memory[n];
                }
            }
            return this.memory[n];
        }

        Registers() {
        }
    }

    private static class CRCOutputStream
    extends OutputStream {
        private OutputStream os;
        private boolean calculatingCRC = false;
        private CRC32 crc = new CRC32();

        public void write(int n) throws IOException {
            this.os.write(n);
            if (this.calculatingCRC) {
                this.crc.update(n);
            }
        }

        public void startCRC() {
            this.calculatingCRC = true;
            this.crc.reset();
        }

        public void writeCRC() throws IOException {
            long l = this.crc.getValue();
            this.os.write((int)(l & 0xFFFFFFFFFF000000L) >> 24);
            this.os.write((int)(l & 0xFF0000L) >> 16);
            this.os.write((int)(l & 0xFF00L) >> 8);
            this.os.write((int)(l & 0xFFL));
            this.calculatingCRC = false;
        }

        CRCOutputStream(OutputStream outputStream) {
            this.os = outputStream;
        }
    }
}

