/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.AY38900;
import com.bliss.core.AY38914;
import com.bliss.core.AudioMixer;
import com.bliss.core.CP1610;
import com.bliss.core.ECS;
import com.bliss.core.ECSKeyboard;
import com.bliss.core.EmulationDirector;
import com.bliss.core.EmulationException;
import com.bliss.core.HandController;
import com.bliss.core.Intellivision;
import com.bliss.core.IntellivisionListener;
import com.bliss.core.LoadInputStream;
import com.bliss.core.MemoryBus;
import com.bliss.core.Option;
import com.bliss.core.Peripheral;
import com.bliss.core.ProcessorBus;
import com.bliss.core.RAM;
import com.bliss.core.ROM;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.SignalLine;
import com.bliss.core.cartridge.Cartridge;
import com.bliss.core.devices.PlugIn;
import com.bliss.core.ivoice.Intellivoice;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class Intellivision {
    static ResourceBundle RESOURCES = ResourceBundle.getBundle("i18n/IntellivisionResources");
    public static final int NTSC_CLOCK_SPEED = 3579545;
    public static final int PAL_CLOCK_SPEED = 4000000;
    private static final int MAX_PERIPHERALS = 12;
    private static final Integer[] frameSkipChoices = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5)};
    private EmulationThread thread;
    HandController player1Controller;
    HandController player2Controller;
    private EmulationDirector director;
    private ECSKeyboard keyboard;
    private File gameSaveDir;
    private File snapshotDir;
    protected Cartridge currentCartridge;
    protected boolean on;
    protected boolean audioEnabled = true;
    protected PlugIn plugIn;
    protected Peripheral[] peripherals = new Peripheral[12];
    protected int periphCount;
    protected CP1610 cpu;
    protected AY38900 stic;
    protected AY38914 psg;
    protected AudioMixer.AudioOutputLine psgAudioLine;
    protected AudioMixer am;
    protected ProcessorBus processorBus;
    protected MemoryBus memoryBus;
    protected RAM RAM8bit;
    protected RAM RAM16bit;
    protected int[] execImage;
    protected ROM execROM;
    protected boolean hasExecImage = false;
    ECS ecs;
    AudioMixer.AudioOutputLine ecsAudioLine;
    boolean ecsInUse;
    protected Intellivoice intellivoice;
    AudioMixer.AudioOutputLine intellivoiceAudioLine;
    protected boolean intellivoiceInUse;
    protected Vector listeners;
    private FilenameFilter existingSnapFilter;
    private FilenameFilter existingSaveFilter;
    private Option[] basicVideoOptions;
    private Option[] basicAudioOptions;
    private Option[] basicInputOptions;
    private Option[] combinedVideoOptions;
    private Option[] combinedAudioOptions;
    private Option[] combinedInputOptions;

    public void setFrameSkip(int n) {
        this.director.setFrameSkip(n);
    }

    public void setHighQualityAudioMixing(boolean bl) {
        this.am.setHighQualityMixing(bl);
    }

    public void setAudioAccuracy(int n) {
        this.psg.setClockDivisor(n);
        this.ecs.setPSGClockDivisor(n);
    }

    public void setPaused(boolean bl) {
        this.processorBus.setPaused(bl);
    }

    public byte[] getImageBank() {
        return this.stic.stagingBankData;
    }

    public HandController getHandControllerOne() {
        return this.player1Controller;
    }

    public HandController getHandControllerTwo() {
        return this.player2Controller;
    }

    public ECSKeyboard getECSKeyboard() {
        return this.keyboard;
    }

    public EmulationDirector getDirector() {
        return this.director;
    }

    public void enableECSSupport(int[] nArray) {
        this.ecs.setECSROMImage(nArray);
    }

    public void enableIntellivoiceSupport(int[] nArray) {
        this.intellivoice.setIntellivoiceImage(nArray);
    }

    public void addIntellivisionListener(IntellivisionListener intellivisionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(intellivisionListener);
    }

    public void removeIntellivisionListener(IntellivisionListener intellivisionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(intellivisionListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public Option[] getVideoOptions() {
        return this.combinedVideoOptions;
    }

    public Option[] getAudioOptions() {
        return this.combinedAudioOptions;
    }

    public Option[] getInputVideoOptions() {
        return this.combinedInputOptions;
    }

    void saveGame() throws IOException {
        Object object;
        if (this.gameSaveDir == null) {
            object = System.getProperty("user.dir");
            this.gameSaveDir = new File((String)object + File.separator + "saves");
        }
        if (this.gameSaveDir.exists() && this.gameSaveDir.isFile()) {
            throw new IOException("Unable to create save game directory: " + this.gameSaveDir.getAbsolutePath());
        }
        if (!this.gameSaveDir.exists()) {
            this.gameSaveDir.mkdir();
        }
        if (((File)(object = new File(this.gameSaveDir, this.currentCartridge.getType().getName() + ".sav"))).exists() && !((File)object).delete()) {
            throw new IOException("Unable to overwrite existing save game: " + ((File)object).getAbsolutePath());
        }
        SaveOutputStream saveOutputStream = new SaveOutputStream(new BufferedOutputStream(new FileOutputStream((File)object), 4096));
        saveOutputStream.writeBoolean(this.intellivoiceInUse);
        this.memoryBus.save(saveOutputStream);
        this.processorBus.save(saveOutputStream);
        saveOutputStream.close();
    }

    void loadGame() throws IOException {
        Object object;
        if (this.gameSaveDir == null) {
            object = System.getProperty("user.dir");
            this.gameSaveDir = new File((String)object + File.separator + "saves");
        }
        if (this.gameSaveDir.exists() && this.gameSaveDir.isFile()) {
            throw new IOException("No save game directory: " + this.gameSaveDir.getAbsolutePath());
        }
        if (!this.gameSaveDir.exists()) {
            throw new IOException("No save game directory: " + this.gameSaveDir.getAbsolutePath());
        }
        object = new File(this.gameSaveDir, this.currentCartridge.getType().getName() + ".sav");
        if (!((File)object).exists() || ((File)object).isDirectory()) {
            throw new IOException("No save game file: " + this.gameSaveDir.getAbsolutePath());
        }
        LoadInputStream loadInputStream = new LoadInputStream(new BufferedInputStream(new FileInputStream((File)object), 4096));
        boolean bl = loadInputStream.readBoolean();
        if (bl && !this.intellivoiceInUse) {
            this.addPeripheral(this.intellivoice);
            this.intellivoiceAudioLine.acquire();
            this.intellivoiceInUse = true;
        } else if (!bl && this.intellivoiceInUse) {
            this.removePeripheral(this.intellivoice);
            this.intellivoiceAudioLine.release();
            this.intellivoiceInUse = false;
        }
        this.memoryBus.load(loadInputStream);
        this.processorBus.load(loadInputStream);
        loadInputStream.close();
    }

    void writeSnapshot() throws IOException {
        Object object;
        String[] stringArray;
        if (this.snapshotDir == null) {
            stringArray = System.getProperty("user.dir");
            this.snapshotDir = new File((String)stringArray + File.separator + "pics");
        }
        if (this.snapshotDir.exists() && this.snapshotDir.isFile()) {
            throw new IOException("Unable to create snapshot directory: " + this.snapshotDir.getAbsolutePath());
        }
        if (!this.snapshotDir.exists()) {
            this.snapshotDir.mkdir();
        }
        stringArray = this.snapshotDir.list(this.existingSnapFilter);
        int n = 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                object = new File(this.snapshotDir, stringArray[n2]);
                String string = ((File)object).getName();
                int n3 = Integer.parseInt(string.substring(string.lastIndexOf("_") + 1, string.length() - 4));
                if (n3 >= n) {
                    n = n3 + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        File file = new File(this.snapshotDir, this.currentCartridge.getType().getName() + "_" + n + ".png");
        object = new BufferedOutputStream(new FileOutputStream(file), 4096);
        this.stic.writeSnapshot((OutputStream)object);
        ((FilterOutputStream)object).close();
    }

    public void setPlugIn(PlugIn plugIn) {
        if (this.plugIn == plugIn) {
            return;
        }
        this.plugIn = plugIn;
        Option[] optionArray = plugIn.getVideoOutputDevice().getOptions();
        this.combinedVideoOptions = new Option[this.basicVideoOptions.length + optionArray.length];
        System.arraycopy(this.basicVideoOptions, 0, this.combinedVideoOptions, 0, this.basicVideoOptions.length);
        System.arraycopy(optionArray, 0, this.combinedVideoOptions, this.basicVideoOptions.length, optionArray.length);
        Option[] optionArray2 = plugIn.getAudioOutputDevice().getOptions();
        this.combinedAudioOptions = new Option[this.basicAudioOptions.length + optionArray2.length];
        System.arraycopy(this.basicAudioOptions, 0, this.combinedAudioOptions, 0, this.basicAudioOptions.length);
        System.arraycopy(optionArray2, 0, this.combinedAudioOptions, this.basicAudioOptions.length, optionArray2.length);
        Option[] optionArray3 = plugIn.getInputDevice().getOptions();
        this.combinedInputOptions = new Option[this.basicInputOptions.length + optionArray3.length];
        System.arraycopy(this.basicInputOptions, 0, this.combinedInputOptions, 0, this.basicInputOptions.length);
        System.arraycopy(optionArray3, 0, this.combinedInputOptions, this.basicInputOptions.length, optionArray3.length);
        this.director.changePlugIn(plugIn);
        this.am.setAudioOutputDevice(plugIn.getAudioOutputDevice());
        this.player1Controller.setInputDevice(plugIn.getInputDevice());
        this.player2Controller.setInputDevice(plugIn.getInputDevice());
        this.ecs.keyboard.setInputDevice(plugIn.getInputDevice());
    }

    public PlugIn getPlugIn() {
        return this.plugIn;
    }

    public void setAudioEnabled(boolean bl) {
        this.audioEnabled = bl;
        this.am.isIdle = !bl;
        this.psg.isIdle = !bl;
        this.ecs.psg2.isIdle = !bl;
        this.intellivoice.setAudioEnabled(bl);
    }

    public void setExecImage(int[] nArray) {
        System.arraycopy(nArray, 0, this.execImage, 0, this.execImage.length);
        this.hasExecImage = true;
    }

    public boolean hasExecImage() {
        return this.hasExecImage;
    }

    public void setGROMImage(int[] nArray) {
        this.stic.setGROMImage(nArray);
    }

    public boolean hasGROMImage() {
        return this.stic.hasGROMImage();
    }

    public void turnOn() {
        if (this.on) {
            return;
        }
        if (this.execROM == null) {
            throw new EmulationException(RESOURCES.getString("ErrorNoExecutiveROM"));
        }
        if (!this.stic.hasGROMImage()) {
            throw new EmulationException(RESOURCES.getString("ErrorNoGROM"));
        }
        if (this.currentCartridge.getType().requiresECS() && !this.ecs.hasECSROMImage()) {
            throw new EmulationException(RESOURCES.getString("ErrorNoECS"));
        }
        this.reset();
        Intellivision intellivision = this;
        if (intellivision == null) {
            throw null;
        }
        this.thread = intellivision.new EmulationThread();
        this.thread.setPriority(this.thread.getPriority() - 1);
        this.thread.start();
        this.thread.waitForStart();
        this.on = true;
    }

    public void turnOff() {
        this.turnOff(false);
    }

    public void turnOff(boolean bl) {
        if (!this.on) {
            return;
        }
        this.processorBus.stop();
        if (bl) {
            this.thread.waitForExit();
        }
        this.on = false;
    }

    public void reset() {
        this.director.reset();
        this.processorBus.reset();
        this.memoryBus.reset();
    }

    public void insertCartridge(Cartridge cartridge) {
        Cartridge cartridge2 = this.currentCartridge;
        if (this.currentCartridge != null) {
            this.removeCartridge();
        }
        this.currentCartridge = cartridge;
        if (this.currentCartridge.requiresECS()) {
            this.addPeripheral(this.ecs);
            this.ecsAudioLine.acquire();
            this.ecsInUse = true;
        }
        if (this.currentCartridge.usesIntellivoice() && this.intellivoice.hasIntellivoiceImage()) {
            this.addPeripheral(this.intellivoice);
            this.intellivoiceAudioLine.acquire();
            this.intellivoiceInUse = true;
        }
        this.addPeripheral(cartridge);
        this.fireCartridgeChanged(cartridge2, this.currentCartridge);
    }

    public void removeCartridge() {
        if (this.currentCartridge == null) {
            return;
        }
        Cartridge cartridge = this.currentCartridge;
        this.removePeripheral(this.currentCartridge);
        if (this.intellivoiceInUse) {
            this.removePeripheral(this.intellivoice);
            this.intellivoiceAudioLine.release();
            this.intellivoiceInUse = false;
        }
        if (this.ecsInUse) {
            this.removePeripheral(this.ecs);
            this.ecsAudioLine.release();
            this.ecsInUse = false;
        }
        this.currentCartridge = null;
        this.fireCartridgeChanged(cartridge, null);
    }

    public Cartridge getCartridge() {
        return this.currentCartridge;
    }

    protected void init() {
        this.director = new EmulationDirector(this);
        this.processorBus = new ProcessorBus(this.director);
        this.memoryBus = new MemoryBus(65536);
        this.player1Controller = new HandController(0);
        this.player2Controller = new HandController(1);
        this.keyboard = new ECSKeyboard();
        this.RAM8bit = new RAM(240, 256, 8);
        this.memoryBus.addMemory(this.RAM8bit);
        this.execImage = new int[4096];
        this.execROM = new ROM(this.execImage, 4096);
        this.memoryBus.addMemory(this.execROM);
        this.RAM16bit = new RAM(112, 752, 16);
        this.memoryBus.addMemory(this.RAM16bit);
        SignalLine signalLine = new SignalLine();
        SignalLine signalLine2 = new SignalLine();
        SignalLine signalLine3 = new SignalLine();
        this.cpu = new CP1610(this.memoryBus, signalLine, signalLine2, signalLine3, 4096, 4100);
        this.processorBus.addProcessor(this.cpu);
        this.stic = new AY38900(this.director, this.cpu, signalLine, signalLine2, signalLine3);
        this.addPeripheral(this.stic);
        this.am = new AudioMixer(this.processorBus);
        this.processorBus.addProcessor(this.am);
        this.psgAudioLine = this.am.getAudioOutputLine();
        this.psg = new AY38914(this.psgAudioLine, 496, this.player1Controller, this.player2Controller);
        this.psgAudioLine.acquire();
        this.addPeripheral(this.psg);
        this.ecsAudioLine = this.am.getAudioOutputLine();
        this.ecs = new ECS(this.ecsAudioLine, this.keyboard);
        this.intellivoiceAudioLine = this.am.getAudioOutputLine();
        this.intellivoice = new Intellivoice(this.intellivoiceAudioLine);
    }

    private void addPeripheral(Peripheral peripheral) {
        this.peripherals[this.periphCount] = peripheral;
        ++this.periphCount;
        int n = peripheral.getProcessorCount();
        int n2 = 0;
        while (n2 < n) {
            this.processorBus.addProcessor(peripheral.getProcessor(n2));
            ++n2;
        }
        n = peripheral.getMemoryCount();
        n2 = 0;
        while (n2 < n) {
            this.memoryBus.addMemory(peripheral.getMemory(n2));
            ++n2;
        }
    }

    private void removePeripheral(Peripheral peripheral) {
        int n = 0;
        while (n < this.periphCount) {
            if (this.peripherals[n] == peripheral) {
                int n2 = n;
                while (n2 < this.periphCount - 1) {
                    this.peripherals[n2] = this.peripherals[n2 + 1];
                    ++n2;
                }
                --this.periphCount;
                n2 = peripheral.getProcessorCount();
                int n3 = 0;
                while (n3 < n2) {
                    this.processorBus.removeProcessor(peripheral.getProcessor(n3));
                    ++n3;
                }
                n2 = peripheral.getMemoryCount();
                n3 = 0;
                while (n3 < n2) {
                    this.memoryBus.removeMemory(peripheral.getMemory(n3));
                    ++n3;
                }
                break;
            }
            ++n;
        }
    }

    protected void fireTurnedOn() {
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IntellivisionListener)enumeration.nextElement()).turnedOn(this);
        }
    }

    protected void fireCartridgeChanged(Cartridge cartridge, Cartridge cartridge2) {
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IntellivisionListener)enumeration.nextElement()).cartridgeChanged(this, cartridge, cartridge2);
        }
    }

    protected void fireErrorOccurred(String string) {
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IntellivisionListener)enumeration.nextElement()).errorOccurred(this, string);
        }
    }

    protected void fireTurnedOff() {
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IntellivisionListener)enumeration.nextElement()).turnedOff(this);
        }
    }

    static /* synthetic */ Integer[] access$0() {
        return frameSkipChoices;
    }

    static /* synthetic */ EmulationDirector access$1(Intellivision intellivision) {
        return intellivision.director;
    }

    public Intellivision() {
        Intellivision intellivision = this;
        if (intellivision == null) {
            throw null;
        }
        this.existingSnapFilter = new 1(intellivision);
        Intellivision intellivision2 = this;
        if (intellivision2 == null) {
            throw null;
        }
        this.existingSaveFilter = new 2(intellivision2);
        Option[] optionArray = new Option[1];
        Intellivision intellivision3 = this;
        if (intellivision3 == null) {
            throw null;
        }
        optionArray[0] = new 3(intellivision3);
        this.basicVideoOptions = optionArray;
        Option[] optionArray2 = new Option[2];
        Intellivision intellivision4 = this;
        if (intellivision4 == null) {
            throw null;
        }
        optionArray2[0] = new 4(intellivision4);
        Intellivision intellivision5 = this;
        if (intellivision5 == null) {
            throw null;
        }
        optionArray2[1] = new 5(intellivision5);
        this.basicAudioOptions = optionArray2;
        this.basicInputOptions = new Option[0];
        this.init();
    }

    class EmulationThread
    extends Thread {
        private boolean stillRunning = false;

        public void run() {
            EmulationThread emulationThread;
            try {
                emulationThread = this;
                synchronized (emulationThread) {
                    this.stillRunning = true;
                    this.notifyAll();
                }
                Intellivision.this.plugIn.init(Intellivision.this);
                Intellivision.this.fireTurnedOn();
                Intellivision.this.processorBus.run();
                Intellivision.this.plugIn.release(Intellivision.this);
                Intellivision.this.fireTurnedOff();
            }
            catch (EmulationException emulationException) {
                Intellivision.this.plugIn.release(Intellivision.this);
                Intellivision.this.fireTurnedOff();
                Intellivision.this.fireErrorOccurred(emulationException.getPresentableMessage());
            }
            catch (Exception exception) {
                Intellivision.this.plugIn.release(Intellivision.this);
                Intellivision.this.fireTurnedOff();
                exception.printStackTrace(System.err);
                Intellivision.this.fireErrorOccurred(RESOURCES.getString("ErrorUnexpected"));
            }
            emulationThread = this;
            synchronized (emulationThread) {
                this.stillRunning = false;
                this.notifyAll();
            }
        }

        synchronized void waitForStart() {
            if (!this.stillRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void waitForExit() {
            if (this.stillRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        EmulationThread() {
        }
    }
}

