/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app;

import com.bliss.core.cartridge.CartridgeType;
import com.blissj.app.Bliss;
import com.blissj.app.BlissMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class BlissPropertiesDialog
extends JDialog {
    private CartridgeType cartType;
    private JTabbedPane tabbedPane;
    private JPanel generalPanel;
    private JLabel nameLabel;
    private JLabel nameRenderer;
    private JLabel producerLabel;
    private JLabel producerRenderer;
    private JLabel yearLabel;
    private JLabel yearRenderer;
    private JLabel sizeLabel;
    private JLabel sizeRenderer;
    private JLabel checksumLabel;
    private JLabel checksumRenderer;
    private JLabel memoryMapLabel;
    private JLabel[] memoryMapRenderers;
    private JButton closeButton;

    private void initUI() {
        this.setTitle(Bliss.RESOURCES.getString("PropertiesDialogTitle"));
        this.setModal(true);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 150;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        container.add((Component)this.tabbedPane, gridBagConstraints);
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new GridBagLayout());
        this.tabbedPane.addTab(Bliss.RESOURCES.getString("GeneralTab"), this.generalPanel);
        this.nameLabel = new JLabel(Bliss.RESOURCES.getString("NameLabel") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 8, 8);
        this.generalPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameRenderer = new JLabel();
        this.nameRenderer.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 8, 12);
        this.generalPanel.add((Component)this.nameRenderer, gridBagConstraints);
        this.producerLabel = new JLabel(Bliss.RESOURCES.getString("ProducerLabel") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 8);
        this.generalPanel.add((Component)this.producerLabel, gridBagConstraints);
        this.producerRenderer = new JLabel();
        this.producerRenderer.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 12);
        this.generalPanel.add((Component)this.producerRenderer, gridBagConstraints);
        this.yearLabel = new JLabel(Bliss.RESOURCES.getString("YearLabel") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 8);
        this.generalPanel.add((Component)this.yearLabel, gridBagConstraints);
        this.yearRenderer = new JLabel();
        this.yearRenderer.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 12);
        this.generalPanel.add((Component)this.yearRenderer, gridBagConstraints);
        this.sizeLabel = new JLabel(Bliss.RESOURCES.getString("SizeLabel") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 8);
        this.generalPanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeRenderer = new JLabel();
        this.sizeRenderer.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 12);
        this.generalPanel.add((Component)this.sizeRenderer, gridBagConstraints);
        this.checksumLabel = new JLabel(Bliss.RESOURCES.getString("ChecksumLabel") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 8, 8);
        this.generalPanel.add((Component)this.checksumLabel, gridBagConstraints);
        this.checksumRenderer = new JLabel();
        this.checksumRenderer.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 12);
        this.generalPanel.add((Component)this.checksumRenderer, gridBagConstraints);
        this.memoryMapLabel = new JLabel(Bliss.RESOURCES.getString("MemoryMapLabel") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 2, 8);
        this.generalPanel.add((Component)this.memoryMapLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 12);
        this.memoryMapRenderers = new JLabel[5];
        int n = 0;
        while (n < this.memoryMapRenderers.length) {
            this.memoryMapRenderers[n] = new JLabel();
            this.memoryMapRenderers[n].setForeground(Color.black);
            if (n == this.memoryMapRenderers.length - 1) {
                gridBagConstraints.insets.bottom = 8;
            }
            this.generalPanel.add((Component)this.memoryMapRenderers[n], gridBagConstraints);
            ++gridBagConstraints.gridy;
            ++n;
        }
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5 + this.memoryMapRenderers.length;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.generalPanel.add((Component)jPanel, gridBagConstraints);
        this.closeButton = new JButton(Bliss.RESOURCES.getString("CloseButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        container.add((Component)this.closeButton, gridBagConstraints);
        this.pack();
    }

    private void initListeners() {
        BlissPropertiesDialog blissPropertiesDialog = this;
        if (blissPropertiesDialog == null) {
            throw null;
        }
        this.closeButton.addActionListener(new ActionListener(blissPropertiesDialog){
            private final /* synthetic */ BlissPropertiesDialog this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.dispose();
            }
            {
                this.this$0 = blissPropertiesDialog;
                this.constructor$0(blissPropertiesDialog);
            }

            private final void constructor$0(BlissPropertiesDialog blissPropertiesDialog) {
            }
        });
    }

    public void setCartridgeType(CartridgeType cartridgeType) {
        this.cartType = cartridgeType;
        this.loadData();
    }

    private void loadData() {
        this.nameRenderer.setText(this.cartType.getName());
        this.producerRenderer.setText(this.cartType.getProducer());
        this.yearRenderer.setText(this.cartType.getYear());
        this.sizeRenderer.setText(Integer.toString(this.cartType.getSize()));
        this.checksumRenderer.setText(Long.toString(this.cartType.getCrc(), 16).toUpperCase());
        CartridgeType.MemoryMap memoryMap = this.cartType.getMemoryMap();
        int n = memoryMap.getSegmentCount();
        int n2 = 0;
        while (n2 < this.memoryMapRenderers.length) {
            if (n2 < n) {
                this.memoryMapRenderers[n2].setText("$" + this.formHex(memoryMap.getSegmentStart(n2)) + " - $" + this.formHex(memoryMap.getSegmentEnd(n2)) + " = $" + this.formHex(memoryMap.getSegmentLocation(n2)));
            } else {
                this.memoryMapRenderers[n2].setText("");
            }
            ++n2;
        }
    }

    private String formHex(int n) {
        String string = "0000" + Integer.toString(n, 16);
        return string.substring(string.length() - 4).toUpperCase();
    }

    public BlissPropertiesDialog(BlissMainFrame blissMainFrame) {
        super(blissMainFrame);
        this.initUI();
        this.initListeners();
    }
}

