/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app.util;

import com.blissj.app.util.ArchiveEntry;
import com.blissj.app.util.ArchiveStream;
import com.blissj.app.util.ZipArchiveStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipArchiveStream
extends ArchiveStream {
    private ZipInputStream zis;
    private ZipEntry nextEntry;
    private boolean nextEntryRead;

    public ArchiveEntry getNextEntry() throws IOException {
        this.nextEntry = this.zis.getNextEntry();
        return this.nextEntry == null ? null : new ZipArchiveEntry(null, this.nextEntry.getName(), this.nextEntry.getCrc());
    }

    public int available() throws IOException {
        return this.zis.available();
    }

    public int read() throws IOException {
        return ((InflaterInputStream)this.zis).read();
    }

    public void close() throws IOException {
        this.zis.close();
    }

    public ZipArchiveStream(InputStream inputStream) throws IOException {
        this.zis = new ZipInputStream(inputStream);
    }

    private static class ZipArchiveEntry
    implements ArchiveEntry {
        private String name;
        private long crc;

        public String getName() {
            return this.name;
        }

        public long getCrc() {
            return this.crc;
        }

        private ZipArchiveEntry(String string, long l) {
            this.name = string;
            this.crc = l;
        }

        /* synthetic */ ZipArchiveEntry(1 var1_1, String string, long l) {
            this(string, l);
        }
    }
}

