/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.plugin;

import com.bliss.core.Option;
import com.bliss.core.devices.AudioOutputDevice;
import com.blissj.plugin.AppAudioOutputDevice;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class AppAudioOutputDevice
implements AudioOutputDevice {
    public static final int SAMPLE_RATE_11025 = 11025;
    public static final int SAMPLE_RATE_22050 = 22050;
    public static final int SAMPLE_RATE_44100 = 44100;
    private SourceDataLine sourceDataLine;
    private int sampleRate = 11025;
    private byte[] frame = new byte[16];
    private int bufferSizeInMillis = 40;
    private Option[] controllers;
    private static /* synthetic */ Class class$Ljavax$sound$sampled$SourceDataLine;

    public Option[] getOptions() {
        return this.controllers;
    }

    public void init() {
        this.acquireChannel();
    }

    public int available() {
        return this.sourceDataLine.available();
    }

    public void playSamples(int[] nArray, int n) {
        if (this.sourceDataLine == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.playSample(nArray[n2]);
            ++n2;
        }
    }

    public void playSample(int n) {
        if (this.sourceDataLine == null) {
            return;
        }
        this.frame[0] = (byte)(n & 0xFF);
        this.frame[1] = (byte)((n & 0xFF00) >> 8);
        System.arraycopy(this.frame, 0, this.frame, 2, 2);
        if (this.sampleRate < 44100) {
            System.arraycopy(this.frame, 0, this.frame, 4, 4);
            if (this.sampleRate < 22050) {
                System.arraycopy(this.frame, 0, this.frame, 8, 8);
            }
        }
        this.sourceDataLine.write(this.frame, 0, this.frame.length);
    }

    public void setBufferLength(int n) {
        if (this.bufferSizeInMillis == n) {
            return;
        }
        this.bufferSizeInMillis = n;
        if (this.sourceDataLine != null) {
            this.releaseChannel();
            this.acquireChannel();
        }
    }

    public int getBufferLength() {
        return this.bufferSizeInMillis;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
        this.frame = new byte[this.sampleRate == 11025 ? 16 : (this.sampleRate == 22050 ? 8 : 4)];
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void release() {
        this.releaseChannel();
    }

    private void acquireChannel() {
        if (this.sourceDataLine != null) {
            this.sourceDataLine.close();
        }
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
        int n = (int)((float)this.bufferSizeInMillis * 44100.0f * 8.0f) / 1000;
        DataLine.Info info = new DataLine.Info(class$Ljavax$sound$sampled$SourceDataLine != null ? class$Ljavax$sound$sampled$SourceDataLine : (class$Ljavax$sound$sampled$SourceDataLine = AppAudioOutputDevice.class$("javax.sound.sampled.SourceDataLine")), audioFormat, n);
        Line.Info[] infoArray = AudioSystem.getSourceLineInfo(info);
        try {
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(infoArray[0]);
            this.sourceDataLine.open(audioFormat, n);
            this.sourceDataLine.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.sourceDataLine = null;
        }
    }

    private void releaseChannel() {
        if (this.sourceDataLine == null) {
            return;
        }
        this.sourceDataLine.close();
        this.sourceDataLine = null;
    }

    static /* synthetic */ int access$0(AppAudioOutputDevice appAudioOutputDevice) {
        return appAudioOutputDevice.sampleRate;
    }

    static /* synthetic */ int access$1(AppAudioOutputDevice appAudioOutputDevice) {
        return appAudioOutputDevice.bufferSizeInMillis;
    }

    static /* synthetic */ void access$2(AppAudioOutputDevice appAudioOutputDevice, int n) {
        appAudioOutputDevice.bufferSizeInMillis = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AppAudioOutputDevice() {
        Option[] optionArray = new Option[2];
        AppAudioOutputDevice appAudioOutputDevice = this;
        if (appAudioOutputDevice == null) {
            throw null;
        }
        optionArray[0] = new 1(appAudioOutputDevice);
        AppAudioOutputDevice appAudioOutputDevice2 = this;
        if (appAudioOutputDevice2 == null) {
            throw null;
        }
        optionArray[1] = new 2(appAudioOutputDevice2);
        this.controllers = optionArray;
    }
}

