/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.plugin;

import com.bliss.core.Option;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.InputSignal;
import com.blissj.plugin.AppInputDevice;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;

public class AppInputDevice
implements InputDevice {
    private static final AppInputSignal[] DEFAULTS_EMULATOR = new AppInputSignal[]{new AppInputSignal(112), new AppInputSignal(116), new AppInputSignal(117), new AppInputSignal(120), new AppInputSignal(123)};
    private static final AppInputSignal[] DEFAULTS_PLAYER_ONE = new AppInputSignal[]{new AppInputSignal(38), new AppInputSignal(33), new AppInputSignal(39), new AppInputSignal(34), new AppInputSignal(40), new AppInputSignal(35), new AppInputSignal(37), new AppInputSignal(36), new AppInputSignal(17), new AppInputSignal(90), new AppInputSignal(88), null, null, null, new AppInputSignal(49), new AppInputSignal(50), new AppInputSignal(51), new AppInputSignal(52), new AppInputSignal(53), new AppInputSignal(54), new AppInputSignal(55), new AppInputSignal(56), new AppInputSignal(57), new AppInputSignal(48), new AppInputSignal(127), new AppInputSignal(10), null, null};
    private static final AppInputSignal[] DEFAULTS_PLAYER_TWO = new AppInputSignal[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final AppInputSignal[] DEFAULTS_KEYBOARD = new AppInputSignal[]{new AppInputSignal(65), new AppInputSignal(66), new AppInputSignal(67), new AppInputSignal(68), new AppInputSignal(69), new AppInputSignal(70), new AppInputSignal(71), new AppInputSignal(72), new AppInputSignal(73), new AppInputSignal(74), new AppInputSignal(75), new AppInputSignal(76), new AppInputSignal(77), new AppInputSignal(78), new AppInputSignal(79), new AppInputSignal(80), new AppInputSignal(81), new AppInputSignal(82), new AppInputSignal(83), new AppInputSignal(84), new AppInputSignal(85), new AppInputSignal(86), new AppInputSignal(87), new AppInputSignal(88), new AppInputSignal(89), new AppInputSignal(90), new AppInputSignal(48), new AppInputSignal(49), new AppInputSignal(50), new AppInputSignal(51), new AppInputSignal(52), new AppInputSignal(53), new AppInputSignal(54), new AppInputSignal(55), new AppInputSignal(56), new AppInputSignal(57), new AppInputSignal(38), new AppInputSignal(40), new AppInputSignal(37), new AppInputSignal(39), new AppInputSignal(44), new AppInputSignal(46), new AppInputSignal(32), new AppInputSignal(59), new AppInputSignal(513), new AppInputSignal(128), new AppInputSignal(10), new AppInputSignal(17), new AppInputSignal(16)};
    boolean stop;
    private boolean[] keyMap = new boolean[65535];
    private AppInputSignal[] signalsPlayerOne;
    private AppInputSignal[] signalsPlayerTwo;
    private AppInputSignal[] signalsKeyboard;
    private AppInputSignal[] signalsEmulator;
    private AWTEventListener keyListener;

    public Option[] getOptions() {
        return Option.EMPTY_CONTROLLER_ARRAY;
    }

    public void poll() {
        if (this.keyMap[27]) {
            this.stop = true;
        }
    }

    public InputSignal getInputSignal(String string) {
        try {
            return new AppInputSignal(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public InputSignal getInputSignal(int n) {
        if (n >= 1000 && n <= 1027) {
            return this.signalsPlayerOne[n - 1000];
        }
        if (n >= 2000 && n <= 2027) {
            return this.signalsPlayerTwo[n - 2000];
        }
        if (n >= 5000 && n <= 5048) {
            return this.signalsKeyboard[n - 5000];
        }
        if (n >= 7000 && n <= 7004) {
            return this.signalsEmulator[n - 7000];
        }
        return null;
    }

    public void setInputSignal(int n, InputSignal inputSignal) {
        AppInputSignal appInputSignal = (AppInputSignal)inputSignal;
        if (n >= 1000 && n <= 1027) {
            this.signalsPlayerOne[n - 1000] = appInputSignal;
        } else if (n >= 2000 && n <= 2027) {
            this.signalsPlayerTwo[n - 2000] = appInputSignal;
        } else if (n >= 5000 && n <= 5048) {
            this.signalsKeyboard[n - 5000] = appInputSignal;
        } else if (n >= 7000 && n <= 7004) {
            this.signalsEmulator[n - 7000] = appInputSignal;
        }
    }

    public InputSignal getDefaultSignal(int n) {
        if (n >= 1000 && n <= 1027) {
            return DEFAULTS_PLAYER_ONE[n - 1000];
        }
        if (n >= 2000 && n <= 2027) {
            return DEFAULTS_PLAYER_TWO[n - 2000];
        }
        if (n >= 5000 && n <= 5048) {
            return DEFAULTS_KEYBOARD[n - 5000];
        }
        if (n >= 7000 && n <= 7004) {
            return DEFAULTS_EMULATOR[n - 7000];
        }
        return null;
    }

    public InputSignal pollForInputSignal() {
        int n = 0;
        while (n < this.keyMap.length) {
            if (this.keyMap[n]) {
                return new AppInputSignal(n);
            }
            ++n;
        }
        return null;
    }

    public float getControlValue(int n) {
        AppInputSignal appInputSignal = null;
        if (n <= 1027) {
            appInputSignal = this.signalsPlayerOne[n - 1000];
        } else if (n <= 2027) {
            appInputSignal = this.signalsPlayerTwo[n - 2000];
        } else if (n <= 5048) {
            appInputSignal = this.signalsKeyboard[n - 5000];
        } else if (n <= 7004) {
            appInputSignal = this.signalsEmulator[n - 7000];
        }
        if (appInputSignal == null) {
            return 0.0f;
        }
        int n2 = appInputSignal.keyCode;
        return this.keyMap[n2] ? 1.0f : 0.0f;
    }

    public void initConfigMode() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    public void releaseConfigMode() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
        int n = 0;
        while (n < this.keyMap.length) {
            this.keyMap[n] = false;
            ++n;
        }
    }

    public void init() {
        this.stop = false;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    public void release() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
        int n = 0;
        while (n < this.keyMap.length) {
            this.keyMap[n] = false;
            ++n;
        }
    }

    static /* synthetic */ boolean[] access$0(AppInputDevice appInputDevice) {
        return appInputDevice.keyMap;
    }

    AppInputDevice() {
        AppInputDevice appInputDevice = this;
        if (appInputDevice == null) {
            throw null;
        }
        this.keyListener = new 1(appInputDevice);
        this.signalsPlayerOne = new AppInputSignal[DEFAULTS_PLAYER_ONE.length];
        System.arraycopy(DEFAULTS_PLAYER_ONE, 0, this.signalsPlayerOne, 0, DEFAULTS_PLAYER_ONE.length);
        this.signalsPlayerTwo = new AppInputSignal[DEFAULTS_PLAYER_TWO.length];
        System.arraycopy(DEFAULTS_PLAYER_TWO, 0, this.signalsPlayerTwo, 0, DEFAULTS_PLAYER_TWO.length);
        this.signalsKeyboard = new AppInputSignal[DEFAULTS_KEYBOARD.length];
        System.arraycopy(DEFAULTS_KEYBOARD, 0, this.signalsKeyboard, 0, DEFAULTS_KEYBOARD.length);
        this.signalsEmulator = new AppInputSignal[DEFAULTS_EMULATOR.length];
        System.arraycopy(DEFAULTS_EMULATOR, 0, this.signalsEmulator, 0, DEFAULTS_EMULATOR.length);
    }

    private static class AppInputSignal
    implements InputSignal {
        private int keyCode;
        private String description;

        public String getDescription() {
            return this.description;
        }

        public String getConfigString() {
            return Integer.toString(this.keyCode);
        }

        public AppInputSignal(int n) {
            this.keyCode = n;
            this.description = "'" + KeyEvent.getKeyText(n) + "'";
        }
    }
}

