/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app;

import com.bliss.core.BooleanOption;
import com.bliss.core.ChoiceOption;
import com.bliss.core.ECSKeyboard;
import com.bliss.core.EmulationDirector;
import com.bliss.core.HandController;
import com.bliss.core.Intellivision;
import com.bliss.core.IntellivisionAdapter;
import com.bliss.core.Option;
import com.bliss.core.ROM;
import com.bliss.core.cartridge.Cartridge;
import com.bliss.core.cartridge.CartridgeFile;
import com.bliss.core.cartridge.CartridgeType;
import com.bliss.core.cartridge.CartridgeTypeFactory;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.PlugIn;
import com.blissj.app.Bliss;
import com.blissj.app.BlissAboutDialog;
import com.blissj.app.BlissConfig;
import com.blissj.app.BlissMainFrame;
import com.blissj.app.BlissOptionsDialog;
import com.blissj.app.BlissPropertiesDialog;
import com.blissj.app.BlissTableCellRenderer;
import com.blissj.app.BlissUtilities;
import com.blissj.app.BusyDialog;
import com.blissj.app.CartridgeTableModel;
import com.blissj.app.IconTableCellRenderer;
import com.blissj.app.ThinBorder;
import com.blissj.app.actions.AboutAction;
import com.blissj.app.actions.ExitBlissAction;
import com.blissj.app.actions.LoadIntellicartAction;
import com.blissj.app.actions.OptionsAction;
import com.blissj.app.actions.PlayCartridgeAction;
import com.blissj.app.actions.PropertiesAction;
import com.blissj.app.actions.RefreshAction;
import com.blissj.app.actions.ViewAllAction;
import com.blissj.app.actions.ViewAvailableAction;
import com.blissj.plugin.AppPlugIn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class BlissMainFrame
extends JFrame {
    private static final Comparator cartFileComparator = new 1();
    private Action refreshAction;
    private ScanCartridgeDirectoryThread scanThread;
    private int[] execImage;
    private int[] gromImage;
    private int[] ecsImage;
    private int[] ivoiceImage;
    private HashMap cartTypeByCrcMap;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem playMenuItem;
    private JMenuItem playIntelCartMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem propertiesMenuItem;
    private JMenu viewMenu;
    private JRadioButtonMenuItem viewAllMenuItem;
    private JRadioButtonMenuItem viewAvailableMenuItem;
    private JMenuItem refreshMenuItem;
    private JMenuItem optionsMenuItem;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JMenu Menu;
    private CartridgeTableModel cartTableModel;
    private JTable cartTable;
    private JScrollPane cartScrollPane;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private BusyDialog busyDialog;
    private BlissPropertiesDialog propertiesDialog;
    private BlissOptionsDialog optionsDialog;
    private BlissAboutDialog aboutDialog;
    private Intellivision inty;
    private HandController player1;
    private HandController player2;
    private ECSKeyboard keyboard;
    private EmulationDirector director;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    private void initUI() {
        this.setDefaultCloseOperation(0);
        this.setTitle(Bliss.RESOURCES.getString("AppName"));
        ((Frame)this).setIconImage(this.getToolkit().createImage(this.getClass().getClassLoader().getResource("com/blissj/app/images/Bliss.gif")));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.cartTableModel = new CartridgeTableModel();
        this.cartTable = new JTable(this.cartTableModel);
        this.cartTable.setAutoResizeMode(3);
        this.cartTable.setIntercellSpacing(new Dimension(0, 0));
        this.cartTable.setShowGrid(false);
        this.cartTable.setRowHeight(this.cartTable.getRowHeight() + 2);
        this.cartTable.setDefaultRenderer(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = BlissMainFrame.class$("java.lang.Object")), new BlissTableCellRenderer());
        TableColumn tableColumn = this.cartTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new IconTableCellRenderer());
        tableColumn.setWidth(18);
        tableColumn.setMinWidth(18);
        tableColumn.setMaxWidth(18);
        tableColumn.setResizable(false);
        this.cartTable.getSelectionModel().setSelectionMode(0);
        this.cartScrollPane = new JScrollPane(this.cartTable);
        this.cartScrollPane.setPreferredSize(new Dimension(750, 550));
        this.cartScrollPane.getViewport().setBackground(Color.white);
        container.add((Component)this.cartScrollPane, "Center");
        this.pack();
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu(Bliss.RESOURCES.getString("FileMenu"));
        this.menuBar.add(this.fileMenu);
        this.playMenuItem = new JMenuItem(new PlayCartridgeAction(this, this.cartTable));
        this.fileMenu.add(this.playMenuItem);
        this.playIntelCartMenuItem = new JMenuItem(new LoadIntellicartAction(this));
        this.fileMenu.add(this.playIntelCartMenuItem);
        this.fileMenu.addSeparator();
        this.propertiesMenuItem = new JMenuItem(new PropertiesAction(this, this.cartTable));
        this.fileMenu.add(this.propertiesMenuItem);
        this.fileMenu.addSeparator();
        this.exitMenuItem = new JMenuItem(new ExitBlissAction(this));
        this.fileMenu.add(this.exitMenuItem);
        this.viewMenu = new JMenu(Bliss.RESOURCES.getString("ViewMenu"));
        this.menuBar.add(this.viewMenu);
        this.viewAllMenuItem = new JRadioButtonMenuItem(new ViewAllAction(this.cartTable));
        this.viewAllMenuItem.setSelected(true);
        this.viewMenu.add(this.viewAllMenuItem);
        this.viewAvailableMenuItem = new JRadioButtonMenuItem(new ViewAvailableAction(this.cartTable));
        this.viewMenu.add(this.viewAvailableMenuItem);
        this.viewMenu.addSeparator();
        this.refreshAction = new RefreshAction(this);
        this.refreshMenuItem = new JMenuItem(this.refreshAction);
        this.viewMenu.add(this.refreshMenuItem);
        this.viewMenu.addSeparator();
        this.optionsMenuItem = new JMenuItem(new OptionsAction(this));
        this.viewMenu.add(this.optionsMenuItem);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.viewAllMenuItem);
        buttonGroup.add(this.viewAvailableMenuItem);
        this.helpMenu = new JMenu(Bliss.RESOURCES.getString("HelpMenu"));
        this.menuBar.add(this.helpMenu);
        this.aboutMenuItem = new JMenuItem(new AboutAction(this));
        this.helpMenu.add(this.aboutMenuItem);
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new GridBagLayout());
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(ThinBorder.createBorder(1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        this.statusPanel.add((Component)this.statusLabel, gridBagConstraints);
        container.add((Component)this.statusPanel, "South");
        this.propertiesDialog = new BlissPropertiesDialog(this);
        BlissMainFrame blissMainFrame = this;
        if (blissMainFrame == null) {
            throw null;
        }
        this.scanThread = blissMainFrame.new ScanCartridgeDirectoryThread();
    }

    private void initROMs() {
        BufferedInputStream bufferedInputStream;
        File file;
        try {
            file = new File("exec.bin");
            if (file.exists() && this.getCrc(file) == 3419309815L) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
                this.extractExecutiveROM(bufferedInputStream);
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file = new File("grom.bin");
            if (file.exists() && file.exists() && this.getCrc(file) == 1748648280L) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
                this.extractGROM(bufferedInputStream);
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file = new File("ecs.bin");
            if (file.exists() && this.getCrc(file) == 3933800966L) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
                this.extractECSROM(bufferedInputStream);
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file = new File("ivoice.bin");
            if (file.exists() && this.getCrc(file) == 233265053L) {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
                this.extractIvoiceROM(bufferedInputStream);
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initListeners() {
        BlissMainFrame blissMainFrame = this;
        if (blissMainFrame == null) {
            throw null;
        }
        this.addWindowListener(new WindowAdapter(blissMainFrame){
            private final /* synthetic */ BlissMainFrame this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.exit();
            }
            {
                this.this$0 = blissMainFrame;
                this.constructor$0(blissMainFrame);
            }

            private final void constructor$0(BlissMainFrame blissMainFrame) {
            }
        });
        BlissMainFrame blissMainFrame2 = this;
        if (blissMainFrame2 == null) {
            throw null;
        }
        this.cartTable.addMouseListener(new MouseAdapter(blissMainFrame2){
            private final /* synthetic */ BlissMainFrame this$0;

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    this.this$0.playCartridge();
                }
            }
            {
                this.this$0 = blissMainFrame;
                this.constructor$0(blissMainFrame);
            }

            private final void constructor$0(BlissMainFrame blissMainFrame) {
            }
        });
    }

    private void initIntellivision() {
        this.inty = new Intellivision();
        PlugIn plugIn = new AppPlugIn();
        String string = System.getProperty("PlugInClass");
        if (string != null && !string.equals("")) {
            try {
                Class<?> clazz = Class.forName(string);
                plugIn = (PlugIn)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inty.setPlugIn(plugIn);
        BlissMainFrame blissMainFrame = this;
        if (blissMainFrame == null) {
            throw null;
        }
        this.inty.addIntellivisionListener(new IntellivisionAdapter(blissMainFrame){
            private final /* synthetic */ BlissMainFrame this$0;

            public void errorOccurred(Intellivision intellivision, String string) {
                intellivision.turnOff();
                intellivision.removeCartridge();
                ((Component)this.this$0).setVisible(true);
                JOptionPane.showMessageDialog(this.this$0, string, Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
            }

            public void turnedOff(Intellivision intellivision) {
                intellivision.removeCartridge();
                ((Component)this.this$0).setVisible(true);
            }
            {
                this.this$0 = blissMainFrame;
                this.constructor$0(blissMainFrame);
            }

            private final void constructor$0(BlissMainFrame blissMainFrame) {
            }
        });
        this.player1 = this.inty.getHandControllerOne();
        this.player2 = this.inty.getHandControllerTwo();
        this.keyboard = this.inty.getECSKeyboard();
        this.director = this.inty.getDirector();
    }

    public void exit() {
        this.dispose();
        this.saveUIState();
        this.saveAudioVideoOptions();
        try {
            Bliss.REGISTRY.saveRegistry();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorCannotSaveRegistry"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
        }
        System.exit(0);
    }

    public void playCartridge() {
        int n = this.cartTable.getSelectionModel().getLeadSelectionIndex();
        CartridgeFile cartridgeFile = this.cartTableModel.getCartridgeFile(n);
        if (cartridgeFile == null) {
            return;
        }
        try {
            Cartridge cartridge = Cartridge.loadCartridge(cartridgeFile);
            this.playCartridge(cartridge);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorLoadingROM"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
        }
    }

    public void playCartridge(Cartridge cartridge) {
        if (this.execImage == null) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorNoExecutiveROM"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
            return;
        }
        if (this.gromImage == null) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorNoGROM"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
            return;
        }
        if (cartridge.getType().requiresECS() && this.ecsImage == null) {
            JOptionPane.showMessageDialog(this, Bliss.RESOURCES.getString("ErrorNoECS"), Bliss.RESOURCES.getString("ErrorDialogTitle"), 0);
            return;
        }
        ((Component)this).setVisible(false);
        this.inty.insertCartridge(cartridge);
        this.inty.turnOn();
    }

    public void scanCartridgeDirectory() {
        this.statusLabel.setText(Bliss.RESOURCES.getString("ScanningCartridgeDirectoryMessage"));
        this.cartTable.clearSelection();
        this.cartTableModel.setCartridgeFileList(new CartridgeFile[0]);
        this.scanThread.startScanning();
    }

    public void displayOptions() {
        if (this.optionsDialog == null) {
            this.optionsDialog = new BlissOptionsDialog(this, this.inty);
        }
        String string = Bliss.REGISTRY.getDataAsString(BlissConfig.KEY_GENERAL, "cartdir", "roms");
        BlissUtilities.centerWindowOverParent(this.optionsDialog);
        ((Component)this.optionsDialog).setVisible(true);
        String string2 = Bliss.REGISTRY.getDataAsString(BlissConfig.KEY_GENERAL, "cartdir", "roms");
        if (!string2.equals(string)) {
            this.scanCartridgeDirectory();
        }
    }

    public void displayAbout() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new BlissAboutDialog(this);
        }
        BlissUtilities.centerWindowOverParent(this.aboutDialog);
        ((Component)this.aboutDialog).setVisible(true);
    }

    public void displayProperties() {
        int n = this.cartTable.getSelectionModel().getLeadSelectionIndex();
        CartridgeType cartridgeType = this.cartTableModel.getCartridgeType(n);
        this.propertiesDialog.setCartridgeType(cartridgeType);
        BlissUtilities.centerWindowOverParent(this.propertiesDialog);
        ((Component)this.propertiesDialog).setVisible(true);
    }

    private boolean isNeededSystemROM(long l) {
        return l == 3419309815L && this.execImage == null || l == 1748648280L && this.gromImage == null || l == 3933800966L && this.ecsImage == null || l == 233265053L && this.ivoiceImage == null;
    }

    private void extractSystemROM(long l, InputStream inputStream) throws IOException {
        if (l == 3419309815L) {
            this.extractExecutiveROM(inputStream);
        } else if (l == 1748648280L) {
            this.extractGROM(inputStream);
        } else if (l == 3933800966L) {
            this.extractECSROM(inputStream);
        } else if (l == 233265053L) {
            this.extractIvoiceROM(inputStream);
        }
    }

    private void extractExecutiveROM(InputStream inputStream) throws IOException {
        if (this.execImage != null) {
            return;
        }
        try {
            this.execImage = ROM.loadROMImage(inputStream, 8192, true);
            this.inty.setExecImage(this.execImage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void extractGROM(InputStream inputStream) throws IOException {
        if (this.gromImage != null) {
            return;
        }
        try {
            this.gromImage = ROM.loadROMImage(inputStream, 2048, false);
            this.inty.setGROMImage(this.gromImage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void extractECSROM(InputStream inputStream) throws IOException {
        if (this.ecsImage != null) {
            return;
        }
        try {
            this.ecsImage = ROM.loadROMImage(inputStream, 24576, true);
            if (this.inty != null) {
                this.inty.enableECSSupport(this.ecsImage);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void extractIvoiceROM(InputStream inputStream) throws IOException {
        if (this.ivoiceImage != null) {
            return;
        }
        try {
            this.ivoiceImage = ROM.loadROMImage(inputStream, 2048, false);
            if (this.inty != null) {
                this.inty.enableIntellivoiceSupport(this.ivoiceImage);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private long getCrc(File file) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
            byte[] byArray = new byte[4096];
            CRC32 cRC32 = new CRC32();
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                cRC32.update(byArray, 0, n);
            }
            return cRC32.getValue();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    private void saveUIState() {
        Bliss.REGISTRY.setData(BlissConfig.KEY_UI, "viewallgames", this.viewAllMenuItem.isSelected() ? "true" : "false");
        Rectangle rectangle = this.getBounds();
        Bliss.REGISTRY.setData(BlissConfig.KEY_UI, "x", rectangle.x);
        Bliss.REGISTRY.setData(BlissConfig.KEY_UI, "y", rectangle.y);
        Bliss.REGISTRY.setData(BlissConfig.KEY_UI, "width", rectangle.width);
        Bliss.REGISTRY.setData(BlissConfig.KEY_UI, "height", rectangle.height);
        int n = 0;
        while (n < this.cartTableModel.getColumnCount()) {
            Bliss.REGISTRY.setData(BlissConfig.KEY_UI, "column" + n, this.cartTable.getColumnModel().getColumn(n).getWidth());
            ++n;
        }
    }

    private void restoreUIState() {
        String string = Bliss.REGISTRY.getDataAsString(BlissConfig.KEY_UI, "viewallgames", "true");
        if (!string.equals("true")) {
            this.viewAvailableMenuItem.doClick();
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Rectangle rectangle = new Rectangle();
        rectangle.x = Bliss.REGISTRY.getDataAsInt(BlissConfig.KEY_UI, "x", (dimension.width - dimension2.width) / 2);
        rectangle.y = Bliss.REGISTRY.getDataAsInt(BlissConfig.KEY_UI, "y", (dimension.height - dimension2.height) / 2);
        rectangle.width = Bliss.REGISTRY.getDataAsInt(BlissConfig.KEY_UI, "width", 750);
        rectangle.height = Bliss.REGISTRY.getDataAsInt(BlissConfig.KEY_UI, "height", 550);
        ((Component)this).setBounds(rectangle);
        int n = this.cartTable.getColumnModel().getColumn(0).getWidth();
        int n2 = 0;
        while (n2 < this.cartTableModel.getColumnCount()) {
            this.cartTable.getColumnModel().getColumn(n2).setPreferredWidth(Bliss.REGISTRY.getDataAsInt(BlissConfig.KEY_UI, "column" + n2, n));
            ++n2;
        }
    }

    private void saveAudioVideoOptions() {
        String[] stringArray = new String[BlissConfig.KEY.length + 2];
        System.arraycopy(BlissConfig.KEY, 0, stringArray, 0, BlissConfig.KEY.length);
        stringArray[stringArray.length - 2] = this.inty.getPlugIn().getPlugInName();
        stringArray[stringArray.length - 1] = "video";
        Option[] optionArray = this.inty.getVideoOptions();
        int n = 0;
        while (n < optionArray.length) {
            Bliss.REGISTRY.setData(stringArray, optionArray[n].getDescription(), optionArray[n].getDescription(optionArray[n].getValue()));
            ++n;
        }
        stringArray[stringArray.length - 1] = "sound";
        optionArray = this.inty.getAudioOptions();
        n = 0;
        while (n < optionArray.length) {
            Bliss.REGISTRY.setData(stringArray, optionArray[n].getDescription(), optionArray[n].getDescription(optionArray[n].getValue()));
            ++n;
        }
    }

    private void restoreAudioVideoOptions() {
        int n;
        Object[] objectArray;
        ChoiceOption choiceOption;
        String string;
        String[] stringArray = new String[BlissConfig.KEY.length + 2];
        System.arraycopy(BlissConfig.KEY, 0, stringArray, 0, BlissConfig.KEY.length);
        stringArray[stringArray.length - 2] = this.inty.getPlugIn().getPlugInName();
        stringArray[stringArray.length - 1] = "video";
        Option[] optionArray = this.inty.getVideoOptions();
        int n2 = 0;
        while (n2 < optionArray.length) {
            string = Bliss.REGISTRY.getDataAsString(stringArray, optionArray[n2].getDescription(), "");
            if (string.length() != 0) {
                if (optionArray[n2] instanceof ChoiceOption) {
                    choiceOption = (ChoiceOption)optionArray[n2];
                    objectArray = choiceOption.getChoices();
                    n = 0;
                    while (n < objectArray.length) {
                        if (choiceOption.getDescription(objectArray[n]).equals(string)) {
                            choiceOption.setValue(objectArray[n]);
                            break;
                        }
                        ++n;
                    }
                } else if (optionArray[n2] instanceof BooleanOption) {
                    ((BooleanOption)optionArray[n2]).setEnabled(string.equals("true"));
                }
            }
            ++n2;
        }
        stringArray[stringArray.length - 1] = "sound";
        optionArray = this.inty.getAudioOptions();
        n2 = 0;
        while (n2 < optionArray.length) {
            string = Bliss.REGISTRY.getDataAsString(stringArray, optionArray[n2].getDescription(), "");
            if (string.length() != 0) {
                if (optionArray[n2] instanceof ChoiceOption) {
                    choiceOption = (ChoiceOption)optionArray[n2];
                    objectArray = choiceOption.getChoices();
                    n = 0;
                    while (n < objectArray.length) {
                        if (choiceOption.getDescription(objectArray[n]).equals(string)) {
                            choiceOption.setValue(objectArray[n]);
                            break;
                        }
                        ++n;
                    }
                } else if (optionArray[n2] instanceof BooleanOption) {
                    ((BooleanOption)optionArray[n2]).setEnabled(string.equals("true"));
                }
            }
            ++n2;
        }
    }

    private void restoreInputDevices() {
        String string;
        InputDevice inputDevice = this.inty.getPlugIn().getInputDevice();
        String[] stringArray = new String[BlissConfig.KEY_INPUT_LEFT_CONTROLLER.length + 1];
        System.arraycopy(BlissConfig.KEY_INPUT_LEFT_CONTROLLER, 0, stringArray, 0, stringArray.length - 1);
        stringArray[stringArray.length - 1] = this.inty.getPlugIn().getPlugInName();
        int n = this.player1.getControlCount();
        int n2 = 0;
        while (n2 < n) {
            string = Bliss.REGISTRY.getDataAsString(stringArray, Integer.toString(n2), null);
            if (string != null) {
                inputDevice.setInputSignal(this.player1.getControlID(n2), string.length() == 0 ? null : inputDevice.getInputSignal(string));
            }
            ++n2;
        }
        System.arraycopy(BlissConfig.KEY_INPUT_RIGHT_CONTROLLER, 0, stringArray, 0, stringArray.length - 1);
        n = this.player2.getControlCount();
        n2 = 0;
        while (n2 < n) {
            string = Bliss.REGISTRY.getDataAsString(stringArray, Integer.toString(n2), null);
            if (string != null) {
                inputDevice.setInputSignal(this.player2.getControlID(n2), string.length() == 0 ? null : inputDevice.getInputSignal(string));
            }
            ++n2;
        }
        System.arraycopy(BlissConfig.KEY_INPUT_ECS_KEYBOARD, 0, stringArray, 0, stringArray.length - 1);
        n = this.keyboard.getControlCount();
        n2 = 0;
        while (n2 < n) {
            string = Bliss.REGISTRY.getDataAsString(stringArray, Integer.toString(n2), null);
            if (string != null) {
                inputDevice.setInputSignal(this.keyboard.getControlID(n2), string.length() == 0 ? null : inputDevice.getInputSignal(string));
            }
            ++n2;
        }
    }

    static /* synthetic */ CartridgeTableModel access$4(BlissMainFrame blissMainFrame) {
        return blissMainFrame.cartTableModel;
    }

    static /* synthetic */ JLabel access$5(BlissMainFrame blissMainFrame) {
        return blissMainFrame.statusLabel;
    }

    static /* synthetic */ Action access$6(BlissMainFrame blissMainFrame) {
        return blissMainFrame.refreshAction;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BlissMainFrame() {
        this.initIntellivision();
        this.initROMs();
        this.initUI();
        this.initListeners();
        this.restoreUIState();
        this.restoreInputDevices();
        this.restoreAudioVideoOptions();
        this.scanCartridgeDirectory();
        this.scanThread.waitForIdle();
    }

    private class ScanCartridgeDirectoryThread
    extends Thread {
        private boolean running = true;
        private CartridgeFile[] cartFiles;

        public void startScanning() {
            ScanCartridgeDirectoryThread scanCartridgeDirectoryThread = this;
            synchronized (scanCartridgeDirectoryThread) {
                if (this.running) {
                    Object var2_2 = null;
                    return;
                }
                this.notify();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void waitForIdle() {
            ScanCartridgeDirectoryThread scanCartridgeDirectoryThread = this;
            synchronized (scanCartridgeDirectoryThread) {
                if (!this.running) {
                    Object var2_2 = null;
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void run() {
            while (true) {
                File[] fileArray;
                ScanCartridgeDirectoryThread scanCartridgeDirectoryThread = this;
                synchronized (scanCartridgeDirectoryThread) {
                    this.running = false;
                    this.notifyAll();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.notifyAll();
                    this.running = true;
                }
                File file = new File(Bliss.REGISTRY.getDataAsString(BlissConfig.KEY_GENERAL, "cartdir", "roms"));
                if (file.exists() && file.isDirectory()) {
                    ScanCartridgeDirectoryThread scanCartridgeDirectoryThread2 = this;
                    if (scanCartridgeDirectoryThread2 == null) {
                        throw null;
                    }
                    fileArray = file.listFiles(new FilenameFilter(scanCartridgeDirectoryThread2){
                        private final /* synthetic */ ScanCartridgeDirectoryThread this$0;

                        public boolean accept(File file, String string) {
                            return string.toLowerCase().endsWith(".bin") || string.toLowerCase().endsWith(".int") || string.toLowerCase().endsWith(".zip");
                        }
                        {
                            this.this$0 = scanCartridgeDirectoryThread;
                            this.constructor$0(scanCartridgeDirectoryThread);
                        }

                        private final void constructor$0(ScanCartridgeDirectoryThread scanCartridgeDirectoryThread) {
                        }
                    });
                } else {
                    fileArray = new File[]{};
                }
                ArrayList<CartridgeFile> arrayList = new ArrayList<CartridgeFile>();
                int n = 0;
                while (n < fileArray.length) {
                    Object object;
                    if (fileArray[n].getName().toLowerCase().endsWith(".zip")) {
                        try {
                            ZipFile zipFile = new ZipFile(fileArray[n]);
                            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                            while (enumeration.hasMoreElements()) {
                                Object object2;
                                object = enumeration.nextElement();
                                long l = ((ZipEntry)object).getCrc();
                                if (BlissMainFrame.this.isNeededSystemROM(l)) {
                                    object2 = new BufferedInputStream(zipFile.getInputStream((ZipEntry)object), 4096);
                                    BlissMainFrame.this.extractSystemROM(l, (InputStream)object2);
                                    ((InputStream)object2).close();
                                    continue;
                                }
                                object2 = CartridgeTypeFactory.getCartridgeType(l);
                                if (object2 == null) continue;
                                arrayList.add(new CartridgeFile((CartridgeType)object2, fileArray[n], ((ZipEntry)object).getName()));
                            }
                        }
                        catch (IOException iOException) {}
                    } else {
                        long l = BlissMainFrame.this.getCrc(fileArray[n]);
                        if (BlissMainFrame.this.isNeededSystemROM(l)) {
                            try {
                                object = new BufferedInputStream(new FileInputStream(fileArray[n]), 4096);
                                BlissMainFrame.this.extractSystemROM(l, (InputStream)object);
                                ((InputStream)object).close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            object = CartridgeTypeFactory.getCartridgeType(l);
                            if (object != null) {
                                arrayList.add(new CartridgeFile((CartridgeType)object, fileArray[n]));
                            }
                        }
                    }
                    ++n;
                }
                this.cartFiles = new CartridgeFile[arrayList.size()];
                arrayList.toArray(this.cartFiles);
                Arrays.sort(this.cartFiles, cartFileComparator);
                ScanCartridgeDirectoryThread scanCartridgeDirectoryThread3 = this;
                if (scanCartridgeDirectoryThread3 == null) {
                    throw null;
                }
                SwingUtilities.invokeLater(new Runnable(scanCartridgeDirectoryThread3){
                    private final /* synthetic */ ScanCartridgeDirectoryThread this$0;
                    private final /* synthetic */ BlissMainFrame this$1;

                    public void run() {
                        BlissMainFrame.access$4(this.this$1).setCartridgeFileList(ScanCartridgeDirectoryThread.access$0(this.this$0));
                        BlissMainFrame.access$5(this.this$1).setText(" ");
                        BlissMainFrame.access$6(this.this$1).setEnabled(true);
                    }
                    {
                        this.this$0 = scanCartridgeDirectoryThread;
                        this.this$1 = ScanCartridgeDirectoryThread.access$1(this.this$0);
                        this.constructor$0(scanCartridgeDirectoryThread);
                    }

                    private final void constructor$0(ScanCartridgeDirectoryThread scanCartridgeDirectoryThread) {
                    }
                });
            }
        }

        static /* synthetic */ CartridgeFile[] access$0(ScanCartridgeDirectoryThread scanCartridgeDirectoryThread) {
            return scanCartridgeDirectoryThread.cartFiles;
        }

        static /* synthetic */ BlissMainFrame access$1(ScanCartridgeDirectoryThread scanCartridgeDirectoryThread) {
            return scanCartridgeDirectoryThread.BlissMainFrame.this;
        }

        private ScanCartridgeDirectoryThread() {
            this.setDaemon(true);
            this.start();
            this.waitForIdle();
        }
    }
}

