/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;

public class MixerClip
extends AbstractDataLine
implements Clip {
    private int id;
    private int waveformId;
    private int frameLength = -1;
    private long microsecondLength = -1L;
    int position = 0;
    int loopCount = 0;
    int currentLoop = 0;
    int loopStart;
    int loopEnd;
    private boolean resettingFramePosition = false;
    private boolean stopping = false;
    MixerClipSampleRateControl rateControl;
    MixerClipGainControl gainControl;
    MixerClipMuteControl muteControl;
    MixerClipPanControl panControl;
    MixerClipApplyReverbControl applyReverbControl;

    MixerClip(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[5], audioFormat, n);
        if (Printer.trace) {
            Printer.trace("> MixerClip: constructor: format: " + audioFormat + " bufferSize: " + n);
        }
        this.gainControl = new MixerClipGainControl();
        this.controls[0] = this.gainControl;
        this.muteControl = new MixerClipMuteControl();
        this.controls[1] = this.muteControl;
        this.panControl = new MixerClipPanControl();
        this.controls[2] = this.panControl;
        this.rateControl = new MixerClipSampleRateControl();
        this.controls[3] = this.rateControl;
        this.applyReverbControl = new MixerClipApplyReverbControl();
        this.controls[4] = this.applyReverbControl;
        if (Printer.trace) {
            Printer.trace("< MixerClip: constructor completed");
        }
    }

    public synchronized void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.mixer.open(this, audioFormat, n2);
            try {
                this.implOpen(audioFormat, byArray, n, n2);
                this.setOpen(true);
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.mixer.close(this);
                throw lineUnavailableException;
            }
        } else {
            throw new IllegalStateException("Line is already open with " + this.getBufferSize() + " bytes of " + this.getFormat() + " data");
        }
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        byte[] byArray;
        int n = (int)audioInputStream.getFrameLength();
        int n2 = n * audioInputStream.getFormat().getFrameSize();
        if (Printer.debug) {
            Printer.debug("HeadspaceMixer: getClip: lengthInFrames: " + n);
        }
        if (n != -1) {
            byArray = new byte[n2];
            int n3 = n2;
            int n4 = 0;
            while (n3 > 0) {
                int n5 = audioInputStream.read(byArray, n4, n3);
                if (n5 > 0) {
                    n4 += n5;
                    n3 -= n5;
                    continue;
                }
                if (n5 != 0) break;
                Thread.yield();
            }
            if (n4 != n2) {
                n2 = n4;
                n = n4 / audioInputStream.getFormat().getFrameSize();
            }
        } else {
            n2 = 0;
            int n6 = 0;
            int n7 = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray2 = new byte[n7];
            while (true) {
                if ((n6 = audioInputStream.read(byArray2, 0, byArray2.length)) == -1) {
                    if (n2 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n6);
                n2 += n6;
                Thread.currentThread();
                Thread.yield();
            }
            byArray = byteArrayOutputStream.toByteArray();
            n = byArray.length / audioInputStream.getFormat().getFrameSize();
            if (Printer.debug) {
                Printer.debug("Read to end of stream.  lengthInBytes: " + n2 + " streamData.length: " + byArray.length + " lengthInFrames: " + n);
            }
        }
        this.open(audioInputStream.getFormat(), byArray, 0, byArray.length);
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    public synchronized void setFramePosition(int n) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setFramePosition: " + n);
        }
        int n2 = this.bufferSize / this.format.getFrameSize();
        if (Printer.debug) {
            Printer.debug("    MixerClip: bufferSize: " + this.bufferSize + " lengthInFrames: " + n2);
        }
        if (Printer.debug) {
            Printer.debug("    getFramePosition(): " + this.getFramePosition());
        }
        if (!this.isStartedRunning() && n == this.position) {
            return;
        }
        this.resettingFramePosition = true;
        boolean bl = this.isStartedRunning();
        if (this.id != 0) {
            this.implStop();
        }
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        this.position = n;
        if (this.loopStart < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting loopStart to new position value " + this.position);
            }
            this.loopStart = this.position;
        }
        if (this.loopEnd < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting loopEnd to end of sample " + n2);
            }
            this.loopStart = n2;
        }
        if (bl) {
            this.implStart();
        }
        this.resettingFramePosition = false;
        if (Printer.trace) {
            Printer.trace("< MixerClip: setFramePosition: set position to " + this.position);
        }
    }

    public synchronized void setMicrosecondPosition(long l) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setMicrosecondPosition: " + l);
        }
        int n = (int)((double)((float)l * this.getFormat().getFrameRate()) / 1000000.0);
        if (Printer.debug) {
            Printer.debug("    frame rate: " + this.format.getFrameRate());
        }
        if (Printer.debug) {
            Printer.debug("    frames: " + n);
        }
        this.setFramePosition(n);
    }

    public void setLoopPoints(int n, int n2) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setLoopPoints: start: " + n + " end: " + n2);
        }
        int n3 = this.bufferSize / this.format.getFrameSize();
        if (Printer.debug) {
            Printer.debug("    > MixerClip: setLoopPoints: lengthInFrames: " + n3);
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < n) {
            throw new IllegalArgumentException("End position " + n2 + "  preceeds start position " + n);
        }
        if (n < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting start to new position value " + this.position);
            }
            n = this.position;
        }
        if (n2 < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting end to end of sample " + n3);
            }
            n2 = n3;
        }
        this.loopStart = n;
        this.loopEnd = n2;
        if (Printer.trace) {
            Printer.trace("< MixerClip: setLoopPoints completed: loopStart: " + this.loopStart + " loopEnd: " + this.loopEnd);
        }
    }

    public void loop(int n) {
        if (n != 0) {
            this.stop();
        }
        this.loopCount = n;
        this.start();
    }

    void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
        throw new IllegalArgumentException("This method should not have been invoked!");
    }

    void implOpen(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        this.rateControl.update(audioFormat.getFrameRate());
        boolean bl = false;
        boolean bl2 = false;
        if (audioFormat.getSampleSizeInBits() == 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            bl = true;
        }
        if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
            bl2 = true;
        }
        if (bl) {
            Toolkit.getUnsigned8(byArray, n, n2);
        } else if (bl2) {
            Toolkit.getByteSwapped(byArray, n, n2);
        }
        int n3 = n2 / audioFormat.getFrameSize();
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        if (n3 > 0x100000) {
            throw new LineUnavailableException("Failed to allocate clip data: Requested buffer too large.");
        }
        this.waveformId = this.nOpen(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getSampleRate(), byArray, n, n3);
        if (this.waveformId == 0) {
            throw new LineUnavailableException("Failed to allocate clip data.");
        }
        this.format = audioFormat;
        this.bufferSize = n2;
        this.frameLength = this.bufferSize / audioFormat.getFrameSize();
        this.microsecondLength = (long)((float)this.frameLength / audioFormat.getFrameRate());
        this.loopStart = 0;
        this.loopEnd = n3;
        this.position = 0;
        this.id = this.getValidVoiceId();
    }

    synchronized int getValidVoiceId() throws LineUnavailableException {
        int n;
        float f;
        if (this.id != 0) {
            return this.id;
        }
        float f2 = this.muteControl.getValue() ? 0.0f : Toolkit.dBToLinear(this.gainControl.getValue());
        int n2 = this.nSetup(this.waveformId, this.position, this.loopStart, this.loopEnd, f2, (f = this.panControl.getValue()) * -1.0f, n = (int)this.rateControl.getValue());
        if (n2 == 0) {
            throw new LineUnavailableException("Failed to allocate sample voice");
        }
        return n2;
    }

    void implClose() {
        this.nClose(this.id, this.waveformId);
        this.id = 0;
        this.waveformId = 0;
    }

    void implStart() {
        block5: {
            int n = this.bufferSize / this.format.getFrameSize();
            if (this.position >= n) {
                if (Printer.debug) {
                    Printer.debug("MixerClip: implStart: already at end of sample; returning.");
                }
                return;
            }
            try {
                this.id = this.getValidVoiceId();
                if (this.nStart(this.id)) {
                    this.setActive(true);
                    this.setStarted(true);
                }
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (!Printer.err) break block5;
                Printer.err("ERROR: LineUnavailableException in implStart: " + lineUnavailableException);
            }
        }
    }

    void implStop() {
        if (Printer.debug) {
            Printer.debug("> MixerClip: implStop: id: " + this.id);
        }
        this.position = this.getFramePosition();
        this.loopCount = 0;
        this.currentLoop = 0;
        this.stopping = true;
        this.nStop(this.id);
        while (this.id != 0) {
            MixerClip mixerClip = this;
            synchronized (mixerClip) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopping = false;
        this.setStarted(false);
        if (Printer.debug) {
            Printer.debug("< MixerClip: implStop: id: " + this.id + " position: " + this.position);
        }
    }

    public int getFramePosition() {
        return this.id != 0 ? this.position + (int)this.nGetPosition(this.id) : this.position;
    }

    boolean callbackSampleLoop() {
        boolean bl;
        if (Printer.trace) {
            Printer.trace(">> MixerClip: callbackSampleLoop()");
        }
        boolean bl2 = bl = this.loopCount == -1 || this.currentLoop < this.loopCount;
        if (Printer.debug) {
            Printer.debug("currentLoop: " + this.currentLoop + " loopCount: " + this.loopCount + " keepLooping: " + bl);
        }
        ++this.currentLoop;
        if (!bl) {
            this.loopCount = 0;
            this.currentLoop = 0;
        }
        if (Printer.trace) {
            Printer.trace("<< MixerClip: callbackSampleLoop() returning: " + bl);
        }
        return bl;
    }

    void callbackSampleEnd() {
        if (Printer.trace) {
            Printer.trace(">> MixerClip: callbackSampleEnd()");
        }
        this.id = 0;
        if (!this.resettingFramePosition) {
            this.setActive(false);
            if (!this.stopping) {
                this.setEOM();
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerClip: callbackSampleEnd() completed");
        }
    }

    private native boolean nStart(int var1);

    private native int nSetup(int var1, int var2, int var3, int var4, float var5, float var6, int var7) throws LineUnavailableException, IllegalArgumentException;

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native long nGetPosition(int var1);

    private native float nGetLevel(int var1);

    private native int nOpen(int var1, int var2, float var3, byte[] var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose(int var1, int var2);

    private native void nStop(int var1);

    protected native float nSetLinearGain(int var1, float var2);

    protected native float nSetPan(int var1, float var2);

    protected native int nSetSampleRate(int var1, int var2);

    private class MixerClipApplyReverbControl
    extends BooleanControl {
        private MixerClipApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean bl) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (bl == this.getValue() || MixerClip.this.id != 0) {
                // empty if block
            }
            super.setValue(bl);
        }
    }

    private class MixerClipMuteControl
    extends BooleanControl {
        private MixerClipMuteControl() {
            super(BooleanControl.Type.MUTE, false, "Mute", "Not Mute");
        }

        public void setValue(boolean bl) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (bl && !this.getValue() && MixerClip.this.id != 0) {
                MixerClip.this.nSetLinearGain(MixerClip.this.id, 0.0f);
            } else if (!bl && this.getValue() && MixerClip.this.id != 0) {
                float f = Toolkit.dBToLinear(MixerClip.this.gainControl.getValue());
                MixerClip.this.nSetLinearGain(MixerClip.this.id, f);
            }
            super.setValue(bl);
        }
    }

    private class MixerClipSampleRateControl
    extends FloatControl {
        private MixerClipSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerClip.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float f) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            if ((f = Math.max(f, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                f = MixerClip.this.nSetSampleRate(MixerClip.this.id, (int)f);
            }
            super.setValue(f);
        }

        private void update(float f) {
            super.setValue(f);
        }
    }

    private class MixerClipPanControl
    extends FloatControl {
        private MixerClipPanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float f) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            if ((f = Math.max(f, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                f = -1.0f * MixerClip.this.nSetPan(MixerClip.this.id, -1.0f * f);
            }
            super.setValue(f);
        }
    }

    private class MixerClipGainControl
    extends FloatControl {
        private float linearGain = 1.0f;

        private MixerClipGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Toolkit.linearToDB(0.0078125f), -1, 0.0f, "dB", "Minimum", "", "Maximum");
        }

        public void setValue(float f) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            float f2 = Toolkit.dBToLinear(f = Math.max(f, this.getMinimum()));
            if (f2 != this.linearGain && MixerClip.this.id != 0) {
                f2 = MixerClip.this.nSetLinearGain(MixerClip.this.id, f2);
            }
            this.linearGain = f2;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }
}

