/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    protected ButtonModel model = null;
    private String text = "";
    private Insets margin = null;
    private Insets defaultMargin = null;
    private Icon defaultIcon = null;
    private Icon pressedIcon = null;
    private Icon disabledIcon = null;
    private Icon selectedIcon = null;
    private Icon disabledSelectedIcon = null;
    private Icon rolloverIcon = null;
    private Icon rolloverSelectedIcon = null;
    private boolean paintBorder = true;
    private boolean paintFocus = true;
    private boolean rolloverEnabled = false;
    private boolean contentAreaFilled = true;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private AccessibleIcon accessibleIcon = null;
    protected ChangeListener changeListener = null;
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected transient ChangeEvent changeEvent;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (string == null || string2 == null || !string.equals(string2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        this.model.setSelected(bl);
    }

    public void doClick() {
        this.doClick(68);
    }

    public void doClick(int n) {
        Dimension dimension = this.getSize();
        this.model.setArmed(true);
        this.model.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, dimension.width, dimension.height));
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.model.setPressed(false);
        this.model.setArmed(false);
    }

    public void setMargin(Insets insets) {
        if (insets instanceof UIResource) {
            this.defaultMargin = insets;
        } else if (this.margin instanceof UIResource) {
            this.defaultMargin = this.margin;
        }
        if (insets == null && this.defaultMargin != null) {
            insets = this.defaultMargin;
        }
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, insets2, insets);
        if (insets2 == null || !insets.equals(insets2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public Insets getMargin() {
        return this.margin == null ? null : (Insets)this.margin.clone();
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public void setIcon(Icon icon) {
        AccessibleContext accessibleContext;
        Icon icon2 = this.defaultIcon;
        this.defaultIcon = icon;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.pressedIcon);
        }
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
        this.accessibleIcon = null;
        if (icon instanceof Accessible && (accessibleContext = ((Accessible)((Object)icon)).getAccessibleContext()) != null && accessibleContext instanceof AccessibleIcon) {
            this.accessibleIcon = (AccessibleIcon)((Object)accessibleContext);
        }
    }

    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public void setPressedIcon(Icon icon) {
        Icon icon2 = this.pressedIcon;
        this.pressedIcon = icon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        if (icon != icon2 && this.getModel().isPressed()) {
            this.repaint();
        }
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        Icon icon2 = this.selectedIcon;
        this.selectedIcon = icon;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && this.isSelected()) {
            this.repaint();
        }
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon icon) {
        Icon icon2 = this.rolloverIcon;
        this.rolloverIcon = icon;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != icon2) {
            this.repaint();
        }
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon icon) {
        Icon icon2 = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = icon;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && this.isSelected()) {
            this.repaint();
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage()));
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && !this.isEnabled()) {
            this.repaint();
        }
    }

    public Icon getDisabledSelectedIcon() {
        if (this.disabledSelectedIcon == null) {
            if (this.selectedIcon != null && this.selectedIcon instanceof ImageIcon) {
                this.disabledSelectedIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.selectedIcon).getImage()));
            } else {
                return this.disabledIcon;
            }
        }
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon icon) {
        Icon icon2 = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            if (!this.isEnabled() && this.isSelected()) {
                this.repaint();
            }
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, VERTICAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, n2, this.verticalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, n2, this.horizontalAlignment);
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (n == this.verticalTextPosition) {
            return;
        }
        int n2 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n, VERTICAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, n2, this.verticalTextPosition);
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        if (n == this.horizontalTextPosition) {
            return;
        }
        int n2 = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(n, HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, n2, this.horizontalTextPosition);
        this.repaint();
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n == 2 || n == 0 || n == 4 || n == 10 || n == 11) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n, String string) {
        if (n == 1 || n == 0 || n == 3) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public void setActionCommand(String string) {
        this.getModel().setActionCommand(string);
    }

    public String getActionCommand() {
        String string = this.getModel().getActionCommand();
        if (string == null) {
            string = this.getText();
        }
        return string;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl = false;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == clazz && objectArray[n + 1] == actionListener) {
                bl = true;
            }
            n -= 2;
        }
        return bl;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        Integer n;
        this.setText(action != null ? (String)action.getValue("Name") : null);
        this.setIcon(action != null ? (Icon)action.getValue("SmallIcon") : null);
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
        if (action != null && (n = (Integer)action.getValue("MnemonicKey")) != null) {
            this.setMnemonic(n);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new ButtonActionPropertyChangeListener(this, action);
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        boolean bl2 = this.paintBorder;
        this.paintBorder = bl;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, bl2, this.paintBorder);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public boolean isFocusPainted() {
        return this.paintFocus;
    }

    public void setFocusPainted(boolean bl) {
        boolean bl2 = this.paintFocus;
        this.paintFocus = bl;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, bl2, this.paintFocus);
        if (bl != bl2 && this.hasFocus()) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public void setContentAreaFilled(boolean bl) {
        boolean bl2 = this.contentAreaFilled;
        this.contentAreaFilled = bl;
        this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, bl2, this.contentAreaFilled);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.rolloverEnabled;
        this.rolloverEnabled = bl;
        this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl2, this.rolloverEnabled);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public int getMnemonic() {
        return this.model.getMnemonic();
    }

    public void setMnemonic(int n) {
        int n2 = this.getMnemonic();
        this.model.setMnemonic(n);
        this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, n2, n);
        if (n != n2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setMnemonic(char n) {
        int n2 = n;
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        this.setMnemonic(n2);
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        if (buttonModel2 != null) {
            buttonModel2.removeChangeListener(this.changeListener);
            buttonModel2.removeActionListener(this.actionListener);
            this.changeListener = null;
            this.actionListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.changeListener = this.createChangeListener();
            this.actionListener = this.createActionListener();
            this.itemListener = this.createItemListener();
            buttonModel.addChangeListener(this.changeListener);
            buttonModel.addActionListener(this.actionListener);
            buttonModel.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, buttonModel2, buttonModel);
        if (buttonModel != buttonModel2) {
            this.revalidate();
            this.repaint();
        }
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    public void updateUI() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? AbstractButton.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    protected ChangeListener createChangeListener() {
        return new ButtonChangeListener();
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener == null ? AbstractButton.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (actionEvent2 == null) {
                    String string = actionEvent.getActionCommand();
                    if (string == null) {
                        string = this.getActionCommand();
                    }
                    actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getModifiers());
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent2);
            }
            n -= 2;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener == null ? AbstractButton.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                if (itemEvent2 == null) {
                    itemEvent2 = new ItemEvent(this, 701, this, itemEvent.getStateChange());
                }
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent2);
            }
            n -= 2;
        }
        if (this.accessibleContext != null) {
            if (itemEvent.getStateChange() == 1) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(0), new Integer(1));
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(1), new Integer(0));
            }
        }
    }

    protected ActionListener createActionListener() {
        return new ForwardActionEvents();
    }

    protected ItemListener createItemListener() {
        return new ForwardItemEvents();
    }

    public void setEnabled(boolean bl) {
        if (!bl && this.model.isRollover()) {
            this.model.setRollover(false);
        }
        super.setEnabled(bl);
        this.model.setEnabled(bl);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setLabel(String string) {
        this.setText(string);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (!this.isSelected()) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getText()};
        return objectArray;
    }

    protected void init(String string, Icon icon) {
        this.setLayout(new OverlayLayout(this));
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.updateUI();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                AbstractButton.this.model.setArmed(false);
                if (AbstractButton.this.isFocusPainted()) {
                    AbstractButton.this.repaint();
                }
            }
        });
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (!(SwingUtilities.doesIconReferenceImage(this.getIcon(), image) || SwingUtilities.doesIconReferenceImage(this.getPressedIcon(), image) || SwingUtilities.doesIconReferenceImage(this.getDisabledIcon(), image) || SwingUtilities.doesIconReferenceImage(this.getSelectedIcon(), image) || SwingUtilities.doesIconReferenceImage(this.getDisabledSelectedIcon(), image) || SwingUtilities.doesIconReferenceImage(this.getRolloverIcon(), image) || SwingUtilities.doesIconReferenceImage(this.getRolloverSelectedIcon(), image))) {
            return false;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    protected String paramString() {
        String string = this.defaultIcon != null && this.defaultIcon != this ? this.defaultIcon.toString() : "";
        String string2 = this.pressedIcon != null && this.pressedIcon != this ? this.pressedIcon.toString() : "";
        String string3 = this.disabledIcon != null && this.disabledIcon != this ? this.disabledIcon.toString() : "";
        String string4 = this.selectedIcon != null && this.selectedIcon != this ? this.selectedIcon.toString() : "";
        String string5 = this.disabledSelectedIcon != null && this.disabledSelectedIcon != this ? this.disabledSelectedIcon.toString() : "";
        String string6 = this.rolloverIcon != null && this.rolloverIcon != this ? this.rolloverIcon.toString() : "";
        String string7 = this.rolloverSelectedIcon != null && this.rolloverSelectedIcon != this ? this.rolloverSelectedIcon.toString() : "";
        String string8 = this.paintBorder ? "true" : "false";
        String string9 = this.paintFocus ? "true" : "false";
        String string10 = this.rolloverEnabled ? "true" : "false";
        return super.paramString() + ",defaultIcon=" + string + ",disabledIcon=" + string3 + ",disabledSelectedIcon=" + string5 + ",margin=" + this.margin + ",paintBorder=" + string8 + ",paintFocus=" + string9 + ",pressedIcon=" + string2 + ",rolloverEnabled=" + string10 + ",rolloverIcon=" + string6 + ",rolloverSelectedIcon=" + string7 + ",selectedIcon=" + string4 + ",text=" + this.text;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText {
        protected AccessibleAbstractButton() {
            super(AbstractButton.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (AbstractButton.this.getText() == null) {
                return super.getAccessibleName();
            }
            return AbstractButton.this.getText();
        }

        public AccessibleIcon[] getAccessibleIcon() {
            if (AbstractButton.this.accessibleIcon == null) {
                return null;
            }
            AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{AbstractButton.this.accessibleIcon};
            return accessibleIconArray;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (AbstractButton.this.getModel().isArmed()) {
                accessibleStateSet.add(AccessibleState.ARMED);
            }
            if (AbstractButton.this.hasFocus()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (AbstractButton.this.getModel().isPressed()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            if (AbstractButton.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            ButtonGroup buttonGroup;
            ButtonModel buttonModel;
            AccessibleRelationSet accessibleRelationSet = super.getAccessibleRelationSet();
            if (!accessibleRelationSet.contains(AccessibleRelation.MEMBER_OF) && (buttonModel = AbstractButton.this.getModel()) != null && buttonModel instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)buttonModel).getGroup()) != null) {
                int n = buttonGroup.getButtonCount();
                Object[] objectArray = new Object[n];
                Enumeration enumeration = buttonGroup.getElements();
                int n2 = 0;
                while (n2 < n) {
                    if (enumeration.hasMoreElements()) {
                        objectArray[n2] = enumeration.nextElement();
                    }
                    ++n2;
                }
                AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.MEMBER_OF);
                accessibleRelation.setTarget(objectArray);
                accessibleRelationSet.add(accessibleRelation);
            }
            return accessibleRelationSet;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                AbstractButton.this.doClick();
                return true;
            }
            return false;
        }

        public Number getCurrentAccessibleValue() {
            if (AbstractButton.this.isSelected()) {
                return new Integer(1);
            }
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                int n = number.intValue();
                if (n == 0) {
                    AbstractButton.this.setSelected(false);
                } else {
                    AbstractButton.this.setSelected(true);
                }
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(1);
        }

        public AccessibleText getAccessibleText() {
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                return this;
            }
            return null;
        }

        public int getIndexAtPoint(Point point) {
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                if (rectangle == null) {
                    return -1;
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Position.Bias[] biasArray = new Position.Bias[1];
                return view.viewToModel(point.x, point.y, float_, biasArray);
            }
            return -1;
        }

        public Rectangle getCharacterBounds(int n) {
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                if (rectangle == null) {
                    return null;
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                try {
                    Shape shape = view.modelToView(n, float_, Position.Bias.Forward);
                    return shape.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        public int getCharCount() {
            Document document;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                return styledDocument.getLength();
            }
            return AbstractButton.this.accessibleContext.getAccessibleName().length();
        }

        public int getCaretPosition() {
            return -1;
        }

        public String getAtIndex(int n, int n2) {
            if (n2 < 0 || n2 >= this.getCharCount()) {
                return null;
            }
            switch (n) {
                case 1: {
                    try {
                        return this.getText(n2, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        return string.substring(breakIterator.previous(), n3);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n2);
                        return string.substring(breakIterator.previous(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getAfterIndex(int n, int n2) {
            if (n2 < 0 || n2 >= this.getCharCount()) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 + 1 >= this.getCharCount()) {
                        return null;
                    }
                    try {
                        return this.getText(n2 + 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        if (n3 == -1 || n3 >= string.length()) {
                            return null;
                        }
                        int n4 = breakIterator.following(n3);
                        if (n4 == -1 || n4 >= string.length()) {
                            return null;
                        }
                        return string.substring(n3, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n5 = breakIterator.following(n2);
                        if (n5 == -1 || n5 >= string.length()) {
                            return null;
                        }
                        int n6 = breakIterator.following(n5);
                        if (n6 == -1 || n6 >= string.length()) {
                            return null;
                        }
                        return string.substring(n5, n6);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getBeforeIndex(int n, int n2) {
            if (n2 < 0 || n2 > this.getCharCount() - 1) {
                return null;
            }
            switch (n) {
                case 1: {
                    if (n2 == 0) {
                        return null;
                    }
                    try {
                        return this.getText(n2 - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string);
                        int n3 = breakIterator.following(n2);
                        n3 = breakIterator.previous();
                        int n4 = breakIterator.previous();
                        if (n4 == -1) {
                            return null;
                        }
                        return string.substring(n4, n3);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string);
                        int n5 = breakIterator.following(n2);
                        n5 = breakIterator.previous();
                        int n6 = breakIterator.previous();
                        if (n6 == -1) {
                            return null;
                        }
                        return string.substring(n6, n5);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public AttributeSet getCharacterAttribute(int n) {
            StyledDocument styledDocument;
            Element element;
            Document document;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument && (element = (styledDocument = (StyledDocument)document).getCharacterElement(n)) != null) {
                return element.getAttributes();
            }
            return null;
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public String getSelectedText() {
            return null;
        }

        private String getText(int n, int n2) throws BadLocationException {
            Document document;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                return styledDocument.getText(n, n2);
            }
            return null;
        }

        private Rectangle getTextRectangle() {
            Icon icon;
            String string = AbstractButton.this.getText();
            Icon icon2 = icon = AbstractButton.this.isEnabled() ? AbstractButton.this.getIcon() : AbstractButton.this.getDisabledIcon();
            if (icon == null && string == null) {
                return null;
            }
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            insets = AbstractButton.this.getInsets(insets);
            rectangle3.x = insets.left;
            rectangle3.y = insets.top;
            rectangle3.width = AbstractButton.this.getWidth() - (insets.left + insets.right);
            rectangle3.height = AbstractButton.this.getHeight() - (insets.top + insets.bottom);
            Graphics graphics = AbstractButton.this.getGraphics();
            if (graphics == null) {
                return null;
            }
            String string2 = SwingUtilities.layoutCompoundLabel(AbstractButton.this, graphics.getFontMetrics(), string, icon, AbstractButton.this.getVerticalAlignment(), AbstractButton.this.getHorizontalAlignment(), AbstractButton.this.getVerticalTextPosition(), AbstractButton.this.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, 0);
            return rectangle2;
        }
    }

    private class ForwardItemEvents
    implements ItemListener,
    Serializable {
        private ForwardItemEvents() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton.this.fireItemStateChanged(itemEvent);
        }
    }

    private class ForwardActionEvents
    implements ActionListener,
    Serializable {
        private ForwardActionEvents() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton.this.fireActionPerformed(actionEvent);
        }
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton.this.fireStateChanged();
            AbstractButton.this.repaint();
        }
    }

    private static class ButtonActionPropertyChangeListener
    extends AbstractActionPropertyChangeListener {
        ButtonActionPropertyChangeListener(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            AbstractButton abstractButton = (AbstractButton)this.getTarget();
            if (abstractButton == null) {
                Action action = (Action)propertyChangeEvent.getSource();
                action.removePropertyChangeListener(this);
            } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                abstractButton.setText(string2);
                abstractButton.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                abstractButton.setToolTipText(string3);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                abstractButton.setEnabled(bl);
                abstractButton.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                abstractButton.setIcon(icon);
                abstractButton.invalidate();
                abstractButton.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                abstractButton.setMnemonic(n);
                abstractButton.invalidate();
                abstractButton.repaint();
            }
        }
    }
}

