/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.SaveOutputStream;
import java.io.IOException;

public class GRAM
extends Memory {
    protected int[] image;
    protected int location;
    protected boolean[] dirtyBytes;
    protected boolean dirtyRAM;
    protected int bitWidth;
    protected int trimmer;

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        int n = 0;
        while (n < this.image.length) {
            saveOutputStream.writeInt(this.image[n]);
            ++n;
        }
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        int n = 0;
        while (n < this.image.length) {
            this.image[n] = loadInputStream.readInt(0, this.trimmer);
            this.dirtyBytes[n] = true;
            ++n;
        }
        this.dirtyRAM = true;
    }

    public void reset() {
        this.dirtyRAM = true;
        int n = 0;
        while (n < this.image.length) {
            this.image[n] = 0;
            this.dirtyBytes[n] = true;
            ++n;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public int peek(int n) {
        return this.image[n - this.location];
    }

    public void poke(int n, int n2) {
        if (this.image[n - this.location] != (n2 &= this.trimmer)) {
            this.image[n - this.location] = n2;
            this.dirtyBytes[n - this.location] = true;
            this.dirtyRAM = true;
        }
    }

    public void markClean() {
        if (!this.dirtyRAM) {
            return;
        }
        int n = 0;
        while (n < this.dirtyBytes.length) {
            this.dirtyBytes[n] = false;
            ++n;
        }
        this.dirtyRAM = false;
    }

    public boolean isDirty() {
        return this.dirtyRAM;
    }

    public boolean isDirty(int n) {
        return this.dirtyBytes[n - this.location];
    }

    public int getSize() {
        return this.image.length;
    }

    public GRAM(int n, int n2, int n3) {
        this.image = new int[n];
        this.location = n2;
        this.dirtyBytes = new boolean[n];
        this.bitWidth = n3;
        this.trimmer = (int)Math.pow(2.0, n3) - 1;
    }
}

