/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.SaveOutputStream;
import java.io.IOException;

public class RAM
extends Memory {
    int[] image;
    int location;
    int bitWidth;
    int trimmer;

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        int n = 0;
        while (n < this.image.length) {
            saveOutputStream.writeInt(this.image[n]);
            ++n;
        }
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        int n = 0;
        while (n < this.image.length) {
            this.image[n] = loadInputStream.readInt(0, this.trimmer);
            ++n;
        }
    }

    public void reset() {
        int n = 0;
        while (n < this.image.length) {
            this.image[n] = 0;
            ++n;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public int peek(int n) {
        return this.image[n - this.location];
    }

    public void poke(int n, int n2) {
        this.image[n - this.location] = n2 & this.trimmer;
    }

    public int getSize() {
        return this.image.length;
    }

    public RAM(int n, int n2, int n3) {
        this.image = new int[n];
        this.location = n2;
        this.bitWidth = n3;
        this.trimmer = (int)Math.pow(2.0, n3) - 1;
    }
}

