/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core.cartridge;

import com.bliss.core.cartridge.CartridgeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

public class CartridgeTypeFactory {
    private static CartridgeType[] cartTypes;
    private static Hashtable cartTypesByCrc;
    private static /* synthetic */ Class class$Lcom$bliss$core$cartridge$CartridgeTypeFactory;

    public static CartridgeType[] getCartridgeTypeList() {
        if (cartTypes == null) {
            CartridgeTypeFactory.loadCartTypes();
        }
        return cartTypes;
    }

    public static CartridgeType getCartridgeType(long l) {
        if (cartTypes == null) {
            CartridgeTypeFactory.loadCartTypes();
        }
        return (CartridgeType)cartTypesByCrc.get(new Long(l));
    }

    private static void loadCartTypes() {
        try {
            InputStream inputStream = (class$Lcom$bliss$core$cartridge$CartridgeTypeFactory != null ? class$Lcom$bliss$core$cartridge$CartridgeTypeFactory : (class$Lcom$bliss$core$cartridge$CartridgeTypeFactory = CartridgeTypeFactory.class$("com.bliss.core.cartridge.CartridgeTypeFactory"))).getResourceAsStream("games.ram");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 4096);
            Vector<CartridgeType> vector = new Vector<CartridgeType>();
            Vector<String> vector2 = new Vector<String>();
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!string.equals("<Cartridge>")) {
                    string = bufferedReader.readLine();
                    continue;
                }
                string = bufferedReader.readLine();
                if (!string.startsWith("<Name>")) {
                    string = bufferedReader.readLine();
                    continue;
                }
                String string2 = string.substring(6, string.length() - 7);
                string = bufferedReader.readLine();
                if (!string.startsWith("<Producer>")) {
                    string = bufferedReader.readLine();
                    continue;
                }
                String string3 = string.substring(10, string.length() - 11);
                string = bufferedReader.readLine();
                if (!string.startsWith("<Year>")) {
                    string = bufferedReader.readLine();
                    continue;
                }
                String string4 = string.substring(6, string.length() - 7);
                string = bufferedReader.readLine();
                if (!string.startsWith("<CRC>")) {
                    string = bufferedReader.readLine();
                    continue;
                }
                try {
                    long l = Long.parseLong(string.substring(5, string.length() - 6), 16);
                    string = bufferedReader.readLine();
                    if (!string.startsWith("<Size>")) {
                        string = bufferedReader.readLine();
                        continue;
                    }
                    int n = Integer.parseInt(string.substring(6, string.length() - 7));
                    string = bufferedReader.readLine();
                    if (!string.startsWith("<Config>")) {
                        string = bufferedReader.readLine();
                        continue;
                    }
                    string = bufferedReader.readLine();
                    vector2.removeAllElements();
                    while (!string.equals("</Config>")) {
                        vector2.addElement(string);
                        string = bufferedReader.readLine();
                    }
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        string = (String)vector2.elementAt(n2);
                        if (string.startsWith("ECS")) {
                            bl = true;
                            vector2.removeElementAt(n2);
                            n2 -= 1;
                        }
                        n2 += 1;
                    }
                    n2 = 0;
                    int n3 = 0;
                    while (n3 < vector2.size()) {
                        string = (String)vector2.elementAt(n3);
                        if (string.startsWith("Intellivoice")) {
                            n2 = 1;
                            vector2.removeElementAt(n3);
                            --n3;
                        }
                        ++n3;
                    }
                    int[][] nArray = new int[vector2.size()][4];
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        string = (String)vector2.elementAt(n4);
                        if (string.startsWith("RAM")) {
                            if (string.charAt(3) == '8') {
                                nArray[n4][0] = Integer.parseInt(string.substring(6, 10), 16);
                                nArray[n4][1] = Integer.parseInt(string.substring(12, 16), 16);
                                nArray[n4][2] = -8;
                            } else {
                                nArray[n4][0] = Integer.parseInt(string.substring(7, 11), 16);
                                nArray[n4][1] = Integer.parseInt(string.substring(13, 17), 16);
                                nArray[n4][2] = -16;
                            }
                            nArray[n4][3] = -1;
                        } else {
                            nArray[n4][0] = Integer.parseInt(string.substring(1, 5), 16);
                            nArray[n4][1] = Integer.parseInt(string.substring(7, 11), 16);
                            nArray[n4][2] = Integer.parseInt(string.substring(13, 17), 16);
                            nArray[n4][3] = string.length() > 17 ? Integer.parseInt(string.substring(23, 24), 16) : -1;
                        }
                        ++n4;
                    }
                    CartridgeType.MemoryMap memoryMap = new CartridgeType.MemoryMap(nArray);
                    vector.addElement(new CartridgeType(string2, string3, string4, l, n, bl, n2 != 0, memoryMap));
                }
                catch (NumberFormatException numberFormatException) {
                    string = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
            cartTypes = new CartridgeType[vector.size()];
            vector.copyInto(cartTypes);
            cartTypesByCrc = new Hashtable();
            int n = 0;
            while (n < cartTypes.length) {
                cartTypesByCrc.put(new Long(cartTypes[n].getCrc()), cartTypes[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

