/*
 * Decompiled with CFR 0.152.
 */
package com.blissjx.plugin;

import com.bliss.core.Option;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.InputSignal;

public class DirectInputDevice
implements InputDevice {
    boolean stop;
    long nativeHandle = this.nativeDirectInputDevice();
    private InputSignal[] signalsPlayerOne = new DirectInputSignal[28];
    private InputSignal[] signalsPlayerTwo;
    private InputSignal[] signalsKeyboard;
    private InputSignal[] signalsEmulator;

    private native long nativeDirectInputDevice();

    public native InputSignal getDefaultSignal(int var1);

    public native void init();

    public native void poll();

    public InputSignal getInputSignal(int n) {
        if (n <= 1027) {
            return this.signalsPlayerOne[n - 1000];
        }
        if (n <= 2027) {
            return this.signalsPlayerTwo[n - 2000];
        }
        if (n <= 5048) {
            return this.signalsKeyboard[n - 5000];
        }
        if (n <= 7004) {
            return this.signalsEmulator[n - 7000];
        }
        return null;
    }

    public void setInputSignal(int n, InputSignal inputSignal) {
        DirectInputSignal directInputSignal = (DirectInputSignal)inputSignal;
        if (n >= 1000 && n <= 1027) {
            this.signalsPlayerOne[n - 1000] = directInputSignal;
        } else if (n >= 2000 && n <= 2027) {
            this.signalsPlayerTwo[n - 2000] = directInputSignal;
        } else if (n >= 5000 && n <= 5048) {
            this.signalsKeyboard[n - 5000] = directInputSignal;
        } else if (n >= 7000 && n <= 7004) {
            this.signalsEmulator[n - 7000] = directInputSignal;
        }
    }

    public float getControlValue(int n) {
        InputSignal inputSignal = null;
        if (n <= 1027) {
            inputSignal = this.signalsPlayerOne[n - 1000];
        } else if (n <= 2027) {
            inputSignal = this.signalsPlayerTwo[n - 2000];
        } else if (n <= 5048) {
            inputSignal = this.signalsKeyboard[n - 5000];
        } else if (n <= 7004) {
            inputSignal = this.signalsEmulator[n - 7000];
        }
        if (inputSignal == null) {
            return 0.0f;
        }
        return this.getSignalValue(inputSignal);
    }

    public native float getSignalValue(InputSignal var1);

    public native void release();

    public native void initConfigMode();

    public native InputSignal pollForInputSignal();

    public native void releaseConfigMode();

    public native InputSignal getInputSignal(String var1);

    public native void finalize();

    public Option[] getOptions() {
        return Option.EMPTY_CONTROLLER_ARRAY;
    }

    private static native void releaseSignal(DirectInputSignal var0);

    DirectInputDevice() {
        int n = 0;
        while (n < this.signalsPlayerOne.length) {
            this.signalsPlayerOne[n] = this.getDefaultSignal(1000 + n);
            ++n;
        }
        this.signalsPlayerTwo = new DirectInputSignal[28];
        n = 0;
        while (n < this.signalsPlayerTwo.length) {
            this.signalsPlayerTwo[n] = this.getDefaultSignal(2000 + n);
            ++n;
        }
        this.signalsKeyboard = new DirectInputSignal[49];
        n = 0;
        while (n < this.signalsKeyboard.length) {
            this.signalsKeyboard[n] = this.getDefaultSignal(5000 + n);
            ++n;
        }
        this.signalsEmulator = new DirectInputSignal[5];
        n = 0;
        while (n < this.signalsEmulator.length) {
            this.signalsEmulator[n] = this.getDefaultSignal(7000 + n);
            ++n;
        }
    }

    public static class DirectInputSignal
    implements InputSignal {
        long nativeHandle;
        private String configString;
        private String description;

        public String getConfigString() {
            return this.configString;
        }

        public String getDescription() {
            return this.description;
        }

        public void finalize() {
            DirectInputDevice.releaseSignal(this);
        }

        public DirectInputSignal(long l, String string, String string2) {
            this.nativeHandle = l;
            this.configString = string;
            this.description = string2;
        }
    }
}

