/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Printer;
import com.sun.media.sound.Toolkit;

class CircularBuffer {
    boolean convertSign = false;
    boolean convertByteOrder = false;
    private byte[] array;
    private int bytesWritten = 0;
    private int bytesRead = 0;
    private int end = -1;

    CircularBuffer(int n, boolean bl, boolean bl2) {
        this.array = new byte[n];
        this.convertSign = bl;
        this.convertByteOrder = bl2;
    }

    synchronized int write(byte[] byArray, int n, int n2) {
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: write: b: " + byArray + " off: " + n + " len: " + n2);
        }
        if (this.end >= 0) {
            return 0;
        }
        int n3 = Math.min(n2, this.bytesAvailableToWrite());
        if (this.convertSign) {
            Toolkit.getUnsigned8(byArray, n, n3);
        } else if (this.convertByteOrder) {
            n3 -= n3 % 2;
            Toolkit.getByteSwapped(byArray, n, n3);
        }
        int n4 = n3;
        while (n4 > 0) {
            int n5 = n4;
            n5 = Math.min(n5, this.array.length - this.getWriteIndex());
            System.arraycopy(byArray, n, this.array, this.getWriteIndex(), n5);
            this.bytesWritten += n5;
            n4 -= n5;
            n += n5;
        }
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: write: returning: " + n3);
        }
        return n3;
    }

    synchronized int read(byte[] byArray, int n, int n2) {
        int n3;
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: read: b: " + byArray + " off: " + n + " len: " + n2);
        }
        if (this.end >= 0 && this.bytesRead >= this.bytesWritten) {
            return -1;
        }
        int n4 = n3 = Math.min(n2, this.bytesAvailableToRead());
        while (n4 > 0) {
            int n5 = n4;
            n5 = Math.min(n5, this.array.length - this.getReadIndex());
            System.arraycopy(this.array, this.getReadIndex(), byArray, n, n5);
            this.bytesRead += n5;
            n4 -= n5;
            n += n5;
        }
        if (Printer.verbose) {
            Printer.verbose("CircularBuffer: read: returning: " + n3);
        }
        return n3;
    }

    synchronized int writeover(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = this.getByteLength();
        if (n2 > n4) {
            n3 = n2 - n4;
            n += n3;
            n2 = n4;
            this.flush();
        } else if (n2 > this.bytesAvailableToWrite()) {
            n3 = n2 - this.bytesAvailableToWrite();
            this.skip(n3);
        }
        this.write(byArray, n, n2);
        return n3;
    }

    synchronized void flush() {
        this.bytesRead = this.bytesWritten;
    }

    void drain() {
        int n = this.bytesWritten;
        while (this.bytesRead < n) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized int skip(int n) {
        int n2 = Math.min(n, this.bytesAvailableToRead());
        this.bytesRead += n2;
        return n2;
    }

    synchronized void markEnd() {
        this.end = this.bytesWritten;
    }

    int bytesAvailableToRead() {
        return this.bytesWritten - this.bytesRead;
    }

    int bytesAvailableToWrite() {
        return this.end >= 0 ? 0 : this.array.length - this.bytesAvailableToRead();
    }

    int getByteLength() {
        return this.array.length;
    }

    private int getReadIndex() {
        return this.bytesRead % this.array.length;
    }

    private int getWriteIndex() {
        return this.bytesWritten % this.array.length;
    }
}

