/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Printer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

class HeadspaceSoundbank
implements Soundbank {
    String name;
    String version;
    String vendor;
    String description;
    Vector instruments = new Vector();
    Vector samples = new Vector();
    Vector sequences = new Vector();
    private int id = 0;

    HeadspaceSoundbank(URL uRL) throws IOException {
        String string;
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: url: " + uRL);
        }
        if (!(string = uRL.getProtocol()).equals("file")) {
            this.initialize(uRL.openStream());
        } else {
            String string2 = uRL.getFile();
            this.initialize(string2);
        }
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: url: " + uRL + " completed");
        }
    }

    HeadspaceSoundbank(String string) {
        this.initialize(string);
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: path: " + string + " completed");
        }
    }

    HeadspaceSoundbank(InputStream inputStream) throws IOException {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: stream: " + inputStream);
        }
        this.initialize(inputStream);
    }

    HeadspaceSoundbank(File file) throws IOException {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: constructor: file: " + file);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.initialize(fileInputStream);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDescription() {
        return this.description;
    }

    public SoundbankResource[] getResources() {
        SoundbankResource[] soundbankResourceArray;
        Vector vector = this.samples;
        synchronized (vector) {
            soundbankResourceArray = new SoundbankResource[this.samples.size()];
            int n = 0;
            while (n < soundbankResourceArray.length) {
                soundbankResourceArray[n] = (SoundbankResource)this.samples.elementAt(n);
                ++n;
            }
        }
        return soundbankResourceArray;
    }

    public Instrument[] getInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            int n = 0;
            while (n < instrumentArray.length) {
                instrumentArray[n] = (Instrument)this.instruments.elementAt(n);
                ++n;
            }
        }
        return instrumentArray;
    }

    public Instrument getInstrument(Patch patch) {
        Vector vector = this.instruments;
        synchronized (vector) {
            int n = 0;
            while (n < this.instruments.size()) {
                Instrument instrument = (Instrument)this.instruments.elementAt(n);
                if (instrument.getPatch().getBank() == patch.getBank() && instrument.getPatch().getProgram() == patch.getProgram()) {
                    Instrument instrument2 = instrument;
                    return instrument2;
                }
                ++n;
            }
        }
        return null;
    }

    private void setupInformation() {
        this.name = this.nGetName(this.id);
        if (this.name == null) {
            this.name = "Untitled Headspace Soundbank";
        }
        int n = this.nGetVersionMajor(this.id);
        int n2 = this.nGetVersionMinor(this.id);
        int n3 = this.nGetVersionSubMinor(this.id);
        this.version = new String(n + "." + n2 + "." + n3);
        this.vendor = "Sun Microsystems, Headspace Corporation";
        this.description = "Soundbank for use with Headspace Mixer.";
        this.nGetInstruments(this.id, this.instruments);
        this.nGetSamples(this.id, this.samples);
    }

    private void initialize(InputStream inputStream) throws IOException {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: stream: " + inputStream);
        }
        HeadspaceMixer headspaceMixer = HeadspaceMixer.getMixerInstance();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        byte[] byArray2 = null;
        int n = 0;
        while (true) {
            if ((n = inputStream.read(byArray, 0, byArray.length)) <= 0) break;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byArray2 = byteArrayOutputStream.toByteArray();
        if (Printer.debug) {
            Printer.debug("> calling nOpenResourceFromByteArray with length: " + byArray2.length);
        }
        this.id = this.nOpenResourceFromByteArray(byArray2, byArray2.length);
        if (Printer.debug) {
            Printer.debug("> returned from nOpenResourceFromByteArray; id = " + this.id);
        }
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to get id");
        }
        this.setupInformation();
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: stream: " + inputStream + " completed");
        }
    }

    private void initialize(String string) {
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: path: " + string);
        }
        HeadspaceMixer headspaceMixer = HeadspaceMixer.getMixerInstance();
        if (Printer.debug) {
            Printer.debug("> calling nOpenResource with path: " + string);
        }
        this.id = this.nOpenResource(string);
        if (Printer.debug) {
            Printer.debug("> returned from nOpenResource; id = " + this.id);
        }
        if (this.id == 0) {
            throw new IllegalArgumentException("Failed to get id");
        }
        this.setupInformation();
        if (Printer.trace) {
            Printer.trace("HeadspaceSoundbank: initialize: path: " + string + " completed");
        }
    }

    private native int nOpenResource(String var1);

    private native int nOpenResourceFromByteArray(byte[] var1, int var2);

    private native boolean nCloseResource(int var1);

    private native String nGetName(int var1);

    private native int nGetVersionMajor(int var1);

    private native int nGetVersionMinor(int var1);

    private native int nGetVersionSubMinor(int var1);

    private native void nGetInstruments(int var1, Vector var2);

    private native void nGetSamples(int var1, Vector var2);
}

