/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferUShort
extends DataBuffer {
    short[] data;
    short[][] bankdata;

    public DataBufferUShort(int n) {
        super(1, n);
        this.data = new short[n];
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(int n, int n2) {
        super(1, n, n2);
        this.bankdata = new short[n2][];
        int n3 = 0;
        while (n3 < n2) {
            this.bankdata[n3] = new short[n];
            ++n3;
        }
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[] sArray, int n) {
        super(1, n);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        this.data = sArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[] sArray, int n, int n2) {
        super(1, n, 1, n2);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        if (n + n2 > sArray.length) {
            throw new IllegalArgumentException("Length of dataArray is less  than size+offset.");
        }
        this.data = sArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[][] sArray, int n) {
        super(1, n, sArray.length);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        int n2 = 0;
        while (n2 < sArray.length) {
            if (sArray[n2] == null) {
                throw new NullPointerException("dataArray[" + n2 + "] is null");
            }
            ++n2;
        }
        this.bankdata = sArray;
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[][] sArray, int n, int[] nArray) {
        super(1, n, sArray.length, nArray);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        int n2 = 0;
        while (n2 < sArray.length) {
            if (sArray[n2] == null) {
                throw new NullPointerException("dataArray[" + n2 + "] is null");
            }
            if (n + nArray[n2] > sArray[n2].length) {
                throw new IllegalArgumentException("Length of dataArray[" + n2 + "] is less than size+" + "offsets[" + n2 + "].");
            }
            ++n2;
        }
        this.bankdata = sArray;
        this.data = this.bankdata[0];
    }

    public short[] getData() {
        return this.data;
    }

    public short[] getData(int n) {
        return this.bankdata[n];
    }

    public short[][] getBankData() {
        return this.bankdata;
    }

    public int getElem(int n) {
        return this.data[n + this.offset] & 0xFFFF;
    }

    public int getElem(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]] & 0xFFFF;
    }

    public void setElem(int n, int n2) {
        this.data[n + this.offset] = (short)(n2 & 0xFFFF);
    }

    public void setElem(int n, int n2, int n3) {
        this.bankdata[n][n2 + this.offsets[n]] = (short)(n3 & 0xFFFF);
    }
}

