/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MemoryImageSource
implements ImageProducer {
    int width;
    int height;
    ColorModel model;
    Object pixels;
    int pixeloffset;
    int pixelscan;
    Hashtable properties;
    Vector theConsumers = new Vector();
    boolean animating;
    boolean fullbuffers;

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4) {
        this.initialize(n, n2, colorModel, byArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4, Hashtable hashtable) {
        this.initialize(n, n2, colorModel, byArray, n3, n4, hashtable);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4) {
        this.initialize(n, n2, colorModel, nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.initialize(n, n2, colorModel, nArray, n3, n4, hashtable);
    }

    private void initialize(int n, int n2, ColorModel colorModel, Object object, int n3, int n4, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.model = colorModel;
        this.pixels = object;
        this.pixeloffset = n3;
        this.pixelscan = n4;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.properties = hashtable;
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4) {
        this.initialize(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, null);
    }

    public MemoryImageSource(int n, int n2, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.initialize(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, hashtable);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block5: {
            if (this.theConsumers.contains(imageConsumer)) {
                return;
            }
            this.theConsumers.addElement(imageConsumer);
            try {
                this.initConsumer(imageConsumer);
                this.sendPixels(imageConsumer, 0, 0, this.width, this.height);
                if (this.isConsumer(imageConsumer)) {
                    imageConsumer.imageComplete(this.animating ? 2 : 3);
                    if (!this.animating && this.isConsumer(imageConsumer)) {
                        imageConsumer.imageComplete(1);
                        this.removeConsumer(imageConsumer);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageConsumer)) break block5;
                imageConsumer.imageComplete(1);
            }
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.theConsumers.removeElement(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public synchronized void setAnimated(boolean bl) {
        this.animating = bl;
        if (!this.animating) {
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.imageComplete(3);
                if (!this.isConsumer(imageConsumer)) continue;
                imageConsumer.imageComplete(1);
            }
            this.theConsumers.removeAllElements();
        }
    }

    public synchronized void setFullBufferUpdates(boolean bl) {
        if (this.fullbuffers == bl) {
            return;
        }
        this.fullbuffers = bl;
        if (this.animating) {
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setHints(bl ? 6 : 1);
            }
        }
    }

    public void newPixels() {
        this.newPixels(0, 0, this.width, this.height, true);
    }

    public synchronized void newPixels(int n, int n2, int n3, int n4) {
        this.newPixels(n, n2, n3, n4, true);
    }

    public synchronized void newPixels(int n, int n2, int n3, int n4, boolean bl) {
        if (this.animating) {
            if (this.fullbuffers) {
                n2 = 0;
                n = 0;
                n3 = this.width;
                n4 = this.height;
            } else {
                if (n < 0) {
                    n3 += n;
                    n = 0;
                }
                if (n + n3 > this.width) {
                    n3 = this.width - n;
                }
                if (n2 < 0) {
                    n4 += n2;
                    n2 = 0;
                }
                if (n2 + n4 > this.height) {
                    n4 = this.height - n2;
                }
            }
            if (!(n3 > 0 && n4 > 0 || bl)) {
                return;
            }
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                if (n3 > 0 && n4 > 0) {
                    this.sendPixels(imageConsumer, n, n2, n3, n4);
                }
                if (!bl || !this.isConsumer(imageConsumer)) continue;
                imageConsumer.imageComplete(2);
            }
        }
    }

    public synchronized void newPixels(byte[] byArray, ColorModel colorModel, int n, int n2) {
        this.pixels = byArray;
        this.model = colorModel;
        this.pixeloffset = n;
        this.pixelscan = n2;
        this.newPixels();
    }

    public synchronized void newPixels(int[] nArray, ColorModel colorModel, int n, int n2) {
        this.pixels = nArray;
        this.model = colorModel;
        this.pixeloffset = n;
        this.pixelscan = n2;
        this.newPixels();
    }

    private void initConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setDimensions(this.width, this.height);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setProperties(this.properties);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setColorModel(this.model);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setHints(this.animating ? (this.fullbuffers ? 6 : 1) : 30);
        }
    }

    private void sendPixels(ImageConsumer imageConsumer, int n, int n2, int n3, int n4) {
        int n5 = this.pixeloffset + this.pixelscan * n2 + n;
        if (this.isConsumer(imageConsumer)) {
            if (this.pixels instanceof byte[]) {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, (byte[])this.pixels, n5, this.pixelscan);
            } else {
                imageConsumer.setPixels(n, n2, n3, n4, this.model, (int[])this.pixels, n5, this.pixelscan);
            }
        }
    }
}

