/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new char[n];
    }

    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = this.count + 1;
            if (n2 > this.buf.length) {
                char[] cArray = new char[Math.max(this.buf.length << 1, n2)];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            this.buf[this.count] = (char)n;
            this.count = n2;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                char[] cArray2 = new char[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, cArray2, 0, this.count);
                this.buf = cArray2;
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count = n3;
        }
    }

    public void write(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + n2;
            if (n3 > this.buf.length) {
                char[] cArray = new char[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            string.getChars(n, n + n2, this.buf, this.count);
            this.count = n3;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            writer.write(this.buf, 0, this.count);
        }
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            char[] cArray2 = cArray;
            return cArray2;
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            String string = new String(this.buf, 0, this.count);
            return string;
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

