/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static Random r = new Random();
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final Comparator REVERSE_ORDER = new ReverseComparator();

    private Collections() {
    }

    public static void sort(List list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        ListIterator listIterator = list.listIterator();
        int n = 0;
        while (n < objectArray.length) {
            listIterator.next();
            listIterator.set(objectArray[n]);
            ++n;
        }
    }

    public static void sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator listIterator = list.listIterator();
        int n = 0;
        while (n < objectArray.length) {
            listIterator.next();
            listIterator.set(objectArray[n]);
            ++n;
        }
    }

    public static int binarySearch(List list, Object object) {
        if (list instanceof AbstractSequentialList) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                int n = ((Comparable)listIterator.next()).compareTo(object);
                if (n == 0) {
                    return listIterator.previousIndex();
                }
                if (n <= 0) continue;
                return -listIterator.nextIndex();
            }
            return -listIterator.nextIndex() - 1;
        }
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Object object2 = list.get(n3);
            int n4 = ((Comparable)object2).compareTo(object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, object);
        }
        if (list instanceof AbstractSequentialList) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                int n = comparator.compare(listIterator.next(), object);
                if (n == 0) {
                    return listIterator.previousIndex();
                }
                if (n <= 0) continue;
                return -listIterator.nextIndex();
            }
            return -listIterator.nextIndex() - 1;
        }
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Object object2 = list.get(n3);
            int n4 = comparator.compare(object2, object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static void reverse(List list) {
        ListIterator listIterator = list.listIterator();
        ListIterator listIterator2 = list.listIterator(list.size());
        int n = 0;
        int n2 = list.size() / 2;
        while (n < n2) {
            Object object = listIterator.next();
            listIterator.set(listIterator2.previous());
            listIterator2.set(object);
            ++n;
        }
    }

    public static void shuffle(List list) {
        Collections.shuffle(list, r);
    }

    public static void shuffle(List list, Random random) {
        int n = list.size();
        while (n > 1) {
            Collections.swap(list, n - 1, random.nextInt(n));
            --n;
        }
    }

    private static void swap(List list, int n, int n2) {
        Object object = list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, object);
    }

    public static void fill(List list, Object object) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.set(object);
        }
    }

    public static void copy(List list, List list2) {
        try {
            ListIterator listIterator = list.listIterator();
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                listIterator.next();
                listIterator.set(listIterator2.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Source does not fit in dest.");
        }
    }

    public static Object min(Collection collection) {
        Iterator iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparable2.compareTo(comparable) >= 0) continue;
            comparable = comparable2;
        }
        return comparable;
    }

    public static Object min(Collection collection, Comparator comparator) {
        if (comparator == null) {
            return Collections.min(collection);
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object max(Collection collection) {
        Iterator iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparable2.compareTo(comparable) <= 0) continue;
            comparable = comparable2;
        }
        return comparable;
    }

    public static Object max(Collection collection, Comparator comparator) {
        if (comparator == null) {
            return Collections.max(collection);
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UnmodifiableCollection(collection);
    }

    public static Set unmodifiableSet(Set set) {
        return new UnmodifiableSet(set);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UnmodifiableSortedSet(sortedSet);
    }

    public static List unmodifiableList(List list) {
        return new UnmodifiableList(list);
    }

    public static Map unmodifiableMap(Map map) {
        return new UnmodifiableMap(map);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UnmodifiableSortedMap(sortedMap);
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SynchronizedCollection(collection);
    }

    static Collection synchronizedCollection(Collection collection, Object object) {
        return new SynchronizedCollection(collection, object);
    }

    public static Set synchronizedSet(Set set) {
        return new SynchronizedSet(set);
    }

    static Set synchronizedSet(Set set, Object object) {
        return new SynchronizedSet(set, object);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SynchronizedSortedSet(sortedSet);
    }

    public static List synchronizedList(List list) {
        return new SynchronizedList(list);
    }

    static List synchronizedList(List list, Object object) {
        return new SynchronizedList(list, object);
    }

    public static Map synchronizedMap(Map map) {
        return new SynchronizedMap(map);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SynchronizedSortedMap(sortedMap);
    }

    public static Set singleton(Object object) {
        return new SingletonSet(object);
    }

    public static List singletonList(Object object) {
        return new SingletonList(object);
    }

    public static Map singletonMap(Object object, Object object2) {
        return new SingletonMap(object, object2);
    }

    public static List nCopies(int n, Object object) {
        return new CopiesList(n, object);
    }

    public static Comparator reverseOrder() {
        return REVERSE_ORDER;
    }

    public static Enumeration enumeration(final Collection collection) {
        return new Enumeration(){
            Iterator i;
            {
                this.i = collection.iterator();
            }

            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            public Object nextElement() {
                return this.i.next();
            }
        };
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        private ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = (Comparable)object2;
            return -comparable.compareTo(comparable2);
        }
    }

    private static class CopiesList
    extends AbstractList
    implements Serializable {
        int n;
        Object element;

        CopiesList(int n, Object object) {
            if (n < 0) {
                throw new IllegalArgumentException("List length = " + n);
            }
            this.n = n;
            this.element = object;
        }

        public int size() {
            return this.n;
        }

        public boolean contains(Object object) {
            return this.n != 0 && Collections.eq(object, this.element);
        }

        public Object get(int n) {
            if (n < 0 || n >= this.n) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.n);
            }
            return this.element;
        }
    }

    private static class SingletonMap
    extends AbstractMap
    implements Serializable {
        private final Object k;
        private final Object v;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        SingletonMap(Object object, Object object2) {
            this.k = object;
            this.v = object2;
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean containsKey(Object object) {
            return Collections.eq(object, this.k);
        }

        public boolean containsValue(Object object) {
            return Collections.eq(object, this.v);
        }

        public Object get(Object object) {
            return Collections.eq(object, this.k) ? this.v : null;
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new ImmutableEntry(this.k, this.v));
            }
            return this.entrySet;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        private static class ImmutableEntry
        implements Map.Entry {
            final Object k;
            final Object v;

            ImmutableEntry(Object object, Object object2) {
                this.k = object;
                this.v = object2;
            }

            public Object getKey() {
                return this.k;
            }

            public Object getValue() {
                return this.v;
            }

            public Object setValue(Object object) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Collections.eq(entry.getKey(), this.k) && Collections.eq(entry.getValue(), this.v);
            }

            public int hashCode() {
                return (this.k == null ? 0 : this.k.hashCode()) ^ (this.v == null ? 0 : this.v.hashCode());
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    private static class SingletonList
    extends AbstractList
    implements Serializable {
        private final Object element;

        SingletonList(Object object) {
            this.element = object;
        }

        public int size() {
            return 1;
        }

        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        public Object get(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: 1");
            }
            return this.element;
        }
    }

    private static class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private Object element;

        SingletonSet(Object object) {
            this.element = object;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private boolean hasNext;
                private final /* synthetic */ SingletonSet this$0;
                {
                    this.this$0 = singletonSet;
                    this.hasNext = true;
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.access$500(this.this$0);
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return 1;
        }

        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        static /* synthetic */ Object access$500(SingletonSet singletonSet) {
            return singletonSet.element;
        }
    }

    private static class EmptyMap
    extends AbstractMap
    implements Serializable {
        private EmptyMap() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean containsValue(Object object) {
            return false;
        }

        public Object get(Object object) {
            return null;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Collection values() {
            return EMPTY_SET;
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).size() == 0;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class EmptyList
    extends AbstractList
    implements Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object object) {
            return false;
        }

        public Object get(int n) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    private static class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ EmptySet this$0;
                {
                    this.this$0 = emptySet;
                }

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object object) {
            return false;
        }
    }

    static class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private SortedMap sm;

        SynchronizedSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap sortedMap, Object object) {
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                Comparator comparator = this.sm.comparator();
                return comparator;
            }
        }

        public SortedMap subMap(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.sm.subMap(object, object2), this.mutex);
                return synchronizedSortedMap;
            }
        }

        public SortedMap headMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.sm.headMap(object), this.mutex);
                return synchronizedSortedMap;
            }
        }

        public SortedMap tailMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.sm.tailMap(object), this.mutex);
                return synchronizedSortedMap;
            }
        }

        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.sm.firstKey();
                return object2;
            }
        }

        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.sm.lastKey();
                return object2;
            }
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private Map m;
        Object mutex;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        SynchronizedMap(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
            this.mutex = this;
        }

        SynchronizedMap(Map map, Object object) {
            this.m = map;
            this.mutex = object;
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.m.size();
                return n;
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.m.isEmpty();
                return bl;
            }
        }

        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.m.containsKey(object);
                return bl;
            }
        }

        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.m.containsValue(object);
                return bl;
            }
        }

        public Object get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                Object object3 = this.m.get(object);
                return object3;
            }
        }

        public Object put(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                Object object4 = this.m.put(object, object2);
                return object4;
            }
        }

        public Object remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                Object object3 = this.m.remove(object);
                return object3;
            }
        }

        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        public Set keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet(this.m.keySet(), this.mutex);
                }
                Set set = this.keySet;
                return set;
            }
        }

        public Set entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet(this.m.entrySet(), this.mutex);
                }
                Set set = this.entrySet;
                return set;
            }
        }

        public Collection values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection(this.m.values(), this.mutex);
                }
                Collection collection = this.values;
                return collection;
            }
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.m.equals(object);
                return bl;
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.m.hashCode();
                return n;
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                String string = this.m.toString();
                return string;
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private List list;

        SynchronizedList(List list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List list, Object object) {
            super(list, object);
            this.list = list;
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.list.equals(object);
                return bl;
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.list.hashCode();
                return n;
            }
        }

        public Object get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.list.get(n);
                return object2;
            }
        }

        public Object set(int n, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                Object object3 = this.list.set(n, object);
                return object3;
            }
        }

        public void add(int n, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.list.add(n, object);
            }
        }

        public Object remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.list.remove(n);
                return object2;
            }
        }

        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                int n = this.list.indexOf(object);
                return n;
            }
        }

        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                int n = this.list.lastIndexOf(object);
                return n;
            }
        }

        public boolean addAll(int n, Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.list.addAll(n, collection);
                return bl;
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int n) {
            return this.list.listIterator(n);
        }

        public List subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                SynchronizedList synchronizedList = new SynchronizedList(this.list.subList(n, n2), this.mutex);
                return synchronizedList;
            }
        }
    }

    static class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private SortedSet ss;

        SynchronizedSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet sortedSet, Object object) {
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                Comparator comparator = this.ss.comparator();
                return comparator;
            }
        }

        public SortedSet subSet(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.ss.subSet(object, object2), this.mutex);
                return synchronizedSortedSet;
            }
        }

        public SortedSet headSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.ss.headSet(object), this.mutex);
                return synchronizedSortedSet;
            }
        }

        public SortedSet tailSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.ss.tailSet(object), this.mutex);
                return synchronizedSortedSet;
            }
        }

        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.ss.first();
                return object2;
            }
        }

        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                Object object2 = this.ss.last();
                return object2;
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        SynchronizedSet(Set set) {
            super(set);
        }

        SynchronizedSet(Set set, Object object) {
            super(set, object);
        }

        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.equals(object);
                return bl;
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.c.hashCode();
                return n;
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        Collection c;
        Object mutex;

        SynchronizedCollection(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection collection, Object object) {
            this.c = collection;
            this.mutex = object;
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                int n = this.c.size();
                return n;
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.isEmpty();
                return bl;
            }
        }

        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.contains(object);
                return bl;
            }
        }

        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                Object[] objectArray = this.c.toArray();
                return objectArray;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            Object object = this.mutex;
            synchronized (object) {
                Object[] objectArray2 = this.c.toArray(objectArray);
                return objectArray2;
            }
        }

        public Iterator iterator() {
            return this.c.iterator();
        }

        public boolean add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.add(object);
                return bl;
            }
        }

        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                boolean bl = this.c.remove(object);
                return bl;
            }
        }

        public boolean containsAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.containsAll(collection);
                return bl;
            }
        }

        public boolean addAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.addAll(collection);
                return bl;
            }
        }

        public boolean removeAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.removeAll(collection);
                return bl;
            }
        }

        public boolean retainAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = this.c.retainAll(collection);
                return bl;
            }
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                String string = this.c.toString();
                return string;
            }
        }
    }

    static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap,
    Serializable {
        private SortedMap sm;

        UnmodifiableSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new UnmodifiableSortedMap(this.sm.subMap(object, object2));
        }

        public SortedMap headMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.headMap(object));
        }

        public SortedMap tailMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.tailMap(object));
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        UnmodifiableMap(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
        }

        public int size() {
            return this.m.size();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public Object get(Object object) {
            return this.m.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entrySet;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        static class UnmodifiableEntrySet
        extends UnmodifiableSet {
            UnmodifiableEntrySet(Set set) {
                super(set);
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator i;
                    private final /* synthetic */ UnmodifiableEntrySet this$0;
                    {
                        this.this$0 = unmodifiableEntrySet;
                        this.i = this.this$0.c.iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return new UnmodifiableEntry((Map.Entry)this.i.next());
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public Object[] toArray() {
                Object[] objectArray = this.c.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = new UnmodifiableEntry((Map.Entry)objectArray[n]);
                    ++n;
                }
                return objectArray;
            }

            public Object[] toArray(Object[] objectArray) {
                Object[] objectArray2 = this.c.toArray(objectArray.length == 0 ? objectArray : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), 0));
                int n = 0;
                while (n < objectArray2.length) {
                    objectArray2[n] = new UnmodifiableEntry((Map.Entry)objectArray2[n]);
                    ++n;
                }
                if (objectArray2.length > objectArray.length) {
                    return objectArray2;
                }
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                if (objectArray.length > objectArray2.length) {
                    objectArray[objectArray2.length] = null;
                }
                return objectArray;
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)object));
            }

            public boolean containsAll(Collection collection) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.contains(iterator.next())) continue;
                    return false;
                }
                return true;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                if (set.size() != this.c.size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            private static class UnmodifiableEntry
            implements Map.Entry {
                private Map.Entry e;

                UnmodifiableEntry(Map.Entry entry) {
                    this.e = entry;
                }

                public Object getKey() {
                    return this.e.getKey();
                }

                public Object getValue() {
                    return this.e.getValue();
                }

                public Object setValue(Object object) {
                    throw new UnsupportedOperationException();
                }

                public int hashCode() {
                    return this.e.hashCode();
                }

                public boolean equals(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return Collections.eq(this.e.getKey(), entry.getKey()) && Collections.eq(this.e.getValue(), entry.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }
            }
        }
    }

    static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        static final long serialVersionUID = -283967356065247728L;
        private List list;

        UnmodifiableList(List list) {
            super(list);
            this.list = list;
        }

        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int n) {
            return new ListIterator(this, n){
                ListIterator i;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ UnmodifiableList this$0;
                {
                    this.this$0 = unmodifiableList;
                    this.val$index = n;
                    this.i = UnmodifiableList.access$000(this.this$0).listIterator(this.val$index);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object object) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int n, int n2) {
            return new UnmodifiableList(this.list.subList(n, n2));
        }

        static /* synthetic */ List access$000(UnmodifiableList unmodifiableList) {
            return unmodifiableList.list;
        }
    }

    static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet,
    Serializable {
        private SortedSet ss;

        UnmodifiableSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public SortedSet subSet(Object object, Object object2) {
            return new UnmodifiableSortedSet(this.ss.subSet(object, object2));
        }

        public SortedSet headSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.headSet(object));
        }

        public SortedSet tailSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.tailSet(object));
        }

        public Object first() {
            return this.ss.first();
        }

        public Object last() {
            return this.ss.last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set,
    Serializable {
        UnmodifiableSet(Set set) {
            super(set);
        }

        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        Collection c;

        UnmodifiableCollection(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
        }

        public int size() {
            return this.c.size();
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        public String toString() {
            return this.c.toString();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator i;
                {
                    this.i = c.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

