/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarOutputStream
extends ZipOutputStream {
    private static final int JAR_MAGIC = 51966;
    private boolean firstEntry = true;

    public JarOutputStream(OutputStream outputStream, Manifest manifest) throws IOException {
        super(outputStream);
        if (manifest == null) {
            throw new NullPointerException("man");
        }
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(zipEntry);
        manifest.write(new BufferedOutputStream(this));
        this.closeEntry();
    }

    public JarOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.firstEntry) {
            byte[] byArray = zipEntry.getExtra();
            if (byArray != null && !JarOutputStream.hasMagic(byArray)) {
                byte[] byArray2 = new byte[byArray.length + 4];
                System.arraycopy(byArray2, 4, byArray, 0, byArray.length);
                byArray = byArray2;
            } else {
                byArray = new byte[4];
            }
            JarOutputStream.set16(byArray, 0, 51966);
            JarOutputStream.set16(byArray, 2, 0);
            zipEntry.setExtra(byArray);
            this.firstEntry = false;
        }
        super.putNextEntry(zipEntry);
    }

    private static boolean hasMagic(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                if (JarOutputStream.get16(byArray, n) == 51966) {
                    return true;
                }
                n += JarOutputStream.get16(byArray, n + 2) + 4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static void set16(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
    }
}

