/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Vector;
import javax.accessibility.AccessibleRelation;

public class AccessibleRelationSet {
    protected Vector relations = null;

    public AccessibleRelationSet() {
        this.relations = null;
    }

    public AccessibleRelationSet(AccessibleRelation[] accessibleRelationArray) {
        if (accessibleRelationArray.length != 0) {
            this.relations = new Vector(accessibleRelationArray.length);
            int n = 0;
            while (n < accessibleRelationArray.length) {
                if (!this.relations.contains(accessibleRelationArray[n])) {
                    this.relations.addElement(accessibleRelationArray[n]);
                }
                ++n;
            }
        }
    }

    public boolean add(AccessibleRelation accessibleRelation) {
        if (this.relations == null) {
            this.relations = new Vector();
        }
        if (!this.relations.contains(accessibleRelation)) {
            this.relations.addElement(accessibleRelation);
            return true;
        }
        return false;
    }

    public void addAll(AccessibleRelation[] accessibleRelationArray) {
        if (accessibleRelationArray.length != 0) {
            if (this.relations == null) {
                this.relations = new Vector(accessibleRelationArray.length);
            }
            int n = 0;
            while (n < accessibleRelationArray.length) {
                if (!this.relations.contains(accessibleRelationArray[n])) {
                    this.relations.addElement(accessibleRelationArray[n]);
                }
                ++n;
            }
        }
    }

    public boolean remove(AccessibleRelation accessibleRelation) {
        if (this.relations == null) {
            return false;
        }
        return this.relations.removeElement(accessibleRelation);
    }

    public void clear() {
        if (this.relations != null) {
            this.relations.removeAllElements();
        }
    }

    public int size() {
        if (this.relations == null) {
            return 0;
        }
        return this.relations.size();
    }

    public boolean contains(String string) {
        return this.get(string) != null;
    }

    public AccessibleRelation get(String string) {
        if (this.relations == null) {
            return null;
        }
        int n = this.relations.size();
        int n2 = 0;
        while (n2 < n) {
            AccessibleRelation accessibleRelation = (AccessibleRelation)this.relations.elementAt(n2);
            if (accessibleRelation != null && accessibleRelation.getKey().equals(string)) {
                return accessibleRelation;
            }
            ++n2;
        }
        return null;
    }

    public AccessibleRelation[] toArray() {
        if (this.relations == null) {
            return new AccessibleRelation[0];
        }
        AccessibleRelation[] accessibleRelationArray = new AccessibleRelation[this.relations.size()];
        int n = 0;
        while (n < accessibleRelationArray.length) {
            accessibleRelationArray[n] = (AccessibleRelation)this.relations.elementAt(n);
            ++n;
        }
        return accessibleRelationArray;
    }

    public String toString() {
        String string = "";
        if (this.relations != null && this.relations.size() > 0) {
            string = ((AccessibleRelation)this.relations.elementAt(0)).toDisplayString();
            int n = 1;
            while (n < this.relations.size()) {
                string = string + "," + ((AccessibleRelation)this.relations.elementAt(n)).toDisplayString();
                ++n;
            }
        }
        return string;
    }
}

