/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static byte[] defaultMessage = new byte[]{-1, 0};
    private int dataLength = 0;

    public MetaMessage() {
        this(defaultMessage);
    }

    protected MetaMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n >= 128) {
            throw new InvalidMidiDataException("Invalid meta event with type " + n);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(255);
            dataOutputStream.writeByte(n);
            this.writeVarInt(n2, dataOutputStream);
            dataOutputStream.write(byArray, 0, n2);
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
            this.dataLength = n2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getType() {
        int n = 0;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.skip(1L);
            n = dataInputStream.readUnsignedByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.dataLength];
        System.arraycopy(this.data, this.length - this.dataLength, byArray, 0, this.dataLength);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        MetaMessage metaMessage = new MetaMessage(byArray);
        return metaMessage;
    }

    private void writeVarInt(int n, DataOutputStream dataOutputStream) throws InvalidMidiDataException, IOException {
        int n2 = 6;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = 0;
            ++n4;
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            byArray[n5] = (byte)(n & 0x7F);
            n >>>= 7;
            if (++n3 > 1) {
                int n6 = n5;
                byArray[n6] = (byte)(byArray[n6] | 0x80);
            }
            if (n == 0) break;
            --n5;
        }
        if ((byArray[n2 - 1] & 0x80) != 0) {
            throw new InvalidMidiDataException("Unable to create variable-length integer");
        }
        dataOutputStream.write(byArray, n2 - n3, n3);
    }
}

