/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JWindow
extends Window
implements Accessible,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JWindow() {
        this((Frame)null);
    }

    public JWindow(GraphicsConfiguration graphicsConfiguration) {
        this(null, graphicsConfiguration);
    }

    public JWindow(Frame frame) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame);
        this.windowInit();
    }

    public JWindow(Window window) {
        super(window);
        this.windowInit();
    }

    public JWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.windowInit();
    }

    protected void windowInit() {
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setRootPaneCheckingEnabled(bl);
                throw throwable;
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    protected String paramString() {
        String string = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",rootPaneCheckingEnabled=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJWindow
    extends Window.AccessibleAWTWindow {
        protected AccessibleJWindow() {
        }
    }
}

