/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFAttribute;
import javax.swing.text.rtf.RTFGenerator;

class RTFAttributes {
    static RTFAttribute[] attributes;

    RTFAttributes() {
    }

    static Dictionary attributesByKeyword() {
        Hashtable hashtable = new Hashtable(attributes.length);
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            ((Dictionary)hashtable).put(attributes[n2].rtfName(), attributes[n2]);
            ++n2;
        }
        return hashtable;
    }

    static {
        Vector vector = new Vector();
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        Boolean bl = new Boolean(true);
        Boolean bl2 = new Boolean(false);
        vector.addElement(new BooleanAttribute(n, StyleConstants.Italic, "i"));
        vector.addElement(new BooleanAttribute(n, StyleConstants.Bold, "b"));
        vector.addElement(new BooleanAttribute(n, StyleConstants.Underline, "ul"));
        vector.addElement(NumericAttribute.NewTwips(n2, StyleConstants.LeftIndent, "li", 0.0f, 0));
        vector.addElement(NumericAttribute.NewTwips(n2, StyleConstants.RightIndent, "ri", 0.0f, 0));
        vector.addElement(NumericAttribute.NewTwips(n2, StyleConstants.FirstLineIndent, "fi", 0.0f, 0));
        vector.addElement(new AssertiveAttribute(n2, StyleConstants.Alignment, "ql", 0));
        vector.addElement(new AssertiveAttribute(n2, StyleConstants.Alignment, "qr", 2));
        vector.addElement(new AssertiveAttribute(n2, StyleConstants.Alignment, "qc", 1));
        vector.addElement(new AssertiveAttribute(n2, StyleConstants.Alignment, "qj", 3));
        vector.addElement(NumericAttribute.NewTwips(n2, StyleConstants.SpaceAbove, "sa", 0));
        vector.addElement(NumericAttribute.NewTwips(n2, StyleConstants.SpaceBelow, "sb", 0));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_alignment", "tqr", 1));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_alignment", "tqc", 2));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_alignment", "tqdec", 4));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_leader", "tldot", 1));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_leader", "tlhyph", 2));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_leader", "tlul", 3));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_leader", "tlth", 4));
        vector.addElement(new AssertiveAttribute(n5, (Object)"tab_leader", "tleq", 5));
        vector.addElement(new BooleanAttribute(n, "caps", "caps"));
        vector.addElement(new BooleanAttribute(n, "outl", "outl"));
        vector.addElement(new BooleanAttribute(n, "scaps", "scaps"));
        vector.addElement(new BooleanAttribute(n, "shad", "shad"));
        vector.addElement(new BooleanAttribute(n, "v", "v"));
        vector.addElement(new BooleanAttribute(n, "strike", "strike"));
        vector.addElement(new BooleanAttribute(n, "deleted", "deleted"));
        vector.addElement(new AssertiveAttribute(n4, (Object)"saveformat", "defformat", "RTF"));
        vector.addElement(new AssertiveAttribute(n4, "landscape", "landscape"));
        vector.addElement(NumericAttribute.NewTwips(n4, "paperw", "paperw", 12240));
        vector.addElement(NumericAttribute.NewTwips(n4, "paperh", "paperh", 15840));
        vector.addElement(NumericAttribute.NewTwips(n4, "margl", "margl", 1800));
        vector.addElement(NumericAttribute.NewTwips(n4, "margr", "margr", 1800));
        vector.addElement(NumericAttribute.NewTwips(n4, "margt", "margt", 1440));
        vector.addElement(NumericAttribute.NewTwips(n4, "margb", "margb", 1440));
        vector.addElement(NumericAttribute.NewTwips(n4, "gutter", "gutter", 0));
        vector.addElement(new AssertiveAttribute(n2, (Object)"widowctrl", "nowidctlpar", bl2));
        vector.addElement(new AssertiveAttribute(n2, (Object)"widowctrl", "widctlpar", bl));
        vector.addElement(new AssertiveAttribute(n4, (Object)"widowctrl", "widowctrl", bl));
        Object[] objectArray = new RTFAttribute[vector.size()];
        vector.copyInto(objectArray);
        attributes = objectArray;
    }

    static class NumericAttribute
    extends GenericAttribute
    implements RTFAttribute {
        int rtfDefault;
        Number swingDefault;
        float scale;

        protected NumericAttribute(int n, Object object, String string) {
            super(n, object, string);
            this.rtfDefault = 0;
            this.swingDefault = null;
            this.scale = 1.0f;
        }

        public NumericAttribute(int n, Object object, String string, int n2, int n3) {
            this(n, object, string, new Integer(n2), n3, 1.0f);
        }

        public NumericAttribute(int n, Object object, String string, Number number, int n2, float f) {
            super(n, object, string);
            this.swingDefault = number;
            this.rtfDefault = n2;
            this.scale = f;
        }

        public static NumericAttribute NewTwips(int n, Object object, String string, float f, int n2) {
            return new NumericAttribute(n, object, string, new Float(f), n2, 20.0f);
        }

        public static NumericAttribute NewTwips(int n, Object object, String string, int n2) {
            return new NumericAttribute(n, object, string, null, n2, 20.0f);
        }

        public boolean set(MutableAttributeSet mutableAttributeSet) {
            return false;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet, int n) {
            Number number = this.scale == 1.0f ? (Number)new Integer(n) : (Number)new Float((float)n / this.scale);
            mutableAttributeSet.addAttribute(this.swingName, number);
            return true;
        }

        public boolean setDefault(MutableAttributeSet mutableAttributeSet) {
            Number number = (Number)mutableAttributeSet.getAttribute(this.swingName);
            if (number == null) {
                number = this.swingDefault;
            }
            if (number != null && (this.scale == 1.0f && number.intValue() == this.rtfDefault || Math.round(number.floatValue() * this.scale) == this.rtfDefault)) {
                return true;
            }
            this.set(mutableAttributeSet, this.rtfDefault);
            return true;
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl) throws IOException {
            Number number = (Number)object;
            if (number == null) {
                number = this.swingDefault;
            }
            if (number == null) {
                return true;
            }
            int n = Math.round(number.floatValue() * this.scale);
            if (bl || n != this.rtfDefault) {
                rTFGenerator.writeControlWord(this.rtfName, n);
            }
            return true;
        }
    }

    static class AssertiveAttribute
    extends GenericAttribute
    implements RTFAttribute {
        Object swingValue;

        public AssertiveAttribute(int n, Object object, String string) {
            super(n, object, string);
            this.swingValue = new Boolean(true);
        }

        public AssertiveAttribute(int n, Object object, String string, Object object2) {
            super(n, object, string);
            this.swingValue = object2;
        }

        public AssertiveAttribute(int n, Object object, String string, int n2) {
            super(n, object, string);
            this.swingValue = new Integer(n2);
        }

        public boolean set(MutableAttributeSet mutableAttributeSet) {
            if (this.swingValue == null) {
                mutableAttributeSet.removeAttribute(this.swingName);
            } else {
                mutableAttributeSet.addAttribute(this.swingName, this.swingValue);
            }
            return true;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet, int n) {
            return false;
        }

        public boolean setDefault(MutableAttributeSet mutableAttributeSet) {
            mutableAttributeSet.removeAttribute(this.swingName);
            return true;
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl) throws IOException {
            if (object == null) {
                return !bl;
            }
            if (object.equals(this.swingValue)) {
                rTFGenerator.writeControlWord(this.rtfName);
                return true;
            }
            return !bl;
        }
    }

    static class BooleanAttribute
    extends GenericAttribute
    implements RTFAttribute {
        boolean rtfDefault;
        boolean swingDefault;
        protected static final Boolean True = new Boolean(true);
        protected static final Boolean False = new Boolean(false);

        public BooleanAttribute(int n, Object object, String string, boolean bl, boolean bl2) {
            super(n, object, string);
            this.swingDefault = bl;
            this.rtfDefault = bl2;
        }

        public BooleanAttribute(int n, Object object, String string) {
            super(n, object, string);
            this.swingDefault = false;
            this.rtfDefault = false;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet) {
            mutableAttributeSet.addAttribute(this.swingName, True);
            return true;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet, int n) {
            Boolean bl = n != 0 ? True : False;
            mutableAttributeSet.addAttribute(this.swingName, bl);
            return true;
        }

        public boolean setDefault(MutableAttributeSet mutableAttributeSet) {
            if (this.swingDefault != this.rtfDefault || mutableAttributeSet.getAttribute(this.swingName) != null) {
                mutableAttributeSet.addAttribute(this.swingName, new Boolean(this.rtfDefault));
            }
            return true;
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl) throws IOException {
            Boolean bl2 = object == null ? new Boolean(this.swingDefault) : (Boolean)object;
            if (bl || bl2 != this.rtfDefault) {
                if (bl2.booleanValue()) {
                    rTFGenerator.writeControlWord(this.rtfName);
                } else {
                    rTFGenerator.writeControlWord(this.rtfName, 0);
                }
            }
            return true;
        }
    }

    static abstract class GenericAttribute {
        int domain;
        Object swingName;
        String rtfName;

        protected GenericAttribute(int n, Object object, String string) {
            this.domain = n;
            this.swingName = object;
            this.rtfName = string;
        }

        public int domain() {
            return this.domain;
        }

        public Object swingName() {
            return this.swingName;
        }

        public String rtfName() {
            return this.rtfName;
        }

        abstract boolean set(MutableAttributeSet var1);

        abstract boolean set(MutableAttributeSet var1, int var2);

        abstract boolean setDefault(MutableAttributeSet var1);

        public boolean write(AttributeSet attributeSet, RTFGenerator rTFGenerator, boolean bl) throws IOException {
            return this.writeValue(attributeSet.getAttribute(this.swingName), rTFGenerator, bl);
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl) throws IOException {
            return false;
        }
    }
}

