/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.TextLineComponent;

public final class ExtendedTextLabelComponent
extends TextLineComponent {
    private ExtendedTextLabel label;

    public ExtendedTextLabelComponent(ExtendedTextLabel extendedTextLabel, Map map) {
        super(map, extendedTextLabel.getLineMetrics());
        this.label = extendedTextLabel;
    }

    private ExtendedTextLabelComponent(ExtendedTextLabel extendedTextLabel, TextLineComponent textLineComponent) {
        super(textLineComponent);
        this.label = extendedTextLabel;
    }

    public float getItalicAngle() {
        return this.label.getItalicAngle();
    }

    protected Rectangle2D handleGetVisualBounds() {
        return this.label.getVisualBounds();
    }

    protected Shape handleGetOutline(float f, float f2) {
        return this.label.getOutline(f, f2);
    }

    protected void handleDraw(Graphics2D graphics2D, float f, float f2) {
        this.label.draw(graphics2D, f, f2);
    }

    public int getNumCharacters() {
        return this.label.getNumCharacters();
    }

    public float getCharX(int n) {
        return this.label.getCharX(n);
    }

    public float getCharY(int n) {
        return this.label.getCharY(n);
    }

    public float getCharAdvance(int n) {
        return this.label.getCharAdvance(n);
    }

    public boolean caretAtOffsetIsValid(int n) {
        return this.label.caretAtOffsetIsValid(n);
    }

    protected Rectangle2D handleGetCharVisualBounds(int n) {
        return this.label.getCharVisualBounds(n);
    }

    public int getLineBreakIndex(int n, float f) {
        return this.label.getLineBreakIndex(n, f);
    }

    public float getAdvanceBetween(int n, int n2) {
        return this.label.getCharAdvanceBetween(n, n2);
    }

    public Rectangle2D getLogicalBounds() {
        return this.label.getLogicalBounds();
    }

    public TextLineComponent getSubset(int n, int n2, int n3) {
        int n4 = this.label.getNumCharacters();
        if (n < 0 || n2 > n4 || n >= n2) {
            throw new IllegalArgumentException("Invalid range");
        }
        if (n == 0 && n2 == n4 && n3 == 2) {
            return this;
        }
        return new ExtendedTextLabelComponent(this.label.getSubset(n, n2, n3), this);
    }

    public int getNumJustificationInfos() {
        return this.label.getNumJustificationInfos();
    }

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n, int n2, int n3) {
        this.label.getJustificationInfos(glyphJustificationInfoArray, n, n2, n3);
    }

    public TextLineComponent applyJustificationDeltas(float[] fArray, int n, boolean[] blArray) {
        return new ExtendedTextLabelComponent(this.label.applyJustificationDeltas(fArray, n, blArray), this);
    }

    public String toString() {
        return "[characters:" + this.label + "]";
    }
}

