/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class EDIPartyName
implements GeneralNameInterface {
    private static final byte TAG_ASSIGNER = 0;
    private static final byte TAG_PARTYNAME = 1;
    private String assigner = null;
    private String party = null;

    public EDIPartyName(String string, String string2) {
        this.assigner = string;
        this.party = string2;
    }

    public EDIPartyName(String string) {
        this.party = string;
    }

    public EDIPartyName(DerValue derValue) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        if (n < 1 || n > 2) {
            throw new IOException("Invalid encoding of EDIPartyName");
        }
        int n2 = 0;
        while (n2 < n) {
            DerValue derValue2 = derValueArray[n2];
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.assigner != null) {
                    throw new IOException("Duplicate nameAssigner found in EDIPartyName");
                }
                derValue2 = derValue2.data.getDerValue();
                this.assigner = derValue2.getAsString();
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.party != null) {
                    throw new IOException("Duplicate partyName found in EDIPartyName");
                }
                derValue2 = derValue2.data.getDerValue();
                this.party = derValue2.getAsString();
            }
            ++n2;
        }
    }

    public int getType() {
        return 5;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.assigner != null) {
            DerOutputStream derOutputStream4 = new DerOutputStream();
            derOutputStream4.putPrintableString(this.assigner);
            derOutputStream2.write(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream4);
        }
        if (this.party == null) {
            throw new IOException("Cannot have null partyName");
        }
        derOutputStream3.putPrintableString(this.party);
        derOutputStream2.write(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream3);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public String toString() {
        return "EDIPartyName: " + (this.assigner == null ? "" : "  nameAssigner = " + this.assigner + ",") + "  partyName = " + this.party;
    }
}

