/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.MemoryBanker;
import com.bliss.core.MemoryBus;
import com.bliss.core.SaveOutputStream;
import java.io.IOException;

public class MemoryBus
extends Memory {
    private static final int MAX_MAPPED_MEMORIES = 50;
    private Memory[] mappedMemories = new Memory[50];
    private int mappedMemoryCount;
    Memory[] memory;
    protected Memory unmappedMemory;

    public void reset() {
        int n = 0;
        while (n < this.mappedMemoryCount) {
            this.mappedMemories[n].reset();
            ++n;
        }
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        int n = 0;
        while (n < this.mappedMemoryCount) {
            this.mappedMemories[n].save(saveOutputStream);
            ++n;
        }
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        int n = 0;
        while (n < this.mappedMemoryCount) {
            this.mappedMemories[n].load(loadInputStream);
            ++n;
        }
    }

    public void addMemory(Memory memory) {
        int n = memory.getLocation();
        int n2 = memory.getSize();
        int n3 = n + n2;
        if (memory.isBanked()) {
            if (this.memory[n] == this.unmappedMemory) {
                int n4 = n;
                while (n4 < n3) {
                    if (this.memory[n4] != this.unmappedMemory) {
                        throw new IllegalArgumentException("Memory mapping collision error at: " + Integer.toString(n, 16));
                    }
                    ++n4;
                }
                MemoryBanker memoryBanker = new MemoryBanker(n, n2);
                memoryBanker.setMemoryBank(memory.getBank(), memory);
                int n5 = n;
                while (n5 < n3) {
                    this.memory[n5] = memoryBanker;
                    ++n5;
                }
            } else {
                if (!(this.memory[n] instanceof MemoryBanker)) {
                    throw new IllegalArgumentException("Memory mapping collision error at: " + Integer.toString(n, 16));
                }
                if (this.memory[n].getLocation() != n || this.memory[n].getSize() != n2) {
                    throw new IllegalArgumentException("Memory mapping collision error at: " + Integer.toString(n, 16));
                }
                MemoryBanker memoryBanker = (MemoryBanker)this.memory[n];
                if (memoryBanker.getMemoryBank(memory.getBank()) != null) {
                    throw new IllegalArgumentException("Memory mapping collision error at: " + Integer.toString(n, 16));
                }
                memoryBanker.setMemoryBank(memory.getBank(), memory);
            }
        } else {
            int n6 = n;
            while (n6 < n3) {
                if (this.memory[n6] != this.unmappedMemory) {
                    throw new IllegalArgumentException("Memory mapping collision error at: " + Integer.toString(n, 16));
                }
                ++n6;
            }
            n6 = n;
            while (n6 < n3) {
                this.memory[n6] = memory;
                ++n6;
            }
        }
        this.mappedMemories[this.mappedMemoryCount] = memory;
        ++this.mappedMemoryCount;
    }

    public void removeMemory(Memory memory) {
        int n = 0;
        while (n < this.mappedMemoryCount) {
            if (this.mappedMemories[n] == memory) {
                int n2 = n;
                while (n2 < this.mappedMemoryCount - 1) {
                    this.mappedMemories[n2] = this.mappedMemories[n2 + 1];
                    ++n2;
                }
                --this.mappedMemoryCount;
                n2 = memory.getLocation();
                int n3 = memory.getSize();
                int n4 = n2 + n3;
                if (memory.isBanked()) {
                    MemoryBanker memoryBanker = (MemoryBanker)this.memory[n2];
                    memoryBanker.setMemoryBank(memory.getBank(), null);
                    boolean bl = true;
                    int n5 = 0;
                    while (n5 < 16) {
                        if (memoryBanker.getMemoryBank(n5) != null) {
                            bl = false;
                        }
                        ++n5;
                    }
                    if (bl) {
                        n5 = n2;
                        while (n5 < n4) {
                            this.memory[n5] = this.unmappedMemory;
                            ++n5;
                        }
                    }
                } else {
                    int n6 = n2;
                    while (n6 < n4) {
                        this.memory[n6] = this.unmappedMemory;
                        ++n6;
                    }
                }
            }
            ++n;
        }
    }

    public int getLocation() {
        return 0;
    }

    public int peek(int n) {
        return this.memory[n].peek(n);
    }

    public void poke(int n, int n2) {
        this.memory[n].poke(n, n2);
    }

    public int getSize() {
        return this.memory.length;
    }

    public MemoryBus(int n) {
        MemoryBus memoryBus = this;
        if (memoryBus == null) {
            throw null;
        }
        this.unmappedMemory = new 1(memoryBus);
        this.memory = new Memory[n];
        int n2 = 0;
        while (n2 < this.memory.length) {
            this.memory[n2] = this.unmappedMemory;
            ++n2;
        }
    }
}

