/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.SaveOutputStream;
import java.awt.Rectangle;
import java.io.IOException;

public class Sprite {
    private Rectangle boundingRectangle = new Rectangle();
    int xLocation = 0;
    int yLocation = 0;
    int foregroundColor = 0;
    int cardNumber = 0;
    int collisionRegister = 0;
    boolean isGrom = false;
    boolean isVisible = false;
    boolean doubleWidth = false;
    boolean doubleYResolution = false;
    boolean doubleHeight = false;
    boolean quadHeight = false;
    boolean flagCollisions = false;
    boolean horizontalMirror = false;
    boolean verticalMirror = false;
    boolean behindForeground = false;
    boolean boundsChanged = true;
    boolean changed = true;

    void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeInt(this.xLocation);
        saveOutputStream.writeInt(this.yLocation);
        saveOutputStream.writeInt(this.foregroundColor);
        saveOutputStream.writeInt(this.cardNumber);
        saveOutputStream.writeBoolean(this.isGrom);
        saveOutputStream.writeBoolean(this.isVisible);
        saveOutputStream.writeBoolean(this.doubleWidth);
        saveOutputStream.writeBoolean(this.doubleYResolution);
        saveOutputStream.writeBoolean(this.doubleHeight);
        saveOutputStream.writeBoolean(this.quadHeight);
        saveOutputStream.writeBoolean(this.flagCollisions);
        saveOutputStream.writeBoolean(this.horizontalMirror);
        saveOutputStream.writeBoolean(this.verticalMirror);
        saveOutputStream.writeBoolean(this.behindForeground);
    }

    void load(LoadInputStream loadInputStream) throws IOException {
        this.xLocation = loadInputStream.readInt(0, 255);
        this.yLocation = loadInputStream.readInt(0, 127);
        this.foregroundColor = loadInputStream.readInt(0, 15);
        this.cardNumber = loadInputStream.readInt(0, 255);
        this.isGrom = loadInputStream.readBoolean();
        this.isVisible = loadInputStream.readBoolean();
        this.doubleWidth = loadInputStream.readBoolean();
        this.doubleYResolution = loadInputStream.readBoolean();
        this.doubleHeight = loadInputStream.readBoolean();
        this.quadHeight = loadInputStream.readBoolean();
        this.flagCollisions = loadInputStream.readBoolean();
        this.horizontalMirror = loadInputStream.readBoolean();
        this.verticalMirror = loadInputStream.readBoolean();
        this.behindForeground = loadInputStream.readBoolean();
        this.changed = true;
        this.boundsChanged = true;
    }

    protected void reset() {
        this.xLocation = 0;
        this.yLocation = 0;
        this.foregroundColor = 0;
        this.cardNumber = 0;
        this.collisionRegister = 0;
        this.isGrom = false;
        this.isVisible = false;
        this.doubleWidth = false;
        this.doubleYResolution = false;
        this.doubleHeight = false;
        this.quadHeight = false;
        this.flagCollisions = false;
        this.horizontalMirror = false;
        this.verticalMirror = false;
        this.behindForeground = false;
        this.boundingRectangle.x = 0;
        this.boundingRectangle.y = 0;
        this.boundingRectangle.width = 0;
        this.boundingRectangle.height = 0;
        this.changed = true;
        this.boundsChanged = true;
    }

    protected void setXLocation(int n) {
        if (n == this.xLocation) {
            return;
        }
        this.xLocation = n;
        this.boundsChanged = true;
        this.changed = true;
    }

    protected void setYLocation(int n) {
        if (n == this.yLocation) {
            return;
        }
        this.yLocation = n;
        this.boundsChanged = true;
        this.changed = true;
    }

    protected void setForegroundColor(int n) {
        if (n == this.foregroundColor) {
            return;
        }
        this.foregroundColor = n;
        this.changed = true;
    }

    protected void setCardNumber(int n) {
        if (n == this.cardNumber) {
            return;
        }
        this.cardNumber = n;
        this.changed = true;
    }

    protected void setVisible(boolean bl) {
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        this.changed = true;
    }

    protected void setDoubleWidth(boolean bl) {
        if (bl == this.doubleWidth) {
            return;
        }
        this.doubleWidth = bl;
        this.boundsChanged = true;
        this.changed = true;
    }

    protected void setDoubleYResolution(boolean bl) {
        if (bl == this.doubleYResolution) {
            return;
        }
        this.doubleYResolution = bl;
        this.boundsChanged = true;
        this.changed = true;
    }

    protected void setDoubleHeight(boolean bl) {
        if (bl == this.doubleHeight) {
            return;
        }
        this.doubleHeight = bl;
        this.boundsChanged = true;
        this.changed = true;
    }

    protected void setQuadHeight(boolean bl) {
        if (bl == this.quadHeight) {
            return;
        }
        this.quadHeight = bl;
        this.boundsChanged = true;
        this.changed = true;
    }

    protected void setFlagCollisions(boolean bl) {
        if (bl == this.flagCollisions) {
            return;
        }
        this.flagCollisions = bl;
        this.changed = true;
    }

    protected void setHorizontalMirror(boolean bl) {
        if (bl == this.horizontalMirror) {
            return;
        }
        this.horizontalMirror = bl;
        this.changed = true;
    }

    protected void setVerticalMirror(boolean bl) {
        if (bl == this.verticalMirror) {
            return;
        }
        this.verticalMirror = bl;
        this.changed = true;
    }

    protected void setBehindForeground(boolean bl) {
        if (bl == this.behindForeground) {
            return;
        }
        this.behindForeground = bl;
        this.changed = true;
    }

    protected void setGROM(boolean bl) {
        if (bl == this.isGrom) {
            return;
        }
        this.isGrom = bl;
        this.changed = true;
    }

    protected void markClean() {
        this.changed = false;
    }

    protected Rectangle getBounds() {
        if (this.boundsChanged) {
            this.boundingRectangle.x = this.xLocation - 8;
            this.boundingRectangle.y = this.yLocation - 8;
            this.boundingRectangle.width = 8 * (this.doubleWidth ? 2 : 1);
            this.boundingRectangle.height = 4 * (this.quadHeight ? 4 : 1) * (this.doubleHeight ? 2 : 1) * (this.doubleYResolution ? 2 : 1);
            this.boundsChanged = false;
        }
        return this.boundingRectangle;
    }
}

