/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.SaveOutputStream;
import java.io.IOException;

public class MemoryAlias
extends Memory {
    protected Memory aliasedMemory;
    protected int location;
    protected int offset;
    protected boolean writeOnly;
    protected boolean visible = true;

    public void reset() {
        this.visible = true;
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeBoolean(this.visible);
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.visible = loadInputStream.readBoolean();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getLocation() {
        return this.location;
    }

    public int peek(int n) {
        return this.writeOnly ? 65535 : (this.visible ? this.aliasedMemory.peek(n - this.offset) : n);
    }

    public void poke(int n, int n2) {
        if (this.visible) {
            this.aliasedMemory.poke(n - this.offset, n2);
        }
    }

    public int getSize() {
        return this.aliasedMemory.getSize();
    }

    public MemoryAlias(Memory memory, int n) {
        this(memory, n, false);
    }

    public MemoryAlias(Memory memory, int n, boolean bl) {
        this.aliasedMemory = memory;
        this.location = n;
        this.writeOnly = bl;
        this.offset = n - memory.getLocation();
    }
}

