/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core.cartridge;

public class CartridgeType {
    private String name;
    private String producer;
    private String year;
    private long crc;
    private int size;
    private MemoryMap map;
    private boolean requiresECS;
    private boolean usesIntellivoice;

    public String getName() {
        return this.name;
    }

    public String getProducer() {
        return this.producer;
    }

    public String getYear() {
        return this.year;
    }

    public long getCrc() {
        return this.crc;
    }

    public int getSize() {
        return this.size;
    }

    public boolean requiresECS() {
        return this.requiresECS;
    }

    public boolean usesIntellivoice() {
        return this.usesIntellivoice;
    }

    public MemoryMap getMemoryMap() {
        return this.map;
    }

    public CartridgeType(String string, String string2, String string3, long l, int n, boolean bl, boolean bl2, MemoryMap memoryMap) {
        this.name = string;
        this.producer = string2;
        this.year = string3;
        this.crc = l;
        this.size = n;
        this.requiresECS = bl;
        this.usesIntellivoice = bl2;
        this.map = memoryMap;
    }

    public static class MemoryMap {
        private int[][] config;

        public int getSegmentCount() {
            return this.config.length;
        }

        public int getSegmentStart(int n) {
            return this.config[n][0];
        }

        public int getSegmentEnd(int n) {
            return this.config[n][1];
        }

        public int getSegmentSize(int n) {
            return this.config[n][1] - this.config[n][0] + 1;
        }

        public int getSegmentLocation(int n) {
            return this.config[n][2];
        }

        public int getSegmentBank(int n) {
            return this.config[n][3];
        }

        public MemoryMap(int[][] nArray) {
            this.config = nArray;
        }
    }
}

