/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core.ivoice;

import com.bliss.core.AudioMixer;
import com.bliss.core.Memory;
import com.bliss.core.Peripheral;
import com.bliss.core.Processor;
import com.bliss.core.ivoice.LPC12;
import com.bliss.core.ivoice.MicroSequencer;

public class Intellivoice
implements Peripheral {
    private boolean audioEnabled = true;
    private MicroSequencer microSequencer;
    private LPC12 lpc12;
    private boolean hasIvoiceImage = false;

    public int getProcessorCount() {
        return 2;
    }

    public void setAudioEnabled(boolean bl) {
        this.audioEnabled = bl;
        this.lpc12.audioEnabled = bl;
    }

    public Processor getProcessor(int n) {
        return n == 0 ? this.microSequencer : this.lpc12;
    }

    public int getMemoryCount() {
        return 1;
    }

    public Memory getMemory(int n) {
        return this.microSequencer.registers;
    }

    public void setIntellivoiceImage(int[] nArray) {
        System.arraycopy(nArray, 0, this.microSequencer.ivoiceROMImage, 0, this.microSequencer.ivoiceROMImage.length);
        this.hasIvoiceImage = true;
    }

    public boolean hasIntellivoiceImage() {
        return this.hasIvoiceImage;
    }

    public Intellivoice(AudioMixer.AudioOutputLine audioOutputLine) {
        this.lpc12 = new LPC12(audioOutputLine);
        this.microSequencer = new MicroSequencer(this.lpc12);
    }
}

