/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app;

import com.bliss.core.IODevice;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.InputSignal;
import com.blissj.app.Bliss;
import javax.swing.table.AbstractTableModel;

public class InputTableModel
extends AbstractTableModel {
    private static final String[] inputKeys = new String[]{"InputKeyPadOne", "InputKeyPadTwo", "InputKeyPadThree", "InputKeyPadFour", "InputKeyPadFive", "InputKeyPadSix", "InputKeyPadSeven", "InputKeyPadEight", "InputKeyPadNine", "InputKeyPadClear", "InputKeyPadZero", "InputKeyPadEnter", "InputActionButtonsTop", "InputActionButtonBottomLeft", "InputActionButtonBottomRight", "InputDiscNorth", "InputDiscNorthEast", "InputDiscEast", "InputDiscSouthEast", "InputDiscSouth", "InputDiscSouthWest", "InputDiscWest", "InputDiscNorthWest"};
    private InputDevice inputDevice;
    private IODevice ioDevice;
    private InputSignal[] inputSignals;

    public void setIODevice(InputDevice inputDevice, IODevice iODevice) {
        this.inputSignals = null;
        this.ioDevice = iODevice;
        this.inputDevice = inputDevice;
        if (this.ioDevice != null) {
            int n = iODevice.getControlCount();
            this.inputSignals = new InputSignal[n];
            int n2 = 0;
            while (n2 < n) {
                this.inputSignals[n2] = inputDevice.getInputSignal(iODevice.getControlID(n2));
                ++n2;
            }
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.ioDevice == null ? 0 : this.ioDevice.getControlCount();
    }

    public int getColumnCount() {
        return 2;
    }

    public void reloadDevice() {
        int n = 0;
        while (n < this.inputSignals.length) {
            this.inputSignals[n] = this.inputDevice.getInputSignal(this.ioDevice.getControlID(n));
            ++n;
        }
        this.fireTableDataChanged();
    }

    public void commitToDevice() {
        int n = 0;
        while (n < this.inputSignals.length) {
            this.inputDevice.setInputSignal(this.ioDevice.getControlID(n), this.inputSignals[n]);
            ++n;
        }
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return Bliss.RESOURCES.getString("ColumnIntellivisionControl");
        }
        return Bliss.RESOURCES.getString("ColumnMapping");
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.ioDevice.getControlDescription(n);
        }
        InputSignal inputSignal = this.inputSignals[n];
        if (inputSignal == null) {
            return Bliss.RESOURCES.getString("InputUndefined");
        }
        return inputSignal.getDescription();
    }

    public void setControlInputSignal(int n, InputSignal inputSignal) {
        this.inputSignals[n] = inputSignal;
        this.fireTableCellUpdated(n, 1);
    }

    public int getInputID(int n) {
        return n;
    }
}

