/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app.actions;

import com.bliss.core.Memory;
import com.bliss.core.ROM;
import com.bliss.core.cartridge.Cartridge;
import com.bliss.core.cartridge.CartridgeType;
import com.blissj.app.Bliss;
import com.blissj.app.BlissMainFrame;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class LoadIntellicartAction
extends AbstractAction {
    private static final String intellicartFileExtension = Bliss.RESOURCES.getString("IntellicartFileExtension");
    private static final String intellicartFileDescription = Bliss.RESOURCES.getString("IntellicartFilesDescription") + " (*" + intellicartFileExtension + ")";
    private static final int TAG_TITLE = 1;
    private static final int TAG_PUBLISHER = 2;
    private static final int TAG_RELEASE_DATE = 5;
    private static final int TAG_COMPATIBILITY = 6;
    private BlissMainFrame frame;
    private JFileChooser fileChooser;

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
            LoadIntellicartAction loadIntellicartAction = this;
            if (loadIntellicartAction == null) {
                throw null;
            }
            this.fileChooser.addChoosableFileFilter(new FileFilter(loadIntellicartAction){
                private final /* synthetic */ LoadIntellicartAction this$0;

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(LoadIntellicartAction.access$0());
                }

                public String getDescription() {
                    return LoadIntellicartAction.access$1();
                }
                {
                    this.this$0 = loadIntellicartAction;
                    this.constructor$0(loadIntellicartAction);
                }

                private final void constructor$0(LoadIntellicartAction loadIntellicartAction) {
                }
            });
        }
        if ((n = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        try {
            Cartridge cartridge = this.loadIntellicart(file);
            this.frame.playCartridge(cartridge);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, Bliss.RESOURCES.getString("ErrorUnableToLoadIntellicart"));
        }
    }

    private Cartridge loadIntellicart(File file) throws IOException {
        String string;
        int n;
        int n2;
        int n3;
        CRC16 cRC16;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
        int n4 = bufferedInputStream.read();
        if (n4 != 168) {
            bufferedInputStream.close();
            throw new IOException("Invalid byte 0: " + Integer.toString(n4, 16));
        }
        int n5 = bufferedInputStream.read();
        n4 = bufferedInputStream.read();
        if ((n4 ^ 0xFF) != n5) {
            bufferedInputStream.close();
            throw new IOException("Invalid rom segment count: " + n5);
        }
        int[][] nArray = new int[n5][4];
        Memory[] memoryArray = new Memory[n5];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = bufferedInputStream.read() << 8;
            int n9 = bufferedInputStream.read() << 8 | 0xFF;
            nArray[n7][0] = n6;
            nArray[n7][1] = n6 + (n9 - n8);
            nArray[n7][2] = n8;
            nArray[n7][3] = -1;
            int n10 = n9 - n8 + 1;
            int[] nArray2 = new int[n10];
            cRC16 = new CRC16();
            cRC16.update((n8 & 0xFF00) >> 8);
            cRC16.update((n9 & 0xFF00) >> 8);
            n3 = 0;
            while (n3 < n10) {
                n2 = bufferedInputStream.read();
                n = bufferedInputStream.read();
                nArray2[n3] = n2 << 8 | n;
                cRC16.update(n2);
                cRC16.update(n);
                ++n3;
            }
            memoryArray[n7] = new ROM(nArray2, nArray[n7][2]);
            n3 = bufferedInputStream.read() << 8 | bufferedInputStream.read();
            if (n3 != cRC16.getCRC()) {
                bufferedInputStream.close();
                throw new IOException("Invalid CRC: " + Integer.toString(n3, 16) + " should be " + Integer.toString(cRC16.getCRC(), 16));
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < 16) {
            bufferedInputStream.read();
            ++n7;
        }
        n7 = 0;
        while (n7 < 32) {
            bufferedInputStream.read();
            ++n7;
        }
        String string2 = string = Bliss.RESOURCES.getString("UnknownCartridgeAttribute");
        String string3 = string;
        String string4 = string;
        boolean bl = false;
        while ((n4 = bufferedInputStream.read()) != -1) {
            n3 = n4 & 0x3F;
            n4 = (n4 & 0xC) >> 6;
            n2 = 0;
            while (n2 < n4) {
                n3 |= bufferedInputStream.read() << 8 * n2 + 6;
                ++n2;
            }
            n2 = bufferedInputStream.read();
            switch (n2) {
                case 1: {
                    cRC16 = new CRC16();
                    byte[] byArray = new byte[n3];
                    int n11 = 0;
                    while (n11 < n3) {
                        n4 = bufferedInputStream.read();
                        byArray[n11] = (byte)n4;
                        cRC16.update(n4);
                        ++n11;
                    }
                    n = bufferedInputStream.read() << 8 | bufferedInputStream.read();
                    if (n != cRC16.getCRC()) {
                        bufferedInputStream.close();
                        throw new IOException("Invalid CRC: " + Integer.toString(n, 16));
                    }
                    string2 = new String(byArray);
                    break;
                }
                case 2: {
                    cRC16 = new CRC16();
                    byte[] byArray = new byte[n3];
                    int n12 = 0;
                    while (n12 < n3) {
                        n4 = bufferedInputStream.read();
                        byArray[n12] = (byte)n4;
                        cRC16.update(n4);
                        ++n12;
                    }
                    n = bufferedInputStream.read() << 8 | bufferedInputStream.read();
                    if (n != cRC16.getCRC()) {
                        bufferedInputStream.close();
                        throw new IOException("Invalid CRC: " + Integer.toString(n, 16));
                    }
                    string3 = new String(byArray);
                    break;
                }
                case 5: {
                    int n12 = 0;
                    while (n12 < n3) {
                        bufferedInputStream.read();
                        bufferedInputStream.read();
                        ++n12;
                    }
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                    break;
                }
                case 6: {
                    n4 = bufferedInputStream.read();
                    bl = (n4 & 0xC0) == 128;
                    int n12 = 0;
                    while (n12 < n3 - 1) {
                        bufferedInputStream.read();
                        bufferedInputStream.read();
                        ++n12;
                    }
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                    break;
                }
                default: {
                    int n12 = 0;
                    while (n12 < n3) {
                        bufferedInputStream.read();
                        bufferedInputStream.read();
                        ++n12;
                    }
                    bufferedInputStream.read();
                    bufferedInputStream.read();
                }
            }
        }
        bufferedInputStream.close();
        CartridgeType.MemoryMap memoryMap = new CartridgeType.MemoryMap(nArray);
        CartridgeType cartridgeType = new CartridgeType(string2, string3, string4, 0L, (int)file.length(), bl, false, memoryMap);
        return new Cartridge(cartridgeType, memoryArray);
    }

    static /* synthetic */ String access$0() {
        return intellicartFileExtension;
    }

    static /* synthetic */ String access$1() {
        return intellicartFileDescription;
    }

    public LoadIntellicartAction(BlissMainFrame blissMainFrame) {
        this.frame = blissMainFrame;
        this.putValue("Name", Bliss.RESOURCES.getString("ActionLoadIntellicart"));
    }

    private static class CRC16 {
        private static final int[] crctable = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
        private int reg = 65535;

        public void update(int n) {
            this.reg = this.reg << 8 & 0xFFFF ^ crctable[this.reg >> 8 ^ n];
        }

        public int getCRC() {
            return this.reg;
        }

        CRC16() {
        }
    }
}

