/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app.util;

import com.blissj.app.util.ConfigurationRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class ConfigurationRegistry {
    private KeyEntry registry;
    private File registryFile;

    public String[] getKeys(String[] stringArray, String[] stringArray2) {
        KeyEntry keyEntry = this.getKey(stringArray, false);
        if (keyEntry == null) {
            return new String[0];
        }
        ArrayList arrayList = keyEntry.getKeys();
        String[] stringArray3 = new String[arrayList.size()];
        int n = 0;
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            stringArray3[n] = ((KeyEntry)iterator.next()).getName();
            ++n;
        }
        return stringArray3;
    }

    public String getDataAsString(String[] stringArray, String string, String string2) {
        KeyEntry keyEntry = this.getKey(stringArray, false);
        if (keyEntry == null) {
            return string2;
        }
        ValueEntry valueEntry = keyEntry.getValue(string);
        if (valueEntry == null) {
            return string2;
        }
        return valueEntry.getDataAsString();
    }

    public int getDataAsInt(String[] stringArray, String string, int n) {
        KeyEntry keyEntry = this.getKey(stringArray, false);
        if (keyEntry == null) {
            return n;
        }
        ValueEntry valueEntry = keyEntry.getValue(string);
        if (valueEntry == null) {
            return n;
        }
        return valueEntry.getDataAsInt();
    }

    public void setKey(String[] stringArray) {
        KeyEntry keyEntry = this.registry;
        int n = 0;
        while (n < stringArray.length - 1) {
            KeyEntry keyEntry2 = keyEntry;
            if ((keyEntry = keyEntry.getKey(stringArray[n])) == null) {
                ConfigurationRegistry configurationRegistry = this;
                if (configurationRegistry == null) {
                    throw null;
                }
                keyEntry = configurationRegistry.new KeyEntry(null, stringArray[n]);
                keyEntry2.putKey(keyEntry);
            }
            ++n;
        }
        ConfigurationRegistry configurationRegistry = this;
        if (configurationRegistry == null) {
            throw null;
        }
        keyEntry.putKey(configurationRegistry.new KeyEntry(null, stringArray[stringArray.length - 1]));
    }

    public void setData(String[] stringArray, String string, int n) {
        KeyEntry keyEntry = this.getKey(stringArray, true);
        ValueEntry valueEntry = keyEntry.getValue(string);
        if (valueEntry == null) {
            ConfigurationRegistry configurationRegistry = this;
            if (configurationRegistry == null) {
                throw null;
            }
            valueEntry = configurationRegistry.new ValueEntry(null, string, new Integer(n));
            keyEntry.putValue(valueEntry);
        } else {
            valueEntry.setData(new Integer(n));
        }
    }

    public void setData(String[] stringArray, String string, String string2) {
        if (string2 == null) {
            this.removeValue(stringArray, string);
            return;
        }
        KeyEntry keyEntry = this.getKey(stringArray, true);
        ValueEntry valueEntry = keyEntry.getValue(string);
        if (valueEntry == null) {
            ConfigurationRegistry configurationRegistry = this;
            if (configurationRegistry == null) {
                throw null;
            }
            valueEntry = configurationRegistry.new ValueEntry(null, string, string2);
            keyEntry.putValue(valueEntry);
        } else {
            valueEntry.setData(string2);
        }
    }

    public void removeKey(String[] stringArray) {
        KeyEntry keyEntry = this.registry;
        int n = 0;
        while (n < stringArray.length - 1) {
            if ((keyEntry = keyEntry.getKey(stringArray[n])) == null) {
                return;
            }
            ++n;
        }
        keyEntry.removeKey(stringArray[stringArray.length - 1]);
    }

    public void removeValue(String[] stringArray, String string) {
        KeyEntry keyEntry = this.getKey(stringArray, false);
        if (keyEntry != null) {
            keyEntry.removeValue(string);
        }
    }

    protected KeyEntry getKey(String[] stringArray, boolean bl) {
        KeyEntry keyEntry = this.registry;
        int n = 0;
        while (n < stringArray.length) {
            KeyEntry keyEntry2 = keyEntry;
            if ((keyEntry = keyEntry.getKey(stringArray[n])) == null) {
                if (bl) {
                    ConfigurationRegistry configurationRegistry = this;
                    if (configurationRegistry == null) {
                        throw null;
                    }
                    keyEntry = configurationRegistry.new KeyEntry(null, stringArray[n]);
                    keyEntry2.putKey(keyEntry);
                } else {
                    return null;
                }
            }
            ++n;
        }
        return keyEntry;
    }

    public static String[] concatenateKeys(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        ConfigurationRegistry.concatenateKeys(stringArray, stringArray2, stringArray3);
        return stringArray3;
    }

    public static String[] concatenateKeys(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String[] concatenateKeys(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public void saveRegistry() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.registryFile), 4096));
        dataOutputStream.writeInt(1);
        this.saveKey(this.registry, dataOutputStream);
        dataOutputStream.close();
    }

    public void saveKey(KeyEntry keyEntry, DataOutputStream dataOutputStream) throws IOException {
        String string = keyEntry.getName();
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeChars(string);
        ArrayList arrayList = keyEntry.getKeys();
        dataOutputStream.writeInt(arrayList.size());
        Object object = ((AbstractList)arrayList).iterator();
        while (object.hasNext()) {
            this.saveKey((KeyEntry)object.next(), dataOutputStream);
        }
        object = keyEntry.getValues();
        dataOutputStream.writeInt(((ArrayList)object).size());
        Iterator iterator = ((AbstractList)object).iterator();
        while (iterator.hasNext()) {
            this.saveValue((ValueEntry)iterator.next(), dataOutputStream);
        }
    }

    public void saveValue(ValueEntry valueEntry, DataOutputStream dataOutputStream) throws IOException {
        String string = valueEntry.getName();
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeChars(string);
        int n = valueEntry.getDataType();
        dataOutputStream.writeInt(n);
        if (n == 0) {
            dataOutputStream.writeInt(valueEntry.getDataAsInt());
        } else {
            String string2 = valueEntry.getDataAsString();
            dataOutputStream.writeInt(string2.length());
            dataOutputStream.writeChars(string2);
        }
    }

    public void loadRegistry() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.registryFile), 4096));
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.loadKey(null, dataInputStream);
            ++n2;
        }
        dataInputStream.close();
    }

    private void loadKey(KeyEntry keyEntry, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInputStream.readChar();
            ++n2;
        }
        ConfigurationRegistry configurationRegistry = this;
        if (configurationRegistry == null) {
            throw null;
        }
        KeyEntry keyEntry2 = configurationRegistry.new KeyEntry(null, new String(cArray));
        int n3 = dataInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            this.loadKey(keyEntry2, dataInputStream);
            ++n4;
        }
        n4 = dataInputStream.readInt();
        int n5 = 0;
        while (n5 < n4) {
            this.loadValue(keyEntry2, dataInputStream);
            ++n5;
        }
        if (keyEntry == null) {
            this.registry = keyEntry2;
        } else {
            keyEntry.putKey(keyEntry2);
        }
    }

    private void loadValue(KeyEntry keyEntry, DataInputStream dataInputStream) throws IOException {
        ValueEntry valueEntry;
        int n = dataInputStream.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInputStream.readChar();
            ++n2;
        }
        n2 = dataInputStream.readInt();
        if (n2 == 0) {
            ConfigurationRegistry configurationRegistry = this;
            if (configurationRegistry == null) {
                throw null;
            }
            valueEntry = configurationRegistry.new ValueEntry(null, new String(cArray), new Integer(dataInputStream.readInt()));
        } else {
            String string = new String(cArray);
            n = dataInputStream.readInt();
            cArray = new char[n];
            int n3 = 0;
            while (n3 < n) {
                cArray[n3] = dataInputStream.readChar();
                ++n3;
            }
            ConfigurationRegistry configurationRegistry = this;
            if (configurationRegistry == null) {
                throw null;
            }
            valueEntry = configurationRegistry.new ValueEntry(null, string, new String(cArray));
        }
        keyEntry.putValue(valueEntry);
    }

    public ConfigurationRegistry(File file) {
        ConfigurationRegistry configurationRegistry = this;
        if (configurationRegistry == null) {
            throw null;
        }
        this.registry = configurationRegistry.new KeyEntry(null, "root");
        this.registryFile = file;
    }

    private class KeyEntry
    implements Comparable {
        private final String keyName;
        private final TreeMap keys = new TreeMap();
        private final ArrayList keysNO = new ArrayList();
        private final TreeMap vals = new TreeMap();
        private final ArrayList valsNO = new ArrayList();

        private String getName() {
            return this.keyName;
        }

        private KeyEntry getKey(String string) {
            return (KeyEntry)this.keys.get(string);
        }

        private ArrayList getKeys() {
            return this.keysNO;
        }

        private void putKey(KeyEntry keyEntry) {
            this.keys.put(keyEntry.keyName, keyEntry);
            this.keysNO.add(keyEntry);
        }

        private void removeKey(String string) {
            Object v = this.keys.get(string);
            if (v != null) {
                this.keys.remove(string);
                ((AbstractCollection)this.keysNO).remove(v);
            }
        }

        private ValueEntry getValue(String string) {
            return (ValueEntry)this.vals.get(string);
        }

        private ArrayList getValues() {
            return this.valsNO;
        }

        private void putValue(ValueEntry valueEntry) {
            this.vals.put(valueEntry.getName(), valueEntry);
            this.valsNO.add(valueEntry);
        }

        private void removeValue(String string) {
            Object v = this.keys.get(string);
            if (v != null) {
                this.vals.remove(string);
                ((AbstractCollection)this.valsNO).remove(v);
            }
        }

        public int compareTo(Object object) {
            return this.keyName.compareTo(((KeyEntry)object).keyName);
        }

        private KeyEntry(String string) {
            this.keyName = string;
        }

        /* synthetic */ KeyEntry(1 var2_2, String string) {
            this(string);
        }
    }

    private class ValueEntry {
        private static final int INT_TYPE = 0;
        private static final int STRING_TYPE = 1;
        private final String valueName;
        private Object data;

        private String getName() {
            return this.valueName;
        }

        private String getDataAsString() {
            return (String)this.data;
        }

        private int getDataAsInt() {
            return (Integer)this.data;
        }

        private int getDataType() {
            return this.data instanceof Integer ? 0 : 1;
        }

        private void setData(Object object) {
            if (!object.getClass().equals(this.data.getClass())) {
                Object[] objectArray = new Object[]{this.data.getClass().getName(), this.valueName, object.getClass().getName()};
                throw new IllegalArgumentException("The new registry value of class " + object.getClass().getName() + " is incompatible with the existing value of class " + this.data.getClass().getName());
            }
            this.data = object;
        }

        private ValueEntry(String string, Object object) {
            this.valueName = string;
            this.data = object;
        }

        /* synthetic */ ValueEntry(2 var2_2, String string, Object object) {
            this(string, object);
        }
    }
}

