/*
 * Decompiled with CFR 0.152.
 */
package com.blissj.app.util;

import com.blissj.app.util.ArchiveEntry;
import com.blissj.app.util.ArchiveStream;
import com.blissj.app.util.ResourceArchiveStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class ResourceArchiveStream
extends ArchiveStream {
    private InputStream is;
    private byte[] header = new byte[12];
    private int resourceCounter;
    private long dataCounter;
    private CRC32 crc;

    public ArchiveEntry getNextEntry() throws IOException {
        if (this.resourceCounter == 0) {
            return null;
        }
        this.discard(this.dataCounter);
        this.crc = new CRC32();
        int n = this.is.read();
        this.readFully(this.header);
        String string = new String(this.header, 0, n);
        int n2 = this.readWord();
        this.dataCounter = this.readLong();
        this.discard(12L);
        ResourceArchiveStream resourceArchiveStream = this;
        if (resourceArchiveStream == null) {
            throw null;
        }
        return resourceArchiveStream.new ResourceArchiveEntry(null, string);
    }

    public int available() {
        return (int)this.dataCounter;
    }

    public int read() throws IOException {
        if (this.dataCounter == 0L) {
            return -1;
        }
        --this.dataCounter;
        int n = this.is.read();
        this.crc.update(n);
        return n;
    }

    public void close() throws IOException {
        this.is.close();
    }

    private void discard(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            this.is.read();
            ++l2;
        }
    }

    private void readFully(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.is.read();
            ++n;
        }
    }

    private void readFully(byte[] byArray) throws IOException {
        int n = 0;
        while ((n = this.is.read(byArray, n, byArray.length - n)) < byArray.length) {
        }
    }

    private int readWord() throws IOException {
        int n = this.is.read();
        int n2 = this.is.read();
        return n2 << 8 | n;
    }

    private long readLong() throws IOException {
        long l = this.is.read();
        long l2 = this.is.read();
        long l3 = this.is.read();
        long l4 = this.is.read();
        return l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    public ResourceArchiveStream(InputStream inputStream) throws IOException {
        this.is = inputStream;
        int n = inputStream.read();
        this.readFully(this.header);
        String string = new String(this.header, 0, n);
        if (!string.equals("Resource")) {
            throw new IOException("Not a valid resource file format");
        }
        this.discard(2L);
        this.resourceCounter = this.readWord();
        this.discard(32L);
    }

    private class ResourceArchiveEntry
    implements ArchiveEntry {
        private String name;

        public String getName() {
            return this.name;
        }

        public long getCrc() {
            return ResourceArchiveStream.this.crc.getValue();
        }

        private ResourceArchiveEntry(String string) {
            this.name = string;
        }

        /* synthetic */ ResourceArchiveEntry(1 var2_2, String string) {
            this(string);
        }
    }
}

