/*
 * Decompiled with CFR 0.152.
 */
package com.blissjx.plugin;

import com.bliss.core.Intellivision;
import com.bliss.core.devices.AudioOutputDevice;
import com.bliss.core.devices.ClockDevice;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.PlugIn;
import com.bliss.core.devices.VideoOutputDevice;
import com.blissj.plugin.AppAudioOutputDevice;
import com.blissjx.plugin.DirectInputDevice;
import com.blissjx.plugin.DirectXVideoOutputDevice;
import com.blissjx.plugin.Win32ClockDevice;
import java.util.ResourceBundle;

public class Win32PlugIn
implements PlugIn {
    static final ResourceBundle RESOURCES = ResourceBundle.getBundle("i18n/Win32PlugInResources");
    private static final boolean isSupported;
    private static String[] win32OS;
    private Win32ClockDevice cd = new Win32ClockDevice();
    private DirectXVideoOutputDevice vod = new DirectXVideoOutputDevice();
    private AppAudioOutputDevice aod = new AppAudioOutputDevice();
    private DirectInputDevice id = new DirectInputDevice();

    public void init(Intellivision intellivision) {
        this.vod.init(intellivision.getCartridge().getType().getName());
        this.aod.init();
        this.id.init();
    }

    public void release(Intellivision intellivision) {
        this.id.release();
        this.aod.release();
        this.vod.release();
    }

    public String getPlugInName() {
        return RESOURCES.getString("Win32PlugInName");
    }

    public String getPlugInDescription() {
        return RESOURCES.getString("Win32PlugInDescription");
    }

    public ClockDevice getClockDevice() {
        return this.cd;
    }

    public VideoOutputDevice getVideoOutputDevice() {
        return this.vod;
    }

    public AudioOutputDevice getAudioOutputDevice() {
        return this.aod;
    }

    public boolean stopRequested() {
        return this.vod.stop || this.id.stop;
    }

    public InputDevice getInputDevice() {
        return this.id;
    }

    public static boolean isSupported() {
        return isSupported;
    }

    static {
        win32OS = new String[]{"Windows 2000", "Windows Me", "Windows 98", "Windows 95"};
        String string = System.getProperties().getProperty("os.name");
        boolean bl = false;
        if (string != null && string.indexOf("Windows") != -1) {
            try {
                System.loadLibrary("BlissNativeWin32");
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        isSupported = bl;
    }
}

