/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    private Naming() {
    }

    public static Remote lookup(String string) throws NotBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        if (parsedNamingURL.name == null) {
            return registry;
        }
        return registry.lookup(parsedNamingURL.name);
    }

    public static void bind(String string, Remote remote) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        if (remote == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.bind(parsedNamingURL.name, remote);
    }

    public static void unbind(String string) throws RemoteException, NotBoundException, MalformedURLException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        registry.unbind(parsedNamingURL.name);
    }

    public static void rebind(String string, Remote remote) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        if (remote == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.rebind(parsedNamingURL.name, remote);
    }

    public static String[] list(String string) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsedNamingURL = Naming.parseURL(string);
        Registry registry = Naming.getRegistry(parsedNamingURL);
        String string2 = "rmi:";
        if (parsedNamingURL.port > 0 || !parsedNamingURL.host.equals("")) {
            string2 = string2 + "//" + parsedNamingURL.host;
        }
        if (parsedNamingURL.port > 0) {
            string2 = string2 + ":" + parsedNamingURL.port;
        }
        string2 = string2 + "/";
        String[] stringArray = registry.list();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = string2 + stringArray[n];
            ++n;
        }
        return stringArray;
    }

    private static Registry getRegistry(ParsedNamingURL parsedNamingURL) throws RemoteException {
        return LocateRegistry.getRegistry(parsedNamingURL.host, parsedNamingURL.port);
    }

    private static ParsedNamingURL parseURL(String string) throws MalformedURLException {
        ParsedNamingURL parsedNamingURL = new ParsedNamingURL();
        int n = -1;
        if (string.startsWith("rmi:")) {
            string = string.substring(4);
        }
        if (string.indexOf(35) >= 0) {
            throw new MalformedURLException("Invalid character, '#', in URL: " + string);
        }
        int n2 = string.indexOf(58);
        if (n2 >= 0 && n2 < string.indexOf(47)) {
            throw new MalformedURLException("invalid protocol: " + string.substring(0, n2));
        }
        if (string.startsWith("//")) {
            int n3 = string.indexOf("/", 2);
            n = n3 >= 0 ? n3 + 1 : (n3 = string.length());
            int n4 = string.indexOf(":", 2);
            if (n4 > 1 && n4 < n3) {
                try {
                    parsedNamingURL.port = Integer.parseInt(string.substring(n4 + 1, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("invalid port number: " + string);
                }
            }
            int n5 = n4 >= 2 ? n4 : n3;
            parsedNamingURL.host = string.substring(2, n5);
        } else {
            n = string.startsWith("/") ? 1 : 0;
        }
        parsedNamingURL.name = string.substring(n);
        if (parsedNamingURL.name.equals("") || parsedNamingURL.name.equals("/")) {
            parsedNamingURL.name = null;
        }
        return parsedNamingURL;
    }

    private static class ParsedNamingURL {
        String host = "";
        int port = 1099;
        String name = null;

        private ParsedNamingURL() {
        }
    }
}

