/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.EmulationException;
import com.bliss.core.Intellivision;
import com.bliss.core.LoadInputStream;
import com.bliss.core.MemoryBus;
import com.bliss.core.Processor;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.SignalLine;
import com.bliss.core.devices.PlugIn;
import java.io.IOException;

public class CP1610
extends Processor {
    protected PlugIn plugIn;
    protected int[] r;
    protected boolean S;
    protected boolean Z;
    protected boolean O;
    protected boolean C;
    protected boolean I;
    protected boolean D;
    protected boolean interruptible = true;
    protected SignalLine intrmLine;
    protected SignalLine busRqLine;
    protected SignalLine busAkLine;
    protected int resetAddress;
    protected int interruptAddress;
    protected int usedCycles;
    protected MemoryBus memoryBus;
    protected byte ext;

    public int getClockSpeed() {
        return 3579545;
    }

    public void reset() {
        this.isIdle = false;
        this.intrmLine.isHigh = true;
        this.busRqLine.isHigh = true;
        this.busAkLine.isHigh = true;
        this.interruptible = true;
        this.D = false;
        this.I = false;
        this.Z = false;
        this.O = false;
        this.C = false;
        this.S = false;
        int n = 0;
        while (n < 7) {
            this.r[n] = 0;
            ++n;
        }
        this.r[7] = this.resetAddress;
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        int n = 0;
        while (n < 8) {
            saveOutputStream.writeInt(this.r[n]);
            ++n;
        }
        saveOutputStream.writeBoolean(this.S);
        saveOutputStream.writeBoolean(this.C);
        saveOutputStream.writeBoolean(this.O);
        saveOutputStream.writeBoolean(this.Z);
        saveOutputStream.writeBoolean(this.I);
        saveOutputStream.writeBoolean(this.D);
        saveOutputStream.writeBoolean(this.interruptible);
        saveOutputStream.writeBoolean(this.busAkLine.isHigh);
        saveOutputStream.writeBoolean(this.isIdle);
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        int n = 0;
        while (n < 8) {
            this.r[n] = loadInputStream.readInt(0, 65535);
            ++n;
        }
        this.S = loadInputStream.readBoolean();
        this.C = loadInputStream.readBoolean();
        this.O = loadInputStream.readBoolean();
        this.Z = loadInputStream.readBoolean();
        this.I = loadInputStream.readBoolean();
        this.D = loadInputStream.readBoolean();
        this.interruptible = loadInputStream.readBoolean();
        this.busAkLine.isHigh = loadInputStream.readBoolean();
        this.isIdle = loadInputStream.readBoolean();
    }

    public int tick() {
        if (this.interruptible) {
            if (!this.busRqLine.isHigh) {
                this.busAkLine.isHigh = false;
                this.isIdle = true;
                return 0;
            }
            if (this.I && !this.intrmLine.isHigh) {
                this.intrmLine.isHigh = true;
                this.interruptible = false;
                this.setIndirect(6, this.r[7]);
                this.r[7] = this.interruptAddress;
                return 28;
            }
        } else {
            this.busAkLine.isHigh = true;
        }
        this.interruptible = true;
        boolean bl = this.D;
        this.usedCycles = 0;
        this.decode(this.memoryBus.memory[this.r[7]].peek(this.r[7]));
        if (bl && this.D) {
            this.D = false;
        }
        return this.usedCycles << 2;
    }

    protected void setIndirect(int n, int n2) {
        this.memoryBus.poke(this.r[n], n2);
        if (n == 4 || n == 5 || n == 6 || n == 7) {
            this.r[n] = this.r[n] + 1 & 0xFFFF;
        }
    }

    protected int getIndirect(int n) {
        int n2;
        if (n == 6) {
            this.r[6] = this.r[6] - 1 & 0xFFFF;
            n2 = this.memoryBus.memory[this.r[6]].peek(this.r[6]);
            if (this.D) {
                n2 = n2 & 0xFF | (this.memoryBus.memory[this.r[6]].peek(this.r[6]) & 0xFF) << 8;
            }
        } else if (this.D) {
            n2 = this.memoryBus.memory[this.r[n]].peek(this.r[n]) & 0xFF;
            if (n >= 4) {
                this.r[n] = this.r[n] + 1 & 0xFFFF;
            }
            n2 |= (this.memoryBus.memory[this.r[n]].peek(this.r[n]) & 0xFF) << 8;
            if (n >= 4) {
                this.r[n] = this.r[n] + 1 & 0xFFFF;
            }
        } else {
            n2 = this.memoryBus.memory[this.r[n]].peek(this.r[n]);
            if (n >= 4) {
                this.r[n] = this.r[n] + 1 & 0xFFFF;
            }
        }
        return n2;
    }

    private final void HLT() {
        throw new EmulationException(Intellivision.RESOURCES.getString("ErrorEmulationHalted"));
    }

    private final void SDBD() {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.D = true;
        this.usedCycles += 4;
    }

    private final void EIS() {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.I = true;
        this.usedCycles += 4;
    }

    private final void DIS() {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.I = false;
        this.usedCycles += 4;
    }

    private final void TCI() {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.usedCycles += 4;
    }

    private final void CLRC() {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.C = false;
        this.usedCycles += 4;
    }

    private final void SETC() {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.C = true;
        this.usedCycles += 4;
    }

    private final void J(int n) {
        this.r[7] = n;
        this.usedCycles += 12;
    }

    private final void JSR(int n, int n2) {
        this.r[7] = this.r[7] + 3 & 0xFFFF;
        this.r[n] = this.r[7];
        this.r[7] = n2;
        this.usedCycles += 12;
    }

    private final void JE(int n) {
        this.I = true;
        this.r[7] = n;
        this.usedCycles += 12;
    }

    private final void JSRE(int n, int n2) {
        this.r[7] = this.r[7] + 3 & 0xFFFF;
        this.I = true;
        this.r[n] = this.r[7];
        this.r[7] = n2;
        this.usedCycles += 12;
    }

    private final void JD(int n) {
        this.I = false;
        this.r[7] = n;
        this.usedCycles += 12;
    }

    private final void JSRD(int n, int n2) {
        this.r[7] = this.r[7] + 3 & 0xFFFF;
        this.I = false;
        this.r[n] = this.r[7];
        this.r[7] = n2;
        this.usedCycles += 12;
    }

    private final void INCR(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = this.r[n] + 1 & 0xFFFF;
        this.S = (n2 & 0x8000) != 0;
        this.Z = n2 == 0;
        this.r[n] = n2;
        this.usedCycles += 6;
    }

    private final void DECR(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = this.r[n] + 65535 & 0xFFFF;
        this.S = (n2 & 0x8000) != 0;
        this.Z = n2 == 0;
        this.r[n] = n2;
        this.usedCycles += 6;
    }

    private final void COMR(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = this.r[n] ^ 0xFFFF;
        this.S = (n2 & 0x8000) != 0;
        this.Z = n2 == 0;
        this.r[n] = n2;
        this.usedCycles += 6;
    }

    private final void NEGR(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = this.r[n];
        int n3 = (n2 ^ 0xFFFF) + 1;
        this.C = (n3 & 0x10000) != 0;
        this.O = (n3 & n2 & 0x8000) != 0;
        this.S = ((n3 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n] = n3;
        this.usedCycles += 6;
    }

    private final void ADCR(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = this.r[n];
        int n3 = this.C ? 1 : 0;
        int n4 = n2 + n3;
        this.C = (n4 & 0x10000) != 0;
        this.O = ((n3 ^ n4) & ~(n2 ^ n3) & 0x8000) != 0;
        this.S = ((n4 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n4 == 0;
        this.r[n] = n4;
        this.usedCycles += 6;
    }

    private final void RSWD(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = this.r[n];
        this.S = (n2 & 0x80) != 0;
        this.Z = (n2 & 0x40) != 0;
        this.O = (n2 & 0x20) != 0;
        this.C = (n2 & 0x10) != 0;
        this.usedCycles += 6;
    }

    private final void GSWD(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n2 = ((this.S ? 1 : 0) << 7 | (this.Z ? 1 : 0) << 6 | (this.O ? 1 : 0) << 5 | (this.C ? 1 : 0) << 4) & 0xF0;
        n2 |= n2 << 8;
        this.r[n] = n2;
        this.usedCycles += 6;
    }

    private final void NOP(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.usedCycles += 6;
    }

    private final void SIN(int n) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.usedCycles += 6;
    }

    private final void SWAP(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            this.S = ((n3 = (n3 & 0xFF00) >> 8 | (n3 & 0xFF) << 8) & 0x80) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n4 = this.r[n2] & 0xFF;
            this.S = ((n4 |= n4 << 8) & 0x8000) != 0;
            this.Z = n4 == 0;
            this.r[n2] = n4;
            this.usedCycles += 8;
        }
    }

    private final void SLL(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            this.S = ((n3 = n3 << 1 & 0xFFFF) & 0x8000) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n4 = this.r[n2];
            this.S = ((n4 = n4 << 2 & 0xFFFF) & 0x8000) != 0;
            this.Z = n4 == 0;
            this.r[n2] = n4;
            this.usedCycles += 8;
        }
    }

    private final void RLC(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            int n4 = this.C ? 1 : 0;
            this.C = (n3 & 0x8000) != 0;
            n3 = n3 << 1 & 0xFFFF | n4;
            this.S = (n3 & 0x8000) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n5 = this.r[n2];
            int n6 = this.C ? 1 : 0;
            int n7 = this.O ? 1 : 0;
            this.C = (n5 & 0x8000) != 0;
            this.O = (n5 & 0x4000) != 0;
            n5 = (n5 << 2 | n6 << 1 | n7) & 0xFFFF;
            this.S = (n5 & 0x8000) != 0;
            this.Z = n5 == 0;
            this.r[n2] = n5;
            this.usedCycles += 8;
        }
    }

    private final void SLLC(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            this.C = (n3 & 0x8000) != 0;
            n3 = n3 << 1 & 0xFFFF;
            this.S = (n3 & 0x8000) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n4 = this.r[n2];
            this.C = (n4 & 0x8000) != 0;
            this.O = (n4 & 0x4000) != 0;
            n4 = n4 << 2 & 0xFFFF;
            this.S = (n4 & 0x8000) != 0;
            this.Z = n4 == 0;
            this.r[n2] = n4;
            this.usedCycles += 8;
        }
    }

    private final void SLR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            this.S = ((n3 = n3 >> 1 & Short.MAX_VALUE) & 0x80) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n4 = this.r[n2];
            this.S = ((n4 = n4 >> 2 & 0x3FFF) & 0x80) != 0;
            this.Z = n4 == 0;
            this.r[n2] = n4;
            this.usedCycles += 8;
        }
    }

    private final void SAR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            this.S = ((n3 = n3 >> 1 | n3 & 0x8000) & 0x80) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n4 = this.r[n2];
            int n5 = n4 & 0x8000;
            this.S = ((n4 = n4 >> 2 | n5 | n5 >> 1) & 0x80) != 0;
            this.Z = n4 == 0;
            this.r[n2] = n4;
            this.usedCycles += 8;
        }
    }

    private final void RRC(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            int n4 = this.C ? 1 : 0;
            this.C = (n3 & 1) != 0;
            n3 = n3 >> 1 & Short.MAX_VALUE | n4 << 15;
            this.S = (n3 & 0x80) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n5 = this.r[n2];
            int n6 = this.C ? 1 : 0;
            int n7 = this.O ? 1 : 0;
            this.C = (n5 & 1) != 0;
            this.O = (n5 & 2) != 0;
            n5 = n5 >> 2 & 0x3FFF | n6 << 14 | n7 << 15;
            this.S = (n5 & 0x80) != 0;
            this.Z = n5 == 0;
            this.r[n2] = n5;
            this.usedCycles += 8;
        }
    }

    private final void SARC(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        if (n == 0) {
            int n3 = this.r[n2];
            this.C = (n3 & 1) != 0;
            n3 = n3 >> 1 & Short.MAX_VALUE | n3 & 0x8000;
            this.S = (n3 & 0x80) != 0;
            this.Z = n3 == 0;
            this.r[n2] = n3;
            this.usedCycles += 6;
        } else {
            int n4 = this.r[n2];
            this.C = (n4 & 1) != 0;
            this.O = (n4 & 2) != 0;
            int n5 = n4 & 0x8000;
            n4 = n4 >> 2 & 0x3FFF | n5 | n5 >> 1;
            this.S = (n4 & 0x80) != 0;
            this.Z = n4 == 0;
            this.r[n2] = n4;
            this.usedCycles += 8;
        }
    }

    private final void MOVR(int n, int n2) {
        int n3;
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.r[n2] = n3 = this.r[n];
        this.S = (n3 & 0x8000) != 0;
        this.Z = n3 == 0;
        this.usedCycles += n2 >= 6 ? 7 : 6;
    }

    private final void ADDR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n];
        int n4 = this.r[n2];
        int n5 = n3 + n4;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n4 ^ n5) & ~(n3 ^ n4) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.r[n2] = n5;
        this.usedCycles += 6;
    }

    private final void SUBR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n2];
        int n4 = this.r[n];
        int n5 = n3 + (0xFFFF ^ n4) + 1;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & (n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.r[n2] = n5;
        this.usedCycles += 6;
    }

    private final void CMPR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n2];
        int n4 = this.r[n];
        int n5 = n3 + (0xFFFF ^ n4) + 1;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & (n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.usedCycles += 6;
    }

    private final void ANDR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n2];
        this.S = ((n3 &= this.r[n]) & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n2] = n3;
        this.usedCycles += 6;
    }

    private final void XORR(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n2] ^ this.r[n];
        this.S = (n3 & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n2] = n3;
        this.usedCycles += 6;
    }

    private final void BEXT(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.ext == n) {
            this.r[7] = this.r[7] + n2 & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void B(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        this.r[7] = this.r[7] + n & 0xFFFF;
        this.usedCycles += 9;
    }

    private final void NOPP(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        this.usedCycles += 7;
    }

    private final void BC(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.C) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BNC(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (!this.C) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BOV(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.O) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BNOV(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (!this.O) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BPL(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (!this.S) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BMI(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.S) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BEQ(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.Z) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BNEQ(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (!this.Z) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BLT(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.S != this.O) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BGE(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.S == this.O) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BLE(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.Z || this.S != this.O) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BGT(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (!this.Z && this.S == this.O) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BUSC(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.C != this.S) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void BESC(int n) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        if (this.C == this.S) {
            this.r[7] = this.r[7] + n & 0xFFFF;
            this.usedCycles += 2;
        }
        this.usedCycles += 7;
    }

    private final void MVO(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        this.interruptible = false;
        this.memoryBus.poke(n2, this.r[n]);
        this.usedCycles += 11;
    }

    private final void MVO_ind(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.interruptible = false;
        this.setIndirect(n, this.r[n2]);
        this.usedCycles += 9;
    }

    private final void MVI(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        this.r[n2] = this.memoryBus.memory[n].peek(n);
        this.usedCycles += 10;
    }

    private final void MVI_ind(int n, int n2) {
        int n3;
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        this.r[n2] = n3 = this.getIndirect(n);
        this.usedCycles += this.D ? 10 : (n == 6 ? 11 : 8);
    }

    private final void ADD(int n, int n2) {
        int n3;
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        int n4 = this.memoryBus.memory[n].peek(n);
        int n5 = n4 + (n3 = this.r[n2]);
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & ~(n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.r[n2] = n5;
        this.usedCycles += 10;
    }

    private final void ADD_ind(int n, int n2) {
        int n3;
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n4 = this.getIndirect(n);
        int n5 = n4 + (n3 = this.r[n2]);
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & ~(n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.r[n2] = n5;
        this.usedCycles += this.D ? 10 : (n == 6 ? 11 : 8);
    }

    private final void SUB(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        int n3 = this.r[n2];
        int n4 = this.memoryBus.memory[n].peek(n);
        int n5 = n3 + (0xFFFF ^ n4) + 1;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & (n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.r[n2] = n5;
        this.usedCycles += 10;
    }

    private final void SUB_ind(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n2];
        int n4 = this.getIndirect(n);
        int n5 = n3 + (0xFFFF ^ n4) + 1;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & (n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.r[n2] = n5;
        this.usedCycles += this.D ? 10 : (n == 6 ? 11 : 8);
    }

    private final void CMP(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        int n3 = this.r[n2];
        int n4 = this.memoryBus.memory[n].peek(n);
        int n5 = n3 + (0xFFFF ^ n4) + 1;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & (n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        this.Z = n5 == 0;
        this.usedCycles += 10;
    }

    private final void CMP_ind(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.r[n2];
        int n4 = this.getIndirect(n);
        int n5 = n3 + (0xFFFF ^ n4) + 1;
        this.C = (n5 & 0x10000) != 0;
        this.O = ((n3 ^ n5) & (n4 ^ n3) & 0x8000) != 0;
        this.S = ((n5 &= 0xFFFF) & 0x8000) != 0;
        boolean bl = this.Z = n5 == 0;
        this.usedCycles += this.D ? 10 : (n == 6 ? 11 : 8);
    }

    private final void AND(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        int n3 = this.memoryBus.memory[n].peek(n);
        this.S = ((n3 &= this.r[n2]) & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n2] = n3;
        this.usedCycles += 10;
    }

    private final void AND_ind(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.getIndirect(n);
        this.S = ((n3 &= this.r[n2]) & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n2] = n3;
        this.usedCycles += this.D ? 10 : (n == 6 ? 11 : 8);
    }

    private final void XOR(int n, int n2) {
        this.r[7] = this.r[7] + 2 & 0xFFFF;
        int n3 = this.memoryBus.memory[n].peek(n);
        this.S = ((n3 ^= this.r[n2]) & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n2] = n3;
        this.usedCycles += 10;
    }

    private final void XOR_ind(int n, int n2) {
        this.r[7] = this.r[7] + 1 & 0xFFFF;
        int n3 = this.getIndirect(n);
        this.S = ((n3 ^= this.r[n2]) & 0x8000) != 0;
        this.Z = n3 == 0;
        this.r[n2] = n3;
        this.usedCycles += this.D ? 10 : (n == 6 ? 11 : 8);
    }

    private void decode(int n) {
        switch (n & 0x3FF) {
            case 0: {
                this.HLT();
                break;
            }
            case 1: {
                this.SDBD();
                break;
            }
            case 2: {
                this.EIS();
                break;
            }
            case 3: {
                this.DIS();
                break;
            }
            case 4: {
                int n2 = this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1);
                int n3 = (n2 & 0x300) >> 8;
                int n4 = n2 & 3;
                int n5 = (n2 & 0xFC) << 8;
                n2 = this.memoryBus.memory[this.r[7] + 2].peek(this.r[7] + 2);
                n5 |= n2 & 0x3FF;
                if (n3 == 3) {
                    if (n4 == 0) {
                        this.J(n5);
                        break;
                    }
                    if (n4 == 1) {
                        this.JE(n5);
                        break;
                    }
                    if (n4 == 2) {
                        this.JD(n5);
                        break;
                    }
                    this.HLT();
                    break;
                }
                if (n4 == 0) {
                    this.JSR(n3 + 4, n5);
                    break;
                }
                if (n4 == 1) {
                    this.JSRE(n3 + 4, n5);
                    break;
                }
                if (n4 == 2) {
                    this.JSRD(n3 + 4, n5);
                    break;
                }
                this.HLT();
                break;
            }
            case 5: {
                this.TCI();
                break;
            }
            case 6: {
                this.CLRC();
                break;
            }
            case 7: {
                this.SETC();
                break;
            }
            case 8: {
                this.INCR(0);
                break;
            }
            case 9: {
                this.INCR(1);
                break;
            }
            case 10: {
                this.INCR(2);
                break;
            }
            case 11: {
                this.INCR(3);
                break;
            }
            case 12: {
                this.INCR(4);
                break;
            }
            case 13: {
                this.INCR(5);
                break;
            }
            case 14: {
                this.INCR(6);
                break;
            }
            case 15: {
                this.INCR(7);
                break;
            }
            case 16: {
                this.DECR(0);
                break;
            }
            case 17: {
                this.DECR(1);
                break;
            }
            case 18: {
                this.DECR(2);
                break;
            }
            case 19: {
                this.DECR(3);
                break;
            }
            case 20: {
                this.DECR(4);
                break;
            }
            case 21: {
                this.DECR(5);
                break;
            }
            case 22: {
                this.DECR(6);
                break;
            }
            case 23: {
                this.DECR(7);
                break;
            }
            case 24: {
                this.COMR(0);
                break;
            }
            case 25: {
                this.COMR(1);
                break;
            }
            case 26: {
                this.COMR(2);
                break;
            }
            case 27: {
                this.COMR(3);
                break;
            }
            case 28: {
                this.COMR(4);
                break;
            }
            case 29: {
                this.COMR(5);
                break;
            }
            case 30: {
                this.COMR(6);
                break;
            }
            case 31: {
                this.COMR(7);
                break;
            }
            case 32: {
                this.NEGR(0);
                break;
            }
            case 33: {
                this.NEGR(1);
                break;
            }
            case 34: {
                this.NEGR(2);
                break;
            }
            case 35: {
                this.NEGR(3);
                break;
            }
            case 36: {
                this.NEGR(4);
                break;
            }
            case 37: {
                this.NEGR(5);
                break;
            }
            case 38: {
                this.NEGR(6);
                break;
            }
            case 39: {
                this.NEGR(7);
                break;
            }
            case 40: {
                this.ADCR(0);
                break;
            }
            case 41: {
                this.ADCR(1);
                break;
            }
            case 42: {
                this.ADCR(2);
                break;
            }
            case 43: {
                this.ADCR(3);
                break;
            }
            case 44: {
                this.ADCR(4);
                break;
            }
            case 45: {
                this.ADCR(5);
                break;
            }
            case 46: {
                this.ADCR(6);
                break;
            }
            case 47: {
                this.ADCR(7);
                break;
            }
            case 48: {
                this.GSWD(0);
                break;
            }
            case 49: {
                this.GSWD(1);
                break;
            }
            case 50: {
                this.GSWD(2);
                break;
            }
            case 51: {
                this.GSWD(3);
                break;
            }
            case 52: {
                this.NOP(0);
                break;
            }
            case 53: {
                this.NOP(1);
                break;
            }
            case 54: {
                this.SIN(0);
                break;
            }
            case 55: {
                this.SIN(1);
                break;
            }
            case 56: {
                this.RSWD(0);
                break;
            }
            case 57: {
                this.RSWD(1);
                break;
            }
            case 58: {
                this.RSWD(2);
                break;
            }
            case 59: {
                this.RSWD(3);
                break;
            }
            case 60: {
                this.RSWD(4);
                break;
            }
            case 61: {
                this.RSWD(5);
                break;
            }
            case 62: {
                this.RSWD(6);
                break;
            }
            case 63: {
                this.RSWD(7);
                break;
            }
            case 64: {
                this.SWAP(0, 0);
                break;
            }
            case 65: {
                this.SWAP(0, 1);
                break;
            }
            case 66: {
                this.SWAP(0, 2);
                break;
            }
            case 67: {
                this.SWAP(0, 3);
                break;
            }
            case 68: {
                this.SWAP(1, 0);
                break;
            }
            case 69: {
                this.SWAP(1, 1);
                break;
            }
            case 70: {
                this.SWAP(1, 2);
                break;
            }
            case 71: {
                this.SWAP(1, 3);
                break;
            }
            case 72: {
                this.SLL(0, 0);
                break;
            }
            case 73: {
                this.SLL(0, 1);
                break;
            }
            case 74: {
                this.SLL(0, 2);
                break;
            }
            case 75: {
                this.SLL(0, 3);
                break;
            }
            case 76: {
                this.SLL(1, 0);
                break;
            }
            case 77: {
                this.SLL(1, 1);
                break;
            }
            case 78: {
                this.SLL(1, 2);
                break;
            }
            case 79: {
                this.SLL(1, 3);
                break;
            }
            case 80: {
                this.RLC(0, 0);
                break;
            }
            case 81: {
                this.RLC(0, 1);
                break;
            }
            case 82: {
                this.RLC(0, 2);
                break;
            }
            case 83: {
                this.RLC(0, 3);
                break;
            }
            case 84: {
                this.RLC(1, 0);
                break;
            }
            case 85: {
                this.RLC(1, 1);
                break;
            }
            case 86: {
                this.RLC(1, 2);
                break;
            }
            case 87: {
                this.RLC(1, 3);
                break;
            }
            case 88: {
                this.SLLC(0, 0);
                break;
            }
            case 89: {
                this.SLLC(0, 1);
                break;
            }
            case 90: {
                this.SLLC(0, 2);
                break;
            }
            case 91: {
                this.SLLC(0, 3);
                break;
            }
            case 92: {
                this.SLLC(1, 0);
                break;
            }
            case 93: {
                this.SLLC(1, 1);
                break;
            }
            case 94: {
                this.SLLC(1, 2);
                break;
            }
            case 95: {
                this.SLLC(1, 3);
                break;
            }
            case 96: {
                this.SLR(0, 0);
                break;
            }
            case 97: {
                this.SLR(0, 1);
                break;
            }
            case 98: {
                this.SLR(0, 2);
                break;
            }
            case 99: {
                this.SLR(0, 3);
                break;
            }
            case 100: {
                this.SLR(1, 0);
                break;
            }
            case 101: {
                this.SLR(1, 1);
                break;
            }
            case 102: {
                this.SLR(1, 2);
                break;
            }
            case 103: {
                this.SLR(1, 3);
                break;
            }
            case 104: {
                this.SAR(0, 0);
                break;
            }
            case 105: {
                this.SAR(0, 1);
                break;
            }
            case 106: {
                this.SAR(0, 2);
                break;
            }
            case 107: {
                this.SAR(0, 3);
                break;
            }
            case 108: {
                this.SAR(1, 0);
                break;
            }
            case 109: {
                this.SAR(1, 1);
                break;
            }
            case 110: {
                this.SAR(1, 2);
                break;
            }
            case 111: {
                this.SAR(1, 3);
                break;
            }
            case 112: {
                this.RRC(0, 0);
                break;
            }
            case 113: {
                this.RRC(0, 1);
                break;
            }
            case 114: {
                this.RRC(0, 2);
                break;
            }
            case 115: {
                this.RRC(0, 3);
                break;
            }
            case 116: {
                this.RRC(1, 0);
                break;
            }
            case 117: {
                this.RRC(1, 1);
                break;
            }
            case 118: {
                this.RRC(1, 2);
                break;
            }
            case 119: {
                this.RRC(1, 3);
                break;
            }
            case 120: {
                this.SARC(0, 0);
                break;
            }
            case 121: {
                this.SARC(0, 1);
                break;
            }
            case 122: {
                this.SARC(0, 2);
                break;
            }
            case 123: {
                this.SARC(0, 3);
                break;
            }
            case 124: {
                this.SARC(1, 0);
                break;
            }
            case 125: {
                this.SARC(1, 1);
                break;
            }
            case 126: {
                this.SARC(1, 2);
                break;
            }
            case 127: {
                this.SARC(1, 3);
                break;
            }
            case 128: {
                this.MOVR(0, 0);
                break;
            }
            case 129: {
                this.MOVR(0, 1);
                break;
            }
            case 130: {
                this.MOVR(0, 2);
                break;
            }
            case 131: {
                this.MOVR(0, 3);
                break;
            }
            case 132: {
                this.MOVR(0, 4);
                break;
            }
            case 133: {
                this.MOVR(0, 5);
                break;
            }
            case 134: {
                this.MOVR(0, 6);
                break;
            }
            case 135: {
                this.MOVR(0, 7);
                break;
            }
            case 136: {
                this.MOVR(1, 0);
                break;
            }
            case 137: {
                this.MOVR(1, 1);
                break;
            }
            case 138: {
                this.MOVR(1, 2);
                break;
            }
            case 139: {
                this.MOVR(1, 3);
                break;
            }
            case 140: {
                this.MOVR(1, 4);
                break;
            }
            case 141: {
                this.MOVR(1, 5);
                break;
            }
            case 142: {
                this.MOVR(1, 6);
                break;
            }
            case 143: {
                this.MOVR(1, 7);
                break;
            }
            case 144: {
                this.MOVR(2, 0);
                break;
            }
            case 145: {
                this.MOVR(2, 1);
                break;
            }
            case 146: {
                this.MOVR(2, 2);
                break;
            }
            case 147: {
                this.MOVR(2, 3);
                break;
            }
            case 148: {
                this.MOVR(2, 4);
                break;
            }
            case 149: {
                this.MOVR(2, 5);
                break;
            }
            case 150: {
                this.MOVR(2, 6);
                break;
            }
            case 151: {
                this.MOVR(2, 7);
                break;
            }
            case 152: {
                this.MOVR(3, 0);
                break;
            }
            case 153: {
                this.MOVR(3, 1);
                break;
            }
            case 154: {
                this.MOVR(3, 2);
                break;
            }
            case 155: {
                this.MOVR(3, 3);
                break;
            }
            case 156: {
                this.MOVR(3, 4);
                break;
            }
            case 157: {
                this.MOVR(3, 5);
                break;
            }
            case 158: {
                this.MOVR(3, 6);
                break;
            }
            case 159: {
                this.MOVR(3, 7);
                break;
            }
            case 160: {
                this.MOVR(4, 0);
                break;
            }
            case 161: {
                this.MOVR(4, 1);
                break;
            }
            case 162: {
                this.MOVR(4, 2);
                break;
            }
            case 163: {
                this.MOVR(4, 3);
                break;
            }
            case 164: {
                this.MOVR(4, 4);
                break;
            }
            case 165: {
                this.MOVR(4, 5);
                break;
            }
            case 166: {
                this.MOVR(4, 6);
                break;
            }
            case 167: {
                this.MOVR(4, 7);
                break;
            }
            case 168: {
                this.MOVR(5, 0);
                break;
            }
            case 169: {
                this.MOVR(5, 1);
                break;
            }
            case 170: {
                this.MOVR(5, 2);
                break;
            }
            case 171: {
                this.MOVR(5, 3);
                break;
            }
            case 172: {
                this.MOVR(5, 4);
                break;
            }
            case 173: {
                this.MOVR(5, 5);
                break;
            }
            case 174: {
                this.MOVR(5, 6);
                break;
            }
            case 175: {
                this.MOVR(5, 7);
                break;
            }
            case 176: {
                this.MOVR(6, 0);
                break;
            }
            case 177: {
                this.MOVR(6, 1);
                break;
            }
            case 178: {
                this.MOVR(6, 2);
                break;
            }
            case 179: {
                this.MOVR(6, 3);
                break;
            }
            case 180: {
                this.MOVR(6, 4);
                break;
            }
            case 181: {
                this.MOVR(6, 5);
                break;
            }
            case 182: {
                this.MOVR(6, 6);
                break;
            }
            case 183: {
                this.MOVR(6, 7);
                break;
            }
            case 184: {
                this.MOVR(7, 0);
                break;
            }
            case 185: {
                this.MOVR(7, 1);
                break;
            }
            case 186: {
                this.MOVR(7, 2);
                break;
            }
            case 187: {
                this.MOVR(7, 3);
                break;
            }
            case 188: {
                this.MOVR(7, 4);
                break;
            }
            case 189: {
                this.MOVR(7, 5);
                break;
            }
            case 190: {
                this.MOVR(7, 6);
                break;
            }
            case 191: {
                this.MOVR(7, 7);
                break;
            }
            case 192: {
                this.ADDR(0, 0);
                break;
            }
            case 193: {
                this.ADDR(0, 1);
                break;
            }
            case 194: {
                this.ADDR(0, 2);
                break;
            }
            case 195: {
                this.ADDR(0, 3);
                break;
            }
            case 196: {
                this.ADDR(0, 4);
                break;
            }
            case 197: {
                this.ADDR(0, 5);
                break;
            }
            case 198: {
                this.ADDR(0, 6);
                break;
            }
            case 199: {
                this.ADDR(0, 7);
                break;
            }
            case 200: {
                this.ADDR(1, 0);
                break;
            }
            case 201: {
                this.ADDR(1, 1);
                break;
            }
            case 202: {
                this.ADDR(1, 2);
                break;
            }
            case 203: {
                this.ADDR(1, 3);
                break;
            }
            case 204: {
                this.ADDR(1, 4);
                break;
            }
            case 205: {
                this.ADDR(1, 5);
                break;
            }
            case 206: {
                this.ADDR(1, 6);
                break;
            }
            case 207: {
                this.ADDR(1, 7);
                break;
            }
            case 208: {
                this.ADDR(2, 0);
                break;
            }
            case 209: {
                this.ADDR(2, 1);
                break;
            }
            case 210: {
                this.ADDR(2, 2);
                break;
            }
            case 211: {
                this.ADDR(2, 3);
                break;
            }
            case 212: {
                this.ADDR(2, 4);
                break;
            }
            case 213: {
                this.ADDR(2, 5);
                break;
            }
            case 214: {
                this.ADDR(2, 6);
                break;
            }
            case 215: {
                this.ADDR(2, 7);
                break;
            }
            case 216: {
                this.ADDR(3, 0);
                break;
            }
            case 217: {
                this.ADDR(3, 1);
                break;
            }
            case 218: {
                this.ADDR(3, 2);
                break;
            }
            case 219: {
                this.ADDR(3, 3);
                break;
            }
            case 220: {
                this.ADDR(3, 4);
                break;
            }
            case 221: {
                this.ADDR(3, 5);
                break;
            }
            case 222: {
                this.ADDR(3, 6);
                break;
            }
            case 223: {
                this.ADDR(3, 7);
                break;
            }
            case 224: {
                this.ADDR(4, 0);
                break;
            }
            case 225: {
                this.ADDR(4, 1);
                break;
            }
            case 226: {
                this.ADDR(4, 2);
                break;
            }
            case 227: {
                this.ADDR(4, 3);
                break;
            }
            case 228: {
                this.ADDR(4, 4);
                break;
            }
            case 229: {
                this.ADDR(4, 5);
                break;
            }
            case 230: {
                this.ADDR(4, 6);
                break;
            }
            case 231: {
                this.ADDR(4, 7);
                break;
            }
            case 232: {
                this.ADDR(5, 0);
                break;
            }
            case 233: {
                this.ADDR(5, 1);
                break;
            }
            case 234: {
                this.ADDR(5, 2);
                break;
            }
            case 235: {
                this.ADDR(5, 3);
                break;
            }
            case 236: {
                this.ADDR(5, 4);
                break;
            }
            case 237: {
                this.ADDR(5, 5);
                break;
            }
            case 238: {
                this.ADDR(5, 6);
                break;
            }
            case 239: {
                this.ADDR(5, 7);
                break;
            }
            case 240: {
                this.ADDR(6, 0);
                break;
            }
            case 241: {
                this.ADDR(6, 1);
                break;
            }
            case 242: {
                this.ADDR(6, 2);
                break;
            }
            case 243: {
                this.ADDR(6, 3);
                break;
            }
            case 244: {
                this.ADDR(6, 4);
                break;
            }
            case 245: {
                this.ADDR(6, 5);
                break;
            }
            case 246: {
                this.ADDR(6, 6);
                break;
            }
            case 247: {
                this.ADDR(6, 7);
                break;
            }
            case 248: {
                this.ADDR(7, 0);
                break;
            }
            case 249: {
                this.ADDR(7, 1);
                break;
            }
            case 250: {
                this.ADDR(7, 2);
                break;
            }
            case 251: {
                this.ADDR(7, 3);
                break;
            }
            case 252: {
                this.ADDR(7, 4);
                break;
            }
            case 253: {
                this.ADDR(7, 5);
                break;
            }
            case 254: {
                this.ADDR(7, 6);
                break;
            }
            case 255: {
                this.ADDR(7, 7);
                break;
            }
            case 256: {
                this.SUBR(0, 0);
                break;
            }
            case 257: {
                this.SUBR(0, 1);
                break;
            }
            case 258: {
                this.SUBR(0, 2);
                break;
            }
            case 259: {
                this.SUBR(0, 3);
                break;
            }
            case 260: {
                this.SUBR(0, 4);
                break;
            }
            case 261: {
                this.SUBR(0, 5);
                break;
            }
            case 262: {
                this.SUBR(0, 6);
                break;
            }
            case 263: {
                this.SUBR(0, 7);
                break;
            }
            case 264: {
                this.SUBR(1, 0);
                break;
            }
            case 265: {
                this.SUBR(1, 1);
                break;
            }
            case 266: {
                this.SUBR(1, 2);
                break;
            }
            case 267: {
                this.SUBR(1, 3);
                break;
            }
            case 268: {
                this.SUBR(1, 4);
                break;
            }
            case 269: {
                this.SUBR(1, 5);
                break;
            }
            case 270: {
                this.SUBR(1, 6);
                break;
            }
            case 271: {
                this.SUBR(1, 7);
                break;
            }
            case 272: {
                this.SUBR(2, 0);
                break;
            }
            case 273: {
                this.SUBR(2, 1);
                break;
            }
            case 274: {
                this.SUBR(2, 2);
                break;
            }
            case 275: {
                this.SUBR(2, 3);
                break;
            }
            case 276: {
                this.SUBR(2, 4);
                break;
            }
            case 277: {
                this.SUBR(2, 5);
                break;
            }
            case 278: {
                this.SUBR(2, 6);
                break;
            }
            case 279: {
                this.SUBR(2, 7);
                break;
            }
            case 280: {
                this.SUBR(3, 0);
                break;
            }
            case 281: {
                this.SUBR(3, 1);
                break;
            }
            case 282: {
                this.SUBR(3, 2);
                break;
            }
            case 283: {
                this.SUBR(3, 3);
                break;
            }
            case 284: {
                this.SUBR(3, 4);
                break;
            }
            case 285: {
                this.SUBR(3, 5);
                break;
            }
            case 286: {
                this.SUBR(3, 6);
                break;
            }
            case 287: {
                this.SUBR(3, 7);
                break;
            }
            case 288: {
                this.SUBR(4, 0);
                break;
            }
            case 289: {
                this.SUBR(4, 1);
                break;
            }
            case 290: {
                this.SUBR(4, 2);
                break;
            }
            case 291: {
                this.SUBR(4, 3);
                break;
            }
            case 292: {
                this.SUBR(4, 4);
                break;
            }
            case 293: {
                this.SUBR(4, 5);
                break;
            }
            case 294: {
                this.SUBR(4, 6);
                break;
            }
            case 295: {
                this.SUBR(4, 7);
                break;
            }
            case 296: {
                this.SUBR(5, 0);
                break;
            }
            case 297: {
                this.SUBR(5, 1);
                break;
            }
            case 298: {
                this.SUBR(5, 2);
                break;
            }
            case 299: {
                this.SUBR(5, 3);
                break;
            }
            case 300: {
                this.SUBR(5, 4);
                break;
            }
            case 301: {
                this.SUBR(5, 5);
                break;
            }
            case 302: {
                this.SUBR(5, 6);
                break;
            }
            case 303: {
                this.SUBR(5, 7);
                break;
            }
            case 304: {
                this.SUBR(6, 0);
                break;
            }
            case 305: {
                this.SUBR(6, 1);
                break;
            }
            case 306: {
                this.SUBR(6, 2);
                break;
            }
            case 307: {
                this.SUBR(6, 3);
                break;
            }
            case 308: {
                this.SUBR(6, 4);
                break;
            }
            case 309: {
                this.SUBR(6, 5);
                break;
            }
            case 310: {
                this.SUBR(6, 6);
                break;
            }
            case 311: {
                this.SUBR(6, 7);
                break;
            }
            case 312: {
                this.SUBR(7, 0);
                break;
            }
            case 313: {
                this.SUBR(7, 1);
                break;
            }
            case 314: {
                this.SUBR(7, 2);
                break;
            }
            case 315: {
                this.SUBR(7, 3);
                break;
            }
            case 316: {
                this.SUBR(7, 4);
                break;
            }
            case 317: {
                this.SUBR(7, 5);
                break;
            }
            case 318: {
                this.SUBR(7, 6);
                break;
            }
            case 319: {
                this.SUBR(7, 7);
                break;
            }
            case 320: {
                this.CMPR(0, 0);
                break;
            }
            case 321: {
                this.CMPR(0, 1);
                break;
            }
            case 322: {
                this.CMPR(0, 2);
                break;
            }
            case 323: {
                this.CMPR(0, 3);
                break;
            }
            case 324: {
                this.CMPR(0, 4);
                break;
            }
            case 325: {
                this.CMPR(0, 5);
                break;
            }
            case 326: {
                this.CMPR(0, 6);
                break;
            }
            case 327: {
                this.CMPR(0, 7);
                break;
            }
            case 328: {
                this.CMPR(1, 0);
                break;
            }
            case 329: {
                this.CMPR(1, 1);
                break;
            }
            case 330: {
                this.CMPR(1, 2);
                break;
            }
            case 331: {
                this.CMPR(1, 3);
                break;
            }
            case 332: {
                this.CMPR(1, 4);
                break;
            }
            case 333: {
                this.CMPR(1, 5);
                break;
            }
            case 334: {
                this.CMPR(1, 6);
                break;
            }
            case 335: {
                this.CMPR(1, 7);
                break;
            }
            case 336: {
                this.CMPR(2, 0);
                break;
            }
            case 337: {
                this.CMPR(2, 1);
                break;
            }
            case 338: {
                this.CMPR(2, 2);
                break;
            }
            case 339: {
                this.CMPR(2, 3);
                break;
            }
            case 340: {
                this.CMPR(2, 4);
                break;
            }
            case 341: {
                this.CMPR(2, 5);
                break;
            }
            case 342: {
                this.CMPR(2, 6);
                break;
            }
            case 343: {
                this.CMPR(2, 7);
                break;
            }
            case 344: {
                this.CMPR(3, 0);
                break;
            }
            case 345: {
                this.CMPR(3, 1);
                break;
            }
            case 346: {
                this.CMPR(3, 2);
                break;
            }
            case 347: {
                this.CMPR(3, 3);
                break;
            }
            case 348: {
                this.CMPR(3, 4);
                break;
            }
            case 349: {
                this.CMPR(3, 5);
                break;
            }
            case 350: {
                this.CMPR(3, 6);
                break;
            }
            case 351: {
                this.CMPR(3, 7);
                break;
            }
            case 352: {
                this.CMPR(4, 0);
                break;
            }
            case 353: {
                this.CMPR(4, 1);
                break;
            }
            case 354: {
                this.CMPR(4, 2);
                break;
            }
            case 355: {
                this.CMPR(4, 3);
                break;
            }
            case 356: {
                this.CMPR(4, 4);
                break;
            }
            case 357: {
                this.CMPR(4, 5);
                break;
            }
            case 358: {
                this.CMPR(4, 6);
                break;
            }
            case 359: {
                this.CMPR(4, 7);
                break;
            }
            case 360: {
                this.CMPR(5, 0);
                break;
            }
            case 361: {
                this.CMPR(5, 1);
                break;
            }
            case 362: {
                this.CMPR(5, 2);
                break;
            }
            case 363: {
                this.CMPR(5, 3);
                break;
            }
            case 364: {
                this.CMPR(5, 4);
                break;
            }
            case 365: {
                this.CMPR(5, 5);
                break;
            }
            case 366: {
                this.CMPR(5, 6);
                break;
            }
            case 367: {
                this.CMPR(5, 7);
                break;
            }
            case 368: {
                this.CMPR(6, 0);
                break;
            }
            case 369: {
                this.CMPR(6, 1);
                break;
            }
            case 370: {
                this.CMPR(6, 2);
                break;
            }
            case 371: {
                this.CMPR(6, 3);
                break;
            }
            case 372: {
                this.CMPR(6, 4);
                break;
            }
            case 373: {
                this.CMPR(6, 5);
                break;
            }
            case 374: {
                this.CMPR(6, 6);
                break;
            }
            case 375: {
                this.CMPR(6, 7);
                break;
            }
            case 376: {
                this.CMPR(7, 0);
                break;
            }
            case 377: {
                this.CMPR(7, 1);
                break;
            }
            case 378: {
                this.CMPR(7, 2);
                break;
            }
            case 379: {
                this.CMPR(7, 3);
                break;
            }
            case 380: {
                this.CMPR(7, 4);
                break;
            }
            case 381: {
                this.CMPR(7, 5);
                break;
            }
            case 382: {
                this.CMPR(7, 6);
                break;
            }
            case 383: {
                this.CMPR(7, 7);
                break;
            }
            case 384: {
                this.ANDR(0, 0);
                break;
            }
            case 385: {
                this.ANDR(0, 1);
                break;
            }
            case 386: {
                this.ANDR(0, 2);
                break;
            }
            case 387: {
                this.ANDR(0, 3);
                break;
            }
            case 388: {
                this.ANDR(0, 4);
                break;
            }
            case 389: {
                this.ANDR(0, 5);
                break;
            }
            case 390: {
                this.ANDR(0, 6);
                break;
            }
            case 391: {
                this.ANDR(0, 7);
                break;
            }
            case 392: {
                this.ANDR(1, 0);
                break;
            }
            case 393: {
                this.ANDR(1, 1);
                break;
            }
            case 394: {
                this.ANDR(1, 2);
                break;
            }
            case 395: {
                this.ANDR(1, 3);
                break;
            }
            case 396: {
                this.ANDR(1, 4);
                break;
            }
            case 397: {
                this.ANDR(1, 5);
                break;
            }
            case 398: {
                this.ANDR(1, 6);
                break;
            }
            case 399: {
                this.ANDR(1, 7);
                break;
            }
            case 400: {
                this.ANDR(2, 0);
                break;
            }
            case 401: {
                this.ANDR(2, 1);
                break;
            }
            case 402: {
                this.ANDR(2, 2);
                break;
            }
            case 403: {
                this.ANDR(2, 3);
                break;
            }
            case 404: {
                this.ANDR(2, 4);
                break;
            }
            case 405: {
                this.ANDR(2, 5);
                break;
            }
            case 406: {
                this.ANDR(2, 6);
                break;
            }
            case 407: {
                this.ANDR(2, 7);
                break;
            }
            case 408: {
                this.ANDR(3, 0);
                break;
            }
            case 409: {
                this.ANDR(3, 1);
                break;
            }
            case 410: {
                this.ANDR(3, 2);
                break;
            }
            case 411: {
                this.ANDR(3, 3);
                break;
            }
            case 412: {
                this.ANDR(3, 4);
                break;
            }
            case 413: {
                this.ANDR(3, 5);
                break;
            }
            case 414: {
                this.ANDR(3, 6);
                break;
            }
            case 415: {
                this.ANDR(3, 7);
                break;
            }
            case 416: {
                this.ANDR(4, 0);
                break;
            }
            case 417: {
                this.ANDR(4, 1);
                break;
            }
            case 418: {
                this.ANDR(4, 2);
                break;
            }
            case 419: {
                this.ANDR(4, 3);
                break;
            }
            case 420: {
                this.ANDR(4, 4);
                break;
            }
            case 421: {
                this.ANDR(4, 5);
                break;
            }
            case 422: {
                this.ANDR(4, 6);
                break;
            }
            case 423: {
                this.ANDR(4, 7);
                break;
            }
            case 424: {
                this.ANDR(5, 0);
                break;
            }
            case 425: {
                this.ANDR(5, 1);
                break;
            }
            case 426: {
                this.ANDR(5, 2);
                break;
            }
            case 427: {
                this.ANDR(5, 3);
                break;
            }
            case 428: {
                this.ANDR(5, 4);
                break;
            }
            case 429: {
                this.ANDR(5, 5);
                break;
            }
            case 430: {
                this.ANDR(5, 6);
                break;
            }
            case 431: {
                this.ANDR(5, 7);
                break;
            }
            case 432: {
                this.ANDR(6, 0);
                break;
            }
            case 433: {
                this.ANDR(6, 1);
                break;
            }
            case 434: {
                this.ANDR(6, 2);
                break;
            }
            case 435: {
                this.ANDR(6, 3);
                break;
            }
            case 436: {
                this.ANDR(6, 4);
                break;
            }
            case 437: {
                this.ANDR(6, 5);
                break;
            }
            case 438: {
                this.ANDR(6, 6);
                break;
            }
            case 439: {
                this.ANDR(6, 7);
                break;
            }
            case 440: {
                this.ANDR(7, 0);
                break;
            }
            case 441: {
                this.ANDR(7, 1);
                break;
            }
            case 442: {
                this.ANDR(7, 2);
                break;
            }
            case 443: {
                this.ANDR(7, 3);
                break;
            }
            case 444: {
                this.ANDR(7, 4);
                break;
            }
            case 445: {
                this.ANDR(7, 5);
                break;
            }
            case 446: {
                this.ANDR(7, 6);
                break;
            }
            case 447: {
                this.ANDR(7, 7);
                break;
            }
            case 448: {
                this.XORR(0, 0);
                break;
            }
            case 449: {
                this.XORR(0, 1);
                break;
            }
            case 450: {
                this.XORR(0, 2);
                break;
            }
            case 451: {
                this.XORR(0, 3);
                break;
            }
            case 452: {
                this.XORR(0, 4);
                break;
            }
            case 453: {
                this.XORR(0, 5);
                break;
            }
            case 454: {
                this.XORR(0, 6);
                break;
            }
            case 455: {
                this.XORR(0, 7);
                break;
            }
            case 456: {
                this.XORR(1, 0);
                break;
            }
            case 457: {
                this.XORR(1, 1);
                break;
            }
            case 458: {
                this.XORR(1, 2);
                break;
            }
            case 459: {
                this.XORR(1, 3);
                break;
            }
            case 460: {
                this.XORR(1, 4);
                break;
            }
            case 461: {
                this.XORR(1, 5);
                break;
            }
            case 462: {
                this.XORR(1, 6);
                break;
            }
            case 463: {
                this.XORR(1, 7);
                break;
            }
            case 464: {
                this.XORR(2, 0);
                break;
            }
            case 465: {
                this.XORR(2, 1);
                break;
            }
            case 466: {
                this.XORR(2, 2);
                break;
            }
            case 467: {
                this.XORR(2, 3);
                break;
            }
            case 468: {
                this.XORR(2, 4);
                break;
            }
            case 469: {
                this.XORR(2, 5);
                break;
            }
            case 470: {
                this.XORR(2, 6);
                break;
            }
            case 471: {
                this.XORR(2, 7);
                break;
            }
            case 472: {
                this.XORR(3, 0);
                break;
            }
            case 473: {
                this.XORR(3, 1);
                break;
            }
            case 474: {
                this.XORR(3, 2);
                break;
            }
            case 475: {
                this.XORR(3, 3);
                break;
            }
            case 476: {
                this.XORR(3, 4);
                break;
            }
            case 477: {
                this.XORR(3, 5);
                break;
            }
            case 478: {
                this.XORR(3, 6);
                break;
            }
            case 479: {
                this.XORR(3, 7);
                break;
            }
            case 480: {
                this.XORR(4, 0);
                break;
            }
            case 481: {
                this.XORR(4, 1);
                break;
            }
            case 482: {
                this.XORR(4, 2);
                break;
            }
            case 483: {
                this.XORR(4, 3);
                break;
            }
            case 484: {
                this.XORR(4, 4);
                break;
            }
            case 485: {
                this.XORR(4, 5);
                break;
            }
            case 486: {
                this.XORR(4, 6);
                break;
            }
            case 487: {
                this.XORR(4, 7);
                break;
            }
            case 488: {
                this.XORR(5, 0);
                break;
            }
            case 489: {
                this.XORR(5, 1);
                break;
            }
            case 490: {
                this.XORR(5, 2);
                break;
            }
            case 491: {
                this.XORR(5, 3);
                break;
            }
            case 492: {
                this.XORR(5, 4);
                break;
            }
            case 493: {
                this.XORR(5, 5);
                break;
            }
            case 494: {
                this.XORR(5, 6);
                break;
            }
            case 495: {
                this.XORR(5, 7);
                break;
            }
            case 496: {
                this.XORR(6, 0);
                break;
            }
            case 497: {
                this.XORR(6, 1);
                break;
            }
            case 498: {
                this.XORR(6, 2);
                break;
            }
            case 499: {
                this.XORR(6, 3);
                break;
            }
            case 500: {
                this.XORR(6, 4);
                break;
            }
            case 501: {
                this.XORR(6, 5);
                break;
            }
            case 502: {
                this.XORR(6, 6);
                break;
            }
            case 503: {
                this.XORR(6, 7);
                break;
            }
            case 504: {
                this.XORR(7, 0);
                break;
            }
            case 505: {
                this.XORR(7, 1);
                break;
            }
            case 506: {
                this.XORR(7, 2);
                break;
            }
            case 507: {
                this.XORR(7, 3);
                break;
            }
            case 508: {
                this.XORR(7, 4);
                break;
            }
            case 509: {
                this.XORR(7, 5);
                break;
            }
            case 510: {
                this.XORR(7, 6);
                break;
            }
            case 511: {
                this.XORR(7, 7);
                break;
            }
            case 512: {
                this.B(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 513: {
                this.BC(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 514: {
                this.BOV(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 515: {
                this.BPL(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 516: {
                this.BEQ(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 517: {
                this.BLT(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 518: {
                this.BLE(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 519: {
                this.BUSC(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 520: {
                this.NOPP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 521: {
                this.BNC(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 522: {
                this.BNOV(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 523: {
                this.BMI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 524: {
                this.BNEQ(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 525: {
                this.BGE(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 526: {
                this.BGT(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 527: {
                this.BESC(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 528: {
                this.BEXT(0, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 529: {
                this.BEXT(1, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 530: {
                this.BEXT(2, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 531: {
                this.BEXT(3, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 532: {
                this.BEXT(4, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 533: {
                this.BEXT(5, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 534: {
                this.BEXT(6, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 535: {
                this.BEXT(7, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 536: {
                this.BEXT(8, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 537: {
                this.BEXT(9, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 538: {
                this.BEXT(10, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 539: {
                this.BEXT(11, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 540: {
                this.BEXT(12, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 541: {
                this.BEXT(13, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 542: {
                this.BEXT(14, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 543: {
                this.BEXT(15, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 544: {
                this.B(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 545: {
                this.BC(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 546: {
                this.BOV(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 547: {
                this.BPL(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 548: {
                this.BEQ(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 549: {
                this.BLT(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 550: {
                this.BLE(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 551: {
                this.BUSC(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 552: {
                this.NOPP(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 553: {
                this.BNC(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 554: {
                this.BNOV(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 555: {
                this.BMI(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 556: {
                this.BNEQ(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 557: {
                this.BGE(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 558: {
                this.BGT(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 559: {
                this.BESC(-this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 560: {
                this.BEXT(0, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 561: {
                this.BEXT(1, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 562: {
                this.BEXT(2, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 563: {
                this.BEXT(3, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 564: {
                this.BEXT(4, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 565: {
                this.BEXT(5, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 566: {
                this.BEXT(6, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 567: {
                this.BEXT(7, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 568: {
                this.BEXT(8, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 569: {
                this.BEXT(9, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 570: {
                this.BEXT(10, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 571: {
                this.BEXT(11, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 572: {
                this.BEXT(12, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 573: {
                this.BEXT(13, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 574: {
                this.BEXT(14, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 575: {
                this.BEXT(15, -this.memoryBus.memory[this.r[7] - 1].peek(this.r[7] + 1) - 1);
                break;
            }
            case 576: {
                this.MVO(0, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 577: {
                this.MVO(1, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 578: {
                this.MVO(2, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 579: {
                this.MVO(3, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 580: {
                this.MVO(4, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 581: {
                this.MVO(5, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 582: {
                this.MVO(6, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 583: {
                this.MVO(7, this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1));
                break;
            }
            case 584: {
                this.MVO_ind(1, 0);
                break;
            }
            case 585: {
                this.MVO_ind(1, 1);
                break;
            }
            case 586: {
                this.MVO_ind(1, 2);
                break;
            }
            case 587: {
                this.MVO_ind(1, 3);
                break;
            }
            case 588: {
                this.MVO_ind(1, 4);
                break;
            }
            case 589: {
                this.MVO_ind(1, 5);
                break;
            }
            case 590: {
                this.MVO_ind(1, 6);
                break;
            }
            case 591: {
                this.MVO_ind(1, 7);
                break;
            }
            case 592: {
                this.MVO_ind(2, 0);
                break;
            }
            case 593: {
                this.MVO_ind(2, 1);
                break;
            }
            case 594: {
                this.MVO_ind(2, 2);
                break;
            }
            case 595: {
                this.MVO_ind(2, 3);
                break;
            }
            case 596: {
                this.MVO_ind(2, 4);
                break;
            }
            case 597: {
                this.MVO_ind(2, 5);
                break;
            }
            case 598: {
                this.MVO_ind(2, 6);
                break;
            }
            case 599: {
                this.MVO_ind(2, 7);
                break;
            }
            case 600: {
                this.MVO_ind(3, 0);
                break;
            }
            case 601: {
                this.MVO_ind(3, 1);
                break;
            }
            case 602: {
                this.MVO_ind(3, 2);
                break;
            }
            case 603: {
                this.MVO_ind(3, 3);
                break;
            }
            case 604: {
                this.MVO_ind(3, 4);
                break;
            }
            case 605: {
                this.MVO_ind(3, 5);
                break;
            }
            case 606: {
                this.MVO_ind(3, 6);
                break;
            }
            case 607: {
                this.MVO_ind(3, 7);
                break;
            }
            case 608: {
                this.MVO_ind(4, 0);
                break;
            }
            case 609: {
                this.MVO_ind(4, 1);
                break;
            }
            case 610: {
                this.MVO_ind(4, 2);
                break;
            }
            case 611: {
                this.MVO_ind(4, 3);
                break;
            }
            case 612: {
                this.MVO_ind(4, 4);
                break;
            }
            case 613: {
                this.MVO_ind(4, 5);
                break;
            }
            case 614: {
                this.MVO_ind(4, 6);
                break;
            }
            case 615: {
                this.MVO_ind(4, 7);
                break;
            }
            case 616: {
                this.MVO_ind(5, 0);
                break;
            }
            case 617: {
                this.MVO_ind(5, 1);
                break;
            }
            case 618: {
                this.MVO_ind(5, 2);
                break;
            }
            case 619: {
                this.MVO_ind(5, 3);
                break;
            }
            case 620: {
                this.MVO_ind(5, 4);
                break;
            }
            case 621: {
                this.MVO_ind(5, 5);
                break;
            }
            case 622: {
                this.MVO_ind(5, 6);
                break;
            }
            case 623: {
                this.MVO_ind(5, 7);
                break;
            }
            case 624: {
                this.MVO_ind(6, 0);
                break;
            }
            case 625: {
                this.MVO_ind(6, 1);
                break;
            }
            case 626: {
                this.MVO_ind(6, 2);
                break;
            }
            case 627: {
                this.MVO_ind(6, 3);
                break;
            }
            case 628: {
                this.MVO_ind(6, 4);
                break;
            }
            case 629: {
                this.MVO_ind(6, 5);
                break;
            }
            case 630: {
                this.MVO_ind(6, 6);
                break;
            }
            case 631: {
                this.MVO_ind(6, 7);
                break;
            }
            case 632: {
                this.MVO_ind(7, 0);
                break;
            }
            case 633: {
                this.MVO_ind(7, 1);
                break;
            }
            case 634: {
                this.MVO_ind(7, 2);
                break;
            }
            case 635: {
                this.MVO_ind(7, 3);
                break;
            }
            case 636: {
                this.MVO_ind(7, 4);
                break;
            }
            case 637: {
                this.MVO_ind(7, 5);
                break;
            }
            case 638: {
                this.MVO_ind(7, 6);
                break;
            }
            case 639: {
                this.MVO_ind(7, 7);
                break;
            }
            case 640: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 0);
                break;
            }
            case 641: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 1);
                break;
            }
            case 642: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 2);
                break;
            }
            case 643: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 3);
                break;
            }
            case 644: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 4);
                break;
            }
            case 645: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 5);
                break;
            }
            case 646: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 6);
                break;
            }
            case 647: {
                this.MVI(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 7);
                break;
            }
            case 648: {
                this.MVI_ind(1, 0);
                break;
            }
            case 649: {
                this.MVI_ind(1, 1);
                break;
            }
            case 650: {
                this.MVI_ind(1, 2);
                break;
            }
            case 651: {
                this.MVI_ind(1, 3);
                break;
            }
            case 652: {
                this.MVI_ind(1, 4);
                break;
            }
            case 653: {
                this.MVI_ind(1, 5);
                break;
            }
            case 654: {
                this.MVI_ind(1, 6);
                break;
            }
            case 655: {
                this.MVI_ind(1, 7);
                break;
            }
            case 656: {
                this.MVI_ind(2, 0);
                break;
            }
            case 657: {
                this.MVI_ind(2, 1);
                break;
            }
            case 658: {
                this.MVI_ind(2, 2);
                break;
            }
            case 659: {
                this.MVI_ind(2, 3);
                break;
            }
            case 660: {
                this.MVI_ind(2, 4);
                break;
            }
            case 661: {
                this.MVI_ind(2, 5);
                break;
            }
            case 662: {
                this.MVI_ind(2, 6);
                break;
            }
            case 663: {
                this.MVI_ind(2, 7);
                break;
            }
            case 664: {
                this.MVI_ind(3, 0);
                break;
            }
            case 665: {
                this.MVI_ind(3, 1);
                break;
            }
            case 666: {
                this.MVI_ind(3, 2);
                break;
            }
            case 667: {
                this.MVI_ind(3, 3);
                break;
            }
            case 668: {
                this.MVI_ind(3, 4);
                break;
            }
            case 669: {
                this.MVI_ind(3, 5);
                break;
            }
            case 670: {
                this.MVI_ind(3, 6);
                break;
            }
            case 671: {
                this.MVI_ind(3, 7);
                break;
            }
            case 672: {
                this.MVI_ind(4, 0);
                break;
            }
            case 673: {
                this.MVI_ind(4, 1);
                break;
            }
            case 674: {
                this.MVI_ind(4, 2);
                break;
            }
            case 675: {
                this.MVI_ind(4, 3);
                break;
            }
            case 676: {
                this.MVI_ind(4, 4);
                break;
            }
            case 677: {
                this.MVI_ind(4, 5);
                break;
            }
            case 678: {
                this.MVI_ind(4, 6);
                break;
            }
            case 679: {
                this.MVI_ind(4, 7);
                break;
            }
            case 680: {
                this.MVI_ind(5, 0);
                break;
            }
            case 681: {
                this.MVI_ind(5, 1);
                break;
            }
            case 682: {
                this.MVI_ind(5, 2);
                break;
            }
            case 683: {
                this.MVI_ind(5, 3);
                break;
            }
            case 684: {
                this.MVI_ind(5, 4);
                break;
            }
            case 685: {
                this.MVI_ind(5, 5);
                break;
            }
            case 686: {
                this.MVI_ind(5, 6);
                break;
            }
            case 687: {
                this.MVI_ind(5, 7);
                break;
            }
            case 688: {
                this.MVI_ind(6, 0);
                break;
            }
            case 689: {
                this.MVI_ind(6, 1);
                break;
            }
            case 690: {
                this.MVI_ind(6, 2);
                break;
            }
            case 691: {
                this.MVI_ind(6, 3);
                break;
            }
            case 692: {
                this.MVI_ind(6, 4);
                break;
            }
            case 693: {
                this.MVI_ind(6, 5);
                break;
            }
            case 694: {
                this.MVI_ind(6, 6);
                break;
            }
            case 695: {
                this.MVI_ind(6, 7);
                break;
            }
            case 696: {
                this.MVI_ind(7, 0);
                break;
            }
            case 697: {
                this.MVI_ind(7, 1);
                break;
            }
            case 698: {
                this.MVI_ind(7, 2);
                break;
            }
            case 699: {
                this.MVI_ind(7, 3);
                break;
            }
            case 700: {
                this.MVI_ind(7, 4);
                break;
            }
            case 701: {
                this.MVI_ind(7, 5);
                break;
            }
            case 702: {
                this.MVI_ind(7, 6);
                break;
            }
            case 703: {
                this.MVI_ind(7, 7);
                break;
            }
            case 704: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 0);
                break;
            }
            case 705: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 1);
                break;
            }
            case 706: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 2);
                break;
            }
            case 707: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 3);
                break;
            }
            case 708: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 4);
                break;
            }
            case 709: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 5);
                break;
            }
            case 710: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 6);
                break;
            }
            case 711: {
                this.ADD(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 7);
                break;
            }
            case 712: {
                this.ADD_ind(1, 0);
                break;
            }
            case 713: {
                this.ADD_ind(1, 1);
                break;
            }
            case 714: {
                this.ADD_ind(1, 2);
                break;
            }
            case 715: {
                this.ADD_ind(1, 3);
                break;
            }
            case 716: {
                this.ADD_ind(1, 4);
                break;
            }
            case 717: {
                this.ADD_ind(1, 5);
                break;
            }
            case 718: {
                this.ADD_ind(1, 6);
                break;
            }
            case 719: {
                this.ADD_ind(1, 7);
                break;
            }
            case 720: {
                this.ADD_ind(2, 0);
                break;
            }
            case 721: {
                this.ADD_ind(2, 1);
                break;
            }
            case 722: {
                this.ADD_ind(2, 2);
                break;
            }
            case 723: {
                this.ADD_ind(2, 3);
                break;
            }
            case 724: {
                this.ADD_ind(2, 4);
                break;
            }
            case 725: {
                this.ADD_ind(2, 5);
                break;
            }
            case 726: {
                this.ADD_ind(2, 6);
                break;
            }
            case 727: {
                this.ADD_ind(2, 7);
                break;
            }
            case 728: {
                this.ADD_ind(3, 0);
                break;
            }
            case 729: {
                this.ADD_ind(3, 1);
                break;
            }
            case 730: {
                this.ADD_ind(3, 2);
                break;
            }
            case 731: {
                this.ADD_ind(3, 3);
                break;
            }
            case 732: {
                this.ADD_ind(3, 4);
                break;
            }
            case 733: {
                this.ADD_ind(3, 5);
                break;
            }
            case 734: {
                this.ADD_ind(3, 6);
                break;
            }
            case 735: {
                this.ADD_ind(3, 7);
                break;
            }
            case 736: {
                this.ADD_ind(4, 0);
                break;
            }
            case 737: {
                this.ADD_ind(4, 1);
                break;
            }
            case 738: {
                this.ADD_ind(4, 2);
                break;
            }
            case 739: {
                this.ADD_ind(4, 3);
                break;
            }
            case 740: {
                this.ADD_ind(4, 4);
                break;
            }
            case 741: {
                this.ADD_ind(4, 5);
                break;
            }
            case 742: {
                this.ADD_ind(4, 6);
                break;
            }
            case 743: {
                this.ADD_ind(4, 7);
                break;
            }
            case 744: {
                this.ADD_ind(5, 0);
                break;
            }
            case 745: {
                this.ADD_ind(5, 1);
                break;
            }
            case 746: {
                this.ADD_ind(5, 2);
                break;
            }
            case 747: {
                this.ADD_ind(5, 3);
                break;
            }
            case 748: {
                this.ADD_ind(5, 4);
                break;
            }
            case 749: {
                this.ADD_ind(5, 5);
                break;
            }
            case 750: {
                this.ADD_ind(5, 6);
                break;
            }
            case 751: {
                this.ADD_ind(5, 7);
                break;
            }
            case 752: {
                this.ADD_ind(6, 0);
                break;
            }
            case 753: {
                this.ADD_ind(6, 1);
                break;
            }
            case 754: {
                this.ADD_ind(6, 2);
                break;
            }
            case 755: {
                this.ADD_ind(6, 3);
                break;
            }
            case 756: {
                this.ADD_ind(6, 4);
                break;
            }
            case 757: {
                this.ADD_ind(6, 5);
                break;
            }
            case 758: {
                this.ADD_ind(6, 6);
                break;
            }
            case 759: {
                this.ADD_ind(6, 7);
                break;
            }
            case 760: {
                this.ADD_ind(7, 0);
                break;
            }
            case 761: {
                this.ADD_ind(7, 1);
                break;
            }
            case 762: {
                this.ADD_ind(7, 2);
                break;
            }
            case 763: {
                this.ADD_ind(7, 3);
                break;
            }
            case 764: {
                this.ADD_ind(7, 4);
                break;
            }
            case 765: {
                this.ADD_ind(7, 5);
                break;
            }
            case 766: {
                this.ADD_ind(7, 6);
                break;
            }
            case 767: {
                this.ADD_ind(7, 7);
                break;
            }
            case 768: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 0);
                break;
            }
            case 769: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 1);
                break;
            }
            case 770: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 2);
                break;
            }
            case 771: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 3);
                break;
            }
            case 772: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 4);
                break;
            }
            case 773: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 5);
                break;
            }
            case 774: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 6);
                break;
            }
            case 775: {
                this.SUB(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 7);
                break;
            }
            case 776: {
                this.SUB_ind(1, 0);
                break;
            }
            case 777: {
                this.SUB_ind(1, 1);
                break;
            }
            case 778: {
                this.SUB_ind(1, 2);
                break;
            }
            case 779: {
                this.SUB_ind(1, 3);
                break;
            }
            case 780: {
                this.SUB_ind(1, 4);
                break;
            }
            case 781: {
                this.SUB_ind(1, 5);
                break;
            }
            case 782: {
                this.SUB_ind(1, 6);
                break;
            }
            case 783: {
                this.SUB_ind(1, 7);
                break;
            }
            case 784: {
                this.SUB_ind(2, 0);
                break;
            }
            case 785: {
                this.SUB_ind(2, 1);
                break;
            }
            case 786: {
                this.SUB_ind(2, 2);
                break;
            }
            case 787: {
                this.SUB_ind(2, 3);
                break;
            }
            case 788: {
                this.SUB_ind(2, 4);
                break;
            }
            case 789: {
                this.SUB_ind(2, 5);
                break;
            }
            case 790: {
                this.SUB_ind(2, 6);
                break;
            }
            case 791: {
                this.SUB_ind(2, 7);
                break;
            }
            case 792: {
                this.SUB_ind(3, 0);
                break;
            }
            case 793: {
                this.SUB_ind(3, 1);
                break;
            }
            case 794: {
                this.SUB_ind(3, 2);
                break;
            }
            case 795: {
                this.SUB_ind(3, 3);
                break;
            }
            case 796: {
                this.SUB_ind(3, 4);
                break;
            }
            case 797: {
                this.SUB_ind(3, 5);
                break;
            }
            case 798: {
                this.SUB_ind(3, 6);
                break;
            }
            case 799: {
                this.SUB_ind(3, 7);
                break;
            }
            case 800: {
                this.SUB_ind(4, 0);
                break;
            }
            case 801: {
                this.SUB_ind(4, 1);
                break;
            }
            case 802: {
                this.SUB_ind(4, 2);
                break;
            }
            case 803: {
                this.SUB_ind(4, 3);
                break;
            }
            case 804: {
                this.SUB_ind(4, 4);
                break;
            }
            case 805: {
                this.SUB_ind(4, 5);
                break;
            }
            case 806: {
                this.SUB_ind(4, 6);
                break;
            }
            case 807: {
                this.SUB_ind(4, 7);
                break;
            }
            case 808: {
                this.SUB_ind(5, 0);
                break;
            }
            case 809: {
                this.SUB_ind(5, 1);
                break;
            }
            case 810: {
                this.SUB_ind(5, 2);
                break;
            }
            case 811: {
                this.SUB_ind(5, 3);
                break;
            }
            case 812: {
                this.SUB_ind(5, 4);
                break;
            }
            case 813: {
                this.SUB_ind(5, 5);
                break;
            }
            case 814: {
                this.SUB_ind(5, 6);
                break;
            }
            case 815: {
                this.SUB_ind(5, 7);
                break;
            }
            case 816: {
                this.SUB_ind(6, 0);
                break;
            }
            case 817: {
                this.SUB_ind(6, 1);
                break;
            }
            case 818: {
                this.SUB_ind(6, 2);
                break;
            }
            case 819: {
                this.SUB_ind(6, 3);
                break;
            }
            case 820: {
                this.SUB_ind(6, 4);
                break;
            }
            case 821: {
                this.SUB_ind(6, 5);
                break;
            }
            case 822: {
                this.SUB_ind(6, 6);
                break;
            }
            case 823: {
                this.SUB_ind(6, 7);
                break;
            }
            case 824: {
                this.SUB_ind(7, 0);
                break;
            }
            case 825: {
                this.SUB_ind(7, 1);
                break;
            }
            case 826: {
                this.SUB_ind(7, 2);
                break;
            }
            case 827: {
                this.SUB_ind(7, 3);
                break;
            }
            case 828: {
                this.SUB_ind(7, 4);
                break;
            }
            case 829: {
                this.SUB_ind(7, 5);
                break;
            }
            case 830: {
                this.SUB_ind(7, 6);
                break;
            }
            case 831: {
                this.SUB_ind(7, 7);
                break;
            }
            case 832: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 0);
                break;
            }
            case 833: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 1);
                break;
            }
            case 834: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 2);
                break;
            }
            case 835: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 3);
                break;
            }
            case 836: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 4);
                break;
            }
            case 837: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 5);
                break;
            }
            case 838: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 6);
                break;
            }
            case 839: {
                this.CMP(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 7);
                break;
            }
            case 840: {
                this.CMP_ind(1, 0);
                break;
            }
            case 841: {
                this.CMP_ind(1, 1);
                break;
            }
            case 842: {
                this.CMP_ind(1, 2);
                break;
            }
            case 843: {
                this.CMP_ind(1, 3);
                break;
            }
            case 844: {
                this.CMP_ind(1, 4);
                break;
            }
            case 845: {
                this.CMP_ind(1, 5);
                break;
            }
            case 846: {
                this.CMP_ind(1, 6);
                break;
            }
            case 847: {
                this.CMP_ind(1, 7);
                break;
            }
            case 848: {
                this.CMP_ind(2, 0);
                break;
            }
            case 849: {
                this.CMP_ind(2, 1);
                break;
            }
            case 850: {
                this.CMP_ind(2, 2);
                break;
            }
            case 851: {
                this.CMP_ind(2, 3);
                break;
            }
            case 852: {
                this.CMP_ind(2, 4);
                break;
            }
            case 853: {
                this.CMP_ind(2, 5);
                break;
            }
            case 854: {
                this.CMP_ind(2, 6);
                break;
            }
            case 855: {
                this.CMP_ind(2, 7);
                break;
            }
            case 856: {
                this.CMP_ind(3, 0);
                break;
            }
            case 857: {
                this.CMP_ind(3, 1);
                break;
            }
            case 858: {
                this.CMP_ind(3, 2);
                break;
            }
            case 859: {
                this.CMP_ind(3, 3);
                break;
            }
            case 860: {
                this.CMP_ind(3, 4);
                break;
            }
            case 861: {
                this.CMP_ind(3, 5);
                break;
            }
            case 862: {
                this.CMP_ind(3, 6);
                break;
            }
            case 863: {
                this.CMP_ind(3, 7);
                break;
            }
            case 864: {
                this.CMP_ind(4, 0);
                break;
            }
            case 865: {
                this.CMP_ind(4, 1);
                break;
            }
            case 866: {
                this.CMP_ind(4, 2);
                break;
            }
            case 867: {
                this.CMP_ind(4, 3);
                break;
            }
            case 868: {
                this.CMP_ind(4, 4);
                break;
            }
            case 869: {
                this.CMP_ind(4, 5);
                break;
            }
            case 870: {
                this.CMP_ind(4, 6);
                break;
            }
            case 871: {
                this.CMP_ind(4, 7);
                break;
            }
            case 872: {
                this.CMP_ind(5, 0);
                break;
            }
            case 873: {
                this.CMP_ind(5, 1);
                break;
            }
            case 874: {
                this.CMP_ind(5, 2);
                break;
            }
            case 875: {
                this.CMP_ind(5, 3);
                break;
            }
            case 876: {
                this.CMP_ind(5, 4);
                break;
            }
            case 877: {
                this.CMP_ind(5, 5);
                break;
            }
            case 878: {
                this.CMP_ind(5, 6);
                break;
            }
            case 879: {
                this.CMP_ind(5, 7);
                break;
            }
            case 880: {
                this.CMP_ind(6, 0);
                break;
            }
            case 881: {
                this.CMP_ind(6, 1);
                break;
            }
            case 882: {
                this.CMP_ind(6, 2);
                break;
            }
            case 883: {
                this.CMP_ind(6, 3);
                break;
            }
            case 884: {
                this.CMP_ind(6, 4);
                break;
            }
            case 885: {
                this.CMP_ind(6, 5);
                break;
            }
            case 886: {
                this.CMP_ind(6, 6);
                break;
            }
            case 887: {
                this.CMP_ind(6, 7);
                break;
            }
            case 888: {
                this.CMP_ind(7, 0);
                break;
            }
            case 889: {
                this.CMP_ind(7, 1);
                break;
            }
            case 890: {
                this.CMP_ind(7, 2);
                break;
            }
            case 891: {
                this.CMP_ind(7, 3);
                break;
            }
            case 892: {
                this.CMP_ind(7, 4);
                break;
            }
            case 893: {
                this.CMP_ind(7, 5);
                break;
            }
            case 894: {
                this.CMP_ind(7, 6);
                break;
            }
            case 895: {
                this.CMP_ind(7, 7);
                break;
            }
            case 896: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 0);
                break;
            }
            case 897: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 1);
                break;
            }
            case 898: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 2);
                break;
            }
            case 899: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 3);
                break;
            }
            case 900: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 4);
                break;
            }
            case 901: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 5);
                break;
            }
            case 902: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 6);
                break;
            }
            case 903: {
                this.AND(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 7);
                break;
            }
            case 904: {
                this.AND_ind(1, 0);
                break;
            }
            case 905: {
                this.AND_ind(1, 1);
                break;
            }
            case 906: {
                this.AND_ind(1, 2);
                break;
            }
            case 907: {
                this.AND_ind(1, 3);
                break;
            }
            case 908: {
                this.AND_ind(1, 4);
                break;
            }
            case 909: {
                this.AND_ind(1, 5);
                break;
            }
            case 910: {
                this.AND_ind(1, 6);
                break;
            }
            case 911: {
                this.AND_ind(1, 7);
                break;
            }
            case 912: {
                this.AND_ind(2, 0);
                break;
            }
            case 913: {
                this.AND_ind(2, 1);
                break;
            }
            case 914: {
                this.AND_ind(2, 2);
                break;
            }
            case 915: {
                this.AND_ind(2, 3);
                break;
            }
            case 916: {
                this.AND_ind(2, 4);
                break;
            }
            case 917: {
                this.AND_ind(2, 5);
                break;
            }
            case 918: {
                this.AND_ind(2, 6);
                break;
            }
            case 919: {
                this.AND_ind(2, 7);
                break;
            }
            case 920: {
                this.AND_ind(3, 0);
                break;
            }
            case 921: {
                this.AND_ind(3, 1);
                break;
            }
            case 922: {
                this.AND_ind(3, 2);
                break;
            }
            case 923: {
                this.AND_ind(3, 3);
                break;
            }
            case 924: {
                this.AND_ind(3, 4);
                break;
            }
            case 925: {
                this.AND_ind(3, 5);
                break;
            }
            case 926: {
                this.AND_ind(3, 6);
                break;
            }
            case 927: {
                this.AND_ind(3, 7);
                break;
            }
            case 928: {
                this.AND_ind(4, 0);
                break;
            }
            case 929: {
                this.AND_ind(4, 1);
                break;
            }
            case 930: {
                this.AND_ind(4, 2);
                break;
            }
            case 931: {
                this.AND_ind(4, 3);
                break;
            }
            case 932: {
                this.AND_ind(4, 4);
                break;
            }
            case 933: {
                this.AND_ind(4, 5);
                break;
            }
            case 934: {
                this.AND_ind(4, 6);
                break;
            }
            case 935: {
                this.AND_ind(4, 7);
                break;
            }
            case 936: {
                this.AND_ind(5, 0);
                break;
            }
            case 937: {
                this.AND_ind(5, 1);
                break;
            }
            case 938: {
                this.AND_ind(5, 2);
                break;
            }
            case 939: {
                this.AND_ind(5, 3);
                break;
            }
            case 940: {
                this.AND_ind(5, 4);
                break;
            }
            case 941: {
                this.AND_ind(5, 5);
                break;
            }
            case 942: {
                this.AND_ind(5, 6);
                break;
            }
            case 943: {
                this.AND_ind(5, 7);
                break;
            }
            case 944: {
                this.AND_ind(6, 0);
                break;
            }
            case 945: {
                this.AND_ind(6, 1);
                break;
            }
            case 946: {
                this.AND_ind(6, 2);
                break;
            }
            case 947: {
                this.AND_ind(6, 3);
                break;
            }
            case 948: {
                this.AND_ind(6, 4);
                break;
            }
            case 949: {
                this.AND_ind(6, 5);
                break;
            }
            case 950: {
                this.AND_ind(6, 6);
                break;
            }
            case 951: {
                this.AND_ind(6, 7);
                break;
            }
            case 952: {
                this.AND_ind(7, 0);
                break;
            }
            case 953: {
                this.AND_ind(7, 1);
                break;
            }
            case 954: {
                this.AND_ind(7, 2);
                break;
            }
            case 955: {
                this.AND_ind(7, 3);
                break;
            }
            case 956: {
                this.AND_ind(7, 4);
                break;
            }
            case 957: {
                this.AND_ind(7, 5);
                break;
            }
            case 958: {
                this.AND_ind(7, 6);
                break;
            }
            case 959: {
                this.AND_ind(7, 7);
                break;
            }
            case 960: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 0);
                break;
            }
            case 961: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 1);
                break;
            }
            case 962: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 2);
                break;
            }
            case 963: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 3);
                break;
            }
            case 964: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 4);
                break;
            }
            case 965: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 5);
                break;
            }
            case 966: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 6);
                break;
            }
            case 967: {
                this.XOR(this.memoryBus.memory[this.r[7] + 1].peek(this.r[7] + 1), 7);
                break;
            }
            case 968: {
                this.XOR_ind(1, 0);
                break;
            }
            case 969: {
                this.XOR_ind(1, 1);
                break;
            }
            case 970: {
                this.XOR_ind(1, 2);
                break;
            }
            case 971: {
                this.XOR_ind(1, 3);
                break;
            }
            case 972: {
                this.XOR_ind(1, 4);
                break;
            }
            case 973: {
                this.XOR_ind(1, 5);
                break;
            }
            case 974: {
                this.XOR_ind(1, 6);
                break;
            }
            case 975: {
                this.XOR_ind(1, 7);
                break;
            }
            case 976: {
                this.XOR_ind(2, 0);
                break;
            }
            case 977: {
                this.XOR_ind(2, 1);
                break;
            }
            case 978: {
                this.XOR_ind(2, 2);
                break;
            }
            case 979: {
                this.XOR_ind(2, 3);
                break;
            }
            case 980: {
                this.XOR_ind(2, 4);
                break;
            }
            case 981: {
                this.XOR_ind(2, 5);
                break;
            }
            case 982: {
                this.XOR_ind(2, 6);
                break;
            }
            case 983: {
                this.XOR_ind(2, 7);
                break;
            }
            case 984: {
                this.XOR_ind(3, 0);
                break;
            }
            case 985: {
                this.XOR_ind(3, 1);
                break;
            }
            case 986: {
                this.XOR_ind(3, 2);
                break;
            }
            case 987: {
                this.XOR_ind(3, 3);
                break;
            }
            case 988: {
                this.XOR_ind(3, 4);
                break;
            }
            case 989: {
                this.XOR_ind(3, 5);
                break;
            }
            case 990: {
                this.XOR_ind(3, 6);
                break;
            }
            case 991: {
                this.XOR_ind(3, 7);
                break;
            }
            case 992: {
                this.XOR_ind(4, 0);
                break;
            }
            case 993: {
                this.XOR_ind(4, 1);
                break;
            }
            case 994: {
                this.XOR_ind(4, 2);
                break;
            }
            case 995: {
                this.XOR_ind(4, 3);
                break;
            }
            case 996: {
                this.XOR_ind(4, 4);
                break;
            }
            case 997: {
                this.XOR_ind(4, 5);
                break;
            }
            case 998: {
                this.XOR_ind(4, 6);
                break;
            }
            case 999: {
                this.XOR_ind(4, 7);
                break;
            }
            case 1000: {
                this.XOR_ind(5, 0);
                break;
            }
            case 1001: {
                this.XOR_ind(5, 1);
                break;
            }
            case 1002: {
                this.XOR_ind(5, 2);
                break;
            }
            case 1003: {
                this.XOR_ind(5, 3);
                break;
            }
            case 1004: {
                this.XOR_ind(5, 4);
                break;
            }
            case 1005: {
                this.XOR_ind(5, 5);
                break;
            }
            case 1006: {
                this.XOR_ind(5, 6);
                break;
            }
            case 1007: {
                this.XOR_ind(5, 7);
                break;
            }
            case 1008: {
                this.XOR_ind(6, 0);
                break;
            }
            case 1009: {
                this.XOR_ind(6, 1);
                break;
            }
            case 1010: {
                this.XOR_ind(6, 2);
                break;
            }
            case 1011: {
                this.XOR_ind(6, 3);
                break;
            }
            case 1012: {
                this.XOR_ind(6, 4);
                break;
            }
            case 1013: {
                this.XOR_ind(6, 5);
                break;
            }
            case 1014: {
                this.XOR_ind(6, 6);
                break;
            }
            case 1015: {
                this.XOR_ind(6, 7);
                break;
            }
            case 1016: {
                this.XOR_ind(7, 0);
                break;
            }
            case 1017: {
                this.XOR_ind(7, 1);
                break;
            }
            case 1018: {
                this.XOR_ind(7, 2);
                break;
            }
            case 1019: {
                this.XOR_ind(7, 3);
                break;
            }
            case 1020: {
                this.XOR_ind(7, 4);
                break;
            }
            case 1021: {
                this.XOR_ind(7, 5);
                break;
            }
            case 1022: {
                this.XOR_ind(7, 6);
                break;
            }
            default: {
                this.XOR_ind(7, 7);
                break;
            }
        }
    }

    protected CP1610(MemoryBus memoryBus, SignalLine signalLine, SignalLine signalLine2, SignalLine signalLine3, int n, int n2) {
        this.memoryBus = memoryBus;
        this.intrmLine = signalLine;
        this.busRqLine = signalLine2;
        this.busAkLine = signalLine3;
        this.resetAddress = n;
        this.interruptAddress = n2;
        this.r = new int[8];
        this.r[7] = n;
    }
}

