/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.Intellivision;
import com.bliss.core.devices.ClockDevice;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.PlugIn;
import com.bliss.core.devices.VideoOutputDevice;
import java.io.IOException;

public class EmulationDirector {
    private static final int[] CONTROL_IDS = new int[]{7000, 7001, 7002, 7003, 7004};
    private static final String pausedMessage = Intellivision.RESOURCES.getString("MessagePaused");
    private static final String savedMessage = Intellivision.RESOURCES.getString("MessageSaved");
    private static final String saveFailedMessage = Intellivision.RESOURCES.getString("MessageSaveFailed");
    private static final String loadedMessage = Intellivision.RESOURCES.getString("MessageLoaded");
    private static final String loadFailedMessage = Intellivision.RESOURCES.getString("MessageLoadFailed");
    private static final String screenCaptureFailedMessage = Intellivision.RESOURCES.getString("MessageScreenCaptureFailed");
    private static final String[] descriptionKeys = new String[]{"ControllerPause", "ControllerSave", "ControllerLoad", "ControllerReset", "ControllerScreenshot"};
    private Intellivision inty;
    private PlugIn plugIn;
    private ClockDevice clockDevice;
    private InputDevice inputDevice;
    private VideoOutputDevice videoOutputDevice;
    private boolean[] buttonPressed = new boolean[CONTROL_IDS.length];
    protected long startTime;
    protected long missedFrameBuffer;
    protected int frameCount;
    protected int frameSkipCounter;
    protected int frameSkip = 1;
    protected boolean skippedChange;
    protected byte[] stagingBankData;

    public void setFrameSkip(int n) {
        this.frameSkip = n;
    }

    public int getFrameSkip() {
        return this.frameSkip;
    }

    public void changePlugIn(PlugIn plugIn) {
        this.plugIn = plugIn;
        if (this.plugIn == null) {
            this.clockDevice = null;
            this.inputDevice = null;
            this.videoOutputDevice = null;
        } else {
            this.clockDevice = plugIn.getClockDevice();
            this.inputDevice = plugIn.getInputDevice();
            this.videoOutputDevice = plugIn.getVideoOutputDevice();
        }
    }

    public void reset() {
        int n = 0;
        while (n < this.buttonPressed.length) {
            this.buttonPressed[n] = false;
            ++n;
        }
        this.startTime = this.clockDevice.getTick();
        this.missedFrameBuffer = this.clockDevice.getTickFrequency() / 4L;
        this.frameCount = 0;
        this.frameSkipCounter = this.frameSkip;
        this.skippedChange = false;
    }

    public void pollInput() {
        this.inputDevice.poll();
        if (this.plugIn.stopRequested()) {
            this.inty.turnOff();
            return;
        }
        this.inty.player1Controller.poll();
        this.inty.player2Controller.poll();
        if (this.inty.ecsInUse) {
            this.inty.ecs.keyboard.poll();
        }
        if (this.inputDevice.getControlValue(CONTROL_IDS[0]) == 1.0f) {
            if (!this.buttonPressed[0]) {
                this.buttonPressed[0] = true;
                boolean bl = this.inty.processorBus.isPaused();
                this.inty.processorBus.setPaused(!bl);
                this.inty.stic.setMessage(!bl ? pausedMessage : null);
            }
        } else {
            this.buttonPressed[0] = false;
        }
        if (this.inputDevice.getControlValue(CONTROL_IDS[1]) == 1.0f) {
            if (!this.buttonPressed[1]) {
                this.buttonPressed[1] = true;
                try {
                    this.inty.saveGame();
                    this.inty.stic.setMessage(savedMessage, 1);
                }
                catch (IOException iOException) {
                    this.inty.stic.setMessage(saveFailedMessage, 1);
                }
            }
        } else {
            this.buttonPressed[1] = false;
        }
        if (this.inputDevice.getControlValue(CONTROL_IDS[2]) == 1.0f) {
            if (!this.buttonPressed[2]) {
                this.buttonPressed[2] = true;
                try {
                    this.inty.loadGame();
                    this.inty.stic.setMessage(loadedMessage, 1);
                }
                catch (IOException iOException) {
                    this.inty.stic.setMessage(loadFailedMessage, 1);
                }
            }
        } else {
            this.buttonPressed[2] = false;
        }
        if (this.inputDevice.getControlValue(CONTROL_IDS[3]) == 1.0f) {
            this.inty.reset();
        }
        if (this.inputDevice.getControlValue(CONTROL_IDS[4]) == 1.0f) {
            if (!this.buttonPressed[4]) {
                this.buttonPressed[4] = true;
                try {
                    this.inty.writeSnapshot();
                }
                catch (IOException iOException) {
                    this.inty.stic.setMessage(screenCaptureFailedMessage, 1);
                }
            }
        } else {
            this.buttonPressed[4] = false;
        }
    }

    public void displayImage(boolean bl) {
        if (!bl && !this.skippedChange) {
            this.videoOutputDevice.displayImage(this.stagingBankData, false);
        } else {
            ++this.frameSkipCounter;
            if (this.frameSkipCounter > this.frameSkip) {
                this.frameSkipCounter = 0;
                long l = this.startTime + (long)this.frameCount * this.clockDevice.getTickFrequency() / 60L;
                long l2 = this.clockDevice.getTick();
                if (l2 < l + this.missedFrameBuffer) {
                    while (this.clockDevice.getTick() < l) {
                    }
                } else {
                    this.startTime = l2;
                    this.frameCount = 0;
                }
                this.videoOutputDevice.displayImage(this.stagingBankData, true);
                this.skippedChange = false;
            } else {
                this.skippedChange |= true;
            }
        }
        ++this.frameCount;
    }

    public int getControlCount() {
        return CONTROL_IDS.length;
    }

    public String getControlDescription(int n) {
        return Intellivision.RESOURCES.getString(descriptionKeys[n]);
    }

    void setImageBank(byte[] byArray) {
        this.stagingBankData = byArray;
    }

    public EmulationDirector(Intellivision intellivision) {
        this.inty = intellivision;
    }
}

