/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.EmulationDirector;
import com.bliss.core.LoadInputStream;
import com.bliss.core.Processor;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.devices.PlugIn;
import java.io.IOException;

public class ProcessorBus {
    private static final int MAX_PROCESSORS = 15;
    private EmulationDirector director;
    long clock;
    private long tickDelta;
    private int currentProcessor;
    private volatile boolean running;
    private boolean paused;
    private PlugIn plugIn;
    private Processor[] processors = new Processor[15];
    private long[] processorTickFactors = new long[15];
    private long[] processorTicks = new long[15];
    private boolean[] processorsIdle = new boolean[15];
    private int processorCount = 0;

    public void reset() {
        this.clock = 1L;
        this.tickDelta = 0L;
        this.currentProcessor = 0;
        this.paused = false;
        int n = 0;
        while (n < this.processorCount) {
            this.processors[n].reset();
            ++n;
        }
        long l = this.processors[0].getClockSpeed();
        int n2 = 1;
        while (n2 < this.processorCount) {
            l = ProcessorBus.lcm(l, this.processors[n2].getClockSpeed());
            ++n2;
        }
        n2 = 0;
        while (n2 < this.processorCount) {
            this.processors[n2].reset();
            this.processorTicks[n2] = 0L;
            this.processorTickFactors[n2] = l / (long)this.processors[n2].getClockSpeed();
            ++n2;
        }
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeLong(this.clock);
        saveOutputStream.writeLong(this.tickDelta);
        saveOutputStream.writeInt(this.currentProcessor);
        int n = 0;
        while (n < this.processorCount) {
            this.processors[n].save(saveOutputStream);
            ++n;
        }
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.clock = loadInputStream.readLong(0L, Long.MAX_VALUE);
        this.tickDelta = loadInputStream.readLong(0L, Long.MAX_VALUE);
        this.currentProcessor = loadInputStream.readInt(0, 15);
        int n = 0;
        while (n < this.processorCount) {
            this.processors[n].load(loadInputStream);
            ++n;
        }
    }

    public void addProcessor(Processor processor) {
        this.processors[this.processorCount] = processor;
        ++this.processorCount;
    }

    public void removeProcessor(Processor processor) {
        int n = 0;
        while (n < this.processorCount) {
            if (this.processors[n] == processor) {
                int n2 = n;
                while (n2 < this.processorCount - 1) {
                    this.processors[n2] = this.processors[n2 + 1];
                    ++n2;
                }
                --this.processorCount;
            }
            ++n;
        }
    }

    public void run() {
        this.running = true;
        while (this.running) {
            if (!this.processorsIdle[this.currentProcessor]) {
                int n = this.currentProcessor;
                this.processorTicks[n] = this.processorTicks[n] - this.tickDelta;
                if (this.processorTicks[this.currentProcessor] == 0L) {
                    if (this.processors[this.currentProcessor].isIdle) {
                        this.processorsIdle[this.currentProcessor] = true;
                    } else {
                        this.processorTicks[this.currentProcessor] = (long)this.processors[this.currentProcessor].tick() * this.processorTickFactors[this.currentProcessor];
                    }
                }
            }
            ++this.currentProcessor;
            if (this.currentProcessor == this.processorCount) {
                this.currentProcessor = 0;
                this.tickDelta = Long.MAX_VALUE;
                int n = 0;
                while (n < this.processorCount) {
                    boolean bl = this.processorsIdle[n] = this.processorsIdle[n] && this.processors[n].isIdle;
                    if (!this.processorsIdle[n] && this.processorTicks[n] < this.tickDelta) {
                        this.tickDelta = this.processorTicks[n];
                    }
                    ++n;
                }
                this.clock += this.tickDelta;
            }
            while (this.paused && this.running) {
                this.director.pollInput();
                this.director.displayImage(true);
            }
        }
    }

    public void stop() {
        this.running = false;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public boolean isPaused() {
        return this.paused;
    }

    private static long lcm(long l, long l2) {
        long l3 = ProcessorBus.gcd(l, l2);
        return l / l3 * l2;
    }

    private static long gcd(long l, long l2) {
        long l3 = l % l2;
        while (l3 != 0L) {
            l = l2;
            l2 = l3;
            l3 = l % l2;
        }
        return l2;
    }

    ProcessorBus(EmulationDirector emulationDirector) {
        this.director = emulationDirector;
    }
}

