/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Processor;
import com.bliss.core.ProcessorBus;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.devices.AudioOutputDevice;
import com.bliss.core.devices.PlugIn;

public class AudioMixer
extends Processor {
    private static final int MAX_LINES = 10;
    private PlugIn plugIn;
    private AudioOutputDevice aod;
    private AudioOutputLine[] lines = new AudioOutputLine[10];
    private int lineCount;
    ProcessorBus processorBus;
    boolean highQualityMixing = true;

    public void setAudioOutputDevice(AudioOutputDevice audioOutputDevice) {
        this.aod = audioOutputDevice;
    }

    public int getClockSpeed() {
        return this.aod.getSampleRate();
    }

    public void setHighQualityMixing(boolean bl) {
        this.highQualityMixing = bl;
    }

    public boolean isHighQualityMixing() {
        return this.highQualityMixing;
    }

    public void reset() {
        int n = 0;
        while (n < this.lineCount) {
            this.lines[n].reset();
            ++n;
        }
    }

    public void save(SaveOutputStream saveOutputStream) {
    }

    public void load(LoadInputStream loadInputStream) {
    }

    public int tick() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.lineCount) {
            AudioOutputLine audioOutputLine = this.lines[n2];
            if (this.highQualityMixing) {
                audioOutputLine.sampleBuffer += (long)audioOutputLine.currentSample * (this.processorBus.clock - audioOutputLine.lastWriteClockMark);
                n += (int)(audioOutputLine.sampleBuffer / this.processorBus.clock);
            } else {
                n += audioOutputLine.currentSample;
            }
            audioOutputLine.sampleBuffer = 0L;
            audioOutputLine.lastWriteClockMark = 0L;
            ++n2;
        }
        this.processorBus.clock = 0L;
        n /= this.lineCount;
        if ((n <<= 1) > 24576) {
            n = 24576 + (n - 24576) / 6;
        }
        this.aod.playSample(n);
        return 1;
    }

    public AudioOutputLine getAudioOutputLine() {
        AudioMixer audioMixer = this;
        if (audioMixer == null) {
            throw null;
        }
        return audioMixer.new AudioOutputLine();
    }

    public AudioMixer(ProcessorBus processorBus) {
        this.processorBus = processorBus;
    }

    public class AudioOutputLine {
        int currentSample;
        long lastWriteClockMark;
        long sampleBuffer;

        private void reset() {
            this.currentSample = 0;
            this.sampleBuffer = 0L;
            this.lastWriteClockMark = 0L;
        }

        public void acquire() {
            ((AudioMixer)AudioMixer.this).lines[((AudioMixer)AudioMixer.this).lineCount] = this;
            AudioMixer audioMixer = AudioMixer.this;
            audioMixer.lineCount = audioMixer.lineCount + 1;
        }

        public void release() {
            int n = 0;
            while (n < AudioMixer.this.lineCount) {
                if (AudioMixer.this.lines[n] == this) {
                    int n2 = n + 1;
                    while (n2 < AudioMixer.this.lineCount - 1) {
                        ((AudioMixer)AudioMixer.this).lines[n2] = AudioMixer.this.lines[n2 + 1];
                        ++n2;
                    }
                    AudioMixer audioMixer = AudioMixer.this;
                    audioMixer.lineCount = audioMixer.lineCount - 1;
                    return;
                }
                ++n;
            }
        }

        public void writeSample(int n) {
            if (AudioMixer.this.highQualityMixing) {
                this.sampleBuffer += (long)this.currentSample * (AudioMixer.this.processorBus.clock - this.lastWriteClockMark);
                this.lastWriteClockMark = AudioMixer.this.processorBus.clock;
            }
            this.currentSample = n;
        }

        private AudioOutputLine() {
        }
    }
}

