/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.AY38914;
import com.bliss.core.AudioMixer;
import com.bliss.core.ECSKeyboard;
import com.bliss.core.Memory;
import com.bliss.core.Peripheral;
import com.bliss.core.Processor;
import com.bliss.core.RAM;
import com.bliss.core.ROM;

public class ECS
implements Peripheral {
    ECSKeyboard keyboard;
    AY38914 psg2;
    private AudioMixer.AudioOutputLine aol;
    private int[] ecsImage0;
    private int[] ecsImage1;
    private int[] ecsImage2;
    private boolean hasECSROMImage = false;
    private RAM ramBank;
    private Memory[] memorySegments;

    public int getProcessorCount() {
        return this.psg2.getProcessorCount();
    }

    public Processor getProcessor(int n) {
        return this.psg2.getProcessor(n);
    }

    public int getMemoryCount() {
        return this.memorySegments.length;
    }

    public Memory getMemory(int n) {
        return this.memorySegments[n];
    }

    void setECSROMImage(int[] nArray) {
        System.arraycopy(nArray, 0, this.ecsImage0, 0, this.ecsImage0.length);
        System.arraycopy(nArray, 4096, this.ecsImage1, 0, this.ecsImage1.length);
        System.arraycopy(nArray, 8192, this.ecsImage2, 0, this.ecsImage2.length);
        this.hasECSROMImage = true;
    }

    boolean hasECSROMImage() {
        return this.hasECSROMImage;
    }

    void setPSGClockDivisor(int n) {
        this.psg2.setClockDivisor(n);
    }

    private void init() {
        this.psg2 = new AY38914(this.aol, 240, this.keyboard, this.keyboard);
        int n = this.psg2.getMemoryCount();
        this.memorySegments = new Memory[n + 5];
        int n2 = 0;
        while (n2 < n) {
            this.memorySegments[n2] = this.psg2.getMemory(n2);
            ++n2;
        }
        this.ecsImage0 = new int[4096];
        this.memorySegments[n] = new ROM(this.ecsImage0, 8192, 1);
        this.ecsImage1 = new int[4096];
        this.memorySegments[n + 1] = new ROM(this.ecsImage1, 28672, 0);
        this.ecsImage2 = new int[4096];
        this.memorySegments[n + 2] = new ROM(this.ecsImage2, 57344, 1);
        this.ramBank = new RAM(2048, 16384, 8);
        this.memorySegments[n + 3] = this.ramBank;
        this.memorySegments[n + 4] = new RAM(4, 224, 8);
    }

    public ECS(AudioMixer.AudioOutputLine audioOutputLine, ECSKeyboard eCSKeyboard) {
        this.aol = audioOutputLine;
        this.keyboard = eCSKeyboard;
        this.init();
    }
}

