/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.IODevice;
import com.bliss.core.Intellivision;
import com.bliss.core.devices.InputDevice;

public class HandController
implements IODevice {
    private static final int[] CONTROL_IDS_PLAYER_ONE = new int[]{1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1024, 1023, 1025, 1008, 1009, 1010, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007};
    private static final int[] CONTROL_IDS_PLAYER_TWO = new int[]{2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2024, 2023, 2025, 2008, 2009, 2010, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 1007};
    private static final float vectorParse = (float)Math.sin(0.7853981633974483);
    private static final int ID_DISC_NORTH = 15;
    private static final int ID_DISC_NORTH_EAST = 16;
    private static final int ID_DISC_EAST = 17;
    private static final int ID_DISC_SOUTH_EAST = 18;
    private static final int ID_DISC_SOUTH = 19;
    private static final int ID_DISC_SOUTH_WEST = 20;
    private static final int ID_DISC_WEST = 21;
    private static final int ID_DISC_NORTH_WEST = 22;
    private static final int[] buttonOutputValues = new int[]{129, 65, 33, 130, 66, 34, 132, 68, 36, 136, 72, 40, 160, 96, 192};
    private static final int[] directionOutputValues = new int[]{4, 20, 22, 6, 2, 18, 19, 3, 1, 17, 25, 9, 8, 24, 28, 12};
    private static final String[] descriptionKeys = new String[]{"InputKeyPadOne", "InputKeyPadTwo", "InputKeyPadThree", "InputKeyPadFour", "InputKeyPadFive", "InputKeyPadSix", "InputKeyPadSeven", "InputKeyPadEight", "InputKeyPadNine", "InputKeyPadClear", "InputKeyPadZero", "InputKeyPadEnter", "InputActionButtonsTop", "InputActionButtonBottomLeft", "InputActionButtonBottomRight", "InputDiscNorth", "InputDiscNorthEast", "InputDiscEast", "InputDiscSouthEast", "InputDiscSouth", "InputDiscSouthWest", "InputDiscWest", "InputDiscNorthWest"};
    private int playerNum;
    private InputDevice inputDevice;
    private int inputValue = 255;
    private int[] controlIDs;

    public void reset() {
        this.inputValue = 255;
    }

    public int getControlCount() {
        return 23;
    }

    public int getControlID(int n) {
        return this.controlIDs[n];
    }

    public String getControlDescription(int n) {
        return Intellivision.RESOURCES.getString(descriptionKeys[n]);
    }

    public void setInputDevice(InputDevice inputDevice) {
        this.inputDevice = inputDevice;
    }

    public void setOutputValue(int n) {
    }

    public int getInputValue() {
        return this.inputValue;
    }

    public void poll() {
        this.inputValue = 0;
        int n = 0;
        while (n < 15) {
            if (this.inputDevice.getControlValue(this.controlIDs[n]) == 1.0f) {
                this.inputValue |= buttonOutputValues[n];
            }
            ++n;
        }
        float f = (this.inputDevice.getControlValue(this.controlIDs[16]) - this.inputDevice.getControlValue(this.controlIDs[20])) * vectorParse;
        float f2 = (this.inputDevice.getControlValue(this.controlIDs[22]) - this.inputDevice.getControlValue(this.controlIDs[18])) * vectorParse;
        float f3 = this.inputDevice.getControlValue(this.controlIDs[15]) - this.inputDevice.getControlValue(this.controlIDs[19]) + f2 + f;
        float f4 = this.inputDevice.getControlValue(this.controlIDs[17]) - this.inputDevice.getControlValue(this.controlIDs[21]) - f2 + f;
        if (f4 != 0.0f || f3 != 0.0f) {
            double d = Math.atan2(-f4, -f3) + Math.PI;
            double d2 = 0.39269908169872414;
            int n2 = directionOutputValues[(int)((d + d2 / 2.0) / d2) & 0xF];
            this.inputValue |= n2;
        }
        this.inputValue = 0xFF ^ this.inputValue;
    }

    HandController(int n) {
        this.playerNum = n;
        this.controlIDs = n == 0 ? CONTROL_IDS_PLAYER_ONE : CONTROL_IDS_PLAYER_TWO;
    }
}

