/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.MemoryBanker;
import com.bliss.core.SaveOutputStream;
import java.io.IOException;

public class MemoryBanker
extends Memory {
    private int location;
    private int size;
    private int triggerLocation;
    private int pageChangeValue;
    private int currentBank;
    private Memory[] bankedMemories = new Memory[16];
    private Memory unmappedMemory;

    public void setMemoryBank(int n, Memory memory) {
        if (memory == null) {
            memory = this.unmappedMemory;
        }
        this.bankedMemories[n] = memory;
    }

    public Memory getMemoryBank(int n) {
        return this.bankedMemories[n] == this.unmappedMemory ? null : this.bankedMemories[n];
    }

    public void reset() {
        this.currentBank = 0;
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeInt(this.currentBank);
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.currentBank = loadInputStream.readInt(0, 15);
    }

    public int getLocation() {
        return this.location;
    }

    public int getSize() {
        return this.size;
    }

    public void poke(int n, int n2) {
        if (n == this.triggerLocation && (n2 & 0xFFF0) == this.pageChangeValue) {
            this.currentBank = n2 & 0xF;
        } else {
            this.bankedMemories[this.currentBank].poke(n, n2);
        }
    }

    public int peek(int n) {
        return this.bankedMemories[this.currentBank].peek(n);
    }

    public MemoryBanker(int n, int n2) {
        this.location = n;
        this.size = n2;
        this.triggerLocation = n + n2 - 1;
        this.unmappedMemory = new UnmappedMemory(null, n, n2);
        int n3 = 0;
        while (n3 < this.bankedMemories.length) {
            this.bankedMemories[n3] = this.unmappedMemory;
            ++n3;
        }
        this.pageChangeValue = n & 0xF000 | 0xA50;
        this.currentBank = 0;
    }

    private static class UnmappedMemory
    extends Memory {
        private int location;
        private int size;

        public void reset() {
        }

        public void save(SaveOutputStream saveOutputStream) throws IOException {
        }

        public void load(LoadInputStream loadInputStream) throws IOException {
        }

        public int getLocation() {
            return this.location;
        }

        public int getSize() {
            return this.size;
        }

        public void poke(int n, int n2) {
        }

        public int peek(int n) {
            return 65535;
        }

        private UnmappedMemory(int n, int n2) {
        }

        /* synthetic */ UnmappedMemory(1 var1_1, int n, int n2) {
            this(n, n2);
        }
    }
}

